/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_8_2$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.message.Message$;
import kafka.message.SnappyCompressionCodec$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0001\u001d\u0011qbS1gW\u0006\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012!\t;fgRdun\u001a*fi\u0016tG/[8o)&lW\rS8veN\u0004&o\u001c<jI\u0016$G#\u0001\f\u0011\u0005%9\u0012B\u0001\r\u000b\u0005\u0011)f.\u001b;)\u0005MQ\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\u0005y\u0012aA8sO&\u0011\u0011\u0005\b\u0002\u0005)\u0016\u001cH\u000fC\u0003$\u0001\u0011\u0005Q#A\u0012uKN$Hj\\4SKR,g\u000e^5p]RKW.Z'j]V$Xm\u001d)s_ZLG-\u001a3)\u0005\tR\u0002\"\u0002\u0014\u0001\t\u0003)\u0012A\b;fgRdun\u001a*fi\u0016tG/[8o)&lW-T:Qe>4\u0018\u000eZ3eQ\t)#\u0004C\u0003*\u0001\u0011\u0005Q#\u0001\u0013uKN$Hj\\4SKR,g\u000e^5p]RKW.\u001a(p\u0007>tg-[4Qe>4\u0018\u000eZ3eQ\tA#\u0004C\u0003-\u0001\u0011\u0005Q#A\u0018uKN$Hj\\4SKR,g\u000e^5p]RKW.\u001a\"pi\"l\u0015N\\;uKN\fe\u000e\u001a%pkJ\u001c\bK]8wS\u0012,G\r\u000b\u0002,5!)q\u0006\u0001C\u0001+\u0005aC/Z:u\u0019><'+\u001a;f]RLwN\u001c+j[\u0016\u0014u\u000e\u001e5NS:,H/Z:B]\u0012l5\u000f\u0015:pm&$W\r\u001a\u0015\u0003]iAQA\r\u0001\u0005\u0002U\t\u0011\u0004^3ti2{wMU3uK:$\u0018n\u001c8V]2LW.\u001b;fI\"\u0012\u0011G\u0007\u0005\u0006k\u0001!\tAN\u0001\u0016i\u0016\u001cH\u000fT8h%\u0016$XM\u001c;j_:4\u0016\r\\5e+\u00051\u0002F\u0001\u001b\u001b\u0011\u0015I\u0004\u0001\"\u0001\u0016\u0003U!Xm\u001d;BIZ,'\u000f^5tK\u0012+g-Y;miND#\u0001\u000f\u000e\t\u000bq\u0002A\u0011A\u000b\u0002/Q,7\u000f^!em\u0016\u0014H/[:f\u0007>tg-[4ve\u0016$\u0007FA\u001e\u001b\u0011\u0015y\u0004\u0001\"\u0001\u0016\u0003a!Xm\u001d;BIZ,'\u000f^5tKB{'\u000f\u001e#fM\u0006,H\u000e\u001e\u0015\u0003}iAQA\u0011\u0001\u0005\u0002U\tA\u0004^3ti\u0006#g/\u001a:uSN,\u0007j\\:u\u001d\u0006lW\rR3gCVdG\u000f\u000b\u0002B5!)Q\t\u0001C\u0001+\u00051B/Z:u\tV\u0004H.[2bi\u0016d\u0015n\u001d;f]\u0016\u00148\u000f\u000b\u0002E5!)\u0001\n\u0001C\u0001+\u00059B/Z:u\u0005\u0006$G*[:uK:,'\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0003\u000fjAQa\u0013\u0001\u0005\u0002U\tA\u0006^3ti2K7\u000f^3oKJt\u0015-\\3t/&$\b.\u00113wKJ$\u0018n]3e\u0019&\u001cH/\u001a8feVs7/\u001a;)\u0005)S\u0002\"\u0002(\u0001\t\u0003)\u0012A\n;fgRd\u0015n\u001d;f]\u0016\u0014\u0018I\u001c3BIZ,'\u000f^5tK\u0012d\u0015n\u001d;f]\u0016\u0014h*Y7fg\"\u0012QJ\u0007\u0005\u0006#\u0002!\t!F\u00017i\u0016\u001cH\u000fT5ti\u0016tWM\u001d(b[\u0016l\u0015n]:j]\u001e4%o\\7MSN$XM\\3s'\u0016\u001cWO]5usB\u0013x\u000e^8d_2l\u0015\r\u001d\u0015\u0003!jAQ\u0001\u0016\u0001\u0005\u0002U\t\u0011\t^3ti&sG/\u001a:Ce>\\WM\u001d'jgR,g.\u001a:OC6,W*[:tS:<gI]8n\u0019&\u001cH/\u001a8feN+7-\u001e:jif\u0004&o\u001c;pG>dW*\u00199)\u0005MS\u0002\"B,\u0001\t\u0003)\u0012!\r;fgRLe\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-\u00118e'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u001cV\r\u001e\u0015\u0003-jAQA\u0017\u0001\u0005\u0002U\t1\u0005^3ti\u000e\u000b7/Z%og\u0016t7/\u001b;jm\u0016d\u0015n\u001d;f]\u0016\u0014\bK]8u_\u000e|G\u000e\u000b\u0002Z5!)Q\f\u0001C\u0001=\u00069B.[:uK:,'\u000fT5tiR{WI\u001c3Q_&tGo\u001d\u000b\u0004?.D\bc\u00011dK6\t\u0011M\u0003\u0002c\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011\f'aA*fcB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eB\u0001\bG2,8\u000f^3s\u0013\tQwM\u0001\u0005F]\u0012\u0004v.\u001b8u\u0011\u0015aG\f1\u0001n\u00031a\u0017n\u001d;f]\u0016\u0014H*[:u!\tqWO\u0004\u0002pgB\u0011\u0001OC\u0007\u0002c*\u0011!OB\u0001\u0007yI|w\u000e\u001e \n\u0005QT\u0011A\u0002)sK\u0012,g-\u0003\u0002wo\n11\u000b\u001e:j]\u001eT!\u0001\u001e\u0006\t\u000fed\u0006\u0013!a\u0001u\u0006\u00192/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\'baB)\u0001m_?\u0002\u0012%\u0011A0\u0019\u0002\u0004\u001b\u0006\u0004\bc\u0001@\u0002\u000e5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011a\u00028fi^|'o\u001b\u0006\u0005\u0003\u000b\t9!\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005%!bAA\u0006=\u00051\u0011\r]1dQ\u0016L1!a\u0004\u0000\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!\u0002BA\f\u0003\u0007\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u00037\t)B\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"1\u0011q\u0004\u0001\u0005\u0002U\tA\u0003^3ti2K7\u000f^3oKJ$UMZ1vYR\u001c\bfAA\u000f5!1\u0011Q\u0005\u0001\u0005\u0002U\t\u0001\u0004^3tiZ+'o]5p]\u000e{gNZ5hkJ\fG/[8oQ\r\t\u0019C\u0007\u0005\b\u0003W\u0001A\u0011BA\u0017\u0003II7OV1mS\u0012\\\u0015MZ6b\u0007>tg-[4\u0015\t\u0005=\u0012Q\u0007\t\u0004\u0013\u0005E\u0012bAA\u001a\u0015\t9!i\\8mK\u0006t\u0007\u0002CA\u001c\u0003S\u0001\r!!\u000f\u0002\u000bA\u0014x\u000e]:\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!Q\u000f^5m\u0015\t\t\u0019%\u0001\u0003kCZ\f\u0017\u0002BA$\u0003{\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019\tY\u0005\u0001C\u0001+\u0005\u0001C/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t\u00164\u0017-\u001e7uQ\r\tIE\u0007\u0005\u0007\u0003#\u0002A\u0011A\u000b\u00027Q,7\u000f^+oG2,\u0017M\\#mK\u000e$\u0018n\u001c8ESN\f'\r\\3eQ\r\tyE\u0007\u0005\u0007\u0003/\u0002A\u0011A\u000b\u00025Q,7\u000f^+oG2,\u0017M\\#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3)\u0007\u0005U#\u0004\u0003\u0004\u0002^\u0001!\t!F\u0001\u001bi\u0016\u001cH/\u00168dY\u0016\fg.\u00127fGRLwN\\%om\u0006d\u0017\u000e\u001a\u0015\u0004\u00037R\u0002BBA2\u0001\u0011\u0005Q#A\ruKN$Hj\\4S_2dG+[7f\u001bN\u0004&o\u001c<jI\u0016$\u0007fAA15!1\u0011\u0011\u000e\u0001\u0005\u0002U\tQ\u0005^3ti2{wMU8mYRKW.\u001a\"pi\"l5/\u00118e\u0011>,(o\u001d)s_ZLG-\u001a3)\u0007\u0005\u001d$\u0004\u0003\u0004\u0002p\u0001!\t!F\u0001 i\u0016\u001cH\u000fT8h%>dG\u000eV5nK:{7i\u001c8gS\u001e\u0004&o\u001c<jI\u0016$\u0007fAA75!1\u0011Q\u000f\u0001\u0005\u0002U\t!\u0004^3ti\u0012+g-Y;mi\u000e{W\u000e\u001d:fgNLwN\u001c+za\u0016D3!a\u001d\u001b\u0011\u0019\tY\b\u0001C\u0001+\u0005AB/Z:u-\u0006d\u0017\u000eZ\"p[B\u0014Xm]:j_:$\u0016\u0010]3)\u0007\u0005e$\u0004\u0003\u0004\u0002\u0002\u0002!\t!F\u0001\u001bi\u0016\u001cH/\u00138wC2LGmQ8naJ,7o]5p]RK\b/\u001a\u0015\u0004\u0003\u007fR\u0002BBAD\u0001\u0011\u0005Q#\u0001\u0014uKN$\u0018J\u001c<bY&$\u0017J\u001c;fe\n\u0013xn[3s'\u0016\u001cWO]5usB\u0013x\u000e^8d_2D3!!\"\u001b\u0011\u0019\ti\t\u0001C\u0001+\u0005!C/Z:u\u000bF,\u0018\r\\!em\u0016\u0014H/[:fI2K7\u000f^3oKJ\u001c\bK]8u_\u000e|G\u000eK\u0002\u0002\fjAa!a%\u0001\t\u0003)\u0012A\n;fgRLeN^1mS\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:t!J|Go\\2pY\"\u001a\u0011\u0011\u0013\u000e\t\r\u0005e\u0005\u0001\"\u0001\u0016\u0003Q!Xm\u001d;Ge>l\u0007K]8qg&sg/\u00197jI\"\u001a\u0011q\u0013\u000e\t\r\u0005}\u0005\u0001\"\u0001\u0016\u0003Y!Xm\u001d;Ta\u0016\u001c\u0017NZ5d!J|\u0007/\u001a:uS\u0016\u001c\bfAAO5!9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0016!F1tg\u0016\u0014H\u000f\u0015:pa\u0016\u0014H/_%om\u0006d\u0017\u000e\u001a\u000b\b-\u0005%\u00161WA\\\u0011%\tY+a)\u0005\u0002\u0004\ti+\u0001\nwC2LGMU3rk&\u0014X\r\u001a)s_B\u001c\b#B\u0005\u00020\u0006e\u0012bAAY\u0015\tAAHY=oC6,g\bC\u0004\u00026\u0006\r\u0006\u0019A7\u0002\t9\fW.\u001a\u0005\t\u0003s\u000b\u0019\u000b1\u0001\u0002<\u00061a/\u00197vKN\u0004R!CA_\u0003\u0003L1!a0\u000b\u0005)a$/\u001a9fCR,GM\u0010\t\u0004\u0013\u0005\r\u0017bAAc\u0015\t\u0019\u0011I\\=\t\u0013\u0005%\u0007!%A\u0005\u0002\u0005-\u0017!\t7jgR,g.\u001a:MSN$Hk\\#oIB{\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u0012TCAAgU\rQ\u0018qZ\u0016\u0003\u0003#\u0004B!a5\u0002^6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.A\u0005v]\u000eDWmY6fI*\u0019\u00111\u001c\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002`\u0006U'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class KafkaConfigTest {
    @Test
    public void testLogRetentionTimeHoursProvided() {
        int x$10 = 0;
        String x$11 = TestUtils$.MODULE$.MockZkConnect();
        int x$12 = 8181;
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$15 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$19 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$20 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$22 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$23 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$24 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$25 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$10, x$11, x$13, x$14, x$12, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)3600000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMinutesProvided() {
        int x$26 = 0;
        String x$27 = TestUtils$.MODULE$.MockZkConnect();
        int x$28 = 8181;
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$31 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$32 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$33 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$34 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$35 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$36 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$37 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$38 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$39 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$40 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$41 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$26, x$27, x$29, x$30, x$28, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "30");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMsProvided() {
        int x$42 = 0;
        String x$43 = TestUtils$.MODULE$.MockZkConnect();
        int x$44 = 8181;
        boolean x$45 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$46 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$47 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$48 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$49 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$50 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$51 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$52 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$53 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$54 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$55 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$56 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$57 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$42, x$43, x$45, x$46, x$44, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1800000");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeNoConfigProvided() {
        int x$58 = 0;
        String x$59 = TestUtils$.MODULE$.MockZkConnect();
        int x$60 = 8181;
        boolean x$61 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$62 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$63 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$64 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$65 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$66 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$67 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$68 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$69 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$70 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$71 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$72 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$73 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$58, x$59, x$61, x$62, x$60, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73);
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)604800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndHoursProvided() {
        int x$74 = 0;
        String x$75 = TestUtils$.MODULE$.MockZkConnect();
        int x$76 = 8181;
        boolean x$77 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$78 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$79 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$80 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$81 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$82 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$83 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$84 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$85 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$86 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$87 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$88 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$89 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$74, x$75, x$77, x$78, x$76, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "30");
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndMsProvided() {
        int x$90 = 0;
        String x$91 = TestUtils$.MODULE$.MockZkConnect();
        int x$92 = 8181;
        boolean x$93 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$94 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$95 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$96 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$97 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$98 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$99 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$100 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$101 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$102 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$103 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$104 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$105 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$90, x$91, x$93, x$94, x$92, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1800000");
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "10");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionUnlimited() {
        int x$106 = 0;
        String x$107 = TestUtils$.MODULE$.MockZkConnect();
        int x$108 = 8181;
        boolean x$109 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$110 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$111 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$112 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$113 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$114 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$115 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$116 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$117 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$118 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$119 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$120 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$121 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(x$106, x$107, x$109, x$110, x$108, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121);
        int x$122 = 0;
        String x$123 = TestUtils$.MODULE$.MockZkConnect();
        int x$124 = 8181;
        boolean x$125 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$126 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$127 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$128 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$129 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$130 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$131 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$132 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$133 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$134 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$135 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$136 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$137 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(x$122, x$123, x$125, x$126, x$124, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137);
        int x$138 = 0;
        String x$139 = TestUtils$.MODULE$.MockZkConnect();
        int x$140 = 8181;
        boolean x$141 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$142 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$143 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$144 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$145 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$146 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$147 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$148 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$149 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$150 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$151 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$152 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$153 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(x$138, x$139, x$141, x$142, x$140, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153);
        int x$154 = 0;
        String x$155 = TestUtils$.MODULE$.MockZkConnect();
        int x$156 = 8181;
        boolean x$157 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$158 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$159 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$160 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$161 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$162 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$163 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$164 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$165 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$166 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$167 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$168 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$169 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props4 = TestUtils$.MODULE$.createBrokerConfig(x$154, x$155, x$157, x$158, x$156, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169);
        int x$170 = 0;
        String x$171 = TestUtils$.MODULE$.MockZkConnect();
        int x$172 = 8181;
        boolean x$173 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$174 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$175 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$176 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$177 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$178 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$179 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$180 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$181 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$182 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$183 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$184 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$185 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props5 = TestUtils$.MODULE$.createBrokerConfig(x$170, x$171, x$173, x$174, x$172, x$175, x$176, x$177, x$178, x$179, x$180, x$181, x$182, x$183, x$184, x$185);
        props1.put("log.retention.ms", "-1");
        props2.put("log.retention.minutes", "-1");
        props3.put("log.retention.hours", "-1");
        KafkaConfig cfg1 = KafkaConfig$.MODULE$.fromProps(props1);
        KafkaConfig cfg2 = KafkaConfig$.MODULE$.fromProps(props2);
        KafkaConfig cfg3 = KafkaConfig$.MODULE$.fromProps(props3);
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg1.logRetentionTimeMillis());
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg2.logRetentionTimeMillis());
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg3.logRetentionTimeMillis());
        props4.put("log.retention.ms", "-1");
        props4.put("log.retention.minutes", "30");
        KafkaConfig cfg4 = KafkaConfig$.MODULE$.fromProps(props4);
        Assert.assertEquals((String)"Should be -1", (long)-1L, (long)cfg4.logRetentionTimeMillis());
        props5.put("log.retention.ms", "0");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props5), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }

    @Test
    public void testLogRetentionValid() {
        int x$186 = 0;
        String x$187 = TestUtils$.MODULE$.MockZkConnect();
        int x$188 = 8181;
        boolean x$189 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$190 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$191 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$192 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$193 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$194 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$195 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$196 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$197 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$198 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$199 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$200 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$201 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(x$186, x$187, x$189, x$190, x$188, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198, x$199, x$200, x$201);
        int x$202 = 0;
        String x$203 = TestUtils$.MODULE$.MockZkConnect();
        int x$204 = 8181;
        boolean x$205 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$206 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$207 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$208 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$209 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$210 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$211 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$212 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$213 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$214 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$215 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$216 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$217 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(x$202, x$203, x$205, x$206, x$204, x$207, x$208, x$209, x$210, x$211, x$212, x$213, x$214, x$215, x$216, x$217);
        int x$218 = 0;
        String x$219 = TestUtils$.MODULE$.MockZkConnect();
        int x$220 = 8181;
        boolean x$221 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$222 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$223 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$224 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$225 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$226 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$227 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$228 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$229 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$230 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$231 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$232 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$233 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(x$218, x$219, x$221, x$222, x$220, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$231, x$232, x$233);
        props1.put("log.retention.ms", "0");
        props2.put("log.retention.minutes", "0");
        props3.put("log.retention.hours", "0");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props3), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }

    @Test
    public void testAdvertiseDefaults() {
        String port = "9999";
        String hostName = "fake-host";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.remove(KafkaConfig$.MODULE$.ListenersProp());
        props.put(KafkaConfig$.MODULE$.HostNameProp(), hostName);
        props.put(KafkaConfig$.MODULE$.PortProp(), port);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Seq endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testAdvertiseDefaults$1(x$1))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)hostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
    }

    @Test
    public void testAdvertiseConfigured() {
        String advertisedHostName = "routable-host";
        String advertisedPort = "1234";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), advertisedHostName);
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), advertisedPort);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Seq endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testAdvertiseConfigured$1(x$2))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)advertisedHostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(advertisedPort)).toInt());
    }

    @Test
    public void testAdvertisePortDefault() {
        String advertisedHostName = "routable-host";
        String port = "9999";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), advertisedHostName);
        props.put(KafkaConfig$.MODULE$.PortProp(), port);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Seq endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testAdvertisePortDefault$1(x$3))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)advertisedHostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
    }

    @Test
    public void testAdvertiseHostNameDefault() {
        String hostName = "routable-host";
        String advertisedPort = "9999";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(KafkaConfig$.MODULE$.HostNameProp(), hostName);
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), advertisedPort);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Seq endpoints = serverConfig.advertisedListeners();
        EndPoint endpoint = (EndPoint)endpoints.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testAdvertiseHostNameDefault$1(x$4))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)hostName);
        Assert.assertEquals((long)endpoint.port(), (long)new StringOps(Predef$.MODULE$.augmentString(advertisedPort)).toInt());
    }

    @Test
    public void testDuplicateListeners() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9091,TRACE://localhost:9091");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9091,PLAINTEXT://localhost:9092");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9091,TRACE://localhost:9091");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testBadListenerProtocol() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "BAD://localhost:9091");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testListenerNamesWithAdvertisedListenerUnset() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "CLIENT://localhost:9091,REPLICATION://localhost:9092,INTERNAL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CLIENT:SSL,REPLICATION:SSL,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Seq expectedListeners = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 9091, new ListenerName("CLIENT"), SecurityProtocol.SSL), new EndPoint("localhost", 9092, new ListenerName("REPLICATION"), SecurityProtocol.SSL), new EndPoint("localhost", 9093, new ListenerName("INTERNAL"), SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedListeners, (Object)config.listeners());
        Assert.assertEquals((Object)expectedListeners, (Object)config.advertisedListeners());
        scala.collection.immutable.Map expectedSecurityProtocolMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("CLIENT")), (Object)SecurityProtocol.SSL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("REPLICATION")), (Object)SecurityProtocol.SSL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("INTERNAL")), (Object)SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedSecurityProtocolMap, (Object)config.listenerSecurityProtocolMap());
    }

    @Test
    public void testListenerAndAdvertisedListenerNames() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:9091,INTERNAL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "EXTERNAL://lb1.example.com:9000,INTERNAL://host1:9093");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:SSL,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "INTERNAL");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Seq expectedListeners = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 9091, new ListenerName("EXTERNAL"), SecurityProtocol.SSL), new EndPoint("localhost", 9093, new ListenerName("INTERNAL"), SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedListeners, (Object)config.listeners());
        Seq expectedAdvertisedListeners = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("lb1.example.com", 9000, new ListenerName("EXTERNAL"), SecurityProtocol.SSL), new EndPoint("host1", 9093, new ListenerName("INTERNAL"), SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedAdvertisedListeners, (Object)config.advertisedListeners());
        scala.collection.immutable.Map expectedSecurityProtocolMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("EXTERNAL")), (Object)SecurityProtocol.SSL), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName("INTERNAL")), (Object)SecurityProtocol.PLAINTEXT)}));
        Assert.assertEquals((Object)expectedSecurityProtocolMap, (Object)config.listenerSecurityProtocolMap());
    }

    @Test
    public void testListenerNameMissingFromListenerSecurityProtocolMap() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9091,REPLICATION://localhost:9092");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "SSL");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testInterBrokerListenerNameMissingFromListenerSecurityProtocolMap() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9091");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testInterBrokerListenerNameAndSecurityProtocolSet() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9091");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), "SSL");
        Assert.assertFalse((boolean)this.isValidKafkaConfig(props));
    }

    @Test
    public void testCaseInsensitiveListenerProtocol() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "plaintext://localhost:9091,SsL://localhost:9092");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)new Some((Object)"SSL://localhost:9092"), (Object)config.listeners().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testCaseInsensitiveListenerProtocol$1(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.connectionString()));
        Assert.assertEquals((Object)new Some((Object)"PLAINTEXT://localhost:9091"), (Object)config.listeners().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testCaseInsensitiveListenerProtocol$3(x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.connectionString()));
    }

    public Seq<EndPoint> listenerListToEndPoints(String listenerList, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        return CoreUtils$.MODULE$.listenerListToEndPoints(listenerList, securityProtocolMap);
    }

    public Map<ListenerName, SecurityProtocol> listenerListToEndPoints$default$2() {
        return EndPoint$.MODULE$.DefaultSecurityProtocolMap();
    }

    @Test
    public void testListenerDefaults() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.HostNameProp(), "myhost");
        props.put(KafkaConfig$.MODULE$.PortProp(), "1111");
        KafkaConfig conf = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals(this.listenerListToEndPoints("PLAINTEXT://myhost:1111", this.listenerListToEndPoints$default$2()), (Object)conf.listeners());
        props.remove(KafkaConfig$.MODULE$.HostNameProp());
        KafkaConfig conf2 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals(this.listenerListToEndPoints("PLAINTEXT://:1111", this.listenerListToEndPoints$default$2()), (Object)conf2.listeners());
        Assert.assertEquals(this.listenerListToEndPoints("PLAINTEXT://:1111", this.listenerListToEndPoints$default$2()), (Object)conf2.advertisedListeners());
        Assert.assertEquals(null, (Object)((EndPoint)conf2.listeners().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KafkaConfigTest.$anonfun$testListenerDefaults$1(x$9))).get()).host());
        props.put(KafkaConfig$.MODULE$.AdvertisedHostNameProp(), "otherhost");
        props.put(KafkaConfig$.MODULE$.AdvertisedPortProp(), "2222");
        KafkaConfig conf3 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)conf3.advertisedListeners(), this.listenerListToEndPoints("PLAINTEXT://otherhost:2222", this.listenerListToEndPoints$default$2()));
    }

    @Test
    public void testVersionConfiguration() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        KafkaConfig conf = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)ApiVersion$.MODULE$.latestVersion(), (Object)conf.interBrokerProtocolVersion());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.8.2.0");
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.8.2.0");
        KafkaConfig conf2 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)conf2.interBrokerProtocolVersion());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.8.2.1");
        props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.8.2.1");
        KafkaConfig conf3 = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)KAFKA_0_8_2$.MODULE$, (Object)conf3.interBrokerProtocolVersion());
        Assert.assertTrue((boolean)ApiVersion$.MODULE$.latestVersion().$greater$eq((Object)conf3.interBrokerProtocolVersion()));
    }

    private boolean isValidKafkaConfig(Properties props) {
        boolean bl;
        try {
            KafkaConfig$.MODULE$.fromProps(props);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof ConfigException;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    @Test
    public void testUncleanLeaderElectionDefault() {
        int x$234 = 0;
        String x$235 = TestUtils$.MODULE$.MockZkConnect();
        int x$236 = 8181;
        boolean x$237 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$238 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$239 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$240 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$241 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$242 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$243 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$244 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$245 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$246 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$247 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$248 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$249 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$234, x$235, x$237, x$238, x$236, x$239, x$240, x$241, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Test
    public void testUncleanElectionDisabled() {
        int x$250 = 0;
        String x$251 = TestUtils$.MODULE$.MockZkConnect();
        int x$252 = 8181;
        boolean x$253 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$254 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$255 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$256 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$257 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$258 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$259 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$260 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$261 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$262 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$263 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$264 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$265 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$250, x$251, x$253, x$254, x$252, x$255, x$256, x$257, x$258, x$259, x$260, x$261, x$262, x$263, x$264, x$265);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), String.valueOf(false));
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Test
    public void testUncleanElectionEnabled() {
        int x$266 = 0;
        String x$267 = TestUtils$.MODULE$.MockZkConnect();
        int x$268 = 8181;
        boolean x$269 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$270 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$271 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$272 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$273 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$274 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$275 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$276 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$277 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$278 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$279 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$280 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$281 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$266, x$267, x$269, x$270, x$268, x$271, x$272, x$273, x$274, x$275, x$276, x$277, x$278, x$279, x$280, x$281);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), String.valueOf(true));
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.uncleanLeaderElectionEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Test
    public void testUncleanElectionInvalid() {
        int x$282 = 0;
        String x$283 = TestUtils$.MODULE$.MockZkConnect();
        int x$284 = 8181;
        boolean x$285 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$286 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$287 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$288 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$289 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$290 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$291 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$292 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$293 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$294 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$295 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$296 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$297 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$282, x$283, x$285, x$286, x$284, x$287, x$288, x$289, x$290, x$291, x$292, x$293, x$294, x$295, x$296, x$297);
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "invalid");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(ConfigException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
    }

    @Test
    public void testLogRollTimeMsProvided() {
        int x$298 = 0;
        String x$299 = TestUtils$.MODULE$.MockZkConnect();
        int x$300 = 8181;
        boolean x$301 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$302 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$303 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$304 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$305 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$306 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$307 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$308 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$309 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$310 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$311 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$312 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$313 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$298, x$299, x$301, x$302, x$300, x$303, x$304, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$312, x$313);
        props.put(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), "1800000");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)1800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testLogRollTimeBothMsAndHoursProvided() {
        int x$314 = 0;
        String x$315 = TestUtils$.MODULE$.MockZkConnect();
        int x$316 = 8181;
        boolean x$317 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$318 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$319 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$320 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$321 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$322 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$323 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$324 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$325 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$326 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$327 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$328 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$329 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$314, x$315, x$317, x$318, x$316, x$319, x$320, x$321, x$322, x$323, x$324, x$325, x$326, x$327, x$328, x$329);
        props.put(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), "1800000");
        props.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "1");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)1800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testLogRollTimeNoConfigProvided() {
        int x$330 = 0;
        String x$331 = TestUtils$.MODULE$.MockZkConnect();
        int x$332 = 8181;
        boolean x$333 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$334 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$335 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$336 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$337 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$338 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$339 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$340 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$341 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$342 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$343 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$344 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$345 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$330, x$331, x$333, x$334, x$332, x$335, x$336, x$337, x$338, x$339, x$340, x$341, x$342, x$343, x$344, x$345);
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)604800000L), (Object)cfg.logRollTimeMillis());
    }

    @Test
    public void testDefaultCompressionType() {
        int x$346 = 0;
        String x$347 = TestUtils$.MODULE$.MockZkConnect();
        int x$348 = 8181;
        boolean x$349 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$350 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$351 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$352 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$353 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$354 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$355 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$356 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$357 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$358 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$359 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$360 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$361 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$346, x$347, x$349, x$350, x$348, x$351, x$352, x$353, x$354, x$355, x$356, x$357, x$358, x$359, x$360, x$361);
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.compressionType(), (Object)"producer");
    }

    @Test
    public void testValidCompressionType() {
        int x$362 = 0;
        String x$363 = TestUtils$.MODULE$.MockZkConnect();
        int x$364 = 8181;
        boolean x$365 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$366 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$367 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$368 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$369 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$370 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$371 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$372 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$373 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$374 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$375 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$376 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$377 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$362, x$363, x$365, x$366, x$364, x$367, x$368, x$369, x$370, x$371, x$372, x$373, x$374, x$375, x$376, x$377);
        props.put("compression.type", "gzip");
        KafkaConfig serverConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assert.assertEquals((Object)serverConfig.compressionType(), (Object)"gzip");
    }

    @Test
    public void testInvalidCompressionType() {
        int x$378 = 0;
        String x$379 = TestUtils$.MODULE$.MockZkConnect();
        int x$380 = 8181;
        boolean x$381 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$382 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$383 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$384 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$385 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$386 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$387 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$388 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$389 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$390 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$391 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$392 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$393 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$378, x$379, x$381, x$382, x$380, x$383, x$384, x$385, x$386, x$387, x$388, x$389, x$390, x$391, x$392, x$393);
        props.put(KafkaConfig$.MODULE$.CompressionTypeProp(), "abc");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
    }

    @Test
    public void testInvalidInterBrokerSecurityProtocol() {
        int x$394 = 0;
        String x$395 = TestUtils$.MODULE$.MockZkConnect();
        int x$396 = 8181;
        boolean x$397 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$398 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$399 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$400 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$401 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$402 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$403 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$404 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$405 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$406 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$407 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$408 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$409 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$394, x$395, x$397, x$398, x$396, x$399, x$400, x$401, x$402, x$403, x$404, x$405, x$406, x$407, x$408, x$409);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:0");
        props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), SecurityProtocol.PLAINTEXT.toString());
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
    }

    @Test
    public void testEqualAdvertisedListenersProtocol() {
        int x$410 = 0;
        String x$411 = TestUtils$.MODULE$.MockZkConnect();
        int x$412 = 8181;
        boolean x$413 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$414 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$415 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$416 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$417 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$418 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$419 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$420 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$421 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$422 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$423 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$424 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$425 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$410, x$411, x$413, x$414, x$412, x$415, x$416, x$417, x$418, x$419, x$420, x$421, x$422, x$423, x$424, x$425);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
        KafkaConfig$.MODULE$.fromProps(props);
    }

    @Test
    public void testInvalidAdvertisedListenersProtocol() {
        int x$426 = 0;
        String x$427 = TestUtils$.MODULE$.MockZkConnect();
        int x$428 = 8181;
        boolean x$429 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$430 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$431 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$432 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$433 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$434 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$435 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$436 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$437 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$438 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$439 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$440 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$441 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$426, x$427, x$429, x$430, x$428, x$431, x$432, x$433, x$434, x$435, x$436, x$437, x$438, x$439, x$440, x$441);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "TRACE://localhost:9091,SSL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
    }

    @Test
    public void testFromPropsInvalid() {
        KafkaConfig$.MODULE$.fromProps(KafkaConfigTest.getBaseProperties$1());
        KafkaConfig$.MODULE$.configNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            KafkaConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSpecificProperties() {
        Properties defaults = new Properties();
        defaults.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        defaults.put(KafkaConfig$.MODULE$.ZkSessionTimeoutMsProp(), "1234");
        defaults.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        defaults.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "1");
        defaults.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        defaults.put(KafkaConfig$.MODULE$.HostNameProp(), "127.0.0.1");
        defaults.put(KafkaConfig$.MODULE$.PortProp(), "1122");
        defaults.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "127.0.0.1:2, 127.0.0.2:3");
        defaults.put(KafkaConfig$.MODULE$.LogDirProp(), "/tmp1,/tmp2");
        defaults.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "12");
        defaults.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "11");
        defaults.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "10");
        defaults.put(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "123");
        defaults.put(KafkaConfig$.MODULE$.OffsetsTopicCompressionCodecProp(), ((Object)BoxesRunTime.boxToInteger((int)SnappyCompressionCodec$.MODULE$.codec())).toString());
        defaults.put(KafkaConfig$.MODULE$.MetricRecordingLevelProp(), Sensor.RecordingLevel.DEBUG.toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(defaults);
        Assert.assertEquals((Object)"127.0.0.1:2181", (Object)config.zkConnect());
        Assert.assertEquals((long)1234L, (long)config.zkConnectionTimeoutMs());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.brokerIdGenerationEnable()));
        Assert.assertEquals((long)1L, (long)config.maxReservedBrokerId());
        Assert.assertEquals((long)1L, (long)config.brokerId());
        Assert.assertEquals((Object)"127.0.0.1", (Object)config.hostName());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1122), (Object)config.advertisedPort());
        Assert.assertEquals((Object)"127.0.0.1", (Object)config.advertisedHostName());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"127.0.0.1"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"127.0.0.2"), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)config.maxConnectionsPerIpOverrides());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/tmp1", "/tmp2"})), (Object)config.logDirs());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)43200000L), (Object)config.logRollTimeMillis());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)39600000L), (Object)config.logRollTimeJitterMillis());
        Assert.assertEquals((long)36000000L, (long)config.logRetentionTimeMillis());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)123L), (Object)config.logFlushIntervalMs());
        Assert.assertEquals((Object)SnappyCompressionCodec$.MODULE$, (Object)config.offsetsTopicCompressionCodec());
        Assert.assertEquals((Object)Sensor.RecordingLevel.DEBUG.toString(), (Object)config.metricRecordingLevel());
    }

    private void assertPropertyInvalid(Function0<Properties> validRequiredProps, String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = (Properties)validRequiredProps.apply();
            props.setProperty(name, value.toString());
            return (Exception)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaConfig$.MODULE$.fromProps(props), ClassTag$.MODULE$.apply(Exception.class), new Position("KafkaConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAdvertiseDefaults$1(EndPoint x$1) {
        SecurityProtocol securityProtocol = x$1.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAdvertiseConfigured$1(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAdvertisePortDefault$1(EndPoint x$3) {
        SecurityProtocol securityProtocol = x$3.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAdvertiseHostNameDefault$1(EndPoint x$4) {
        SecurityProtocol securityProtocol = x$4.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCaseInsensitiveListenerProtocol$1(EndPoint x$5) {
        String string = x$5.listenerName().value();
        String string2 = "SSL";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCaseInsensitiveListenerProtocol$3(EndPoint x$7) {
        String string = x$7.listenerName().value();
        String string2 = "PLAINTEXT";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testListenerDefaults$1(EndPoint x$9) {
        SecurityProtocol securityProtocol = x$9.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Properties getBaseProperties$1() {
        void var0;
        Properties validRequiredProperties = new Properties();
        validRequiredProperties.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        return var0;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(KafkaConfigTest $this, String name) {
        String string = name;
        String string2 = KafkaConfig$.MODULE$.ZkConnectProp();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSessionTimeoutMsProp();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = KafkaConfig$.MODULE$.ZkSyncTimeMsProp();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string10 = KafkaConfig$.MODULE$.ZkEnableSecureAclsProp();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string12 = KafkaConfig$.MODULE$.BrokerIdProp();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string14 = KafkaConfig$.MODULE$.NumNetworkThreadsProp();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String string16 = KafkaConfig$.MODULE$.NumIoThreadsProp();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        String string18 = KafkaConfig$.MODULE$.BackgroundThreadsProp();
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            String string20 = KafkaConfig$.MODULE$.QueuedMaxRequestsProp();
                                            String string21 = string;
                                            if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                String string22 = KafkaConfig$.MODULE$.RequestTimeoutMsProp();
                                                String string23 = string;
                                                if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    String string24 = KafkaConfig$.MODULE$.AuthorizerClassNameProp();
                                                    String string25 = string;
                                                    if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        String string26 = KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp();
                                                        String string27 = string;
                                                        if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            String string28 = KafkaConfig$.MODULE$.PortProp();
                                                            String string29 = string;
                                                            if (!(string28 != null ? !string28.equals(string29) : string29 != null)) {
                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                String string30 = KafkaConfig$.MODULE$.HostNameProp();
                                                                String string31 = string;
                                                                if (!(string30 != null ? !string30.equals(string31) : string31 != null)) {
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    String string32 = KafkaConfig$.MODULE$.AdvertisedHostNameProp();
                                                                    String string33 = string;
                                                                    if (!(string32 != null ? !string32.equals(string33) : string33 != null)) {
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        String string34 = KafkaConfig$.MODULE$.AdvertisedPortProp();
                                                                        String string35 = string;
                                                                        if (!(string34 != null ? !string34.equals(string35) : string35 != null)) {
                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        } else {
                                                                            String string36 = KafkaConfig$.MODULE$.SocketSendBufferBytesProp();
                                                                            String string37 = string;
                                                                            if (!(string36 != null ? !string36.equals(string37) : string37 != null)) {
                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            } else {
                                                                                String string38 = KafkaConfig$.MODULE$.SocketReceiveBufferBytesProp();
                                                                                String string39 = string;
                                                                                if (!(string38 != null ? !string38.equals(string39) : string39 != null)) {
                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                } else {
                                                                                    String string40 = KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp();
                                                                                    String string41 = string;
                                                                                    if (!(string40 != null ? !string40.equals(string41) : string41 != null)) {
                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"127.0.0.1:not_a_number"}));
                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    } else {
                                                                                        String string42 = KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp();
                                                                                        String string43 = string;
                                                                                        if (!(string42 != null ? !string42.equals(string43) : string43 != null)) {
                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                        } else {
                                                                                            String string44 = KafkaConfig$.MODULE$.NumPartitionsProp();
                                                                                            String string45 = string;
                                                                                            if (!(string44 != null ? !string44.equals(string45) : string45 != null)) {
                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                            } else {
                                                                                                String string46 = KafkaConfig$.MODULE$.LogDirsProp();
                                                                                                String string47 = string;
                                                                                                if (!(string46 != null ? !string46.equals(string47) : string47 != null)) {
                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                } else {
                                                                                                    String string48 = KafkaConfig$.MODULE$.LogDirProp();
                                                                                                    String string49 = string;
                                                                                                    if (!(string48 != null ? !string48.equals(string49) : string49 != null)) {
                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                    } else {
                                                                                                        String string50 = KafkaConfig$.MODULE$.LogSegmentBytesProp();
                                                                                                        String string51 = string;
                                                                                                        if (!(string50 != null ? !string50.equals(string51) : string51 != null)) {
                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", BoxesRunTime.boxToInteger((int)(Message$.MODULE$.MinMessageOverhead() - 1))}));
                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                        } else {
                                                                                                            String string52 = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
                                                                                                            String string53 = string;
                                                                                                            if (!(string52 != null ? !string52.equals(string53) : string53 != null)) {
                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                            } else {
                                                                                                                String string54 = KafkaConfig$.MODULE$.LogRollTimeHoursProp();
                                                                                                                String string55 = string;
                                                                                                                if (!(string54 != null ? !string54.equals(string55) : string55 != null)) {
                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                } else {
                                                                                                                    String string56 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
                                                                                                                    String string57 = string;
                                                                                                                    if (!(string56 != null ? !string56.equals(string57) : string57 != null)) {
                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                    } else {
                                                                                                                        String string58 = KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp();
                                                                                                                        String string59 = string;
                                                                                                                        if (!(string58 != null ? !string58.equals(string59) : string59 != null)) {
                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                        } else {
                                                                                                                            String string60 = KafkaConfig$.MODULE$.LogRetentionTimeHoursProp();
                                                                                                                            String string61 = string;
                                                                                                                            if (!(string60 != null ? !string60.equals(string61) : string61 != null)) {
                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                            } else {
                                                                                                                                String string62 = KafkaConfig$.MODULE$.LogRetentionBytesProp();
                                                                                                                                String string63 = string;
                                                                                                                                if (!(string62 != null ? !string62.equals(string63) : string63 != null)) {
                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                } else {
                                                                                                                                    String string64 = KafkaConfig$.MODULE$.LogCleanupIntervalMsProp();
                                                                                                                                    String string65 = string;
                                                                                                                                    if (!(string64 != null ? !string64.equals(string65) : string65 != null)) {
                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                    } else {
                                                                                                                                        String string66 = KafkaConfig$.MODULE$.LogCleanupPolicyProp();
                                                                                                                                        String string67 = string;
                                                                                                                                        if (!(string66 != null ? !string66.equals(string67) : string67 != null)) {
                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"unknown_policy", "0"}));
                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                        } else {
                                                                                                                                            String string68 = KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp();
                                                                                                                                            String string69 = string;
                                                                                                                                            if (!(string68 != null ? !string68.equals(string69) : string69 != null)) {
                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                            } else {
                                                                                                                                                String string70 = KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp();
                                                                                                                                                String string71 = string;
                                                                                                                                                if (!(string70 != null ? !string70.equals(string71) : string71 != null)) {
                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "1024"}));
                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                } else {
                                                                                                                                                    String string72 = KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp();
                                                                                                                                                    String string73 = string;
                                                                                                                                                    if (!(string72 != null ? !string72.equals(string73) : string73 != null)) {
                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                    } else {
                                                                                                                                                        String string74 = KafkaConfig$.MODULE$.LogCleanerEnableProp();
                                                                                                                                                        String string75 = string;
                                                                                                                                                        if (!(string74 != null ? !string74.equals(string75) : string75 != null)) {
                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean"}));
                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                        } else {
                                                                                                                                                            String string76 = KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp();
                                                                                                                                                            String string77 = string;
                                                                                                                                                            if (!(string76 != null ? !string76.equals(string77) : string77 != null)) {
                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                            } else {
                                                                                                                                                                String string78 = KafkaConfig$.MODULE$.LogCleanerMinCompactionLagMsProp();
                                                                                                                                                                String string79 = string;
                                                                                                                                                                if (!(string78 != null ? !string78.equals(string79) : string79 != null)) {
                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                } else {
                                                                                                                                                                    String string80 = KafkaConfig$.MODULE$.LogCleanerMinCleanRatioProp();
                                                                                                                                                                    String string81 = string;
                                                                                                                                                                    if (!(string80 != null ? !string80.equals(string81) : string81 != null)) {
                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                    } else {
                                                                                                                                                                        String string82 = KafkaConfig$.MODULE$.LogIndexSizeMaxBytesProp();
                                                                                                                                                                        String string83 = string;
                                                                                                                                                                        if (!(string82 != null ? !string82.equals(string83) : string83 != null)) {
                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "3"}));
                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                        } else {
                                                                                                                                                                            String string84 = KafkaConfig$.MODULE$.LogFlushIntervalMessagesProp();
                                                                                                                                                                            String string85 = string;
                                                                                                                                                                            if (!(string84 != null ? !string84.equals(string85) : string85 != null)) {
                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                            } else {
                                                                                                                                                                                String string86 = KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp();
                                                                                                                                                                                String string87 = string;
                                                                                                                                                                                if (!(string86 != null ? !string86.equals(string87) : string87 != null)) {
                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                } else {
                                                                                                                                                                                    String string88 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
                                                                                                                                                                                    String string89 = string;
                                                                                                                                                                                    if (!(string88 != null ? !string88.equals(string89) : string89 != null)) {
                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        String string90 = KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp();
                                                                                                                                                                                        String string91 = string;
                                                                                                                                                                                        if (!(string90 != null ? !string90.equals(string91) : string91 != null)) {
                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            String string92 = KafkaConfig$.MODULE$.LogFlushStartOffsetCheckpointIntervalMsProp();
                                                                                                                                                                                            String string93 = string;
                                                                                                                                                                                            if (!(string92 != null ? !string92.equals(string93) : string93 != null)) {
                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                            } else {
                                                                                                                                                                                                String string94 = KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp();
                                                                                                                                                                                                String string95 = string;
                                                                                                                                                                                                if (!(string94 != null ? !string94.equals(string95) : string95 != null)) {
                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    String string96 = KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp();
                                                                                                                                                                                                    String string97 = string;
                                                                                                                                                                                                    if (!(string96 != null ? !string96.equals(string97) : string97 != null)) {
                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        String string98 = KafkaConfig$.MODULE$.MinInSyncReplicasProp();
                                                                                                                                                                                                        String string99 = string;
                                                                                                                                                                                                        if (!(string98 != null ? !string98.equals(string99) : string99 != null)) {
                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            String string100 = KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp();
                                                                                                                                                                                                            String string101 = string;
                                                                                                                                                                                                            if (!(string100 != null ? !string100.equals(string101) : string101 != null)) {
                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                String string102 = KafkaConfig$.MODULE$.DefaultReplicationFactorProp();
                                                                                                                                                                                                                String string103 = string;
                                                                                                                                                                                                                if (!(string102 != null ? !string102.equals(string103) : string103 != null)) {
                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    String string104 = KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp();
                                                                                                                                                                                                                    String string105 = string;
                                                                                                                                                                                                                    if (!(string104 != null ? !string104.equals(string105) : string105 != null)) {
                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        String string106 = KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp();
                                                                                                                                                                                                                        String string107 = string;
                                                                                                                                                                                                                        if (!(string106 != null ? !string106.equals(string107) : string107 != null)) {
                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-2"}));
                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            String string108 = KafkaConfig$.MODULE$.ReplicaSocketReceiveBufferBytesProp();
                                                                                                                                                                                                                            String string109 = string;
                                                                                                                                                                                                                            if (!(string108 != null ? !string108.equals(string109) : string109 != null)) {
                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                String string110 = KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp();
                                                                                                                                                                                                                                String string111 = string;
                                                                                                                                                                                                                                if (!(string110 != null ? !string110.equals(string111) : string111 != null)) {
                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    String string112 = KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp();
                                                                                                                                                                                                                                    String string113 = string;
                                                                                                                                                                                                                                    if (!(string112 != null ? !string112.equals(string113) : string113 != null)) {
                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        String string114 = KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp();
                                                                                                                                                                                                                                        String string115 = string;
                                                                                                                                                                                                                                        if (!(string114 != null ? !string114.equals(string115) : string115 != null)) {
                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            String string116 = KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesProp();
                                                                                                                                                                                                                                            String string117 = string;
                                                                                                                                                                                                                                            if (!(string116 != null ? !string116.equals(string117) : string117 != null)) {
                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                String string118 = KafkaConfig$.MODULE$.NumReplicaFetchersProp();
                                                                                                                                                                                                                                                String string119 = string;
                                                                                                                                                                                                                                                if (!(string118 != null ? !string118.equals(string119) : string119 != null)) {
                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    String string120 = KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp();
                                                                                                                                                                                                                                                    String string121 = string;
                                                                                                                                                                                                                                                    if (!(string120 != null ? !string120.equals(string121) : string121 != null)) {
                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        String string122 = KafkaConfig$.MODULE$.FetchPurgatoryPurgeIntervalRequestsProp();
                                                                                                                                                                                                                                                        String string123 = string;
                                                                                                                                                                                                                                                        if (!(string122 != null ? !string122.equals(string123) : string123 != null)) {
                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            String string124 = KafkaConfig$.MODULE$.ProducerPurgatoryPurgeIntervalRequestsProp();
                                                                                                                                                                                                                                                            String string125 = string;
                                                                                                                                                                                                                                                            if (!(string124 != null ? !string124.equals(string125) : string125 != null)) {
                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                String string126 = KafkaConfig$.MODULE$.DeleteRecordsPurgatoryPurgeIntervalRequestsProp();
                                                                                                                                                                                                                                                                String string127 = string;
                                                                                                                                                                                                                                                                if (!(string126 != null ? !string126.equals(string127) : string127 != null)) {
                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    String string128 = KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp();
                                                                                                                                                                                                                                                                    String string129 = string;
                                                                                                                                                                                                                                                                    if (!(string128 != null ? !string128.equals(string129) : string129 != null)) {
                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        String string130 = KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp();
                                                                                                                                                                                                                                                                        String string131 = string;
                                                                                                                                                                                                                                                                        if (!(string130 != null ? !string130.equals(string131) : string131 != null)) {
                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            String string132 = KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp();
                                                                                                                                                                                                                                                                            String string133 = string;
                                                                                                                                                                                                                                                                            if (!(string132 != null ? !string132.equals(string133) : string133 != null)) {
                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                String string134 = KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp();
                                                                                                                                                                                                                                                                                String string135 = string;
                                                                                                                                                                                                                                                                                if (!(string134 != null ? !string134.equals(string135) : string135 != null)) {
                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    String string136 = KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp();
                                                                                                                                                                                                                                                                                    String string137 = string;
                                                                                                                                                                                                                                                                                    if (!(string136 != null ? !string136.equals(string137) : string137 != null)) {
                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        String string138 = KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp();
                                                                                                                                                                                                                                                                                        String string139 = string;
                                                                                                                                                                                                                                                                                        if (!(string138 != null ? !string138.equals(string139) : string139 != null)) {
                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            String string140 = KafkaConfig$.MODULE$.ControlledShutdownEnableProp();
                                                                                                                                                                                                                                                                                            String string141 = string;
                                                                                                                                                                                                                                                                                            if (!(string140 != null ? !string140.equals(string141) : string141 != null)) {
                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                String string142 = KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp();
                                                                                                                                                                                                                                                                                                String string143 = string;
                                                                                                                                                                                                                                                                                                if (!(string142 != null ? !string142.equals(string143) : string143 != null)) {
                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    String string144 = KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp();
                                                                                                                                                                                                                                                                                                    String string145 = string;
                                                                                                                                                                                                                                                                                                    if (!(string144 != null ? !string144.equals(string145) : string145 != null)) {
                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        String string146 = KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp();
                                                                                                                                                                                                                                                                                                        String string147 = string;
                                                                                                                                                                                                                                                                                                        if (!(string146 != null ? !string146.equals(string147) : string147 != null)) {
                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            String string148 = KafkaConfig$.MODULE$.OffsetMetadataMaxSizeProp();
                                                                                                                                                                                                                                                                                                            String string149 = string;
                                                                                                                                                                                                                                                                                                            if (!(string148 != null ? !string148.equals(string149) : string149 != null)) {
                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number"}));
                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                String string150 = KafkaConfig$.MODULE$.OffsetsLoadBufferSizeProp();
                                                                                                                                                                                                                                                                                                                String string151 = string;
                                                                                                                                                                                                                                                                                                                if (!(string150 != null ? !string150.equals(string151) : string151 != null)) {
                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    String string152 = KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp();
                                                                                                                                                                                                                                                                                                                    String string153 = string;
                                                                                                                                                                                                                                                                                                                    if (!(string152 != null ? !string152.equals(string153) : string153 != null)) {
                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        String string154 = KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp();
                                                                                                                                                                                                                                                                                                                        String string155 = string;
                                                                                                                                                                                                                                                                                                                        if (!(string154 != null ? !string154.equals(string155) : string155 != null)) {
                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            String string156 = KafkaConfig$.MODULE$.OffsetsTopicSegmentBytesProp();
                                                                                                                                                                                                                                                                                                                            String string157 = string;
                                                                                                                                                                                                                                                                                                                            if (!(string156 != null ? !string156.equals(string157) : string157 != null)) {
                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                String string158 = KafkaConfig$.MODULE$.OffsetsTopicCompressionCodecProp();
                                                                                                                                                                                                                                                                                                                                String string159 = string;
                                                                                                                                                                                                                                                                                                                                if (!(string158 != null ? !string158.equals(string159) : string159 != null)) {
                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1"}));
                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    String string160 = KafkaConfig$.MODULE$.OffsetsRetentionMinutesProp();
                                                                                                                                                                                                                                                                                                                                    String string161 = string;
                                                                                                                                                                                                                                                                                                                                    if (!(string160 != null ? !string160.equals(string161) : string161 != null)) {
                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        String string162 = KafkaConfig$.MODULE$.OffsetsRetentionCheckIntervalMsProp();
                                                                                                                                                                                                                                                                                                                                        String string163 = string;
                                                                                                                                                                                                                                                                                                                                        if (!(string162 != null ? !string162.equals(string163) : string163 != null)) {
                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            String string164 = KafkaConfig$.MODULE$.OffsetCommitTimeoutMsProp();
                                                                                                                                                                                                                                                                                                                                            String string165 = string;
                                                                                                                                                                                                                                                                                                                                            if (!(string164 != null ? !string164.equals(string165) : string165 != null)) {
                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                String string166 = KafkaConfig$.MODULE$.OffsetCommitRequiredAcksProp();
                                                                                                                                                                                                                                                                                                                                                String string167 = string;
                                                                                                                                                                                                                                                                                                                                                if (!(string166 != null ? !string166.equals(string167) : string167 != null)) {
                                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-2"}));
                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    String string168 = KafkaConfig$.MODULE$.TransactionalIdExpirationMsProp();
                                                                                                                                                                                                                                                                                                                                                    String string169 = string;
                                                                                                                                                                                                                                                                                                                                                    if (!(string168 != null ? !string168.equals(string169) : string169 != null)) {
                                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        String string170 = KafkaConfig$.MODULE$.TransactionsMaxTimeoutMsProp();
                                                                                                                                                                                                                                                                                                                                                        String string171 = string;
                                                                                                                                                                                                                                                                                                                                                        if (!(string170 != null ? !string170.equals(string171) : string171 != null)) {
                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            String string172 = KafkaConfig$.MODULE$.TransactionsTopicMinISRProp();
                                                                                                                                                                                                                                                                                                                                                            String string173 = string;
                                                                                                                                                                                                                                                                                                                                                            if (!(string172 != null ? !string172.equals(string173) : string173 != null)) {
                                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                String string174 = KafkaConfig$.MODULE$.TransactionsLoadBufferSizeProp();
                                                                                                                                                                                                                                                                                                                                                                String string175 = string;
                                                                                                                                                                                                                                                                                                                                                                if (!(string174 != null ? !string174.equals(string175) : string175 != null)) {
                                                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    String string176 = KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp();
                                                                                                                                                                                                                                                                                                                                                                    String string177 = string;
                                                                                                                                                                                                                                                                                                                                                                    if (!(string176 != null ? !string176.equals(string177) : string177 != null)) {
                                                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        String string178 = KafkaConfig$.MODULE$.TransactionsTopicSegmentBytesProp();
                                                                                                                                                                                                                                                                                                                                                                        String string179 = string;
                                                                                                                                                                                                                                                                                                                                                                        if (!(string178 != null ? !string178.equals(string179) : string179 != null)) {
                                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            String string180 = KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp();
                                                                                                                                                                                                                                                                                                                                                                            String string181 = string;
                                                                                                                                                                                                                                                                                                                                                                            if (!(string180 != null ? !string180.equals(string181) : string181 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0", "-2"}));
                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                String string182 = KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp();
                                                                                                                                                                                                                                                                                                                                                                                String string183 = string;
                                                                                                                                                                                                                                                                                                                                                                                if (!(string182 != null ? !string182.equals(string183) : string183 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    String string184 = KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp();
                                                                                                                                                                                                                                                                                                                                                                                    String string185 = string;
                                                                                                                                                                                                                                                                                                                                                                                    if (!(string184 != null ? !string184.equals(string185) : string185 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        String string186 = KafkaConfig$.MODULE$.NumQuotaSamplesProp();
                                                                                                                                                                                                                                                                                                                                                                                        String string187 = string;
                                                                                                                                                                                                                                                                                                                                                                                        if (!(string186 != null ? !string186.equals(string187) : string187 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            String string188 = KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp();
                                                                                                                                                                                                                                                                                                                                                                                            String string189 = string;
                                                                                                                                                                                                                                                                                                                                                                                            if (!(string188 != null ? !string188.equals(string189) : string189 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                String string190 = KafkaConfig$.MODULE$.DeleteTopicEnableProp();
                                                                                                                                                                                                                                                                                                                                                                                                String string191 = string;
                                                                                                                                                                                                                                                                                                                                                                                                if (!(string190 != null ? !string190.equals(string191) : string191 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                    $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_boolean", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                    String string192 = KafkaConfig$.MODULE$.MetricNumSamplesProp();
                                                                                                                                                                                                                                                                                                                                                                                                    String string193 = string;
                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string192 != null ? !string192.equals(string193) : string193 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                        $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                        String string194 = KafkaConfig$.MODULE$.MetricSampleWindowMsProp();
                                                                                                                                                                                                                                                                                                                                                                                                        String string195 = string;
                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string194 != null ? !string194.equals(string195) : string195 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1", "0"}));
                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                            String string196 = KafkaConfig$.MODULE$.MetricReporterClassesProp();
                                                                                                                                                                                                                                                                                                                                                                                                            String string197 = string;
                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string196 != null ? !string196.equals(string197) : string197 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                String string198 = KafkaConfig$.MODULE$.MetricRecordingLevelProp();
                                                                                                                                                                                                                                                                                                                                                                                                                String string199 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string198 != null ? !string198.equals(string199) : string199 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                    String string200 = KafkaConfig$.MODULE$.RackProp();
                                                                                                                                                                                                                                                                                                                                                                                                                    String string201 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string200 != null ? !string200.equals(string201) : string201 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                        String string202 = KafkaConfig$.MODULE$.PrincipalBuilderClassProp();
                                                                                                                                                                                                                                                                                                                                                                                                                        String string203 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string202 != null ? !string202.equals(string203) : string203 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                            String string204 = KafkaConfig$.MODULE$.SslProtocolProp();
                                                                                                                                                                                                                                                                                                                                                                                                                            String string205 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string204 != null ? !string204.equals(string205) : string205 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                String string206 = KafkaConfig$.MODULE$.SslProviderProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                String string207 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string206 != null ? !string206.equals(string207) : string207 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                    String string208 = KafkaConfig$.MODULE$.SslEnabledProtocolsProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                    String string209 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string208 != null ? !string208.equals(string209) : string209 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                        String string210 = KafkaConfig$.MODULE$.SslKeystoreTypeProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                        String string211 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string210 != null ? !string210.equals(string211) : string211 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                            String string212 = KafkaConfig$.MODULE$.SslKeystoreLocationProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                            String string213 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string212 != null ? !string212.equals(string213) : string213 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                String string214 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                String string215 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string214 != null ? !string214.equals(string215) : string215 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string216 = KafkaConfig$.MODULE$.SslKeyPasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string217 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string216 != null ? !string216.equals(string217) : string217 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string218 = KafkaConfig$.MODULE$.SslTruststoreTypeProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string219 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string218 != null ? !string218.equals(string219) : string219 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string220 = KafkaConfig$.MODULE$.SslTruststorePasswordProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string221 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string220 != null ? !string220.equals(string221) : string221 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string222 = KafkaConfig$.MODULE$.SslTruststoreLocationProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string223 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string222 != null ? !string222.equals(string223) : string223 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string224 = KafkaConfig$.MODULE$.SslKeyManagerAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string225 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string224 != null ? !string224.equals(string225) : string225 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string226 = KafkaConfig$.MODULE$.SslTrustManagerAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string227 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string226 != null ? !string226.equals(string227) : string227 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string228 = KafkaConfig$.MODULE$.SslClientAuthProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string229 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string228 != null ? !string228.equals(string229) : string229 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string230 = KafkaConfig$.MODULE$.SslEndpointIdentificationAlgorithmProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string231 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string230 != null ? !string230.equals(string231) : string231 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string232 = KafkaConfig$.MODULE$.SslSecureRandomImplementationProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string233 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string232 != null ? !string232.equals(string233) : string233 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string234 = KafkaConfig$.MODULE$.SslCipherSuitesProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string235 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string234 != null ? !string234.equals(string235) : string235 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string236 = KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string237 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string236 != null ? !string236.equals(string237) : string237 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string238 = KafkaConfig$.MODULE$.SaslEnabledMechanismsProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string239 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string238 != null ? !string238.equals(string239) : string239 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string240 = KafkaConfig$.MODULE$.SaslKerberosServiceNameProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string241 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string240 != null ? !string240.equals(string241) : string241 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string242 = KafkaConfig$.MODULE$.SaslKerberosKinitCmdProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string243 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string242 != null ? !string242.equals(string243) : string243 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string244 = KafkaConfig$.MODULE$.SaslKerberosTicketRenewWindowFactorProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String string245 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!(string244 != null ? !string244.equals(string245) : string245 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string246 = KafkaConfig$.MODULE$.SaslKerberosTicketRenewJitterProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String string247 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!(string246 != null ? !string246.equals(string247) : string247 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string248 = KafkaConfig$.MODULE$.SaslKerberosMinTimeBeforeReloginProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String string249 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!(string248 != null ? !string248.equals(string249) : string249 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string250 = KafkaConfig$.MODULE$.SaslKerberosPrincipalToLocalRulesProp();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        String string251 = string;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!(string250 != null ? !string250.equals(string251) : string251 != null)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            $this.assertPropertyInvalid((Function0<Properties>)(Function0 & Serializable & scala.Serializable)() -> KafkaConfigTest.getBaseProperties$1(), name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"not_a_number", "-1"}));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

