/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001B\u0001\u0003\u0001\u001d\u0011!CU3qY&\u001c\u0017-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005)Ao\u001c9jGV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\rM#(/\u001b8h\u0011\u0019y\u0002\u0001)A\u0005-\u00051Ao\u001c9jG\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003uS6,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!B;uS2\u001c\u0018B\u0001\u0015&\u0005!iunY6US6,\u0007B\u0002\u0016\u0001A\u0003%1%A\u0003uS6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\u000f5,GO]5dgV\ta\u0006\u0005\u00020q5\t\u0001G\u0003\u0002-c)\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0019\u0003\u000f5+GO]5dg\"11\b\u0001Q\u0001\n9\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002y\n\u0001B_6DY&,g\u000e^\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\tu.\u001cG.[3oi*\u0011AIN\u0001\u0007\u0013BJE/Z2\n\u0005\u0019\u000b%\u0001\u0003.l\u00072LWM\u001c;\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0003I\u0015\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fHC\u0001&N!\tI1*\u0003\u0002M\u0015\t!QK\\5u\u0011\u001dqu)!AA\u0002}\n1\u0001\u001f\u00132\u0011\u0019\u0001\u0006\u0001)Q\u0005\u007f\u0005I!p[\"mS\u0016tG\u000f\t\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002M\u000bqA_6Vi&d7/F\u0001U!\t!S+\u0003\u0002WK\t9!l[+uS2\u001c\b\"\u0003-\u0001\u0001\u0004\u0005\r\u0011\"\u0001Z\u0003-Q8.\u0016;jYN|F%Z9\u0015\u0005)S\u0006b\u0002(X\u0003\u0003\u0005\r\u0001\u0016\u0005\u00079\u0002\u0001\u000b\u0015\u0002+\u0002\u0011i\\W\u000b^5mg\u0002BQA\u0018\u0001\u0005\u0002}\u000bQa]3u+B$\u0012A\u0013\u0015\u0003;\u0006\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u001c\u0002\u000b),h.\u001b;\n\u0005\u0019\u001c'A\u0002\"fM>\u0014X\rC\u0003i\u0001\u0011\u0005q,\u0001\u0005uK\u0006\u0014Hi\\<oQ\t9'\u000e\u0005\u0002cW&\u0011An\u0019\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006]\u0002!\taX\u0001\"i\u0016\u001cH\u000fS5hQ^\u000bG/\u001a:NCJ\\G)\u001b:fGR|'/_'baBLgn\u001a\u0015\u0003[B\u0004\"AY9\n\u0005I\u001c'\u0001\u0002+fgRDQ\u0001\u001e\u0001\u0005\u0002}\u000b\u0011\u0006^3ti\"Kw\r[<bi\u0016\u0014X*\u0019:l%\u0016d\u0017\r^5wK\u0012K'/Z2u_JLX*\u00199qS:<\u0007FA:q\u0011\u00159\b\u0001\"\u0001`\u0003]!Xm\u001d;JY2,w-\u00197SKF,\u0018N]3e\u0003\u000e\\7\u000f\u000b\u0002wa\")!\u0010\u0001C\u0001?\u0006!C/Z:u\u00072,\u0017M\u001d)ve\u001e\fGo\u001c:z\u001f:\u0014UmY8nS:<gi\u001c7m_^,'\u000f\u000b\u0002za\")Q\u0010\u0001C\u0001?\u0006\u0011C/Z:u%\u0016\fGmQ8n[&$H/\u001a3GKR\u001c\u0007\u000eT5nSR,G-\u0011;M'>C#\u0001 9\t\r\u0005\u0005\u0001\u0001\"\u0001`\u0003-\"Xm\u001d;EK2\f\u00170\u001a3GKR\u001c\u0007.\u00138dYV$Wm]!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\bFA@q\u0011\u0019\t9\u0001\u0001C\u0001?\u0006yC/Z:u\r\u0016$8\r\u001b\"fs>tG\rS5hQ^\u000bG/\u001a:nCJ\\'+\u001a;ve:,U\u000e\u001d;z%\u0016\u001c\bo\u001c8tK\"\u001a\u0011Q\u00019\u0007\r\u00055\u0001\u0001BA\b\u00059\u0019\u0015\r\u001c7cC\u000e\\'+Z:vYR,B!!\u0005\u0002 M\u0019\u00111\u0002\u0005\t\u000f=\tY\u0001\"\u0001\u0002\u0016Q\u0011\u0011q\u0003\t\u0007\u00033\tY!a\u0007\u000e\u0003\u0001\u0001B!!\b\u0002 1\u0001A\u0001CA\u0011\u0003\u0017\u0011\r!a\t\u0003\u0003Q\u000bB!!\n\u0002,A\u0019\u0011\"a\n\n\u0007\u0005%\"BA\u0004O_RD\u0017N\\4\u0011\u0007%\ti#C\u0002\u00020)\u00111!\u00118z\u0011)\t\u0019$a\u0003A\u0002\u0013%\u0011QG\u0001\u0006m\u0006dW/Z\u000b\u0003\u0003o\u0001R!CA\u001d\u00037I1!a\u000f\u000b\u0005\u0019y\u0005\u000f^5p]\"Q\u0011qHA\u0006\u0001\u0004%I!!\u0011\u0002\u0013Y\fG.^3`I\u0015\fHc\u0001&\u0002D!Ia*!\u0010\u0002\u0002\u0003\u0007\u0011q\u0007\u0005\n\u0003\u000f\nY\u0001)Q\u0005\u0003o\taA^1mk\u0016\u0004\u0003BCA&\u0003\u0017\u0001\r\u0011\"\u0003\u0002N\u0005\u0019a-\u001e8\u0016\u0005\u0005=\u0003#B\u0005\u0002:\u0005E\u0003CB\u0005\u0002T\u0005m!*C\u0002\u0002V)\u0011\u0011BR;oGRLwN\\\u0019\t\u0015\u0005e\u00131\u0002a\u0001\n\u0013\tY&A\u0004gk:|F%Z9\u0015\u0007)\u000bi\u0006C\u0005O\u0003/\n\t\u00111\u0001\u0002P!I\u0011\u0011MA\u0006A\u0003&\u0011qJ\u0001\u0005MVt\u0007\u0005\u0003\u0005\u0002f\u0005-A\u0011AA4\u0003-\t7o]3si\u001aK'/\u001a3\u0016\u0005\u0005m\u0001\u0002CA6\u0003\u0017!\t!!\u001c\u0002\u000f%\u001ch)\u001b:fIV\u0011\u0011q\u000e\t\u0004\u0013\u0005E\u0014bAA:\u0015\t9!i\\8mK\u0006t\u0007\u0002CA<\u0003\u0017!\t!!\u001f\u0002\t\u0019L'/\u001a\u000b\u0004\u0015\u0006m\u0004\u0002CA\u001a\u0003k\u0002\r!a\u0007\t\u0011\u0005}\u00141\u0002C\u0001\u0003\u0003\u000baa\u001c8GSJ,G\u0003BA\f\u0003\u0007C\u0001\"a\u0013\u0002~\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003\u000f\u0003A\u0011BAE\u00035\t\u0007\u000f]3oIJ+7m\u001c:egRQ\u00111RA]\u0003\u0007\fy-a8\u0011\r\u0005e\u00111BAG!\u0011\ty)a-\u000f\t\u0005E\u0015Q\u0016\b\u0005\u0003'\u000bIK\u0004\u0003\u0002\u0016\u0006\u001df\u0002BAL\u0003KsA!!'\u0002$:!\u00111TAQ\u001b\t\tiJC\u0002\u0002 \u001a\ta\u0001\u0010:p_Rt\u0014\"A\u001c\n\u0005U2\u0014BA\u00035\u0013\t\u00114'C\u0002\u0002,F\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003_\u000b\t,A\bQe>$WoY3SKN\u0004xN\\:f\u0015\r\tY+M\u0005\u0005\u0003k\u000b9LA\tQCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016TA!a,\u00022\"A\u00111XAC\u0001\u0004\ti,\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007I\ty,C\u0002\u0002B\n\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005\u0002F\u0006\u0015\u0005\u0019AAd\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002J\u0006-W\"A\u0019\n\u0007\u00055\u0017G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005E\u0017Q\u0011a\u0001\u0003'\fqA]3d_J$7\u000f\u0005\u0003\u0002V\u0006mWBAAl\u0015\r\tI.M\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005u\u0017q\u001b\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0015\u0005\u0005\u0018Q\u0011I\u0001\u0002\u0004\ty'\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG\u000fC\u0004\u0002f\u0002!I!a:\u0002\u001f\u0019,Go\u00195Bg\u000e{gn];nKJ$B\"!;\u0002r\u0006M\u0018Q\u001fB\u0004\u0005#\u0001b!!\u0007\u0002\f\u0005-\bc\u0001\n\u0002n&\u0019\u0011q\u001e\u0002\u0003%\u0019+Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\t\u0003w\u000b\u0019\u000f1\u0001\u0002>\"A\u0011QYAr\u0001\u0004\t9\r\u0003\u0005\u0002x\u0006\r\b\u0019AA}\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!\u00111 B\u0001\u001d\u0011\t\t*!@\n\t\u0005}\u0018\u0011W\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0005\u0007\u0011)AA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0003\u007f\f\t\f\u0003\u0006\u0003\n\u0005\r\b\u0013!a\u0001\u0005\u0017\t\u0001\"\\5o\u0005f$Xm\u001d\t\u0004\u0013\t5\u0011b\u0001B\b\u0015\t\u0019\u0011J\u001c;\t\u0015\tM\u00111\u001dI\u0001\u0002\u0004\u0011)\"\u0001\bjg>d\u0017\r^5p]2+g/\u001a7\u0011\t\t]!\u0011D\u0007\u0003\u0003cKAAa\u0007\u00022\nq\u0011j]8mCRLwN\u001c'fm\u0016d\u0007b\u0002B\u0010\u0001\u0011%!\u0011E\u0001\u0010M\u0016$8\r[!t\r>dGn\\<feRa\u0011\u0011\u001eB\u0012\u0005K\u00119C!\u000b\u0003,!A\u00111\u0018B\u000f\u0001\u0004\ti\f\u0003\u0005\u0002F\nu\u0001\u0019AAd\u0011!\t9P!\bA\u0002\u0005e\bB\u0003B\u0005\u0005;\u0001\n\u00111\u0001\u0003\f!Q!1\u0003B\u000f!\u0003\u0005\rA!\u0006\t\u000f\t=\u0002\u0001\"\u0003\u00032\u0005ia-\u001a;dQ6+7o]1hKN$b\"!;\u00034\tU\"\u0011\bB\u001e\u0005{\u0011y\u0004\u0003\u0005\u0002<\n5\u0002\u0019AA_\u0011!\u00119D!\fA\u0002\t-\u0011!\u0003:fa2L7-Y%e\u0011!\t)M!\fA\u0002\u0005\u001d\u0007\u0002CA|\u0005[\u0001\r!!?\t\u0011\t%!Q\u0006a\u0001\u0005\u0017A\u0001Ba\u0005\u0003.\u0001\u0007!Q\u0003\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0003!\u001aX\r^;q%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s/&$\b.T8dW\u0016$\u0007+\u001e:hCR|'/[3t)\u0011\tiLa\u0012\t\u0011\t%#\u0011\ta\u0001\u0005\u0017\nQ\u0001^5nKJ\u0004BA!\u0014\u0003R5\u0011!q\n\u0006\u0004\u0005\u0013*\u0013\u0002\u0002B*\u0005\u001f\u0012\u0011\"T8dWRKW.\u001a:\t\u0013\t]\u0003!%A\u0005\n\te\u0013aF1qa\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YF\u000b\u0003\u0002p\tu3F\u0001B0!\u0011\u0011\tGa\u001b\u000e\u0005\t\r$\u0002\u0002B3\u0005O\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%$\"\u0001\u0006b]:|G/\u0019;j_:LAA!\u001c\u0003d\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\tE\u0004!%A\u0005\n\tM\u0014!\u00074fi\u000eD\u0017i]\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIQ*\"A!\u001e+\t\t-!Q\f\u0005\n\u0005s\u0002\u0011\u0013!C\u0005\u0005w\n\u0011DZ3uG\"\f5oQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u0010\u0016\u0005\u0005+\u0011i\u0006C\u0005\u0003\u0002\u0002\t\n\u0011\"\u0003\u0003t\u0005Ib-\u001a;dQ\u0006\u001bhi\u001c7m_^,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011%\u0011)\tAI\u0001\n\u0013\u0011Y(A\rgKR\u001c\u0007.Q:G_2dwn^3sI\u0011,g-Y;mi\u0012*\u0004")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private ZkUtils zkUtils;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkClient(), false));
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), ReplicaManager$.MODULE$.$lessinit$greater$default$11());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1);
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), ReplicaManager$.MODULE$.$lessinit$greater$default$11());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1);
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())}))})), (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.callback$1(responseStatus);
                return BoxedUnit.UNIT;
            }, rm.appendRecords$default$7());
        }
        finally {
            rm.shutdown(false);
        }
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$4 -> new File((String)x$4), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), new LogConfig((java.util.Map)logProps), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), new BrokerTopicStats(), metadataCache, ReplicaManager$.MODULE$.$lessinit$greater$default$11());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0);
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 0, 0, brokerList, 0, brokerList))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$2(x$5, x$6);
                return BoxedUnit.UNIT;
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.appendRecords(rm, new TopicPartition(this.topic(), 0), records, this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$3(response);
                return BoxedUnit.UNIT;
            });
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(0L, 0L, 100000), 100000, this.fetchAsConsumer$default$5());
            Assert.assertFalse((boolean)fetchResult.isFired());
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 1, 1, brokerList, 0, brokerList))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$4(x$7, x$8);
                return BoxedUnit.UNIT;
            });
            Assert.assertTrue((boolean)appendResult.isFired());
            Assert.assertTrue((boolean)fetchResult.isFired());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer);
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0);
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 0, 0, brokerList, 0, brokerList))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$1(x$9, x$10);
                return BoxedUnit.UNIT;
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$2(this, replicaManager, producerId, epoch, BoxesRunTime.unboxToInt((Object)sequence)));
            ReplicaManager x$18 = replicaManager;
            TopicPartition x$19 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$20 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000);
            IsolationLevel x$21 = IsolationLevel.READ_UNCOMMITTED;
            int x$22 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$18, x$19, x$20, x$22, x$21);
            ReplicaManager x$23 = replicaManager;
            TopicPartition x$24 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$25 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$26 = IsolationLevel.READ_COMMITTED;
            int x$27 = this.fetchAsConsumer$default$4();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(x$23, x$24, x$25, x$27, x$26);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            ReplicaManager x$28 = replicaManager;
            TopicPartition x$29 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$30 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$31 = IsolationLevel.READ_COMMITTED;
            int x$32 = 1000;
            consumerFetchResult = this.fetchAsConsumer(x$28, x$29, x$30, x$32, x$31);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, false).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$4(response);
                return BoxedUnit.UNIT;
            });
            ReplicaManager x$33 = replicaManager;
            TopicPartition x$34 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$35 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$36 = IsolationLevel.READ_COMMITTED;
            int x$37 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$33, x$34, x$35, x$37, x$36);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            ReplicaManager x$38 = replicaManager;
            TopicPartition x$39 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$40 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000);
            IsolationLevel x$41 = IsolationLevel.READ_UNCOMMITTED;
            int x$42 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$38, x$39, x$40, x$42, x$41);
            ReplicaManager x$43 = replicaManager;
            TopicPartition x$44 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$45 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$46 = IsolationLevel.READ_COMMITTED;
            int x$47 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$43, x$44, x$45, x$47, x$46);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer);
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            java.util.Set brokerSet = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0);
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 0, 0, brokerList, 0, brokerList))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$1(x$11, x$12);
                return BoxedUnit.UNIT;
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$2(this, replicaManager, producerId, epoch, BoxesRunTime.unboxToInt((Object)sequence)));
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, false).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$4(response);
                return BoxedUnit.UNIT;
            });
            ReplicaManager x$48 = replicaManager;
            TopicPartition x$49 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$50 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000);
            IsolationLevel x$51 = IsolationLevel.READ_UNCOMMITTED;
            int x$52 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$48, x$49, x$50, x$52, x$51);
            ReplicaManager x$53 = replicaManager;
            TopicPartition x$54 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$55 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$56 = IsolationLevel.READ_COMMITTED;
            int x$57 = 10000;
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(x$53, x$54, x$55, x$57, x$56);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        props.put("broker.id", BoxesRunTime.boxToInteger((int)0));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$13 -> new File((String)x$13), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), new LogConfig((java.util.Map)logProps), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host2", 2, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.isBrokerAlive(EasyMock.eq((int)0)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.isBrokerAlive(EasyMock.eq((int)1)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.isBrokerAlive(EasyMock.eq((int)2)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), new BrokerTopicStats(), metadataCache, Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0);
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 0, 0, brokerList, 0, brokerList))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$14, x$15) -> {
                ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(x$14, x$15);
                return BoxedUnit.UNIT;
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(this, rm, BoxesRunTime.unboxToInt((Object)i)));
            CallbackResult<FetchPartitionData> followerFetchResult = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5());
            FetchPartitionData followerFetchData = followerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5());
            FetchPartitionData consumerFetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        finally {
            rm.shutdown(false);
        }
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, boolean isFromClient) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, (short)-1, false, isFromClient, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable & scala.Serializable)responses -> {
            ReplicaManagerTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7());
        return result;
    }

    private boolean appendRecords$default$4() {
        return true;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        long x$58 = 1000L;
        int x$59 = replicaId;
        int x$60 = minBytes;
        int x$61 = Integer.MAX_VALUE;
        boolean x$62 = false;
        Seq x$63 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)partitionData)}));
        Function1 & Serializable & scala.Serializable x$64 = (Function1 & Serializable & scala.Serializable)responseStatus -> {
            ReplicaManagerTest.fetchCallback$1(responseStatus, partition, result);
            return BoxedUnit.UNIT;
        };
        IsolationLevel x$65 = isolationLevel;
        ReplicaQuota x$66 = replicaManager.fetchMessages$default$7();
        replicaManager.fetchMessages(x$58, x$59, x$60, x$61, x$62, x$63, x$66, (Function1)x$64, x$65);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        props.put("broker.id", BoxesRunTime.boxToInteger((int)0));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$17 -> new File((String)x$17), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), new LogConfig((java.util.Map)logProps), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.isBrokerAlive(EasyMock.eq((int)0)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.isBrokerAlive(EasyMock.eq((int)1)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        String x$67 = "Produce";
        MockTimer x$68 = timer;
        boolean x$69 = false;
        int x$70 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$71 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$72 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$67, (Timer)x$68, x$70, x$71, x$69, x$72);
        String x$73 = "Fetch";
        MockTimer x$74 = timer;
        boolean x$75 = false;
        int x$76 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$77 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$78 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$73, (Timer)x$74, x$76, x$77, x$75, x$78);
        String x$79 = "DeleteRecords";
        MockTimer x$80 = timer;
        boolean x$81 = false;
        int x$82 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$83 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$84 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$79, (Timer)x$80, x$82, x$83, x$81, x$84);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), new BrokerTopicStats(), metadataCache, mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private static final void callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$2(Iterable x$5, Iterable x$6) {
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$4(Iterable x$7, Iterable x$8) {
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$1(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReadCommittedFetchLimitedAtLSO$2(ReplicaManagerTest $this, ReplicaManager replicaManager$1, long producerId$1, short epoch$1, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$1, (short)epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
        return $this.appendRecords(replicaManager$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$1(Iterable x$11, Iterable x$12) {
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testDelayedFetchIncludesAbortedTransactions$2(ReplicaManagerTest $this, ReplicaManager replicaManager$2, long producerId$2, short epoch$2, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$2, (short)epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
        return $this.appendRecords(replicaManager$2, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(Iterable x$14, Iterable x$15) {
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(ReplicaManagerTest $this, ReplicaManager rm$1, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return $this.appendRecords(rm$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$4(response);
            return BoxedUnit.UNIT;
        });
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    private static final void fetchCallback$1(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)fetchData);
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        FetchPartitionData fetchData2 = (FetchPartitionData)tuple23._2();
        Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
        result$2.fire(fetchData2);
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable & scala.Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            block0: {
                this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
                if (!this.isFired()) break block0;
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

