/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.log.LogConfig$;
import kafka.network.RequestChannel;
import kafka.security.auth.Operation;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.server.BaseRequestTest;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.server.RequestQuotaTest$;
import kafka.server.RequestQuotaTest$Client$;
import kafka.server.RequestQuotaTest$Task$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.security.auth.DefaultPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011]g\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CU3rk\u0016\u001cH/U;pi\u0006$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u0015\t\u0002\u0001\"\u0011\u0013\u0003)qW/\u001c\"s_.,'o]\u000b\u0002'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t\u0019\u0011J\u001c;\t\u000fi\u0001!\u0019!C\u00057\u0005)Ao\u001c9jGV\tA\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\rM#(/\u001b8h\u0011\u0019)\u0003\u0001)A\u00059\u00051Ao\u001c9jG\u0002Bqa\n\u0001C\u0002\u0013%!#A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007S\u0001\u0001\u000b\u0011B\n\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA!91\u0006\u0001b\u0001\n\u0013a\u0013A\u0001;q+\u0005i\u0003C\u0001\u00187\u001b\u0005y#B\u0001\u00192\u0003\u0019\u0019w.\\7p]*\u0011QA\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028_\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB\u001d\u0001A\u0003%Q&A\u0002ua\u0002Bqa\u000f\u0001C\u0002\u0013%1$A\nv]RD'o\u001c;uY\u0016$7\t\\5f]RLE\r\u0003\u0004>\u0001\u0001\u0006I\u0001H\u0001\u0015k:$\bN]8ui2,Gm\u00117jK:$\u0018\n\u001a\u0011\t\u000f}\u0002!\u0019!C\u0005\u0001\u0006A!M]8lKJLE-F\u0001B!\ti\")\u0003\u0002D=\t9\u0011J\u001c;fO\u0016\u0014\bBB#\u0001A\u0003%\u0011)A\u0005ce>\\WM]%eA!9q\t\u0001a\u0001\n\u0013A\u0015A\u00037fC\u0012,'OT8eKV\t\u0011\n\u0005\u0002\n\u0015&\u00111J\u0001\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0004N\u0001\u0001\u0007I\u0011\u0002(\u0002\u001d1,\u0017\rZ3s\u001d>$Wm\u0018\u0013fcR\u0011qJ\u0015\t\u0003)AK!!U\u000b\u0003\tUs\u0017\u000e\u001e\u0005\b'2\u000b\t\u00111\u0001J\u0003\rAH%\r\u0005\u0007+\u0002\u0001\u000b\u0015B%\u0002\u00171,\u0017\rZ3s\u001d>$W\r\t\u0004\u0005/\u0002\u0001\u0005L\u0001\u0003UCN\\7\u0003\u0002,Z9~\u0003\"\u0001\u0006.\n\u0005m+\"AB!osJ+g\r\u0005\u0002\u0015;&\u0011a,\u0006\u0002\b!J|G-^2u!\t!\u0002-\u0003\u0002b+\ta1+\u001a:jC2L'0\u00192mK\"A1M\u0016BK\u0002\u0013\u0005A-\u0001\u0004ba&\\U-_\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001nL\u0001\taJ|Go\\2pY&\u0011!n\u001a\u0002\b\u0003BL7*Z=t\u0011!agK!E!\u0002\u0013)\u0017aB1qS.+\u0017\u0010\t\u0005\t]Z\u0013)\u001a!C\u0001_\u00061a-\u001e;ve\u0016,\u0012\u0001\u001d\u0019\u0003cn\u00042A]<z\u001b\u0005\u0019(B\u0001;v\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003m\u0002\nA!\u001e;jY&\u0011\u0001p\u001d\u0002\u0007\rV$XO]3\u0011\u0005i\\H\u0002\u0001\u0003\nyv\f\t\u0011!A\u0003\u0002}\u00141a\u0018\u00132\u0011!qhK!E!\u0002\u0013\u0001\u0018a\u00024viV\u0014X\rI\t\u0005\u0003\u0003\t9\u0001E\u0002\u0015\u0003\u0007I1!!\u0002\u0016\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001FA\u0005\u0013\r\tY!\u0006\u0002\u0004\u0003:L\bBB\u0007W\t\u0003\ty\u0001\u0006\u0004\u0002\u0012\u0005U\u0011q\u0003\t\u0004\u0003'1V\"\u0001\u0001\t\r\r\fi\u00011\u0001f\u0011\u001dq\u0017Q\u0002a\u0001\u00033\u0001D!a\u0007\u0002 A!!o^A\u000f!\rQ\u0018q\u0004\u0003\u000by\u0006]\u0011\u0011!A\u0001\u0006\u0003y\b\"CA\u0012-\u0006\u0005I\u0011AA\u0013\u0003\u0011\u0019w\u000e]=\u0015\r\u0005E\u0011qEA\u0015\u0011!\u0019\u0017\u0011\u0005I\u0001\u0002\u0004)\u0007\"\u00038\u0002\"A\u0005\t\u0019AA\r\u0011%\tiCVI\u0001\n\u0003\ty#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E\"fA3\u00024-\u0012\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003%)hn\u00195fG.,GMC\u0002\u0002@U\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019%!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002HY\u000b\n\u0011\"\u0001\u0002J\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA&a\u0011\ti%!\u0015\u0011\tI<\u0018q\n\t\u0004u\u0006ECA\u0003?\u0002F\u0005\u0005\t\u0011!B\u0001\u007f\"A\u0011Q\u000b,\u0002\u0002\u0013\u00053$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\t\u000332\u0016\u0011!C\u0001%\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011Q\f,\u0002\u0002\u0013\u0005\u0011qL\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9!!\u0019\t\u0011M\u000bY&!AA\u0002MA\u0011\"!\u001aW\u0003\u0003%\t%a\u001a\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001b\u0011\r\u0005-\u0014\u0011OA\u0004\u001b\t\tiGC\u0002\u0002pU\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019(!\u001c\u0003\u0011%#XM]1u_JD\u0011\"a\u001eW\u0003\u0003%\t!!\u001f\u0002\u0011\r\fg.R9vC2$B!a\u001f\u0002\u0002B\u0019A#! \n\u0007\u0005}TCA\u0004C_>dW-\u00198\t\u0013M\u000b)(!AA\u0002\u0005\u001d\u0001\"CAC-\u0006\u0005I\u0011IAD\u0003!A\u0017m\u001d5D_\u0012,G#A\n\t\u0013\u0005-e+!A\u0005B\u00055\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003qA\u0011\"!%W\u0003\u0003%\t%a%\u0002\r\u0015\fX/\u00197t)\u0011\tY(!&\t\u0013M\u000by)!AA\u0002\u0005\u001dq!CAM\u0001\u0005\u0005\t\u0012AAN\u0003\u0011!\u0016m]6\u0011\t\u0005M\u0011Q\u0014\u0004\t/\u0002\t\t\u0011#\u0001\u0002 N)\u0011QTAQ?BI\u00111UAUK\u00065\u0016\u0011C\u0007\u0003\u0003KS1!a*\u0016\u0003\u001d\u0011XO\u001c;j[\u0016LA!a+\u0002&\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a1\t\u0005=\u00161\u0017\t\u0005e^\f\t\fE\u0002{\u0003g#!\u0002`AO\u0003\u0003\u0005\tQ!\u0001\u0000\u0011\u001di\u0011Q\u0014C\u0001\u0003o#\"!a'\t\u0015\u0005-\u0015QTA\u0001\n\u000b\ni\t\u0003\u0006\u0002>\u0006u\u0015\u0011!CA\u0003\u007f\u000bQ!\u00199qYf$b!!\u0005\u0002B\u0006\r\u0007BB2\u0002<\u0002\u0007Q\rC\u0004o\u0003w\u0003\r!!21\t\u0005\u001d\u00171\u001a\t\u0005e^\fI\rE\u0002{\u0003\u0017$!\u0002`Ab\u0003\u0003\u0005\tQ!\u0001\u0000\u0011)\ty-!(\u0002\u0002\u0013\u0005\u0015\u0011[\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019.a:\u0011\u000bQ\t).!7\n\u0007\u0005]WC\u0001\u0004PaRLwN\u001c\t\u0007)\u0005mW-a8\n\u0007\u0005uWC\u0001\u0004UkBdWM\r\u0019\u0005\u0003C\f)\u000f\u0005\u0003so\u0006\r\bc\u0001>\u0002f\u0012QA0!4\u0002\u0002\u0003\u0005)\u0011A@\t\u0015\u0005%\u0018QZA\u0001\u0002\u0004\t\t\"A\u0002yIAB\u0011\"!<\u0001\u0005\u0004%I!a<\u0002\u0011\u0015DXmY;u_J,\"!!=\u0011\u0007I\f\u00190C\u0002\u0002vN\u0014q\"\u0012=fGV$xN]*feZL7-\u001a\u0005\t\u0003s\u0004\u0001\u0015!\u0003\u0002r\u0006IQ\r_3dkR|'\u000f\t\u0005\n\u0003{\u0004!\u0019!C\u0005\u0003\u007f\fQ\u0001^1tWN,\"A!\u0001\u0011\r\t\r!\u0011BA\t\u001b\t\u0011)A\u0003\u0003\u0003\b\u00055\u0014aB7vi\u0006\u0014G.Z\u0005\u0005\u0005\u0017\u0011)A\u0001\u0006MSN$()\u001e4gKJD\u0001Ba\u0004\u0001A\u0003%!\u0011A\u0001\u0007i\u0006\u001c8n\u001d\u0011\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016\u0005\t\u0002O]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0007=\u00139\u0002\u0003\u0005\u0003\u001a\tE\u0001\u0019\u0001B\u000e\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005\u0005;\u0011y\"D\u0001v\u0013\r\u0011\t#\u001e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B\u0013\u0001\u0011\u0005#qE\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u001f\"\"!1\u0005B\u0016!\u0011\u0011iCa\r\u000e\u0005\t=\"b\u0001B\u0019i\u0005)!.\u001e8ji&!!Q\u0007B\u0018\u0005\u0019\u0011UMZ8sK\"9!\u0011\b\u0001\u0005B\t\u001d\u0012\u0001\u0003;fCJ$un\u001e8)\t\t]\"Q\b\t\u0005\u0005[\u0011y$\u0003\u0003\u0003B\t=\"!B!gi\u0016\u0014\bb\u0002B#\u0001\u0011\u0005!qE\u0001\u0019i\u0016\u001cHOU3ta>t7/\u001a+ie>$H\u000f\\3US6,\u0007\u0006\u0002B\"\u0005\u0013\u0002BA!\f\u0003L%!!Q\nB\u0018\u0005\u0011!Vm\u001d;\t\u000f\tE\u0003\u0001\"\u0001\u0003(\u0005)B/Z:u+:$\bN]8ui2,Gm\u00117jK:$\b\u0006\u0002B(\u0005\u0013BqAa\u0016\u0001\t\u0003\u00119#A\u000buKN$X\t_3naR\u0014V-];fgR$\u0016.\\3)\t\tU#\u0011\n\u0005\b\u0005;\u0002A\u0011\u0001B\u0014\u0003a!Xm\u001d;V]\u0006,H\u000f[8sSj,G\r\u00165s_R$H.\u001a\u0015\u0005\u00057\u0012I\u0005C\u0004\u0003d\u0001!IA!\u001a\u0002/QD'o\u001c;uY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019,bYV,G\u0003\u0002B4\u0005[\u00022\u0001\u0006B5\u0013\r\u0011Y'\u0006\u0002\u0007\t>,(\r\\3\t\u0011\t=$\u0011\ra\u0001\u0005c\n\u0001b\u00197jK:$\u0018\n\u001a\t\u0005\u0005g\u0012\tI\u0004\u0003\u0003v\tu\u0004c\u0001B<+5\u0011!\u0011\u0010\u0006\u0004\u0005w2\u0011A\u0002\u001fs_>$h(C\u0002\u0003\u0000U\ta\u0001\u0015:fI\u00164\u0017bA\u0012\u0003\u0004*\u0019!qP\u000b\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\u00061\"/Z9vKN$H+[7f\u001b\u0016$(/[2WC2,X\r\u0006\u0003\u0003h\t-\u0005\u0002\u0003B8\u0005\u000b\u0003\rA!\u001d\t\u000f\t=\u0005\u0001\"\u0003\u0003\u0012\u0006AR\r_3naR\u0014V-];fgRlU\r\u001e:jGZ\u000bG.^3\u0016\u0005\t\u001d\u0004b\u0002BK\u0001\u0011%!qS\u0001\f[\u0016$(/[2WC2,X\r\u0006\u0004\u0003h\te%\u0011\u0016\u0005\t\u00057\u0013\u0019\n1\u0001\u0003\u001e\u00061Q.\u001a;sS\u000e\u0004BAa(\u0003&6\u0011!\u0011\u0015\u0006\u0004\u0005G{\u0013aB7fiJL7m]\u0005\u0005\u0005O\u0013\tKA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0007\u0002\u0003BV\u0005'\u0003\rA!,\u0002\rM,gn]8s!\u0011\u0011yJa,\n\t\tE&\u0011\u0015\u0002\u0007'\u0016t7o\u001c:\t\u000f\tU\u0006\u0001\"\u0003\u00038\u0006q!/Z9vKN$()^5mI\u0016\u0014H\u0003\u0002B]\u0005;\u0004DAa/\u0003RB1!Q\u0018Be\u0005\u001ftAAa0\u0003F6\u0011!\u0011\u0019\u0006\u0004\u0005\u0007|\u0013\u0001\u0003:fcV,7\u000f^:\n\t\t\u001d'\u0011Y\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!!1\u001aBg\u0005\u001d\u0011U/\u001b7eKJTAAa2\u0003BB\u0019!P!5\u0005\u0019\tM'1WA\u0001\u0002\u0003\u0015\tA!6\u0003\u0007}##'\u0005\u0003\u0002\u0002\t]\u0007\u0003\u0002B`\u00053LAAa7\u0003B\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000f\u0003\u0004d\u0005g\u0003\r!\u001a\u0005\b\u0005C\u0004A\u0011\u0002Br\u0003=\u0011X-];fgR\u0014Vm\u001d9p]N,GC\u0003Bs\u0005c\u001c\taa\u0001\u0004\bA!!q\u001dBw\u001b\t\u0011IOC\u0002\u0003l\u001e\fQ\u0001^=qKNLAAa<\u0003j\n11\u000b\u001e:vGRD\u0001Ba=\u0003`\u0002\u0007!Q_\u0001\u0007g>\u001c7.\u001a;\u0011\t\t](Q`\u0007\u0003\u0005sT1Aa?!\u0003\rqW\r^\u0005\u0005\u0005\u007f\u0014IP\u0001\u0004T_\u000e\\W\r\u001e\u0005\t\u0005_\u0012y\u000e1\u0001\u0003r!91Q\u0001Bp\u0001\u0004\u0019\u0012!D2peJ,G.\u0019;j_:LE\r\u0003\u0005\u00036\n}\u0007\u0019AB\u0005a\u0011\u0019Yaa\u0004\u0011\r\tu&\u0011ZB\u0007!\rQ8q\u0002\u0003\r\u0007#\u00199!!A\u0001\u0002\u000b\u0005!Q\u001b\u0002\u0004?\u0012\u001adABB\u000b\u0001\u0001\u001b9B\u0001\u0004DY&,g\u000e^\n\u0006\u0007'IFl\u0018\u0005\f\u0005_\u001a\u0019B!f\u0001\n\u0003\u0019Y\"\u0006\u0002\u0003r!Y1qDB\n\u0005#\u0005\u000b\u0011\u0002B9\u0003%\u0019G.[3oi&#\u0007\u0005C\u0005d\u0007'\u0011)\u001a!C\u0001I\"IAna\u0005\u0003\u0012\u0003\u0006I!\u001a\u0005\b\u001b\rMA\u0011AB\u0014)\u0019\u0019Ica\u000b\u0004.A!\u00111CB\n\u0011!\u0011yg!\nA\u0002\tE\u0004BB2\u0004&\u0001\u0007Q\rC\u0005\u0004\u0006\rM\u0001\u0019!C\u0001%!Q11GB\n\u0001\u0004%\ta!\u000e\u0002#\r|'O]3mCRLwN\\%e?\u0012*\u0017\u000fF\u0002P\u0007oA\u0001bUB\u0019\u0003\u0003\u0005\ra\u0005\u0005\t\u0007w\u0019\u0019\u0002)Q\u0005'\u0005q1m\u001c:sK2\fG/[8o\u0013\u0012\u0004\u0003BCB \u0007'\u0011\r\u0011\"\u0001\u0004B\u00059!-^5mI\u0016\u0014XCAB\"a\u0011\u0019)e!\u0013\u0011\r\tu&\u0011ZB$!\rQ8\u0011\n\u0003\r\u0005'\u001cY%!A\u0001\u0002\u000b\u0005!Q\u001b\u0005\n\u0007\u001b\u001a\u0019\u0002)A\u0005\u0007\u0007\n\u0001BY;jY\u0012,'\u000f\t\u0005\t\u0007#\u001a\u0019\u0002\"\u0001\u0004T\u0005A!/\u001e8V]RLG\u000e\u0006\u0003\u0002|\rU\u0003\u0002CB,\u0007\u001f\u0002\ra!\u0017\u0002\u000bUtG/\u001b7\u0011\u000fQ\u0019YF!:\u0002|%\u00191QL\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0002CAF\u0007'!\te!\u0019\u0015\u0005\tE\u0004BCA\u0012\u0007'\t\t\u0011\"\u0001\u0004fQ11\u0011FB4\u0007SB!Ba\u001c\u0004dA\u0005\t\u0019\u0001B9\u0011!\u001971\rI\u0001\u0002\u0004)\u0007BCA\u0017\u0007'\t\n\u0011\"\u0001\u0004nU\u00111q\u000e\u0016\u0005\u0005c\n\u0019\u0004\u0003\u0006\u0002H\rM\u0011\u0013!C\u0001\u0003_A\u0011\"!\u0016\u0004\u0014\u0005\u0005I\u0011I\u000e\t\u0013\u0005e31CA\u0001\n\u0003\u0011\u0002BCA/\u0007'\t\t\u0011\"\u0001\u0004zQ!\u0011qAB>\u0011!\u00196qOA\u0001\u0002\u0004\u0019\u0002BCA3\u0007'\t\t\u0011\"\u0011\u0002h!Q\u0011qOB\n\u0003\u0003%\ta!!\u0015\t\u0005m41\u0011\u0005\n'\u000e}\u0014\u0011!a\u0001\u0003\u000fA!\"!\"\u0004\u0014\u0005\u0005I\u0011IAD\u0011)\t\tja\u0005\u0002\u0002\u0013\u00053\u0011\u0012\u000b\u0005\u0003w\u001aY\tC\u0005T\u0007\u000f\u000b\t\u00111\u0001\u0002\b\u001dI1q\u0012\u0001\u0002\u0002#\u00051\u0011S\u0001\u0007\u00072LWM\u001c;\u0011\t\u0005M11\u0013\u0004\n\u0007+\u0001\u0011\u0011!E\u0001\u0007+\u001bRaa%\u0004\u0018~\u0003\u0012\"a)\u0002*\nETm!\u000b\t\u000f5\u0019\u0019\n\"\u0001\u0004\u001cR\u00111\u0011\u0013\u0005\u000b\u0003\u0017\u001b\u0019*!A\u0005F\u00055\u0005BCA_\u0007'\u000b\t\u0011\"!\u0004\"R11\u0011FBR\u0007KC\u0001Ba\u001c\u0004 \u0002\u0007!\u0011\u000f\u0005\u0007G\u000e}\u0005\u0019A3\t\u0015\u0005=71SA\u0001\n\u0003\u001bI\u000b\u0006\u0003\u0004,\u000e=\u0006#\u0002\u000b\u0002V\u000e5\u0006C\u0002\u000b\u0002\\\nET\r\u0003\u0006\u0002j\u000e\u001d\u0016\u0011!a\u0001\u0007SAqaa-\u0001\t\u0013\u0019),\u0001\u0006tk\nl\u0017\u000e\u001e+fgR$RaTB\\\u0007sCaaYBY\u0001\u0004)\u0007\u0002CB^\u0007c\u0003\ra!0\u0002\tQ,7\u000f\u001e\t\u0005)\r}v*C\u0002\u0004BV\u0011\u0011BR;oGRLwN\u001c\u0019\t\u000f\r\u0015\u0007\u0001\"\u0003\u0003(\u0005\u0019r/Y5u\u0003:$7\t[3dWJ+7/\u001e7ug\"91\u0011\u001a\u0001\u0005\n\r-\u0017\u0001\u0006:fgB|gn]3UQJ|G\u000f\u001e7f)&lW\rF\u0003\u0014\u0007\u001b\u001cy\r\u0003\u0004d\u0007\u000f\u0004\r!\u001a\u0005\t\u0007#\u001c9\r1\u0001\u0003f\u0006A!/Z:q_:\u001cX\rC\u0004\u0004V\u0002!Iaa6\u00021\rDWmY6SKF,Xm\u001d;UQJ|G\u000f\u001e7f)&lW\rF\u0002P\u00073DaaYBj\u0001\u0004)\u0007bBBo\u0001\u0011%1q\\\u0001\u0017G\",7m[+oi\"\u0014x\u000e\u001e;mK\u0012\u001cE.[3oiR\u0019qj!9\t\r\r\u001cY\u000e1\u0001f\u0011\u001d\u0019)\u000f\u0001C\u0005\u0007O\f\u0001d\u00195fG.,\u00050Z7qiJ+\u0017/^3ti6+GO]5d)\ry5\u0011\u001e\u0005\u0007G\u000e\r\b\u0019A3\t\u000f\r5\b\u0001\"\u0003\u0004p\u0006\u00013\r[3dWVs\u0017-\u001e;i_JL'0\u001a3SKF,Xm\u001d;UQJ|G\u000f\u001e7f)\ry5\u0011\u001f\u0005\u0007G\u000e-\b\u0019A3\b\u000f\rU(\u0001#\u0001\u0004x\u0006\u0001\"+Z9vKN$\u0018+^8uCR+7\u000f\u001e\t\u0004\u0013\rehAB\u0001\u0003\u0011\u0003\u0019Yp\u0005\u0003\u0004zf{\u0006bB\u0007\u0004z\u0012\u00051q \u000b\u0003\u0007oD!\u0002b\u0001\u0004z\n\u0007I\u0011\u0001C\u0003\u00039\u0019E.^:uKJ\f5\r^5p]N,\"\u0001b\u0002\u0011\u000b\u0011%AqB3\u000e\u0005\u0011-!\u0002\u0002C\u0007\u0003[\n\u0011\"[7nkR\f'\r\\3\n\t\u0011EA1\u0002\u0002\u0004'\u0016$\b\"\u0003C\u000b\u0007s\u0004\u000b\u0011\u0002C\u0004\u0003=\u0019E.^:uKJ\f5\r^5p]N\u0004\u0003B\u0003C\r\u0007s\u0014\r\u0011\"\u0001\u0005\u0006\u0005i1\t\\5f]R\f5\r^5p]ND\u0011\u0002\"\b\u0004z\u0002\u0006I\u0001b\u0002\u0002\u001d\rc\u0017.\u001a8u\u0003\u000e$\u0018n\u001c8tA!QA\u0011EB}\u0005\u0004%\t\u0001b\t\u0002+Us\u0017-\u001e;i_JL'0\u001a3Qe&t7-\u001b9bYV\u0011AQ\u0005\t\u0005\tO!\t$\u0004\u0002\u0005*)!A1\u0006C\u0017\u0003\u0011\tW\u000f\u001e5\u000b\u0007\u0011=r&\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011!\u0019\u0004\"\u000b\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\"IAqGB}A\u0003%AQE\u0001\u0017+:\fW\u000f\u001e5pe&TX\r\u001a)sS:\u001c\u0017\u000e]1mA!QA1HB}\u0001\u0004%\t\u0001b\t\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007B\u0003C \u0007s\u0004\r\u0011\"\u0001\u0005B\u0005i\u0001O]5oG&\u0004\u0018\r\\0%KF$2a\u0014C\"\u0011%\u0019FQHA\u0001\u0002\u0004!)\u0003C\u0005\u0005H\re\b\u0015)\u0003\u0005&\u0005Q\u0001O]5oG&\u0004\u0018\r\u001c\u0011\u0007\u000f\u0011-3\u0011 \u0001\u0005N\tqA+Z:u\u0003V$\bn\u001c:ju\u0016\u00148\u0003\u0002C%\t\u001f\u0002B\u0001\"\u0015\u0005X5\u0011A1\u000b\u0006\u0005\tW!)FC\u0002\u00050\u0011IA\u0001\"\u0017\u0005T\t\u00192+[7qY\u0016\f5\r\\!vi\"|'/\u001b>fe\"9Q\u0002\"\u0013\u0005\u0002\u0011uCC\u0001C0!\u0011!\t\u0007\"\u0013\u000e\u0005\re\b\u0002\u0003C3\t\u0013\"\t\u0005b\u001a\u0002\u0013\u0005,H\u000f[8sSj,G\u0003CA>\tS\"9\t\"%\t\u0011\u0011-D1\ra\u0001\t[\nqa]3tg&|g\u000e\u0005\u0003\u0005p\u0011\u0005e\u0002\u0002C9\twrA\u0001b\u001d\u0005x9!!q\u000fC;\u0013\u0005)\u0011b\u0001C=\t\u00059a.\u001a;x_J\\\u0017\u0002\u0002C?\t\u007f\naBU3rk\u0016\u001cHo\u00115b]:,GNC\u0002\u0005z\u0011IA\u0001b!\u0005\u0006\n91+Z:tS>t'\u0002\u0002C?\t\u007fB\u0001\u0002\"#\u0005d\u0001\u0007A1R\u0001\n_B,'/\u0019;j_:\u0004B\u0001\"\u0015\u0005\u000e&!Aq\u0012C*\u0005%y\u0005/\u001a:bi&|g\u000e\u0003\u0005\u0005\u0014\u0012\r\u0004\u0019\u0001CK\u0003!\u0011Xm]8ve\u000e,\u0007\u0003\u0002C)\t/KA\u0001\"'\u0005T\tA!+Z:pkJ\u001cWMB\u0004\u0005\u001e\u000ee\b\u0001b(\u0003)Q+7\u000f\u001e)sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3s'\u0011!Y\n\")\u0011\t\u0011\u001dB1U\u0005\u0005\tK#ICA\fEK\u001a\fW\u000f\u001c;Qe&t7-\u001b9bY\n+\u0018\u000e\u001c3fe\"9Q\u0002b'\u0005\u0002\u0011%FC\u0001CV!\u0011!\t\u0007b'\t\u0011\u0011=F1\u0014C!\tc\u000baBY;jY\u0012\u0004&/\u001b8dSB\fG\u000e\u0006\u0004\u0005&\u0011MF\u0011\u0019\u0005\t\tk#i\u000b1\u0001\u00058\u0006qAO]1ogB|'\u000f\u001e'bs\u0016\u0014\b\u0003\u0002C]\t{k!\u0001b/\u000b\u0007\u0011et&\u0003\u0003\u0005@\u0012m&A\u0004+sC:\u001c\bo\u001c:u\u0019\u0006LXM\u001d\u0005\t\t\u0007$i\u000b1\u0001\u0005F\u0006i\u0011-\u001e;iK:$\u0018nY1u_J\u0004B\u0001\"/\u0005H&!A\u0011\u001aC^\u00055\tU\u000f\u001e5f]RL7-\u0019;pe\"QAQZB}\u0003\u0003%I\u0001b4\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\t#\u00042!\bCj\u0013\r!)N\b\u0002\u0007\u001f\nTWm\u0019;")
public class RequestQuotaTest
extends BaseRequestTest {
    private volatile RequestQuotaTest$Task$ Task$module;
    private volatile RequestQuotaTest$Client$ Client$module;
    private final String topic;
    private final int numPartitions;
    private final TopicPartition tp = new TopicPartition(this.topic(), 0);
    private final String unthrottledClientId;
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);
    private KafkaServer leaderNode = null;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final ListBuffer<Task> tasks = new ListBuffer();

    public static void principal_$eq(KafkaPrincipal kafkaPrincipal) {
        RequestQuotaTest$.MODULE$.principal_$eq(kafkaPrincipal);
    }

    public static KafkaPrincipal principal() {
        return RequestQuotaTest$.MODULE$.principal();
    }

    public static KafkaPrincipal UnauthorizedPrincipal() {
        return RequestQuotaTest$.MODULE$.UnauthorizedPrincipal();
    }

    public static scala.collection.immutable.Set<ApiKeys> ClientActions() {
        return RequestQuotaTest$.MODULE$.ClientActions();
    }

    public static scala.collection.immutable.Set<ApiKeys> ClusterActions() {
        return RequestQuotaTest$.MODULE$.ClusterActions();
    }

    public RequestQuotaTest$Task$ Task() {
        if (this.Task$module == null) {
            this.Task$lzycompute$1();
        }
        return this.Task$module;
    }

    public RequestQuotaTest$Client$ Client() {
        if (this.Client$module == null) {
            this.Client$lzycompute$1();
        }
        return this.Client$module;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    private String topic() {
        return this.topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private String unthrottledClientId() {
        return this.unthrottledClientId;
    }

    private Integer brokerId() {
        return this.brokerId;
    }

    private KafkaServer leaderNode() {
        return this.leaderNode;
    }

    private void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private ListBuffer<Task> tasks() {
        return this.tasks;
    }

    @Override
    public void propertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), TestPrincipalBuilder.class.getName());
    }

    @Override
    @Before
    public void setUp() {
        RequestQuotaTest$.MODULE$.principal_$eq(KafkaPrincipal.ANONYMOUS);
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), this.numPartitions(), 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.leaderNode_$eq((KafkaServer)this.servers().head());
        Properties quotaProps = new Properties();
        quotaProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), "0.01");
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), "<default>", quotaProps);
        quotaProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), "2000");
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), this.unthrottledClientId(), quotaProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ClientRequestQuotaManager quotaManager = ((KafkaServer)this.servers().apply(0)).apis().quotas().request();
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default request quota not set"})).s((Seq)Nil$.MODULE$), (Object)Quota.upperBound((double)0.01), (Object)quotaManager.quota("some-user", "some-client"));
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request quota override not set"})).s((Seq)Nil$.MODULE$), (Object)Quota.upperBound((double)2000.0), (Object)quotaManager.quota("some-user", this.unthrottledClientId()));
        });
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testResponseThrottleTime() {
        RequestQuotaTest$.MODULE$.ClientActions().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.submitTest(apiKey, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkRequestThrottleTime(apiKey));
            return BoxedUnit.UNIT;
        });
        this.waitAndCheckResults();
    }

    @Test
    public void testUnthrottledClient() {
        RequestQuotaTest$.MODULE$.ClientActions().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.submitTest(apiKey, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkUnthrottledClient(apiKey));
            return BoxedUnit.UNIT;
        });
        this.waitAndCheckResults();
    }

    @Test
    public void testExemptRequestTime() {
        RequestQuotaTest$.MODULE$.ClusterActions().foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.submitTest(apiKey, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkExemptRequestMetric(apiKey));
            return BoxedUnit.UNIT;
        });
        this.waitAndCheckResults();
    }

    @Test
    public void testUnauthorizedThrottle() {
        RequestQuotaTest$.MODULE$.principal_$eq(RequestQuotaTest$.MODULE$.UnauthorizedPrincipal());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)apiKey -> {
            this.submitTest(apiKey, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkUnauthorizedRequestThrottle(apiKey));
            return BoxedUnit.UNIT;
        });
        this.waitAndCheckResults();
    }

    public double kafka$server$RequestQuotaTest$$throttleTimeMetricValue(String clientId) {
        MetricName metricName = this.leaderNode().metrics().metricName("throttle-time", QuotaType.Request$.MODULE$.toString(), "", new String[]{"user", "", "client-id", clientId});
        Sensor sensor = this.leaderNode().quotaManagers().request().getOrCreateQuotaSensors("ANONYMOUS", clientId).throttleTimeSensor();
        return this.metricValue((KafkaMetric)this.leaderNode().metrics().metrics().get(metricName), sensor);
    }

    public double kafka$server$RequestQuotaTest$$requestTimeMetricValue(String clientId) {
        MetricName metricName = this.leaderNode().metrics().metricName("request-time", QuotaType.Request$.MODULE$.toString(), "", new String[]{"user", "", "client-id", clientId});
        Sensor sensor = this.leaderNode().quotaManagers().request().getOrCreateQuotaSensors("ANONYMOUS", clientId).quotaSensor();
        return this.metricValue((KafkaMetric)this.leaderNode().metrics().metrics().get(metricName), sensor);
    }

    private double exemptRequestMetricValue() {
        MetricName metricName = this.leaderNode().metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return this.metricValue((KafkaMetric)this.leaderNode().metrics().metrics().get(metricName), this.leaderNode().quotaManagers().request().exemptSensor());
    }

    private double metricValue(KafkaMetric metric, Sensor sensor) {
        double d;
        Sensor sensor2 = sensor;
        synchronized (sensor2) {
            d = metric == null ? -1.0 : metric.value();
        }
        return d;
    }

    public AbstractRequest.Builder<? extends AbstractRequest> kafka$server$RequestQuotaTest$$requestBuilder(ApiKeys apiKey) {
        FetchRequest.Builder builder;
        ApiKeys apiKeys = apiKey;
        if (ApiKeys.PRODUCE.equals(apiKeys)) {
            builder = new ProduceRequest.Builder(2, 1, 5000, (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("test".getBytes())}))}))).asJava());
        } else if (ApiKeys.FETCH.equals(apiKeys)) {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            partitionMap.put(this.tp(), new FetchRequest.PartitionData(0L, 0L, 100));
            builder = FetchRequest.Builder.forConsumer((int)0, (int)0, partitionMap);
        } else if (ApiKeys.METADATA.equals(apiKeys)) {
            builder = new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), true);
        } else if (ApiKeys.LIST_OFFSETS.equals(apiKeys)) {
            builder = ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)Predef$.MODULE$.long2Long(0L))}))).asJava());
        } else if (ApiKeys.LEADER_AND_ISR.equals(apiKeys)) {
            builder = new LeaderAndIsrRequest.Builder(Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new PartitionState(Integer.MAX_VALUE, Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{this.brokerId()}))).asJava(), 2, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{this.brokerId()}))).asJava()))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(Predef$.MODULE$.Integer2int(this.brokerId()), "localhost", 0)}))).asJava());
        } else if (ApiKeys.STOP_REPLICA.equals(apiKeys)) {
            builder = new StopReplicaRequest.Builder(Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, true, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        } else if (ApiKeys.UPDATE_METADATA_KEY.equals(apiKeys)) {
            java.util.Map partitionState = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new PartitionState(Integer.MAX_VALUE, Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{this.brokerId()}))).asJava(), 2, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{this.brokerId()}))).asJava()))}))).asJava();
            SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
            java.util.Set brokers = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(Predef$.MODULE$.Integer2int(this.brokerId()), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("localhost", 0, securityProtocol, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol))}))).asJava(), null)}))).asJava();
            builder = new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA_KEY.latestVersion(), Predef$.MODULE$.Integer2int(this.brokerId()), Integer.MAX_VALUE, partitionState, brokers);
        } else if (ApiKeys.CONTROLLED_SHUTDOWN_KEY.equals(apiKeys)) {
            builder = new ControlledShutdownRequest.Builder(Predef$.MODULE$.Integer2int(this.brokerId()));
        } else if (ApiKeys.OFFSET_COMMIT.equals(apiKeys)) {
            builder = new OffsetCommitRequest.Builder("test-group", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetCommitRequest.PartitionData(0L, "metadata"))}))).asJava()).setMemberId("").setGenerationId(1).setRetentionTime(1000L);
        } else if (ApiKeys.OFFSET_FETCH.equals(apiKeys)) {
            builder = new OffsetFetchRequest.Builder("test-group", (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        } else if (ApiKeys.FIND_COORDINATOR.equals(apiKeys)) {
            builder = new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.GROUP, "test-group");
        } else if (ApiKeys.JOIN_GROUP.equals(apiKeys)) {
            builder = new JoinGroupRequest.Builder("test-join-group", 200, "", "consumer", (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinGroupRequest.ProtocolMetadata[]{new JoinGroupRequest.ProtocolMetadata("consumer-range", ByteBuffer.wrap("test".getBytes()))}))).asJava()).setRebalanceTimeout(100);
        } else if (ApiKeys.HEARTBEAT.equals(apiKeys)) {
            builder = new HeartbeatRequest.Builder("test-group", 1, "");
        } else if (ApiKeys.LEAVE_GROUP.equals(apiKeys)) {
            builder = new LeaveGroupRequest.Builder("test-leave-group", "");
        } else if (ApiKeys.SYNC_GROUP.equals(apiKeys)) {
            builder = new SyncGroupRequest.Builder("test-sync-group", 1, "", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava());
        } else if (ApiKeys.DESCRIBE_GROUPS.equals(apiKeys)) {
            builder = new DescribeGroupsRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-group"}))).asJava());
        } else if (ApiKeys.LIST_GROUPS.equals(apiKeys)) {
            builder = new ListGroupsRequest.Builder();
        } else if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
            builder = new SaslHandshakeRequest.Builder("PLAIN");
        } else if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
            builder = new ApiVersionsRequest.Builder();
        } else if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
            builder = new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 0);
        } else if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
            builder = new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-2"}))).asJava(), Predef$.MODULE$.int2Integer(5000));
        } else if (ApiKeys.DELETE_RECORDS.equals(apiKeys)) {
            builder = new DeleteRecordsRequest.Builder(5000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)Predef$.MODULE$.long2Long(0L))}))).asJava());
        } else if (ApiKeys.INIT_PRODUCER_ID.equals(apiKeys)) {
            builder = new InitProducerIdRequest.Builder("abc");
        } else if (ApiKeys.OFFSET_FOR_LEADER_EPOCH.equals(apiKeys)) {
            builder = new OffsetsForLeaderEpochRequest.Builder().add(this.tp(), Predef$.MODULE$.int2Integer(0));
        } else if (ApiKeys.ADD_PARTITIONS_TO_TXN.equals(apiKeys)) {
            builder = new AddPartitionsToTxnRequest.Builder("test-transactional-id", 1L, 0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        } else if (ApiKeys.ADD_OFFSETS_TO_TXN.equals(apiKeys)) {
            builder = new AddOffsetsToTxnRequest.Builder("test-transactional-id", 1L, 0, "test-txn-group");
        } else if (ApiKeys.END_TXN.equals(apiKeys)) {
            builder = new EndTxnRequest.Builder("test-transactional-id", 1L, 0, TransactionResult.forId((boolean)false));
        } else if (ApiKeys.WRITE_TXN_MARKERS.equals(apiKeys)) {
            builder = new WriteTxnMarkersRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
        } else if (ApiKeys.TXN_OFFSET_COMMIT.equals(apiKeys)) {
            builder = new TxnOffsetCommitRequest.Builder("test-transactional-id", "test-txn-group", 2L, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
        } else if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
            builder = new DescribeAclsRequest.Builder(AclBindingFilter.ANY);
        } else if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
            builder = new CreateAclsRequest.Builder(Collections.singletonList(new CreateAclsRequest.AclCreation(new AclBinding(new org.apache.kafka.common.resource.Resource(org.apache.kafka.common.resource.ResourceType.TOPIC, "mytopic"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.DENY)))));
        } else if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
            builder = new DeleteAclsRequest.Builder(Collections.singletonList(new AclBindingFilter(new ResourceFilter(org.apache.kafka.common.resource.ResourceType.TOPIC, null), new AccessControlEntryFilter("User:ANONYMOUS", "*", AclOperation.ANY, AclPermissionType.DENY))));
        } else if (ApiKeys.DESCRIBE_CONFIGS.equals(apiKeys)) {
            builder = new DescribeConfigsRequest.Builder(Collections.singleton(new Resource(ResourceType.TOPIC, this.tp().topic())));
        } else if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
            builder = new AlterConfigsRequest.Builder(Collections.singletonMap(new Resource(ResourceType.TOPIC, this.tp().topic()), new AlterConfigsRequest.Config(Collections.singleton(new AlterConfigsRequest.ConfigEntry(LogConfig$.MODULE$.MaxMessageBytesProp(), "1000000")))), true);
        } else {
            throw new IllegalArgumentException("Unsupported API key " + apiKey);
        }
        return builder;
    }

    public Struct kafka$server$RequestQuotaTest$$requestResponse(Socket socket, String clientId, int correlationId, AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ApiKeys apiKey = requestBuilder.apiKey();
        AbstractRequest request = requestBuilder.build();
        RequestHeader header = new RequestHeader(apiKey.id, request.version(), clientId, correlationId);
        byte[] response = this.requestAndReceive(socket, request.serialize(header).array());
        ByteBuffer responseBuffer = this.skipResponseHeader(response);
        return apiKey.parseResponse(request.version(), responseBuffer);
    }

    private void submitTest(ApiKeys apiKey, Function0<BoxedUnit> test) {
        Future<?> future = this.executor().submit(new Runnable(null, test){
            private final Function0 test$1;

            public void run() {
                this.test$1.apply$mcV$sp();
            }
            {
                this.test$1 = test$1;
            }
        });
        this.tasks().$plus$eq((Object)new Task(this, apiKey, future));
    }

    private void waitAndCheckResults() {
        this.tasks().foreach((Function1 & Serializable & scala.Serializable)task -> {
            Object obj;
            try {
                obj = task.future().get(15L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test failed for api-key ", " with exception ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.apiKey(), e})));
                throw e;
            }
            return obj;
        });
    }

    private int responseThrottleTime(ApiKeys apiKey, Struct response) {
        int n;
        ApiKeys apiKeys = apiKey;
        if (ApiKeys.PRODUCE.equals(apiKeys)) {
            n = new ProduceResponse(response).getThrottleTime();
        } else if (ApiKeys.FETCH.equals(apiKeys)) {
            n = new FetchResponse(response).throttleTimeMs();
        } else if (ApiKeys.LIST_OFFSETS.equals(apiKeys)) {
            n = new ListOffsetResponse(response).throttleTimeMs();
        } else if (ApiKeys.METADATA.equals(apiKeys)) {
            n = new MetadataResponse(response).throttleTimeMs();
        } else if (ApiKeys.OFFSET_COMMIT.equals(apiKeys)) {
            n = new OffsetCommitResponse(response).throttleTimeMs();
        } else if (ApiKeys.OFFSET_FETCH.equals(apiKeys)) {
            n = new OffsetFetchResponse(response).throttleTimeMs();
        } else if (ApiKeys.FIND_COORDINATOR.equals(apiKeys)) {
            n = new FindCoordinatorResponse(response).throttleTimeMs();
        } else if (ApiKeys.JOIN_GROUP.equals(apiKeys)) {
            n = new JoinGroupResponse(response).throttleTimeMs();
        } else if (ApiKeys.HEARTBEAT.equals(apiKeys)) {
            n = new HeartbeatResponse(response).throttleTimeMs();
        } else if (ApiKeys.LEAVE_GROUP.equals(apiKeys)) {
            n = new LeaveGroupResponse(response).throttleTimeMs();
        } else if (ApiKeys.SYNC_GROUP.equals(apiKeys)) {
            n = new SyncGroupResponse(response).throttleTimeMs();
        } else if (ApiKeys.DESCRIBE_GROUPS.equals(apiKeys)) {
            n = new DescribeGroupsResponse(response).throttleTimeMs();
        } else if (ApiKeys.LIST_GROUPS.equals(apiKeys)) {
            n = new ListGroupsResponse(response).throttleTimeMs();
        } else if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
            n = new ApiVersionsResponse(response).throttleTimeMs();
        } else if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
            n = new CreateTopicsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
            n = new DeleteTopicsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DELETE_RECORDS.equals(apiKeys)) {
            n = new DeleteRecordsResponse(response).throttleTimeMs();
        } else if (ApiKeys.INIT_PRODUCER_ID.equals(apiKeys)) {
            n = new InitProducerIdResponse(response).throttleTimeMs();
        } else if (ApiKeys.ADD_PARTITIONS_TO_TXN.equals(apiKeys)) {
            n = new AddPartitionsToTxnResponse(response).throttleTimeMs();
        } else if (ApiKeys.ADD_OFFSETS_TO_TXN.equals(apiKeys)) {
            n = new AddOffsetsToTxnResponse(response).throttleTimeMs();
        } else if (ApiKeys.END_TXN.equals(apiKeys)) {
            n = new EndTxnResponse(response).throttleTimeMs();
        } else if (ApiKeys.TXN_OFFSET_COMMIT.equals(apiKeys)) {
            n = new TxnOffsetCommitResponse(response).throttleTimeMs();
        } else if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
            n = new DescribeAclsResponse(response).throttleTimeMs();
        } else if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
            n = new CreateAclsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
            n = new DeleteAclsResponse(response).throttleTimeMs();
        } else if (ApiKeys.DESCRIBE_CONFIGS.equals(apiKeys)) {
            n = new DescribeConfigsResponse(response).throttleTimeMs();
        } else if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
            n = new AlterConfigsResponse(response).throttleTimeMs();
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No throttle time for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiKeys})));
        }
        return n;
    }

    private void checkRequestThrottleTime(ApiKeys apiKey) {
        String clientId = apiKey.toString();
        Client client = new Client(this, clientId, apiKey);
        boolean throttled = client.runUntil((Function1<Struct, Object>)(Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RequestQuotaTest.$anonfun$checkRequestThrottleTime$1(this, apiKey, response)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response not throttled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (boolean)throttled);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Throttle time metrics not updated: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (this.kafka$server$RequestQuotaTest$$throttleTimeMetricValue(clientId) > 0.0 ? 1 : 0) != 0);
    }

    private void checkUnthrottledClient(ApiKeys apiKey) {
        Client unthrottledClient = new Client(this, this.unthrottledClientId(), apiKey);
        unthrottledClient.runUntil((Function1<Struct, Object>)(Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RequestQuotaTest.$anonfun$checkUnthrottledClient$1(this, apiKey, response)));
        Assert.assertEquals((long)1L, (long)unthrottledClient.correlationId());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client should not have been throttled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unthrottledClient})), (this.kafka$server$RequestQuotaTest$$throttleTimeMetricValue(this.unthrottledClientId()) <= 0.0 ? 1 : 0) != 0);
    }

    private void checkExemptRequestMetric(ApiKeys apiKey) {
        double exemptTarget = this.exemptRequestMetricValue() + 0.02;
        String clientId = apiKey.toString();
        Client client = new Client(this, clientId, apiKey);
        boolean updated = client.runUntil((Function1<Struct, Object>)(Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RequestQuotaTest.$anonfun$checkExemptRequestMetric$1(this, exemptTarget, response)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exempt-request-time metric not updated: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (boolean)updated);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client should not have been throttled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (this.kafka$server$RequestQuotaTest$$throttleTimeMetricValue(clientId) <= 0.0 ? 1 : 0) != 0);
    }

    private void checkUnauthorizedRequestThrottle(ApiKeys apiKey) {
        String clientId = "unauthorized-" + apiKey.toString();
        Client client = new Client(this, clientId, apiKey);
        boolean throttled = client.runUntil((Function1<Struct, Object>)(Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RequestQuotaTest.$anonfun$checkUnauthorizedRequestThrottle$1(this, clientId, response)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unauthorized client should have been throttled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client})), (boolean)throttled);
    }

    private final void Task$lzycompute$1() {
        RequestQuotaTest requestQuotaTest = this;
        synchronized (requestQuotaTest) {
            if (this.Task$module == null) {
                this.Task$module = new RequestQuotaTest$Task$(this);
            }
        }
    }

    private final void Client$lzycompute$1() {
        RequestQuotaTest requestQuotaTest = this;
        synchronized (requestQuotaTest) {
            if (this.Client$module == null) {
                this.Client$module = new RequestQuotaTest$Client$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkRequestThrottleTime$1(RequestQuotaTest $this, ApiKeys apiKey$1, Struct response) {
        return $this.responseThrottleTime(apiKey$1, response) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$checkUnthrottledClient$1(RequestQuotaTest $this, ApiKeys apiKey$2, Struct response) {
        return (double)$this.responseThrottleTime(apiKey$2, response) <= 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$checkExemptRequestMetric$1(RequestQuotaTest $this, double exemptTarget$1, Struct response) {
        return $this.exemptRequestMetricValue() > exemptTarget$1;
    }

    public static final /* synthetic */ boolean $anonfun$checkUnauthorizedRequestThrottle$1(RequestQuotaTest $this, String clientId$1, Struct response) {
        return $this.kafka$server$RequestQuotaTest$$throttleTimeMetricValue(clientId$1) > 0.0;
    }

    public RequestQuotaTest() {
        this.topic = "topic-1";
        this.numPartitions = 1;
        this.unthrottledClientId = "unthrottled-client";
    }

    public class Client
    implements Product,
    scala.Serializable {
        private final String clientId;
        private final ApiKeys apiKey;
        private int correlationId;
        private final AbstractRequest.Builder<? extends AbstractRequest> builder;
        public final /* synthetic */ RequestQuotaTest $outer;

        public String clientId() {
            return this.clientId;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public int correlationId() {
            return this.correlationId;
        }

        public void correlationId_$eq(int x$1) {
            this.correlationId = x$1;
        }

        public AbstractRequest.Builder<? extends AbstractRequest> builder() {
            return this.builder;
        }

        public boolean runUntil(Function1<Struct, Object> until) {
            long startMs = System.currentTimeMillis();
            boolean done = false;
            try (Socket socket = this.kafka$server$RequestQuotaTest$Client$$$outer().connect(this.kafka$server$RequestQuotaTest$Client$$$outer().connect$default$1(), this.kafka$server$RequestQuotaTest$Client$$$outer().connect$default$2());){
                while (!done && System.currentTimeMillis() < startMs + 10000L) {
                    this.correlationId_$eq(this.correlationId() + 1);
                    Struct response = this.kafka$server$RequestQuotaTest$Client$$$outer().kafka$server$RequestQuotaTest$$requestResponse(socket, this.clientId(), this.correlationId(), this.builder());
                    done = BoxesRunTime.unboxToBoolean((Object)until.apply((Object)response));
                }
            }
            return done;
        }

        public String toString() {
            double requestTime = this.kafka$server$RequestQuotaTest$Client$$$outer().kafka$server$RequestQuotaTest$$requestTimeMetricValue(this.clientId());
            double throttleTime = this.kafka$server$RequestQuotaTest$Client$$$outer().kafka$server$RequestQuotaTest$$throttleTimeMetricValue(this.clientId());
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client ", " apiKey ", " requests ", " requestTime ", " throttleTime ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clientId(), this.apiKey(), BoxesRunTime.boxToInteger((int)this.correlationId()), BoxesRunTime.boxToDouble((double)requestTime), BoxesRunTime.boxToDouble((double)throttleTime)}));
        }

        public Client copy(String clientId, ApiKeys apiKey) {
            return new Client(this.kafka$server$RequestQuotaTest$Client$$$outer(), clientId, apiKey);
        }

        public String copy$default$1() {
            return this.clientId();
        }

        public ApiKeys copy$default$2() {
            return this.apiKey();
        }

        public String productPrefix() {
            return "Client";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.clientId();
                    break;
                }
                case 1: {
                    string = this.apiKey();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Client;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Client)) return false;
            if (((Client)object).kafka$server$RequestQuotaTest$Client$$$outer() != this.kafka$server$RequestQuotaTest$Client$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Client client = (Client)x$1;
            String string = this.clientId();
            String string2 = client.clientId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            ApiKeys apiKeys = this.apiKey();
            ApiKeys apiKeys2 = client.apiKey();
            if (apiKeys == null) {
                if (apiKeys2 != null) {
                    return false;
                }
            } else if (!apiKeys.equals(apiKeys2)) return false;
            if (!client.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ RequestQuotaTest kafka$server$RequestQuotaTest$Client$$$outer() {
            return this.$outer;
        }

        public Client(RequestQuotaTest $outer, String clientId, ApiKeys apiKey) {
            this.clientId = clientId;
            this.apiKey = apiKey;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.correlationId = 0;
            this.builder = $outer.kafka$server$RequestQuotaTest$$requestBuilder(apiKey);
        }
    }

    public class Task
    implements Product,
    scala.Serializable {
        private final ApiKeys apiKey;
        private final Future<?> future;
        public final /* synthetic */ RequestQuotaTest $outer;

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public Future<?> future() {
            return this.future;
        }

        public Task copy(ApiKeys apiKey, Future<?> future) {
            return new Task(this.kafka$server$RequestQuotaTest$Task$$$outer(), apiKey, future);
        }

        public ApiKeys copy$default$1() {
            return this.apiKey();
        }

        public Future<?> copy$default$2() {
            return this.future();
        }

        public String productPrefix() {
            return "Task";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.apiKey();
                    break;
                }
                case 1: {
                    object = this.future();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Task;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Task)) return false;
            if (((Task)object).kafka$server$RequestQuotaTest$Task$$$outer() != this.kafka$server$RequestQuotaTest$Task$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Task task = (Task)x$1;
            ApiKeys apiKeys = this.apiKey();
            ApiKeys apiKeys2 = task.apiKey();
            if (apiKeys == null) {
                if (apiKeys2 != null) {
                    return false;
                }
            } else if (!apiKeys.equals(apiKeys2)) return false;
            Future<?> future = this.future();
            Future<?> future2 = task.future();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            if (!task.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ RequestQuotaTest kafka$server$RequestQuotaTest$Task$$$outer() {
            return this.$outer;
        }

        public Task(RequestQuotaTest $outer, ApiKeys apiKey, Future<?> future) {
            this.apiKey = apiKey;
            this.future = future;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public static class TestAuthorizer
    extends SimpleAclAuthorizer {
        public boolean authorize(RequestChannel.Session session, Operation operation, kafka.security.auth.Resource resource) {
            KafkaPrincipal kafkaPrincipal = session.principal();
            KafkaPrincipal kafkaPrincipal2 = RequestQuotaTest$.MODULE$.UnauthorizedPrincipal();
            return kafkaPrincipal == null ? kafkaPrincipal2 != null : !kafkaPrincipal.equals(kafkaPrincipal2);
        }
    }

    public static class TestPrincipalBuilder
    extends DefaultPrincipalBuilder {
        public KafkaPrincipal buildPrincipal(TransportLayer transportLayer, Authenticator authenticator) {
            return RequestQuotaTest$.MODULE$.principal();
        }
    }
}

