/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001\u001d\u0011!dU1tY\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!a\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\bCA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003\r\t\u0007/[\u0005\u0003#9\u0011\u0011bU1tYN+G/\u001e9\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002CA\u0005\u0001\u0011\u00159\u0002\u0001\"\u0015\u0019\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001\u001a!\tQB%D\u0001\u001c\u0015\taR$\u0001\u0005qe>$xnY8m\u0015\tqr$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0001R!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO&\u0011Qe\u0007\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2Dqa\n\u0001C\u0002\u0013%\u0001&\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\"1!\u0007\u0001Q\u0001\n%\n\u0011d[1gW\u0006\u001cE.[3oiN\u000b7\u000f\\'fG\"\fg.[:nA!9A\u0007\u0001b\u0001\n\u0013)\u0014!G6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N,\u0012A\u000e\t\u0004oyJS\"\u0001\u001d\u000b\u0005eR\u0014!C5n[V$\u0018M\u00197f\u0015\tYD(\u0001\u0006d_2dWm\u0019;j_:T\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fa\u0012A\u0001T5ti\"1\u0011\t\u0001Q\u0001\nY\n!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002Bqa\u0011\u0001C\u0002\u0013EC)\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002\u000bB\u0019aiR%\u000e\u0003qJ!\u0001\u0013\u001f\u0003\tM{W.\u001a\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u00196\nA!\u001e;jY&\u0011aj\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002)\u0001A\u0003%Q)A\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm\u001d\u0011\t\u000fI\u0003!\u0019!C)\t\u0006!2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKNDa\u0001\u0016\u0001!\u0002\u0013)\u0015!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000f\t\u0005\u0006-\u0002!\teV\u0001\u000b]Vl'I]8lKJ\u001cX#\u0001-\u0011\u0005\u0019K\u0016B\u0001.=\u0005\rIe\u000e\u001e\u0005\u00069\u0002!\t%X\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002=B\u0011aiX\u0005\u0003Ar\u0012A!\u00168ji\"\u00121L\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\n\nQA[;oSRL!a\u001a3\u0003\r\t+gm\u001c:f\u0011\u0015I\u0007\u0001\"\u0011^\u0003!!X-\u0019:E_^t\u0007F\u00015l!\t\u0019G.\u0003\u0002nI\n)\u0011I\u001a;fe\")q\u000e\u0001C\u0001;\u0006\u0001D/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHOQ3g_J,7+Y:m\u0011\u0006tGm\u001d5bW\u0016\u0014V-];fgRD#A\\9\u0011\u0005\r\u0014\u0018BA:e\u0005\u0011!Vm\u001d;\t\u000bU\u0004A\u0011A/\u0002_Q,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR\fe\r^3s'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;)\u0005Q\f\b\"\u0002=\u0001\t\u0003i\u0016\u0001\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;XSRDWK\\:vaB|'\u000f^3e-\u0016\u00148/[8oQ\t9\u0018\u000fC\u0003|\u0001\u0011%A0\u0001\ftK:$\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u001di\u0018qAA\f\u0003C\u00012A`A\u0002\u001b\u0005y(bAA\u0001;\u0005A!/Z9vKN$8/C\u0002\u0002\u0006}\u00141#\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016Dq!!\u0003{\u0001\u0004\tY!\u0001\u0004t_\u000e\\W\r\u001e\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0017\u0002\u00079,G/\u0003\u0003\u0002\u0016\u0005=!AB*pG.,G\u000fC\u0004\u0002\u001ai\u0004\r!a\u0007\u0002\u000fI,\u0017/^3tiB\u0019a0!\b\n\u0007\u0005}qP\u0001\nBa&4VM]:j_:\u001c(+Z9vKN$\b\"CA\u0012uB\u0005\t\u0019AA\u0013\u0003)\t\u0007/\u001b,feNLwN\u001c\t\u0006\r\u0006\u001d\u00121F\u0005\u0004\u0003Sa$AB(qi&|g\u000eE\u0002G\u0003[I1!a\f=\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003k\t\u0001f]3oIN\u000b7\u000f\u001c%b]\u0012\u001c\b.Y6f%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uKJ+7\u000f]8og\u0016$2AXA\u001c\u0011!\tI!!\rA\u0002\u0005-\u0001\"CA\u001e\u0001E\u0005I\u0011BA\u001f\u0003\u0001\u001aXM\u001c3Ba&4VM]:j_:\u001c(+Z9vKN$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}\"\u0006BA\u0013\u0003\u0003Z#!a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001bb\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011KA$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class SaslApiVersionsRequestTest
extends BaseRequestTest
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$2, x$1);){
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
    }

    @Test
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        SecurityProtocol x$3 = this.securityProtocol();
        SocketServer x$4 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$4, x$3);){
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
            try {
                this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
                throw this.fail("Versions Request during Sasl handshake did not fail", new Position("SaslApiVersionsRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            }
            catch (IOException iOException) {
            }
        }
    }

    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        SecurityProtocol x$5 = this.securityProtocol();
        SocketServer x$6 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$6, x$5);){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(0);
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)apiVersionsResponse.error());
            ApiVersionsResponse apiVersionsResponse2 = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse2);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
    }

    private ApiVersionsResponse sendApiVersionsRequest(Socket socket, ApiVersionsRequest request, Option<Object> apiVersion) {
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.API_VERSIONS, socket, apiVersion);
        return ApiVersionsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<Object> sendApiVersionsRequest$default$3() {
        return None$.MODULE$;
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest("PLAIN");
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.SASL_HANDSHAKE, socket, this.send$default$4());
        SaslHandshakeResponse handshakeResponse = SaslHandshakeResponse.parse((ByteBuffer)response, (short)request.version());
        Assert.assertEquals((Object)Errors.NONE, (Object)handshakeResponse.error());
        Assert.assertEquals(Collections.singletonList("PLAIN"), (Object)handshakeResponse.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PLAIN"}));
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

