/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u000f\tY2+\u001a:wKJ<UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0005i\\\u0017BA\u0007\u000b\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0001\u0016\u0003\u001d\u0019wN\u001c4jOF*\u0012A\u0006\t\u0003%]I!\u0001\u0007\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b5\u0001\u0001\r\u0011\"\u0001\u001c\u0003-\u0019wN\u001c4jOFzF%Z9\u0015\u0005q\u0011\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"\u0001B+oSRDqaI\r\u0002\u0002\u0003\u0007a#A\u0002yIEBa!\n\u0001!B\u00131\u0012\u0001C2p]\u001aLw-\r\u0011\t\u000f\u001d\u0002\u0001\u0019!C\u0001+\u000591m\u001c8gS\u001e\u0014\u0004bB\u0015\u0001\u0001\u0004%\tAK\u0001\fG>tg-[43?\u0012*\u0017\u000f\u0006\u0002\u001dW!91\u0005KA\u0001\u0002\u00041\u0002BB\u0017\u0001A\u0003&a#\u0001\u0005d_:4\u0017n\u001a\u001a!\u0011\u001dy\u0003\u00011A\u0005\u0002U\tqaY8oM&<7\u0007C\u00042\u0001\u0001\u0007I\u0011\u0001\u001a\u0002\u0017\r|gNZ5hg}#S-\u001d\u000b\u00039MBqa\t\u0019\u0002\u0002\u0003\u0007a\u0003\u0003\u00046\u0001\u0001\u0006KAF\u0001\tG>tg-[44A!9q\u0007\u0001a\u0001\n\u0003A\u0014aB:feZ,'o]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u0007\u0003\u0019a$o\\8u}%\tq$\u0003\u0002B=\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003z\u0001\"A\u0005$\n\u0005\u001d\u0013!aC&bM.\f7+\u001a:wKJDq!\u0013\u0001A\u0002\u0013\u0005!*A\u0006tKJ4XM]:`I\u0015\fHC\u0001\u000fL\u0011\u001d\u0019\u0003*!AA\u0002eBa!\u0014\u0001!B\u0013I\u0014\u0001C:feZ,'o\u001d\u0011\t\u000b=\u0003A\u0011\t)\u0002\u000bM,G/\u00169\u0015\u0003qA#A\u0014*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016!\u00026v]&$(\"A,\u0002\u0007=\u0014x-\u0003\u0002Z)\n1!)\u001a4pe\u0016DQa\u0017\u0001\u0005BA\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u00035v\u0003\"a\u00150\n\u0005}#&!B!gi\u0016\u0014\b\"B1\u0001\t\u0003\u0001\u0016!\u0007;fgR\fU\u000f^8HK:,'/\u0019;f\u00072,8\u000f^3s\u0013\u0012D#\u0001Y2\u0011\u0005M#\u0017BA3U\u0005\u0011!Vm\u001d;\t\u000b\u001d\u0004A\u0011\u0001)\u0002eQ,7\u000f^!vi><UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a$pe.\u000bgm[1DYV\u001cH/\u001a:TKF,XM\u001c;jC2D#AZ2\t\u000b)\u0004A\u0011\u0001)\u0002aQ,7\u000f^!vi><UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a$pe.\u000bgm[1DYV\u001cH/\u001a:QCJ\fG\u000e\\3mQ\tI7\r")
public class ServerGenerateClusterIdTest
extends ZooKeeperTestHarness {
    private KafkaConfig config1 = null;
    private KafkaConfig config2 = null;
    private KafkaConfig config3 = null;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public KafkaConfig config3() {
        return this.config3;
    }

    public void config3_$eq(KafkaConfig x$1) {
        this.config3 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())));
        this.config3_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateClusterId() {
        Assert.assertFalse((boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.ClusterIdPath()));
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        String clusterIdOnFirstBoot = server1.clusterId();
        TestUtils.isValidClusterId((String)clusterIdOnFirstBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.ClusterIdPath()));
        Assert.assertEquals((Object)this.zkUtils().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        String clusterIdOnSecondBoot = server1.clusterId();
        Assert.assertEquals((Object)clusterIdOnFirstBoot, (Object)clusterIdOnSecondBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.ClusterIdPath()));
        Assert.assertEquals((Object)this.zkUtils().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterSequential() {
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer1 = server1.clusterId();
        KafkaServer server2 = TestUtils$.MODULE$.createServer(this.config2(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer2 = server2.clusterId();
        KafkaServer server3 = TestUtils$.MODULE$.createServer(this.config3(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer3 = server3.clusterId();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2, server3}))));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
        server1.startup();
        Assert.assertEquals((Object)clusterIdFromServer1, (Object)server1.clusterId());
        server2.startup();
        Assert.assertEquals((Object)clusterIdFromServer2, (Object)server2.clusterId());
        server3.startup();
        Assert.assertEquals((Object)clusterIdFromServer3, (Object)server3.clusterId());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterParallel() {
        Future firstBoot = Future$.MODULE$.traverse((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2(), this.config3()})), (Function1 & Serializable & scala.Serializable)config -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.createServer((KafkaConfig)config, TestUtils$.MODULE$.createServer$default$2()), ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)firstBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        Seq<KafkaServer> seq = this.servers();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
            throw new MatchError(seq);
        }
        KafkaServer server1 = (KafkaServer)((SeqLike)some.get()).apply(0);
        KafkaServer server2 = (KafkaServer)((SeqLike)some.get()).apply(1);
        KafkaServer server3 = (KafkaServer)((SeqLike)some.get()).apply(2);
        Tuple3 tuple3 = new Tuple3((Object)server1, (Object)server2, (Object)server3);
        Tuple3 tuple32 = tuple3;
        KafkaServer server12 = (KafkaServer)tuple32._1();
        KafkaServer server22 = (KafkaServer)tuple32._2();
        KafkaServer server32 = (KafkaServer)tuple32._3();
        String clusterIdFromServer1 = server12.clusterId();
        String clusterIdFromServer2 = server22.clusterId();
        String clusterIdFromServer3 = server32.clusterId();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
        Future secondBoot = Future$.MODULE$.traverse((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server12, server22, server32})), (Function1 & Serializable & scala.Serializable)server -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            server.startup();
            return server;
        }, ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)secondBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ServerGenerateClusterIdTest.$anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(clusterIdFromServer1, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    public static final /* synthetic */ void $anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(String clusterIdFromServer1$1, KafkaServer server) {
        Assert.assertEquals((Object)clusterIdFromServer1$1, (Object)server.clusterId());
    }
}

