/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import kafka.api.ApiVersion$;
import kafka.server.KafkaHealthcheck;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.Watcher;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u000112A!\u0001\u0002\u0001\u000f\tI2+Z:tS>tW\t\u001f9je\u0016d\u0015n\u001d;f]\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0003\u0016\u0003!\u0011'o\\6fe&#W#\u0001\f\u0011\u0005%9\u0012B\u0001\r\u000b\u0005\rIe\u000e\u001e\u0005\u00075\u0001\u0001\u000b\u0011\u0002\f\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003\"\u0002\u000f\u0001\t\u0013i\u0012\u0001F2mK\u0006tW*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u0018\u0010F\u0001\u001f!\tIq$\u0003\u0002!\u0015\t!QK\\5u\u0011\u0015\u0011\u0003\u0001\"\u0001\u001e\u0003\u0001\"Xm\u001d;TKN\u001c\u0018n\u001c8FqBL'/\u001a'jgR,g.\u001a:NKR\u0014\u0018nY:)\u0005\u0005\"\u0003CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0015QWO\\5u\u0015\u0005I\u0013aA8sO&\u00111F\n\u0002\u0005)\u0016\u001cH\u000f")
public class SessionExpireListenerTest {
    private final int brokerId;

    private int brokerId() {
        return this.brokerId;
    }

    private void cleanMetricsRegistry() {
        MetricsRegistry metrics = Metrics.defaultRegistry();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(metrics.allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            metrics.removeMetric(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        this.cleanMetricsRegistry();
        MetricsRegistry metrics = Metrics.defaultRegistry();
        ZkClient zkClient = (ZkClient)EasyMock.mock(ZkClient.class);
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkClient, false);
        KafkaHealthcheck healthcheck = new KafkaHealthcheck(this.brokerId(), (Seq)Seq$.MODULE$.empty(), zkUtils, (Option)None$.MODULE$, ApiVersion$.MODULE$.latestVersion());
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        SessionExpireListenerTest.checkMeterCount$1(expiresPerSecName, 0L, metrics);
        SessionExpireListenerTest.checkMeterCount$1(disconnectsPerSecName, 0L, metrics);
        healthcheck.sessionExpireListener().handleStateChanged(Watcher.Event.KeeperState.Expired);
        SessionExpireListenerTest.checkMeterCount$1(expiresPerSecName, 1L, metrics);
        SessionExpireListenerTest.checkMeterCount$1(disconnectsPerSecName, 0L, metrics);
        healthcheck.sessionExpireListener().handleStateChanged(Watcher.Event.KeeperState.Disconnected);
        SessionExpireListenerTest.checkMeterCount$1(expiresPerSecName, 1L, metrics);
        SessionExpireListenerTest.checkMeterCount$1(disconnectsPerSecName, 1L, metrics);
    }

    private static final void checkMeterCount$1(String name, long expected, MetricsRegistry metrics$2) {
        Meter meter = (Meter)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics$2.allMetrics()).asScala()).collectFirst((PartialFunction)new scala.Serializable(null, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    MetricName metricName = (MetricName)A1._1();
                    Metric meter = (Metric)A1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        String string = metricName.getName();
                        String string2 = this.name$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = meter2;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                Tuple2<MetricName, Metric> tuple2 = x1;
                if (tuple2 == null) return false;
                MetricName metricName = (MetricName)tuple2._1();
                Metric meter = (Metric)tuple2._2();
                if (!(meter instanceof Meter)) return false;
                String string = metricName.getName();
                String string2 = this.name$1;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find meter with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected meter count for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (long)expected, (long)meter.count());
    }

    public SessionExpireListenerTest() {
        this.brokerId = 1;
    }
}

