/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001%\u0011\u0001\u0004T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",G+Z:u\u0015\t\u0019A!A\u0003fa>\u001c\u0007N\u0003\u0002\u0006\r\u000511/\u001a:wKJT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#\u0001\u0002uaV\t\u0001\u0004\u0005\u0002\u001aC5\t!D\u0003\u0002\u001c9\u000511m\\7n_:T!aB\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ei\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004%\u0001\u0001\u0006I\u0001G\u0001\u0004iB\u0004\u0003\"\u0003\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001(\u0003)\u0019\u0007.Z2la>Lg\u000e^\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006B\u0001\fG\",7m\u001b9pS:$8/\u0003\u0002.U\t)B*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$\b\"C\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u00011\u00039\u0019\u0007.Z2la>Lg\u000e^0%KF$\"!\r\u001b\u0011\u0005-\u0011\u0014BA\u001a\r\u0005\u0011)f.\u001b;\t\u000fUr\u0013\u0011!a\u0001Q\u0005\u0019\u0001\u0010J\u0019\t\r]\u0002\u0001\u0015)\u0003)\u0003-\u0019\u0007.Z2la>Lg\u000e\u001e\u0011\t\u000be\u0002A\u0011\u0001\u001e\u0002KMDw.\u001e7e\u0003\u0012$W\t]8dQ\u0006sG-T3tg\u0006<Wm\u00144gg\u0016$Hk\\\"bG\",G#A\u0019)\u0005ab\u0004CA\u001fA\u001b\u0005q$BA  \u0003\u0015QWO\\5u\u0013\t\teH\u0001\u0003UKN$\b\"B\"\u0001\t\u0003Q\u0014AL:i_VdGMU3ukJtGj\\4F]\u0012|eMZ:fi&3G*\u0019;fgR,\u0005o\\2i%\u0016\fX/Z:uK\u0012D#A\u0011\u001f\t\u000b\u0019\u0003A\u0011\u0001\u001e\u0002iMDw.\u001e7e%\u0016$XO\u001d8V]\u0012,g-\u001b8fI>3gm]3u\u0013\u001a,f\u000eZ3gS:,G-\u00129pG\"\u0014V-];fgR,G\r\u000b\u0002Fy!)\u0011\n\u0001C\u0001u\u0005\u00115\u000f[8vY\u0012tu\u000e^(wKJ<(/\u001b;f\u0019><WI\u001c3PM\u001a\u001cX\r\u001e$pe\u0006cU-\u00193fe\u0016\u0003xn\u00195P]\u000e,\u0017\n\u001e%bg\n+WM\\!tg&<g.\u001a3)\u0005!c\u0004\"\u0002'\u0001\t\u0003Q\u0014!M:i_VdG-\u00117m_^dU-\u00193fe\u0016\u0003xn\u00195U_\u000eC\u0017M\\4f\u000bZ,g.\u00134PM\u001a\u001cX\r\u001e#pKNtu\u000e\u001e\u0015\u0003\u0017rBQa\u0014\u0001\u0005\u0002i\nAh\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK>3gm]3u\r>\u0014\u0018\tT3bI\u0016\u0014X\t]8dQ>s7-Z%u\u0011\u0006\u001c()Z3o\u0003N\u001c\u0018n\u001a8fI\"\u0012a\n\u0010\u0005\u0006%\u0002!\tAO\u0001)g\"|W\u000f\u001c3SKR,(O\\+ogV\u0004\bo\u001c:uK\u0012LeMT8Fa>\u001c\u0007NU3d_J$W\r\u001a\u0015\u0003#rBQ!\u0016\u0001\u0005\u0002i\n\u0011h\u001d5pk2$'+\u001a;ve:,fn];qa>\u0014H/\u001a3JMJ+\u0017/^3ti\u0016$W\t]8dQ2+7o\u001d+iC:4\u0015N]:u\u000bB|7\r\u001b\u0015\u0003)rBQ\u0001\u0017\u0001\u0005\u0002i\n\u0001j\u001d5pk2$w)\u001a;GSJ\u001cHo\u00144gg\u0016$xJZ*vEN,\u0017/^3oi\u0016\u0003xn\u00195XQ\u0016twJ\u001a4tKR\u0014V-];fgR,GMR8s!J,g/[8vg\u0016\u0003xn\u00195)\u0005]c\u0004\"B.\u0001\t\u0003Q\u0014!R:i_VdGMU3ukJtg*\u001a=u\u0003Z\f\u0017\u000e\\1cY\u0016,\u0005o\\2i\u0013\u001a$\u0006.\u001a:f\u0013Ntu.\u0012=bGR,\u0005o\\2i\r>\u0014H\u000b[3P]\u0016\u0014V-];fgR,G\r\u000b\u0002[y!)a\f\u0001C\u0001u\u0005\u00114\u000f[8vY\u0012tu\u000e^+qI\u0006$X-\u00129pG\"\fe\u000eZ*uCJ$xJ\u001a4tKRLe-\u0013;ES\u0012tu\u000e^\"iC:<W\r\u000b\u0002^y!)\u0011\r\u0001C\u0001u\u0005)5\u000f[8vY\u0012\u0014V\r^;s]&sg/\u00197jI>3gm]3u\u0013\u001a,\u0005o\\2i\u0013N\u0014V-];fgR,Gm\u00165jG\"L5OT8u\u0007V\u0014(/\u001a8uYf$&/Y2lK\u0012D#\u0001\u0019\u001f\t\u000b\u0011\u0004A\u0011\u0001\u001e\u0002SMDw.\u001e7e'V\u0004\bo\u001c:u\u000bB|7\r[:UQ\u0006$Hi\u001c(piN#\u0018M\u001d;Ge>l',\u001a:pQ\t\u0019G\bC\u0003h\u0001\u0011\u0005!(A\u0012tQ>,H\u000e\u001a)feNL7\u000f^#q_\u000eD7OQ3uo\u0016,g.\u00138ti\u0006t7-Z:)\u0005\u0019d\u0004\"\u00026\u0001\t\u0003Q\u0014!M:i_VdGMT8u\u0019\u0016$X\t]8dQ\u001e{')Y2lo\u0006\u0014Hm]#wK:Le-T3tg\u0006<W-\u00129pG\"\u001cHi\u001c\u0015\u0003SrBQ!\u001c\u0001\u0005\u0002i\n!g\u001d5pk2$gj\u001c;MKR|eMZ:fiN<uNQ1dW^\f'\u000fZ:Fm\u0016t\u0017JZ#q_\u000eD7\u000f\u0015:pOJ,7o\u001d\u0015\u0003YrBQ\u0001\u001d\u0001\u0005\u0002i\nAg\u001d5pk2$\u0017J\\2sK\u0006\u001cX-\u00118e)J\f7m[#q_\u000eD7/Q:MK\u0006$WM]:DQ\u0006tw-Z'b]f$\u0016.\\3tQ\tyG\bC\u0003t\u0001\u0011\u0005!(\u0001\u001etQ>,H\u000eZ%oGJ,\u0017m]3B]\u0012$&/Y2l\u000bB|7\r[:Bg\u001a{G\u000e\\8xKJ\u0014VmY3jm\u0016\u001cX*\u00198z\u001b\u0016\u001c8/Y4fg\"\u0012!\u000f\u0010\u0005\u0006m\u0002!\tAO\u0001:g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001cxJ\\#q_\u000eD'i\\;oI\u0006\u0014\u0018p\u00165f]J+Wn\u001c<j]\u001ed\u0015\r^3ti\u0016sGO]5fg\"\u0012Q\u000f\u0010\u0005\u0006s\u0002!\tAO\u00014g\"|W\u000f\u001c3Qe\u0016\u001cXM\u001d<f%\u0016\u001cX\r^(gMN,Go\u00148DY\u0016\f'/R1sY&,7\u000f^%g\u001f:,W\t_5tiND#\u0001\u001f\u001f\t\u000bq\u0004A\u0011\u0001\u001e\u0002sMDw.\u001e7e+B$\u0017\r^3TCZ,Gm\u00144gg\u0016$x\u000b[3o\u001f\u001a47/\u001a;U_\u000ecW-\u0019:U_&\u001b()\u001a;xK\u0016tW\t]8dQND#a\u001f\u001f\t\u000b}\u0004A\u0011\u0001\u001e\u0002KMDw.\u001e7e\u001d>$8\t\\3be\u0006s\u0017\u0010\u001e5j]\u001eLem\u00144gg\u0016$Hk\\#be2L\bF\u0001@=\u0011\u0019\t)\u0001\u0001C\u0001u\u0005Y3\u000f[8vY\u0012tu\u000e^\"mK\u0006\u0014\u0018I\\=uQ&tw-\u00134PM\u001a\u001cX\r\u001e+p\r&\u00148\u000f^(gMN,G\u000fK\u0002\u0002\u0004qBa!a\u0003\u0001\t\u0003Q\u0014!K:i_VdGMU3uC&tG*\u0019;fgR,\u0005o\\2i\u001f:\u001cE.Z1s\u00032dW)\u0019:mS\u0016\u001cH\u000fK\u0002\u0002\nqBa!!\u0005\u0001\t\u0003Q\u0014aN:i_VdG-\u00169eCR,wJ\u001a4tKR\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1sS\u0016\u001cxJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cH\u000fK\u0002\u0002\u0010qBa!a\u0006\u0001\t\u0003Q\u0014\u0001O:i_VdG-\u00169eCR,wJ\u001a4tKR\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1sS\u0016\u001cxJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cHO\r\u0015\u0004\u0003+a\u0004BBA\u000f\u0001\u0011\u0005!(A\u001etQ>,H\u000e\u001a*fi\u0006Lg\u000eT1uKN$X\t]8dQ>s7\t\\3be\u0006cG.R1sY&,7\u000f^!oIV\u0003H-\u0019;f\u0013R\u001cxJ\u001a4tKRD3!a\u0007=\u0011\u0019\t\u0019\u0003\u0001C\u0001u\u000594\u000f[8vY\u0012$%o\u001c9F]R\u0014\u0018.Z:CKR<X-\u001a8Fa>\u001c\u0007NQ8v]\u0012\f'/_,iK:\u0014V-\\8wS:<g*Z<fgRD3!!\t=\u0011\u0019\tI\u0003\u0001C\u0001u\u0005)2\u000f[8vY\u0012\u001cE.Z1s\u00032dWI\u001c;sS\u0016\u001c\bfAA\u0014y!1\u0011q\u0006\u0001\u0005\u0002i\nqf\u001d5pk2$gj\u001c;SKN,G/\u00129pG\"D\u0015n\u001d;pefDU-\u00193JMVsG-\u001a4j]\u0016$\u0007+Y:tK\u0012D3!!\f=\u0011\u0019\t)\u0004\u0001C\u0001u\u0005y3\u000f[8vY\u0012tu\u000e\u001e*fg\u0016$X\t]8dQ\"K7\u000f^8ssR\u000b\u0017\u000e\\%g+:$WMZ5oK\u0012\u0004\u0016m]:fI\"\u001a\u00111\u0007\u001f\t\r\u0005m\u0002\u0001\"\u0001;\u0003\t\u001a\bn\\;mI\u001a+Go\u00195MCR,7\u000f^#q_\u000eDwJZ#naRL8)Y2iK\"\u001a\u0011\u0011\b\u001f\t\r\u0005\u0005\u0003\u0001\"\u0001;\u0003\u0001\u001a\bn\\;mI\u001a+Go\u00195F]\u0012|eMZ:fi>3W)\u001c9us\u000e\u000b7\r[3)\u0007\u0005}B\b\u0003\u0004\u0002H\u0001!\tAO\u0001 g\"|W\u000f\u001c3DY\u0016\f'/R1sY&,7\u000f^(o\u000b6\u0004H/_\"bG\",\u0007fAA#y!1\u0011Q\n\u0001\u0005\u0002i\nQd\u001d5pk2$7\t\\3be2\u000bG/Z:u\u001f:,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0004\u0003\u0017b\u0004BBA*\u0001\u0011\u0005!(A\u0003tKR,\u0006\u000f\u000b\u0003\u0002R\u0005]\u0003cA\u001f\u0002Z%\u0019\u00111\f \u0003\r\t+gm\u001c:f\u0001")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private LeaderEpochCheckpoint checkpoint;

    public TopicPartition tp() {
        return this.tp;
    }

    public LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    public void checkpoint_$eq(LeaderEpochCheckpoint x$1) {
        this.checkpoint = x$1;
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$1(leo), this.checkpoint());
        cache.assign(2, 10L);
        leo.elem = 11;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((Object)new EpochEntry(2, 10L), (Object)cache.epochEntries().apply(0));
        Assert.assertEquals((long)11L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$2(leo), this.checkpoint());
        cache.assign(2, 11L);
        cache.assign(2, 12L);
        leo.elem = 14;
        Assert.assertEquals((long)14L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$3(), this.checkpoint());
        cache.assign(2, 11L);
        cache.assign(3, 12L);
        long offsetFor = cache.endOffsetFor(-1);
        Assert.assertEquals((long)-1L, (long)offsetFor);
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        IntRef leo = IntRef.create((int)0);
        leo.elem = 9;
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$4(leo), this.checkpoint());
        cache.assign(2, (long)leo.elem);
        cache.assign(2, 10L);
        Assert.assertEquals((long)leo.elem, (long)((EpochEntry)cache.epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldAllowLeaderEpochToChangeEvenIfOffsetDoesNot() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$5(), this.checkpoint());
        cache.assign(2, 9L);
        cache.assign(3, 9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L), new EpochEntry(3, 9L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(2, 10L);
        Assert.assertEquals((long)6L, (long)((EpochEntry)cache.epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$6(), this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(0));
    }

    @Test
    public void shouldReturnUnsupportedIfRequestedEpochLessThanFirstEpoch() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$7(), this.checkpoint());
        cache.assign(5, 11L);
        cache.assign(6, 12L);
        cache.assign(7, 13L);
        long offset = cache.endOffsetFor(4);
        Assert.assertEquals((long)-1L, (long)offset);
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$8(leo), this.checkpoint());
        cache.assign(1, 11L);
        cache.assign(1, 12L);
        cache.assign(2, 13L);
        cache.assign(2, 14L);
        cache.assign(3, 15L);
        cache.assign(3, 16L);
        leo.elem = 17;
        Assert.assertEquals((long)15L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$9(), this.checkpoint());
        cache.assign(0, 10L);
        cache.assign(2, 13L);
        cache.assign(4, 17L);
        Assert.assertEquals((long)13L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)17L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$10(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(2, 7L);
        Assert.assertEquals((long)1L, (long)cache.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        int leo = 100;
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$11(leo), this.checkpoint());
        cache.assign(2, 100L);
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(3));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$12(leo), this.checkpoint());
        cache.assign(2, 6L);
        leo.elem = 7;
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)1L, (long)cache.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        this.checkpoint_$eq((LeaderEpochCheckpoint)new LeaderEpochCheckpointFile(new File(checkpointPath)));
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$13(), this.checkpoint());
        cache.assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath));
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$13(), (LeaderEpochCheckpoint)checkpoint2);
        Assert.assertEquals((long)1L, (long)cache2.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldNotLetEpochGoBackwardsEvenIfMessageEpochsDo() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$14(leo), this.checkpoint());
        cache.assign(1, 5L);
        leo.elem = 6;
        cache.assign(2, 6L);
        leo.elem = 7;
        cache.assign(1, 7L);
        leo.elem = 8;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((long)6L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)8L, (long)cache.endOffsetFor(2));
        Assert.assertEquals((Object)new EpochEntry(1, 5L), (Object)cache.epochEntries().apply(0));
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().apply(1));
    }

    @Test
    public void shouldNotLetOffsetsGoBackwardsEvenIfEpochsProgress() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$15(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 5L);
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$16(leo), this.checkpoint());
        cache.assign(0, 0L);
        cache.assign(1, 0L);
        Assert.assertEquals((long)1L, (long)cache.latestEpoch());
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
        leo.elem = 5;
        Assert.assertEquals((long)5L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
        cache.assign(2, 5L);
        leo.elem = 10;
        Assert.assertEquals((long)10L, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)5L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$17(leo), this.checkpoint());
        cache.assign(0, 0L);
        leo.elem = 1;
        cache.assign(0, 1L);
        leo.elem = 2;
        cache.assign(0, 2L);
        leo.elem = 3;
        Assert.assertEquals((long)0L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(0));
        cache.assign(1, 3L);
        leo.elem = 4;
        cache.assign(1, 4L);
        leo.elem = 5;
        cache.assign(1, 5L);
        leo.elem = 6;
        Assert.assertEquals((long)1L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(1));
        cache.assign(2, 6L);
        leo.elem = 7;
        cache.assign(2, 7L);
        leo.elem = 8;
        cache.assign(2, 8L);
        leo.elem = 9;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)3L, (long)cache.endOffsetFor(0));
        Assert.assertEquals((long)6L, (long)cache.endOffsetFor(1));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$18(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$19(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$20(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$21(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(1L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$22(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(6L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$23(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(11L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$24(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$25(), this.checkpoint());
        cache.assign(0, 0L);
        cache.assign(1, 7L);
        cache.assign(2, 10L);
        cache.clearAndFlushEarliest(5L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$26(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(15L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$27(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(9L);
        Assert.assertEquals((long)3L, (long)cache.latestEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$28(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlush();
        Assert.assertEquals((long)0L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$29(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(-1L);
        Assert.assertEquals((long)3L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$30(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(-1L);
        Assert.assertEquals((long)3L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$31(), this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$32(), this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(7));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$33(), this.checkpoint());
        cache.clearAndFlushEarliest(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$34(), this.checkpoint());
        cache.clearAndFlushLatest(7L);
    }

    @Before
    public void setUp() {
        this.checkpoint_$eq((LeaderEpochCheckpoint)new LeaderEpochCheckpointFile(TestUtils$.MODULE$.tempFile()));
    }

    private static final LogOffsetMetadata leoFinder$1(IntRef leo$1) {
        return new LogOffsetMetadata((long)leo$1.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$2(IntRef leo$2) {
        return new LogOffsetMetadata((long)leo$2.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$3() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$4(IntRef leo$3) {
        return new LogOffsetMetadata((long)leo$3.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$5() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$6() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$7() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$8(IntRef leo$4) {
        return new LogOffsetMetadata((long)leo$4.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$9() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$10() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$11(int leo$5) {
        return new LogOffsetMetadata((long)leo$5, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$12(IntRef leo$6) {
        return new LogOffsetMetadata((long)leo$6.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$13() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$14(IntRef leo$7) {
        return new LogOffsetMetadata((long)leo$7.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$15() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$16(IntRef leo$8) {
        return new LogOffsetMetadata((long)leo$8.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$17(IntRef leo$9) {
        return new LogOffsetMetadata((long)leo$9.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$18() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$19() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$20() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$21() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$22() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$23() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$24() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$25() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$26() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$27() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$28() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$29() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$30() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$31() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$32() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$33() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$34() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }
}

