/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Properties;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.ConsumerTimeoutException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tools.MirrorMaker;
import kafka.tools.MirrorMaker$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u000f\tQR*\u001b:s_Jl\u0015m[3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u0015!\u0002\u0001\"\u0011\u0016\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cH#\u0001\f\u0011\u0007]\tCE\u0004\u0002\u0019=9\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0007yI|w\u000e\u001e \n\u0003u\tQa]2bY\u0006L!a\b\u0011\u0002\u000fA\f7m[1hK*\tQ$\u0003\u0002#G\t\u00191+Z9\u000b\u0005}\u0001\u0003CA\u0013)\u001b\u00051#BA\u0014\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011F\n\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003,\u0001\u0011\u0005A&A\fuKN$8i\\7nCN+\u0007/\u0019:bi\u0016$'+Z4fqR\tQ\u0006\u0005\u0002/_5\t\u0001%\u0003\u00021A\t!QK\\5uQ\tQ#\u0007\u0005\u00024q5\tAG\u0003\u00026m\u0005)!.\u001e8ji*\tq'A\u0002pe\u001eL!!\u000f\u001b\u0003\tQ+7\u000f\u001e")
public class MirrorMakerIntegrationTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testCommaSeparatedRegex() {
        String topic = "new-topic";
        String msg = "a test message";
        String brokerList = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("key.serializer", ByteArraySerializer.class);
        producerProps.put("value.serializer", ByteArraySerializer.class);
        MirrorMaker.MirrorMakerProducer producer = new MirrorMaker.MirrorMakerProducer(true, producerProps);
        MirrorMaker$.MODULE$.producer_$eq(producer);
        MirrorMaker$.MODULE$.producer().send(new ProducerRecord(topic, (Object)msg.getBytes()));
        MirrorMaker$.MODULE$.producer().close();
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", brokerList);
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.MirrorMakerNewConsumer mirrorMakerConsumer = new MirrorMaker.MirrorMakerNewConsumer((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"another_topic,new.*,foo"));
        mirrorMakerConsumer.init();
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                block4: {
                    try {
                        BaseConsumerRecord data = mirrorMakerConsumer.receive();
                        String string = data.topic();
                        String string2 = topic;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            String string3 = new String(data.value());
                            String string4 = msg;
                            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                bl = true;
                                break block4;
                            }
                        }
                        bl = false;
                    }
                    catch (ConsumerTimeoutException consumerTimeoutException) {
                        bl = false;
                    }
                }
                return bl;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "MirrorMaker consumer should read the expected message from the expected topic within the timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        finally {
            consumer.close();
        }
    }
}

