/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Properties;
import java.util.Random;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.log.Log$;
import kafka.message.MessageAndMetadata;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.tools.TestRecord;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.IteratorTemplate;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

public final class TestLogCleaning$ {
    public static TestLogCleaning$ MODULE$;

    static {
        new TestLogCleaning$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec numMessagesOpt = parser.accepts("messages", "The number of messages to send or consume.").withRequiredArg().describedAs("count").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(Long.MAX_VALUE), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec messageCompressionOpt = parser.accepts("compression-type", "message compression type").withOptionalArg().describedAs("compressionType").ofType(String.class).defaultsTo((Object)"none", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec numDupsOpt = parser.accepts("duplicates", "The number of duplicates for each key.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(5), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec brokerOpt = parser.accepts("broker", "Url to connect to.").withRequiredArg().describedAs("url").ofType(String.class);
        ArgumentAcceptingOptionSpec topicsOpt = parser.accepts("topics", "The number of topics to test.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec percentDeletesOpt = parser.accepts("percent-deletes", "The percentage of updates that are deletes.").withRequiredArg().describedAs("percent").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zk", "Zk url.").withRequiredArg().describedAs("url").ofType(String.class);
        ArgumentAcceptingOptionSpec sleepSecsOpt = parser.accepts("sleep", "Time to sleep between production and consumption.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec dumpOpt = parser.accepts("dump", "Dump the message contents of a topic partition that contains test data from this test to standard out.").withRequiredArg().describedAs("directory").ofType(String.class);
        OptionSet options = parser.parse(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An integration test for log cleaning.");
        }
        if (options.has((OptionSpec)dumpOpt)) {
            this.dumpLog(new File((String)options.valueOf((OptionSpec)dumpOpt)));
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerOpt, zkConnectOpt, numMessagesOpt}));
        long messages = (Long)options.valueOf((OptionSpec)numMessagesOpt);
        String compressionType = (String)options.valueOf((OptionSpec)messageCompressionOpt);
        int percentDeletes = (Integer)options.valueOf((OptionSpec)percentDeletesOpt);
        int dups = (Integer)options.valueOf((OptionSpec)numDupsOpt);
        String brokerUrl = (String)options.valueOf((OptionSpec)brokerOpt);
        int topicCount = (Integer)options.valueOf((OptionSpec)topicsOpt);
        String zkUrl = (String)options.valueOf((OptionSpec)zkConnectOpt);
        int sleepSecs = (Integer)options.valueOf((OptionSpec)sleepSecsOpt);
        int testId = new Random().nextInt(Integer.MAX_VALUE);
        String[] topics = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), topicCount).map((Function1 & Serializable & scala.Serializable)x$1 -> TestLogCleaning$.$anonfun$main$1(testId, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Producing %d messages...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)messages)})));
        File producedDataFile = this.produceMessages(brokerUrl, topics, messages, compressionType, dups, percentDeletes);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Sleeping for %d seconds...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sleepSecs)})));
        Thread.sleep(sleepSecs * 1000);
        Predef$.MODULE$.println((Object)"Consuming messages...");
        File consumedDataFile = this.consumeMessages(zkUrl, topics);
        int producedLines = this.lineCount(producedDataFile);
        int consumedLines = this.lineCount(consumedDataFile);
        double reduction = 1.0 - (double)consumedLines / (double)producedLines;
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%d rows of data produced, %d rows of data consumed (%.1f%% reduction).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)producedLines), BoxesRunTime.boxToInteger((int)consumedLines), BoxesRunTime.boxToDouble((double)((double)100 * reduction))})));
        Predef$.MODULE$.println((Object)"De-duplicating and validating output files...");
        this.validateOutput(producedDataFile, consumedDataFile);
        producedDataFile.delete();
        consumedDataFile.delete();
    }

    public void dumpLog(File dir) {
        Predef$.MODULE$.require(dir.exists(), (Function0 & Serializable & scala.Serializable)() -> "Non-existent directory: " + dir.getAbsolutePath());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.list())).sorted((Ordering)Ordering.String$.MODULE$))).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.endsWith(Log$.MODULE$.LogFileSuffix()))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            TestLogCleaning$.$anonfun$dumpLog$3(dir, file);
            return BoxedUnit.UNIT;
        });
    }

    public int lineCount(File file) {
        return Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).getLines().size();
    }

    public void validateOutput(File producedDataFile, File consumedDataFile) {
        BufferedReader producedReader = this.externalSort(producedDataFile);
        BufferedReader consumedReader = this.externalSort(consumedDataFile);
        IteratorTemplate<TestRecord> produced = this.valuesIterator(producedReader);
        IteratorTemplate<TestRecord> consumed = this.valuesIterator(consumedReader);
        File producedDedupedFile = new File(producedDataFile.getAbsolutePath() + ".deduped");
        BufferedWriter producedDeduped = new BufferedWriter(new FileWriter(producedDedupedFile), 0x100000);
        File consumedDedupedFile = new File(consumedDataFile.getAbsolutePath() + ".deduped");
        BufferedWriter consumedDeduped = new BufferedWriter(new FileWriter(consumedDedupedFile), 0x100000);
        int total = 0;
        int mismatched = 0;
        while (produced.hasNext() && consumed.hasNext()) {
            TestRecord p = (TestRecord)produced.next();
            producedDeduped.write(p.toString());
            producedDeduped.newLine();
            TestRecord c = (TestRecord)consumed.next();
            consumedDeduped.write(c.toString());
            consumedDeduped.newLine();
            TestRecord testRecord = p;
            TestRecord testRecord2 = c;
            if (testRecord == null ? testRecord2 != null : !((Object)testRecord).equals(testRecord2)) {
                ++mismatched;
            }
            ++total;
        }
        producedDeduped.close();
        consumedDeduped.close();
        Predef$.MODULE$.println((Object)("Validated " + total + " values, " + mismatched + " mismatches."));
        Predef$.MODULE$.require(!produced.hasNext(), (Function0 & Serializable & scala.Serializable)() -> "Additional values produced not found in consumer log.");
        Predef$.MODULE$.require(!consumed.hasNext(), (Function0 & Serializable & scala.Serializable)() -> "Additional values consumed not found in producer log.");
        Predef$.MODULE$.require(mismatched == 0, (Function0 & Serializable & scala.Serializable)() -> "Non-zero number of row mismatches.");
        producedDedupedFile.delete();
        consumedDedupedFile.delete();
    }

    public IteratorTemplate<TestRecord> valuesIterator(BufferedReader reader) {
        return new IteratorTemplate<TestRecord>(reader){
            private final BufferedReader reader$1;

            /*
             * WARNING - void declaration
             */
            public TestRecord makeNext() {
                void var1_1;
                TestRecord next = TestLogCleaning$.MODULE$.readNext(this.reader$1);
                while (next != null && next.delete()) {
                    next = TestLogCleaning$.MODULE$.readNext(this.reader$1);
                }
                return next == null ? (TestRecord)this.allDone() : var1_1;
            }
            {
                this.reader$1 = reader$1;
            }
        };
    }

    public TestRecord readNext(BufferedReader reader) {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        TestRecord curr = new TestRecord(line);
        while (true) {
            TestRecord next;
            block7: {
                block6: {
                    if ((line = this.peekLine(reader)) == null) {
                        return curr;
                    }
                    next = new TestRecord(line);
                    if (next == null) break block6;
                    String string = next.topicAndKey();
                    String string2 = curr.topicAndKey();
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block7;
                }
                return curr;
            }
            curr = next;
            reader.readLine();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String peekLine(BufferedReader reader) {
        void var2_2;
        reader.mark(4096);
        String line = reader.readLine();
        reader.reset();
        return var2_2;
    }

    public BufferedReader externalSort(File file) {
        ProcessBuilder builder = new ProcessBuilder("sort", "--key=1,2", "--stable", "--buffer-size=20%", "--temporary-directory=" + System.getProperty("java.io.tmpdir"), file.getAbsolutePath());
        Process process = builder.start();
        new Thread(process){
            private final Process process$1;

            public void run() {
                int exitCode = this.process$1.waitFor();
                if (exitCode != 0) {
                    System.err.println("Process exited abnormally.");
                    while (this.process$1.getErrorStream().available() > 0) {
                        System.err.write(this.process$1.getErrorStream().read());
                    }
                }
            }
            {
                this.process$1 = process$1;
            }
        }.start();
        return new BufferedReader(new InputStreamReader(process.getInputStream()), 0xA00000);
    }

    public File produceMessages(String brokerUrl, String[] topics, long messages, String compressionType, int dups, int percentDeletes) {
        Properties producerProps = new Properties();
        producerProps.setProperty("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        producerProps.setProperty("bootstrap.servers", brokerUrl);
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.setProperty("compression.type", compressionType);
        KafkaProducer producer = new KafkaProducer(producerProps);
        Random rand = new Random(1L);
        int keyCount = (int)(messages / (long)dups);
        File producedFile = File.createTempFile("kafka-log-cleaner-produced-", ".txt");
        Predef$.MODULE$.println((Object)("Logging produce requests to " + producedFile.getAbsolutePath()));
        BufferedWriter producedWriter = new BufferedWriter(new FileWriter(producedFile), 0x100000);
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)(messages * (long)topics.length))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)i -> {
            String topic = topics[(int)(i % (long)topics.length)];
            int key = rand.nextInt(keyCount);
            boolean delete = i % 100L < (long)percentDeletes;
            ProducerRecord msg = delete ? new ProducerRecord(topic, (Object)((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), null) : new ProducerRecord(topic, (Object)((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToLong((long)i)).toString().getBytes());
            producer.send(msg);
            producedWriter.write(new TestRecord(topic, key, i, delete).toString());
            producedWriter.newLine();
        });
        producedWriter.close();
        producer.close();
        return producedFile;
    }

    public ZookeeperConsumerConnector makeConsumer(String zkUrl, String[] topics) {
        Properties consumerProps = new Properties();
        consumerProps.setProperty("group.id", "log-cleaner-test-" + new Random().nextInt(Integer.MAX_VALUE));
        consumerProps.setProperty("zookeeper.connect", zkUrl);
        consumerProps.setProperty("consumer.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)20000)).toString());
        consumerProps.setProperty("auto.offset.reset", "smallest");
        return new ZookeeperConsumerConnector(new ConsumerConfig(consumerProps));
    }

    public File consumeMessages(String zkUrl, String[] topics) {
        ZookeeperConsumerConnector connector = this.makeConsumer(zkUrl, topics);
        Map streams = connector.createMessageStreams((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topics)).map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)BoxesRunTime.boxToInteger((int)1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        File consumedFile = File.createTempFile("kafka-log-cleaner-consumed-", ".txt");
        Predef$.MODULE$.println((Object)("Logging consumed messages to " + consumedFile.getAbsolutePath()));
        BufferedWriter consumedWriter = new BufferedWriter(new FileWriter(consumedFile));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topics)).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TestLogCleaning$.$anonfun$consumeMessages$2(streams, consumedWriter, topic);
            return BoxedUnit.UNIT;
        });
        consumedWriter.close();
        connector.shutdown();
        return consumedFile;
    }

    public static final /* synthetic */ String $anonfun$main$1(int testId$1, int x$1) {
        return "log-cleaner-test-" + testId$1 + "-" + x$1;
    }

    public static final /* synthetic */ void $anonfun$dumpLog$4(Record entry) {
        String key = TestUtils$.MODULE$.readString(entry.key(), TestUtils$.MODULE$.readString$default$2());
        String content = !entry.hasValue() ? null : TestUtils$.MODULE$.readString(entry.value(), TestUtils$.MODULE$.readString$default$2());
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("offset = %s, key = %s, content = %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)entry.offset()), key, content})));
    }

    public static final /* synthetic */ void $anonfun$dumpLog$3(File dir$1, String file) {
        FileRecords fileRecords = FileRecords.open((File)new File(dir$1, file));
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fileRecords.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TestLogCleaning$.$anonfun$dumpLog$4(entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$consumeMessages$3(BufferedWriter consumedWriter$1, String topic$1, MessageAndMetadata item) {
        boolean delete = item.message() == null;
        long value = delete ? -1L : new StringOps(Predef$.MODULE$.augmentString((String)item.message())).toLong();
        consumedWriter$1.write(new TestRecord(topic$1, new StringOps(Predef$.MODULE$.augmentString((String)item.key())).toInt(), value, delete).toString());
        consumedWriter$1.newLine();
    }

    public static final /* synthetic */ void $anonfun$consumeMessages$2(Map streams$1, BufferedWriter consumedWriter$1, String topic) {
        KafkaStream stream = (KafkaStream)((IterableLike)streams$1.apply((Object)topic)).head();
        try {
            stream.foreach((Function1 & Serializable & scala.Serializable)item -> {
                TestLogCleaning$.$anonfun$consumeMessages$3(consumedWriter$1, topic, item);
                return BoxedUnit.UNIT;
            });
        }
        catch (ConsumerTimeoutException consumerTimeoutException) {}
    }

    private TestLogCleaning$() {
        MODULE$ = this;
    }
}

