/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.utils.Json$;
import kafka.utils.ReplicationUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u000f\t!\"+\u001a9mS\u000e\fG/[8o+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0003u.L!!\u0004\u0006\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007I\u0011A\u000b\u0002\u000bQ|\u0007/[2\u0016\u0003Y\u0001\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\t1\fgn\u001a\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0004TiJLgn\u001a\u0005\u0007?\u0001\u0001\u000b\u0011\u0002\f\u0002\rQ|\u0007/[2!\u0011\u001d\t\u0003A1A\u0005\u0002\t\n1\u0002]1si&$\u0018n\u001c8JIV\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0002J]RDaA\u000b\u0001!\u0002\u0013\u0019\u0013\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003b\u0002\u0017\u0001\u0005\u0004%\tAI\u0001\tEJ|7.\u001a:JI\"1a\u0006\u0001Q\u0001\n\r\n\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000fA\u0002!\u0019!C\u0001E\u0005YA.Z1eKJ,\u0005o\\2i\u0011\u0019\u0011\u0004\u0001)A\u0005G\u0005aA.Z1eKJ,\u0005o\\2iA!9A\u0007\u0001b\u0001\n\u0003\u0011\u0013aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\rY\u0002\u0001\u0015!\u0003$\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007\u0005C\u00049\u0001\t\u0007I\u0011\u0001\u0012\u0002\u0013i\\g+\u001a:tS>t\u0007B\u0002\u001e\u0001A\u0003%1%\u0001\u0006{WZ+'o]5p]\u0002Bq\u0001\u0010\u0001C\u0002\u0013\u0005Q#A\u0005u_BL7\rU1uQ\"1a\b\u0001Q\u0001\nY\t!\u0002^8qS\u000e\u0004\u0016\r\u001e5!\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005\u000b\u0011\u0002^8qS\u000e$\u0015\r^1\u0016\u0003\t\u0003\"a\u0011&\u000f\u0005\u0011C\u0005CA#&\u001b\u00051%BA$\u0007\u0003\u0019a$o\\8u}%\u0011\u0011*J\u0001\u0007!J,G-\u001a4\n\u0005uY%BA%&\u0011\u0019i\u0005\u0001)A\u0005\u0005\u0006QAo\u001c9jG\u0012\u000bG/\u0019\u0011\t\u000f=\u0003!\u0019!C\u0001\u0003\u0006ABo\u001c9jG\u0012\u000bG/\u0019,feNLwN\\'jg6\fGo\u00195\t\rE\u0003\u0001\u0015!\u0003C\u0003e!x\u000e]5d\t\u0006$\u0018MV3sg&|g.T5t[\u0006$8\r\u001b\u0011\t\u000fM\u0003!\u0019!C\u0001\u0003\u0006\tBo\u001c9jG\u0012\u000bG/Y'jg6\fGo\u00195\t\rU\u0003\u0001\u0015!\u0003C\u0003I!x\u000e]5d\t\u0006$\u0018-T5t[\u0006$8\r\u001b\u0011\t\u000f]\u0003!\u0019!C\u00011\u0006!Co\u001c9jG\u0012\u000bG/\u0019'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007.F\u0001Z!\tQV,D\u0001\\\u0015\taF!\u0001\u0006d_:$(o\u001c7mKJL!AX.\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u0019\u0001\u0007\u0001)A\u00053\u0006)Co\u001c9jG\u0012\u000bG/\u0019'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0005\u0006E\u0002!\teY\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002IB\u0011A%Z\u0005\u0003M\u0016\u0012A!\u00168ji\"\u0012\u0011\r\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\fQA[;oSRT\u0011!\\\u0001\u0004_J<\u0017BA8k\u0005\u0019\u0011UMZ8sK\")\u0011\u000f\u0001C\u0001G\u00061B/Z:u+B$\u0017\r^3MK\u0006$WM]!oI&\u001b(\u000f\u000b\u0002qgB\u0011\u0011\u000e^\u0005\u0003k*\u0014A\u0001V3ti\")q\u000f\u0001C\u0001G\u0006!C/Z:u\u000f\u0016$H*Z1eKJL5O]!oI\u0016\u0003xn\u00195G_J\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002wg\u0002")
public class ReplicationUtilsTest
extends ZooKeeperTestHarness {
    private final String topic;
    private final int partitionId;
    private final int brokerId;
    private final int leaderEpoch;
    private final int controllerEpoch;
    private final int zkVersion;
    private final String topicPath;
    private final String topicData = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
    private final String topicDataVersionMismatch = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
    private final String topicDataMismatch = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
    private final LeaderIsrAndControllerEpoch topicDataLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, this.leaderEpoch(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), 0), this.controllerEpoch());

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public String topicPath() {
        return this.topicPath;
    }

    public String topicData() {
        return this.topicData;
    }

    public String topicDataVersionMismatch() {
        return this.topicDataVersionMismatch;
    }

    public String topicDataMismatch() {
        return this.topicDataMismatch;
    }

    public LeaderIsrAndControllerEpoch topicDataLeaderIsrAndControllerEpoch() {
        return this.topicDataLeaderIsrAndControllerEpoch;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        ZkUtils qual$1 = this.zkUtils();
        String x$4 = this.topicPath();
        String x$5 = this.topicData();
        java.util.List x$6 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$4, x$5, x$6);
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log);
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(new TopicPartition(this.topic(), this.partitionId()))).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.config()).andReturn(configs.head());
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager);
        EasyMock.expect((Object)replicaManager.replicaFetcherManager()).andReturn(EasyMock.createMock(ReplicaFetcherManager.class));
        EasyMock.expect((Object)replicaManager.zkUtils()).andReturn((Object)this.zkUtils());
        EasyMock.replay((Object[])new Object[]{replicaManager});
        ZkUtils qual$2 = this.zkUtils();
        String x$7 = ZkUtils$.MODULE$.IsrChangeNotificationPath();
        java.util.List x$8 = qual$2.makeSurePersistentPathExists$default$2();
        qual$2.makeSurePersistentPathExists(x$7, x$8);
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        LeaderAndIsr newLeaderAndIsr1 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch(), replicas, 0);
        Tuple2 tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), "my-topic-test", this.partitionId(), newLeaderAndIsr1, this.controllerEpoch(), 0);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean updateSucceeded1 = tuple2._1$mcZ$sp();
        int newZkVersion1 = tuple2._2$mcI$sp();
        Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded1, newZkVersion1);
        Tuple2.mcZI.sp sp3 = sp2;
        boolean updateSucceeded12 = sp3._1$mcZ$sp();
        int newZkVersion12 = sp3._2$mcI$sp();
        Assert.assertTrue((boolean)updateSucceeded12);
        Assert.assertEquals((long)newZkVersion12, (long)1L);
        LeaderAndIsr newLeaderAndIsr2 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch(), replicas, this.zkVersion() + 1);
        Tuple2 tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), "my-topic-test", this.partitionId(), newLeaderAndIsr2, this.controllerEpoch(), this.zkVersion() + 1);
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean updateSucceeded2 = tuple22._1$mcZ$sp();
        int newZkVersion2 = tuple22._2$mcI$sp();
        Tuple2.mcZI.sp sp4 = new Tuple2.mcZI.sp(updateSucceeded2, newZkVersion2);
        Tuple2.mcZI.sp sp5 = sp4;
        boolean updateSucceeded22 = sp5._1$mcZ$sp();
        int newZkVersion22 = sp5._2$mcI$sp();
        Assert.assertTrue((boolean)updateSucceeded22);
        Assert.assertEquals((long)newZkVersion22, (long)1L);
        LeaderAndIsr newLeaderAndIsr3 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch() + 1, replicas, this.zkVersion() + 1);
        Tuple2 tuple23 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), "my-topic-test", this.partitionId(), newLeaderAndIsr3, this.controllerEpoch(), this.zkVersion() + 1);
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        boolean updateSucceeded3 = tuple23._1$mcZ$sp();
        int newZkVersion3 = tuple23._2$mcI$sp();
        Tuple2.mcZI.sp sp6 = new Tuple2.mcZI.sp(updateSucceeded3, newZkVersion3);
        Tuple2.mcZI.sp sp7 = sp6;
        boolean updateSucceeded32 = sp7._1$mcZ$sp();
        int newZkVersion32 = sp7._2$mcI$sp();
        Assert.assertFalse((boolean)updateSucceeded32);
        Assert.assertEquals((long)newZkVersion32, (long)-1L);
    }

    @Test
    public void testGetLeaderIsrAndEpochForPartition() {
        Option leaderIsrAndControllerEpoch = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), this.topic(), this.partitionId());
        Assert.assertEquals((Object)this.topicDataLeaderIsrAndControllerEpoch(), (Object)leaderIsrAndControllerEpoch.get());
        Assert.assertEquals((Object)None$.MODULE$, (Object)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), this.topic(), this.partitionId() + 1));
    }

    public ReplicationUtilsTest() {
        this.topic = "my-topic-test";
        this.partitionId = 0;
        this.brokerId = 1;
        this.leaderEpoch = 1;
        this.controllerEpoch = 1;
        this.zkVersion = 1;
        this.topicPath = "/brokers/topics/my-topic-test/partitions/0/state";
    }
}

