/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.api.ProducerRequest;
import kafka.api.Request$;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.producer.DefaultPartitioner;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Resource;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.StringEncoder;
import kafka.server.BrokerState;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.FixedValuePartitioner;
import kafka.utils.IntEncoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.ACL;
import org.junit.Assert;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class TestUtils$
implements Logging {
    public static TestUtils$ MODULE$;
    private final Random random;
    private final int RandomPort;
    private final int MockZkPort;
    private final String MockZkConnect;
    private final String kafka$utils$TestUtils$$transactionStatusKey;
    private final byte[] kafka$utils$TestUtils$$committedValue;
    private final byte[] kafka$utils$TestUtils$$abortedValue;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.trace$((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.debug$((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.info$((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.warn$((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.error$((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Random random() {
        return this.random;
    }

    public int RandomPort() {
        return this.RandomPort;
    }

    public int MockZkPort() {
        return this.MockZkPort;
    }

    public String MockZkConnect() {
        return this.MockZkConnect;
    }

    public String kafka$utils$TestUtils$$transactionStatusKey() {
        return this.kafka$utils$TestUtils$$transactionStatusKey;
    }

    public byte[] kafka$utils$TestUtils$$committedValue() {
        return this.kafka$utils$TestUtils$$committedValue;
    }

    public byte[] kafka$utils$TestUtils$$abortedValue() {
        return this.kafka$utils$TestUtils$$abortedValue;
    }

    public File tempDir() {
        return TestUtils.tempDirectory();
    }

    public String tempTopic() {
        return "testTopic" + this.random().nextInt(1000000);
    }

    public File tempRelativeDir(String parent) {
        File parentFile = new File(parent);
        parentFile.mkdirs();
        return TestUtils.tempDirectory((Path)parentFile.toPath(), null);
    }

    /*
     * WARNING - void declaration
     */
    public File randomPartitionLogDir(File parentDir) {
        void var3_3;
        int attempts = 1000;
        File f = (File)scala.package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> new File(parentDir, "kafka-" + this.random().nextInt(1000000))).take(attempts).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.mkdir())).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory after ", " attempts"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)attempts)}))));
        f.deleteOnExit();
        return var3_3;
    }

    public File tempFile() {
        return TestUtils.tempFile();
    }

    public FileChannel tempChannel() {
        return new RandomAccessFile(this.tempFile(), "rw").getChannel();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(KafkaConfig config, Time time) {
        void var3_3;
        KafkaServer server = new KafkaServer(config, time, KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        return var3_3;
    }

    public Time createServer$default$2() {
        return Time.SYSTEM;
    }

    public int boundPort(KafkaServer server, SecurityProtocol securityProtocol) {
        return server.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
    }

    public SecurityProtocol boundPort$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Broker createBroker(int id, String host, int port, SecurityProtocol securityProtocol) {
        return new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    public SecurityProtocol createBroker$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Properties> createBrokerConfigs(int numConfigs, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numConfigs).map((Function1 & Serializable & scala.Serializable)node -> TestUtils$.$anonfun$createBrokerConfigs$1(this, zkConnect, enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo, BoxesRunTime.unboxToInt((Object)node)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String getBrokerListStrFromServers(Seq<KafkaServer> servers, SecurityProtocol protocol) {
        return ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)s -> {
            EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$getBrokerListStrFromServers$2(protocol, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find listener with security protocol ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol}))));
            return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(this.boundPort((KafkaServer)s, protocol)));
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public SecurityProtocol getBrokerListStrFromServers$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public String bootstrapServers(Seq<KafkaServer> servers, ListenerName listenerName) {
        return ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)s -> {
            EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$bootstrapServers$2(listenerName, x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find listener with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName.value()}))));
            return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(listenerName)));
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public void shutdownServers(Seq<KafkaServer> servers) {
        ((ParIterableLike)servers.par()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.$anonfun$shutdownServers$1(s);
            return BoxedUnit.UNIT;
        });
    }

    public Properties createBrokerConfig(int nodeId, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack) {
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = enablePlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port))) : BoxedUnit.UNIT;
        Object object2 = enableSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort))) : BoxedUnit.UNIT;
        Object object3 = enableSaslPlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort))) : BoxedUnit.UNIT;
        Object object4 = enableSaslSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort))) : BoxedUnit.UNIT;
        String listeners = ((TraversableOnce)protocolAndPorts.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
            int port = tuple2._2$mcI$sp();
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol.name, BoxesRunTime.boxToInteger((int)port)}));
            return string;
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
        Properties props = new Properties();
        Object object5 = nodeId >= 0 ? props.put(KafkaConfig$.MODULE$.BrokerIdProp(), ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString()) : BoxedUnit.UNIT;
        props.put(KafkaConfig$.MODULE$.ListenersProp(), listeners);
        props.put(KafkaConfig$.MODULE$.LogDirProp(), this.tempDir().getAbsolutePath());
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), zkConnect);
        props.put(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "10000");
        props.put(KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableControlledShutdown)).toString());
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableDeleteTopic)).toString());
        props.put(KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), "1000");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "100");
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "2097152");
        props.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        Object object6 = !props.containsKey(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp()) ? props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "5") : BoxedUnit.UNIT;
        Object object7 = !props.containsKey(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp()) ? props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0") : BoxedUnit.UNIT;
        rack.foreach((Function1 & Serializable & scala.Serializable)x$5 -> props.put(KafkaConfig$.MODULE$.RackProp(), x$5));
        if (protocolAndPorts.exists((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$5(this, x0$3)))) {
            props.putAll((java.util.Map<?, ?>)this.sslConfigs(Mode.SERVER, false, trustStoreFile, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"server", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nodeId)}))));
        }
        if (protocolAndPorts.exists((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$6(this, x0$4)))) {
            props.putAll((java.util.Map<?, ?>)JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        interBrokerSecurityProtocol.foreach((Function1 & Serializable & scala.Serializable)protocol -> props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), protocol.name));
        return props;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$4() {
        return false;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$8() {
        return true;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public boolean createBrokerConfigs$default$11() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$12() {
        return (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfig$default$4() {
        return false;
    }

    public int createBrokerConfig$default$5() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$8() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$9() {
        return true;
    }

    public boolean createBrokerConfig$default$10() {
        return false;
    }

    public int createBrokerConfig$default$11() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$12() {
        return false;
    }

    public int createBrokerConfig$default$13() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$14() {
        return false;
    }

    public int createBrokerConfig$default$15() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$16() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(ZkUtils zkUtils, String topic, int numPartitions, int replicationFactor, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminUtils$.MODULE$.createTopic(zkUtils, topic, numPartitions, replicationFactor, topicConfig, AdminUtils$.MODULE$.createTopic$default$6());
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.$anonfun$createTopic$1(zkUtils, topic, servers, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers) {
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, partitionReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        return ((TraversableOnce)partitionReplicaAssignment.keySet().map((Function1 & Serializable & scala.Serializable)x0$5 -> TestUtils$.$anonfun$createTopic$2(zkUtils, topic, servers, BoxesRunTime.unboxToInt((Object)x0$5)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public void createOffsetsTopic(ZkUtils zkUtils, Seq<KafkaServer> servers) {
        KafkaServer server = (KafkaServer)servers.head();
        this.createTopic(zkUtils, "__consumer_offsets", Predef$.MODULE$.Integer2int(server.config().getInt(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp())), Predef$.MODULE$.Short2short(server.config().getShort(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp())), servers, server.groupCoordinator().offsetsTopicConfigs());
    }

    public Properties createConsumerProperties(String zkConnect, String groupId, String consumerId, long consumerTimeout) {
        Properties props = new Properties();
        props.put("zookeeper.connect", zkConnect);
        props.put("group.id", groupId);
        props.put("consumer.id", consumerId);
        props.put("consumer.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)consumerTimeout)).toString());
        props.put("zookeeper.session.timeout.ms", "6000");
        props.put("zookeeper.sync.time.ms", "200");
        props.put("auto.commit.interval.ms", "1000");
        props.put("rebalance.max.retries", "4");
        props.put("auto.offset.reset", "smallest");
        props.put("num.consumer.fetchers", "2");
        return props;
    }

    public long createConsumerProperties$default$4() {
        return -1L;
    }

    public Nothing$ fail(String msg) {
        throw new AssertionError((Object)msg);
    }

    public MemoryRecords singletonRecords(byte[] value, byte[] key, CompressionType codec, long timestamp, byte magicValue) {
        return this.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(timestamp, key, value)}))), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7());
    }

    public byte[] singletonRecords$default$2() {
        return null;
    }

    public CompressionType singletonRecords$default$3() {
        return CompressionType.NONE;
    }

    public long singletonRecords$default$4() {
        return -1L;
    }

    public byte singletonRecords$default$5() {
        return 2;
    }

    public MemoryRecords recordsWithValues(byte magicValue, CompressionType codec, Seq<byte[]> values) {
        return this.records((Iterable<SimpleRecord>)((Iterable)values.map((Function1 & Serializable & scala.Serializable)value -> new SimpleRecord(value), Seq$.MODULE$.canBuildFrom())), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7());
    }

    public MemoryRecords records(Iterable<SimpleRecord> records, byte magicValue, CompressionType codec, long producerId, short producerEpoch, int sequence, long baseOffset) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)System.currentTimeMillis(), (long)producerId, (short)producerEpoch, (int)sequence);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public byte records$default$2() {
        return 2;
    }

    public CompressionType records$default$3() {
        return CompressionType.NONE;
    }

    public long records$default$4() {
        return -1L;
    }

    public short records$default$5() {
        return -1;
    }

    public int records$default$6() {
        return -1;
    }

    public long records$default$7() {
        return 0L;
    }

    public byte[] randomBytes(int numBytes) {
        return TestUtils.randomBytes((int)numBytes);
    }

    public String randomString(int len) {
        return TestUtils.randomString((int)len);
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assert.assertEquals((String)"Buffers should have equal length", (long)(b1.limit() - b1.position()), (long)(b2.limit() - b2.position()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((String)("byte " + i + " byte not equal."), (long)b1.get(b1.position() + i), (long)b2.get(b1.position() + i)));
    }

    public <T> void checkEquals(Iterator<T> expected, Iterator<T> actual) {
        block4: {
            int length = 0;
            while (expected.hasNext() && actual.hasNext()) {
                ++length;
                Assert.assertEquals((Object)expected.next(), (Object)actual.next());
            }
            if (expected.hasNext()) {
                int length1 = length;
                while (expected.hasNext()) {
                    expected.next();
                    ++length1;
                }
                Assert.assertFalse((String)("Iterators have uneven length-- first has more: " + length1 + " > " + length), (boolean)true);
            }
            if (!actual.hasNext()) break block4;
            int length2 = length;
            while (actual.hasNext()) {
                actual.next();
                ++length2;
            }
            Assert.assertFalse((String)("Iterators have uneven length-- second has more: " + length2 + " > " + length), (boolean)true);
        }
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assert.assertEquals((long)expectedLength, (long)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assert.assertEquals(s1.next(), s2.next());
        }
        Assert.assertFalse((String)"Iterators have uneven length--first has more", (boolean)s1.hasNext());
        Assert.assertFalse((String)"Iterators have uneven length--second has more", (boolean)s2.hasNext());
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public Iterator<T> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<T> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.min$((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.max$((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.maxBy$((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.minBy$((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$1.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1 & Serializable & scala.Serializable)i -> builder.append(String.format("%x", buffer.get(buffer.position() + BoxesRunTime.unboxToInt((Object)i)))));
        return builder.toString();
    }

    public <K, V> Producer<K, V> createProducer(String brokerList, String encoder, String keyEncoder, String partitioner, Properties producerProps) {
        Properties props = this.getProducerConfig(brokerList);
        if (producerProps != null) {
            props.putAll((java.util.Map<?, ?>)producerProps);
        }
        props.put("serializer.class", encoder);
        props.put("key.serializer.class", keyEncoder);
        props.put("partitioner.class", partitioner);
        return new Producer(new ProducerConfig(props));
    }

    public <K, V> String createProducer$default$2() {
        return DefaultEncoder.class.getName();
    }

    public <K, V> String createProducer$default$3() {
        return DefaultEncoder.class.getName();
    }

    public <K, V> String createProducer$default$4() {
        return DefaultPartitioner.class.getName();
    }

    public <K, V> Properties createProducer$default$5() {
        return null;
    }

    private Properties securityConfigs(Mode mode, SecurityProtocol securityProtocol, Option<File> trustStoreFile, String certAlias, Option<Properties> saslProperties) {
        Properties props = new Properties();
        if (this.usesSslTransportLayer(securityProtocol)) {
            SecurityProtocol securityProtocol2 = securityProtocol;
            SecurityProtocol securityProtocol3 = SecurityProtocol.SSL;
            props.putAll((java.util.Map<?, ?>)this.sslConfigs(mode, !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null), trustStoreFile, certAlias));
        }
        if (this.usesSaslAuthentication(securityProtocol)) {
            props.putAll((java.util.Map<?, ?>)JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name);
        return props;
    }

    public Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "producer", saslProperties);
    }

    public <K, V> KafkaProducer<K, V> createNewProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, long lingerMs, long requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer, Option<Properties> props) {
        Properties producerProps = (Properties)props.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Properties());
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", ((Object)BoxesRunTime.boxToInteger((int)acks)).toString());
        producerProps.put("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)maxBlockMs)).toString());
        producerProps.put("buffer.memory", ((Object)BoxesRunTime.boxToLong((long)bufferSize)).toString());
        producerProps.put("retries", ((Object)BoxesRunTime.boxToInteger((int)retries)).toString());
        producerProps.put("request.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)requestTimeoutMs)).toString());
        Map defaultProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"retry.backoff.ms"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reconnect.backoff.ms"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"linger.ms"), (Object)((Object)BoxesRunTime.boxToLong((long)lingerMs)).toString())}));
        defaultProps.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            BoxedUnit boxedUnit = !producerProps.containsKey(key) ? producerProps.put(key, value) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        if (!producerProps.containsKey("security.protocol")) {
            producerProps.putAll((java.util.Map<?, ?>)this.producerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        }
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createNewProducer$default$2() {
        return -1;
    }

    public <K, V> long createNewProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createNewProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createNewProducer$default$5() {
        return 0;
    }

    public <K, V> long createNewProducer$default$6() {
        return 0L;
    }

    public <K, V> long createNewProducer$default$7() {
        return 10240L;
    }

    public <K, V> SecurityProtocol createNewProducer$default$8() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createNewProducer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createNewProducer$default$10() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createNewProducer$default$11() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createNewProducer$default$12() {
        return new ByteArraySerializer();
    }

    public <K, V> Option<Properties> createNewProducer$default$13() {
        return None$.MODULE$;
    }

    public boolean usesSslTransportLayer(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SSL.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean usesSaslAuthentication(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "consumer", saslProperties);
    }

    public Properties adminClientSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "admin-client", saslProperties);
    }

    public KafkaConsumer<byte[], byte[]> createNewConsumer(String brokerList, String groupId, String autoOffsetReset, long partitionFetchSize, String partitionAssignmentStrategy, int sessionTimeout, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Option<Properties> props) {
        Properties consumerProps = (Properties)props.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Properties());
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToLong((long)partitionFetchSize)).toString());
        Map defaultProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"retry.backoff.ms"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reconnect.backoff.ms"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), (Object)"org.apache.kafka.common.serialization.ByteArrayDeserializer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value.deserializer"), (Object)"org.apache.kafka.common.serialization.ByteArrayDeserializer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition.assignment.strategy"), (Object)partitionAssignmentStrategy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"session.timeout.ms"), (Object)((Object)BoxesRunTime.boxToInteger((int)sessionTimeout)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)groupId)}));
        defaultProps.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            BoxedUnit boxedUnit = !consumerProps.containsKey(key) ? consumerProps.put(key, value) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        if (!consumerProps.containsKey("security.protocol")) {
            consumerProps.putAll((java.util.Map<?, ?>)this.consumerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        }
        return new KafkaConsumer(consumerProps);
    }

    public String createNewConsumer$default$2() {
        return "group";
    }

    public String createNewConsumer$default$3() {
        return "earliest";
    }

    public long createNewConsumer$default$4() {
        return 4096L;
    }

    public String createNewConsumer$default$5() {
        return RangeAssignor.class.getName();
    }

    public int createNewConsumer$default$6() {
        return 30000;
    }

    public Option<File> createNewConsumer$default$8() {
        return None$.MODULE$;
    }

    public Option<Properties> createNewConsumer$default$9() {
        return None$.MODULE$;
    }

    public Option<Properties> createNewConsumer$default$10() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getProducerConfig(String brokerList) {
        void var2_2;
        Properties props = new Properties();
        props.put("metadata.broker.list", brokerList);
        props.put("message.send.max.retries", "5");
        props.put("retry.backoff.ms", "1000");
        props.put("request.timeout.ms", "2000");
        props.put("request.required.acks", "-1");
        props.put("send.buffer.bytes", "65536");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getSyncProducerConfig(int port) {
        void var2_2;
        Properties props = new Properties();
        props.put("host", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        props.put("request.timeout.ms", "10000");
        props.put("request.required.acks", "1");
        props.put("serializer.class", StringEncoder.class.getName());
        return var2_2;
    }

    public void updateConsumerOffset(ConsumerConfig config, String path, long offset) {
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        zkUtils.updatePersistentPath(path, ((Object)BoxesRunTime.boxToLong((long)offset)).toString(), zkUtils.updatePersistentPath$default$3());
        zkUtils.close();
    }

    public Iterator<Message> getMessageIterator(Iterator<MessageAndOffset> iter) {
        return new IteratorTemplate<Message>(iter){
            private final Iterator iter$1;

            public Message makeNext() {
                return this.iter$1.hasNext() ? ((MessageAndOffset)this.iter$1.next()).message() : (Message)this.allDone();
            }
            {
                this.iter$1 = iter$1;
            }
        };
    }

    public Seq<Broker> createBrokersInZk(ZkUtils zkUtils, Seq<Object> ids) {
        return this.createBrokersInZk((Seq<BrokerMetadata>)((Seq)ids.map((Function1 & Serializable & scala.Serializable)x$6 -> TestUtils$.$anonfun$createBrokersInZk$1(BoxesRunTime.unboxToInt((Object)x$6)), Seq$.MODULE$.canBuildFrom())), zkUtils);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> createBrokersInZk(Seq<BrokerMetadata> brokerMetadatas, ZkUtils zkUtils) {
        void var3_3;
        Seq brokers = (Seq)brokerMetadatas.map((Function1 & Serializable & scala.Serializable)b -> {
            SecurityProtocol protocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)protocol);
            return new Broker(b.id(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 6667, listenerName, protocol)})), b.rack());
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1 & Serializable & scala.Serializable)b -> {
            zkUtils.registerBrokerInZk(b.id(), "localhost", 6667, b.endPoints(), -1, b.rack(), ApiVersion$.MODULE$.latestVersion());
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> deleteBrokersInZk(ZkUtils zkUtils, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1 & Serializable & scala.Serializable)x$7 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$7), "localhost", 6667, SecurityProtocol.PLAINTEXT), Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)zkUtils.deletePath(ZkUtils$.MODULE$.BrokerIdsPath() + "/" + b)));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1 & Serializable & scala.Serializable)i -> buffer.$plus$eq((Object)("msg" + BoxesRunTime.unboxToInt((Object)i))));
        return var2_2;
    }

    public ProducerRequest produceRequest(String topic, int partition, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        return this.produceRequestWithAcks((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition}))), message, acks, timeout, correlationId, clientId);
    }

    public int produceRequest$default$6() {
        return 0;
    }

    public ProducerRequest produceRequestWithAcks(Seq<String> topics, Seq<Object> partitions, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        Seq data = (Seq)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> TestUtils$.$anonfun$produceRequestWithAcks$2(message, topic, BoxesRunTime.unboxToInt((Object)partition)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return new ProducerRequest(correlationId, clientId, (short)acks, timeout, (scala.collection.mutable.Map)Map$.MODULE$.apply(data));
    }

    public int produceRequestWithAcks$default$6() {
        return 0;
    }

    public void makeLeaderForPartition(ZkUtils zkUtils, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        leaderPerPartitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            TestUtils$.$anonfun$makeLeaderForPartition$1(this, zkUtils, topic, controllerEpoch, x0$8);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    public int waitUntilLeaderIsElectedOrChanged(ZkUtils zkUtils, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(oldLeaderOpt.isDefined() == false || newLeaderOpt.isDefined() == false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$1(), ()Ljava/lang/String;)());
        startTime = System.currentTimeMillis();
        topicPartition = new TopicPartition(topic, partition);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$2(scala.Option scala.Option org.apache.kafka.common.TopicPartition ), ()Ljava/lang/String;)(oldLeaderOpt, newLeaderOpt, (TopicPartition)topicPartition));
        leader = ObjectRef.create((Object)None$.MODULE$);
        electedOrChangedLeader = None$.MODULE$;
        while (electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            block9: {
                block5: {
                    block7: {
                        block8: {
                            block6: {
                                leader.elem = zkUtils.getLeaderForPartition(topic, partition);
                                var15_13 = (Option)leader.elem;
                                if (!(var15_13 instanceof Some)) break block5;
                                var16_14 = (Some)var15_13;
                                l = BoxesRunTime.unboxToInt((Object)var16_14.value());
                                var18_16 = new Tuple2(newLeaderOpt, oldLeaderOpt);
                                if (var18_16 == null || !((var19_17 = (Option)var18_16._1()) instanceof Some) || (newLeader = BoxesRunTime.unboxToInt((Object)(var20_18 = (Some)var19_17).value())) != l) break block6;
                                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$3(org.apache.kafka.common.TopicPartition int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l));
                                electedOrChangedLeader = (Option)leader.elem;
                                var9_12 = BoxedUnit.UNIT;
                                break block7;
                            }
                            if (var18_16 == null || !((var22_20 = (Option)var18_16._2()) instanceof Some) || (oldLeader = BoxesRunTime.unboxToInt((Object)(var23_21 = (Some)var22_20).value())) == l) break block8;
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$4(org.apache.kafka.common.TopicPartition int int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l, (int)oldLeader));
                            electedOrChangedLeader = (Option)leader.elem;
                            var9_12 = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (var18_16 == null) ** GOTO lbl-1000
                        var25_23 = (Option)var18_16._1();
                        var26_24 = (Option)var18_16._2();
                        if (None$.MODULE$.equals(var25_23) && None$.MODULE$.equals(var26_24)) {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$5(org.apache.kafka.common.TopicPartition int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l));
                            electedOrChangedLeader = (Option)leader.elem;
                            var9_12 = BoxedUnit.UNIT;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$6(org.apache.kafka.common.TopicPartition int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l));
                            var9_12 = BoxedUnit.UNIT;
                        }
                    }
                    var8_11 = BoxedUnit.UNIT;
                    break block9;
                }
                if (None$.MODULE$.equals(var15_13)) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$7(org.apache.kafka.common.TopicPartition ), ()Ljava/lang/String;)((TopicPartition)topicPartition));
                    var8_11 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)var15_13);
                }
            }
            Thread.sleep(package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)electedOrChangedLeader.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$8(kafka.utils.TestUtils$ long scala.Option scala.Option org.apache.kafka.common.TopicPartition scala.runtime.ObjectRef ), ()Lscala/runtime/Nothing$;)((TestUtils$)this, (long)timeoutMs, oldLeaderOpt, newLeaderOpt, (TopicPartition)topicPartition, (ObjectRef)leader)));
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = LongRef.create((long)1L);
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                block.apply$mcV$sp();
                return;
            }
            catch (AssertionError e) {
                long ellapsed = System.currentTimeMillis() - startTime;
                if (ellapsed > maxWaitMs) {
                    throw e;
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempt failed, sleeping for " + wait$1.elem + ", and then retrying.");
                Thread.sleep(wait.elem);
                wait.elem += package$.MODULE$.min(wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public void waitUntilTrue(Function0<Object> condition, Function0<String> msg, long waitTime, long pause) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                throw this.fail((String)msg.apply());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return;
    }

    public long waitUntilTrue$default$3() {
        return 15000L;
    }

    public long waitUntilTrue$default$4() {
        return 100L;
    }

    public <T> Tuple2<T, Object> computeUntilTrue(Function0<T> compute, long waitTime, long pause, Function1<T, Object> predicate) {
        long startTime = System.currentTimeMillis();
        Object result;
        while (!BoxesRunTime.unboxToBoolean((Object)predicate.apply(result = compute.apply()))) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <T> long computeUntilTrue$default$2() {
        return 15000L;
    }

    public <T> long computeUntilTrue$default$3() {
        return 100L;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        return server.replicaManager().getPartition(new TopicPartition(topic, partitionId)).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$isLeaderLocalOnBroker$1(x$9)));
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer createRequestByteBuffer(RequestOrResponse request) {
        void var2_2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.sizeInBytes() + 2);
        byteBuffer.putShort(BoxesRunTime.unboxToShort((Object)request.requestId().get()));
        request.writeTo(byteBuffer);
        byteBuffer.rewind();
        return var2_2;
    }

    public void waitUntilBrokerMetadataIsPropagated(Seq<KafkaServer> servers, long timeout) {
        Set expectedBrokerIds = ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$1(x$10)), Seq$.MODULE$.canBuildFrom())).toSet();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$4(expectedBrokerIds, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting for broker metadata to propagate to all servers", timeout, this.waitUntilTrue$default$4());
    }

    public long waitUntilBrokerMetadataIsPropagated$default$2() {
        return 15000L;
    }

    public int waitUntilMetadataIsPropagated(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        IntRef leader = IntRef.create((int)-1);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilMetadataIsPropagated$3(topic, partition, leader, BoxesRunTime.unboxToBoolean((Object)result), server)))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)timeout)})), timeout, this.waitUntilTrue$default$4());
        return leader.elem;
    }

    public long waitUntilMetadataIsPropagated$default$4() {
        return 15000L;
    }

    public int waitUntilControllerElected(ZkUtils zkUtils, long timeout) {
        ObjectRef controllerIdTry = ObjectRef.create(null);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            controllerIdTry$1.elem = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> zkUtils.getController());
            return ((Try)controllerIdTry$1.elem).isSuccess();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller not elected after ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeout)})), timeout, this.waitUntilTrue$default$4());
        return BoxesRunTime.unboxToInt((Object)((Try)controllerIdTry.elem).get());
    }

    public long waitUntilControllerElected$default$2() {
        return 15000L;
    }

    public void waitUntilLeaderIsKnown(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        TopicPartition tp = new TopicPartition(topic, partition);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.exists((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$3(tp, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " leaders not made yet after ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToLong((long)timeout)})), timeout, this.waitUntilTrue$default$4());
    }

    public long waitUntilLeaderIsKnown$default$4() {
        return 15000L;
    }

    public void writeNonsenseToFile(File fileName, long position, int size) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> file.writeByte(this.random().nextInt(255)));
        file.close();
    }

    public void appendNonsenseToFile(File fileName, int size) {
        FileOutputStream file = new FileOutputStream(fileName, true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> file.write(this.random().nextInt(255)));
        file.close();
    }

    public void checkForPhantomInSyncReplicas(ZkUtils zkUtils, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas) {
        Seq inSyncReplicas = zkUtils.getInSyncReplicasForPartition(topic, partitionToBeReassigned);
        Set phantomInSyncReplicas = (Set)inSyncReplicas.toSet().$minus$minus((GenTraversableOnce)assignedReplicas.toSet());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})), (boolean)phantomInSyncReplicas.isEmpty());
    }

    public void ensureNoUnderReplicatedPartitions(ZkUtils zkUtils, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas, Seq<KafkaServer> servers) {
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Seq inSyncReplicas = zkUtils.getInSyncReplicasForPartition(topic, partitionToBeReassigned);
            return inSyncReplicas.size() == assignedReplicas.size();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under replicated")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        ObjectRef leader = ObjectRef.create((Object)None$.MODULE$);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            leader$4.elem = zkUtils.getLeaderForPartition(topic, partitionToBeReassigned);
            return ((Option)leader$4.elem).isDefined();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            KafkaServer leaderBroker = (KafkaServer)((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$ensureNoUnderReplicatedPartitions$7(leader, s)))).head();
            return leaderBroker.replicaManager().underReplicatedPartitionCount() == 0;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned), ((Option)leader$4.elem).get()})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public boolean checkIfReassignPartitionPathExists(ZkUtils zkUtils) {
        return zkUtils.pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
    }

    public void verifyNonDaemonThreadsStatus(String threadNamePrefix) {
        int threadCount = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyNonDaemonThreadsStatus$1(threadNamePrefix, t)));
        Assert.assertEquals((long)0L, (long)threadCount);
    }

    public LogManager createLogManager(File[] logDirs, LogConfig defaultConfig, CleanerConfig cleanerConfig, MockTime time) {
        File[] x$54 = logDirs;
        Map x$55 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        LogConfig x$56 = defaultConfig;
        CleanerConfig x$57 = cleanerConfig;
        int x$58 = 4;
        long x$59 = 1000L;
        long x$60 = 10000L;
        long x$61 = 10000L;
        long x$62 = 1000L;
        int x$63 = 3600000;
        MockScheduler x$64 = time.scheduler();
        MockTime x$65 = time;
        BrokerState x$66 = new BrokerState();
        BrokerTopicStats x$67 = new BrokerTopicStats();
        return new LogManager(x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, (Scheduler)x$64, x$66, x$67, (Time)x$65);
    }

    public File[] createLogManager$default$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public LogConfig createLogManager$default$2() {
        return LogConfig$.MODULE$.apply();
    }

    public CleanerConfig createLogManager$default$3() {
        boolean x$117 = false;
        int x$118 = CleanerConfig$.MODULE$.apply$default$1();
        long x$119 = CleanerConfig$.MODULE$.apply$default$2();
        double x$120 = CleanerConfig$.MODULE$.apply$default$3();
        int x$121 = CleanerConfig$.MODULE$.apply$default$4();
        int x$122 = CleanerConfig$.MODULE$.apply$default$5();
        double x$123 = CleanerConfig$.MODULE$.apply$default$6();
        long x$124 = CleanerConfig$.MODULE$.apply$default$7();
        String x$125 = CleanerConfig$.MODULE$.apply$default$9();
        return new CleanerConfig(x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$117, x$125);
    }

    public MockTime createLogManager$default$4() {
        return new MockTime();
    }

    public List<String> sendMessages(Seq<KafkaServer> servers, String topic, int numMessages, int partition, CompressionCodec compression) {
        List list;
        String header = new StringOps(Predef$.MODULE$.augmentString("test-%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition)}));
        Properties props = new Properties();
        props.put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)compression.codec())).toString());
        IndexedSeq ms = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x -> TestUtils$.$anonfun$sendMessages$1(header, BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        if (partition >= 0) {
            Producer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), IntEncoder.class.getName(), FixedValuePartitioner.class.getName(), props);
            producer.send((Seq)ms.map((Function1 & Serializable & scala.Serializable)m -> new KeyedMessage(topic, (Object)BoxesRunTime.boxToInteger((int)partition), m), IndexedSeq$.MODULE$.canBuildFrom()));
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sent %d messages for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ms.size()), topic, BoxesRunTime.boxToInteger((int)partition)})));
            producer.close();
            list = ms.toList();
        } else {
            Producer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), DefaultPartitioner.class.getName(), props);
            producer.send((Seq)ms.map((Function1 & Serializable & scala.Serializable)m -> new KeyedMessage(topic, (Object)topic, m), IndexedSeq$.MODULE$.canBuildFrom()));
            producer.close();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sent %d messages for topic [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ms.size()), topic})));
            list = ms.toList();
        }
        return list;
    }

    public int sendMessages$default$4() {
        return -1;
    }

    public CompressionCodec sendMessages$default$5() {
        return NoCompressionCodec$.MODULE$;
    }

    public Seq<byte[]> produceMessages(Seq<KafkaServer> servers, String topic, int numMessages, int acks, int valueBytes) {
        String x$68 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$69 = 5;
        long x$70 = 2000L;
        int x$71 = acks;
        long x$72 = this.createNewProducer$default$3();
        long x$73 = this.createNewProducer$default$4();
        long x$74 = this.createNewProducer$default$6();
        SecurityProtocol x$75 = this.createNewProducer$default$8();
        Option<File> x$76 = this.createNewProducer$default$9();
        Option<Properties> x$77 = this.createNewProducer$default$10();
        ByteArraySerializer x$78 = this.createNewProducer$default$11();
        ByteArraySerializer x$79 = this.createNewProducer$default$12();
        Option<Properties> x$80 = this.createNewProducer$default$13();
        KafkaProducer producer = this.createNewProducer(x$68, x$71, x$72, x$73, x$69, x$74, x$70, x$75, x$76, x$77, (Serializer)x$78, (Serializer)x$79, x$80);
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x -> TestUtils$.$anonfun$produceMessages$1(valueBytes, BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq futures = (IndexedSeq)values.map((Function1 & Serializable & scala.Serializable)value -> producer.send(new ProducerRecord(topic, value)), IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1 & Serializable & scala.Serializable)x$13 -> (RecordMetadata)x$13.get());
        producer.close();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sent ", " messages for topic [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)values.size()), topic})));
        return values;
    }

    public void produceMessage(Seq<KafkaServer> servers, String topic, String message) {
        String x$81 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$82 = 5;
        long x$83 = 2000L;
        int x$84 = this.createNewProducer$default$2();
        long x$85 = this.createNewProducer$default$3();
        long x$86 = this.createNewProducer$default$4();
        long x$87 = this.createNewProducer$default$6();
        SecurityProtocol x$88 = this.createNewProducer$default$8();
        Option<File> x$89 = this.createNewProducer$default$9();
        Option<Properties> x$90 = this.createNewProducer$default$10();
        ByteArraySerializer x$91 = this.createNewProducer$default$11();
        ByteArraySerializer x$92 = this.createNewProducer$default$12();
        Option<Properties> x$93 = this.createNewProducer$default$13();
        KafkaProducer producer = this.createNewProducer(x$81, x$84, x$85, x$86, x$82, x$87, x$83, x$88, x$89, x$90, (Serializer)x$91, (Serializer)x$92, x$93);
        producer.send(new ProducerRecord(topic, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        producer.close();
    }

    public int produceMessages$default$4() {
        return -1;
    }

    public int produceMessages$default$5() {
        return -1;
    }

    public List<String> getMessages(Map<String, List<KafkaStream<String, String>>> topicMessageStreams, int nMessagesPerThread) {
        ObjectRef messages = ObjectRef.create((Object)Nil$.MODULE$);
        boolean shouldGetAllMessages = nMessagesPerThread < 0;
        topicMessageStreams.values().foreach((Function1 & Serializable & scala.Serializable)messageStreams -> {
            messageStreams.foreach((Function1 & Serializable & scala.Serializable)messageStream -> {
                TestUtils$.$anonfun$getMessages$2($this, nMessagesPerThread$1, messages$1, shouldGetAllMessages$1, messageStream);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return ((List)messages.elem).reverse();
    }

    public int getMessages$default$2() {
        return -1;
    }

    public void verifyTopicDeletion(ZkUtils zkUtils, String topic, int numPartitions, Seq<KafkaServer> servers) {
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)x$14 -> TestUtils$.$anonfun$verifyTopicDeletion$1(topic, BoxesRunTime.unboxToInt((Object)x$14)), IndexedSeq$.MODULE$.canBuildFrom());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !zkUtils.isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even after a replica is restarted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !zkUtils.pathExists(ZkUtils$.MODULE$.getTopicPath(topic)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Topic path /brokers/topics/%s not deleted after /admin/delete_topic/%s path is deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, topic})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$9(server, tp))))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replica manager's should have deleted all of this topic's partitions", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$11(server, tp))))));
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$15(server, tp))))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cleaner offset for deleted partition should have been removed", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$20(topicPartitions, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to soft-delete the data to a delete directory", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$25(topicPartitions, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to hard-delete the delete directory", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties copyOf(Properties props) {
        void var2_2;
        Properties copy = new Properties();
        copy.putAll((java.util.Map<?, ?>)props);
        return var2_2;
    }

    public Properties sslConfigs(Mode mode, boolean clientCert, Option<File> trustStoreFile, String certAlias) {
        File trustStore = (File)trustStoreFile.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("SSL enabled but no trustStoreFile provided");
        });
        java.util.Map sslConfigs = TestSslUtils.createSslConfig((boolean)clientCert, (boolean)true, (Mode)mode, (File)trustStore, (String)certAlias);
        Properties sslProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sslConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            Object object = sslProps.put(k, v);
            return object;
        });
        return sslProps;
    }

    /*
     * WARNING - void declaration
     */
    public X509TrustManager trustAllCerts() {
        void var1_1;
        X509TrustManager trustManager = new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        return var1_1;
    }

    public void waitAndVerifyAcls(Set<Acl> expected, Authorizer authorizer, Resource resource) {
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set set = authorizer.getAcls(resource);
            Set set2 = expected;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected acls ", " but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, authorizer.getAcls(resource)})), 15000L, this.waitUntilTrue$default$4());
    }

    public boolean isAclSecure(ACL acl, boolean sensitive) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{acl})));
        int n = acl.getPerms();
        switch (n) {
            case 1: {
                if (!sensitive) {
                    String string = acl.getId().getScheme();
                    String string2 = "world";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string3 = "sasl";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isAclUnsecure(ACL acl) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{acl})));
        int n = acl.getPerms();
        switch (n) {
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "world";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    private Seq<String> secureZkPaths(ZkUtils zkUtils) {
        Seq topLevelPaths = (Seq)ZkUtils$.MODULE$.SecureZkRootPaths().$plus$plus((GenTraversableOnce)ZkUtils$.MODULE$.SensitiveZkRootPaths(), Seq$.MODULE$.canBuildFrom());
        return (Seq)topLevelPaths.flatMap((Function1 & Serializable & scala.Serializable)path -> TestUtils$.subPaths$1(path, zkUtils), Seq$.MODULE$.canBuildFrom());
    }

    public void verifySecureZkAcls(ZkUtils zkUtils, int usersWithAccess) {
        this.secureZkPaths(zkUtils).foreach((Function1 & Serializable & scala.Serializable)path -> {
            TestUtils$.$anonfun$verifySecureZkAcls$1(this, zkUtils, usersWithAccess, path);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyUnsecureZkAcls(ZkUtils zkUtils) {
        this.secureZkPaths(zkUtils).foreach((Function1 & Serializable & scala.Serializable)path -> {
            TestUtils$.$anonfun$verifyUnsecureZkAcls$1(this, zkUtils, path);
            return BoxedUnit.UNIT;
        });
    }

    public void assertConcurrent(String message, Seq<Function0<Object>> functions, int timeoutMs) {
        int numThreads = functions.size();
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            ArrayBuffer arrayBuffer;
            try {
                java.util.List runnables = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)functions.map((Function1 & Serializable & scala.Serializable)function -> new Callable<BoxedUnit>(function){
                    private final Function0 function$1;

                    public void call() {
                        this.function$1.apply();
                    }
                    {
                        this.function$1 = function$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava();
                Buffer futures = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(threadPool.invokeAll(runnables, timeoutMs, TimeUnit.MILLISECONDS)).asScala();
                futures.foreach((Function1 & Serializable & scala.Serializable)future -> {
                    Object object;
                    if (future.isCancelled()) {
                        this.failWithTimeout$1(message, timeoutMs);
                        object = BoxedUnit.UNIT;
                    } else {
                        try {
                            object = future.get();
                        }
                        catch (Exception e) {
                            object = exceptions.$plus$eq((Object)e);
                        }
                    }
                    return object;
                });
                arrayBuffer = BoxedUnit.UNIT;
            }
            catch (InterruptedException interruptedException) {
                this.failWithTimeout$1(message, timeoutMs);
                arrayBuffer = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                arrayBuffer = exceptions.$plus$eq((Object)e);
            }
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed with exception(s) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, exceptions})), (boolean)exceptions.isEmpty());
    }

    public <K, V> Seq<ConsumerRecord<byte[], byte[]>> consumeTopicRecords(Seq<KafkaServer> servers, String topic, int numMessages, long waitTime) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        String x$94 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$95 = SecurityProtocol.PLAINTEXT;
        String x$96 = this.createNewConsumer$default$2();
        String x$97 = this.createNewConsumer$default$3();
        long x$98 = this.createNewConsumer$default$4();
        String x$99 = this.createNewConsumer$default$5();
        int x$100 = this.createNewConsumer$default$6();
        Option<File> x$101 = this.createNewConsumer$default$8();
        Option<Properties> x$102 = this.createNewConsumer$default$9();
        Option<Properties> x$103 = this.createNewConsumer$default$10();
        try (KafkaConsumer<byte[], byte[]> consumer = this.createNewConsumer(x$94, x$96, x$97, x$98, x$99, x$100, x$95, x$101, x$102, x$103);){
            consumer.subscribe(Collections.singleton(topic));
            seq = this.consumeRecords(consumer, numMessages, waitTime);
        }
        return seq;
    }

    public <K, V> long consumeTopicRecords$default$4() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRecords(KafkaConsumer<K, V> consumer, int numMessages, long waitTime) {
        ArrayBuffer records = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(50L)).asScala());
            return records.size() >= numMessages;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout instead of the expected ", " records"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.size()), BoxesRunTime.boxToInteger((int)numMessages)})), waitTime, this.waitUntilTrue$default$4());
        Assert.assertEquals((String)"Consumed more records than expected", (long)numMessages, (long)records.size());
        return records;
    }

    public <K, V> long consumeRecords$default$3() {
        return 15000L;
    }

    public KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("transactional.id", transactionalId);
        props.put("max.in.flight.requests.per.connection", "1");
        props.put("enable.idempotence", "true");
        String x$16 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$17 = Integer.MAX_VALUE;
        int x$18 = -1;
        Some x$19 = new Some((Object)props);
        long x$20 = this.createNewProducer$default$3();
        long x$21 = this.createNewProducer$default$4();
        long x$22 = this.createNewProducer$default$6();
        long x$23 = this.createNewProducer$default$7();
        SecurityProtocol x$24 = this.createNewProducer$default$8();
        Option<File> x$25 = this.createNewProducer$default$9();
        Option<Properties> x$26 = this.createNewProducer$default$10();
        ByteArraySerializer x$27 = this.createNewProducer$default$11();
        ByteArraySerializer x$28 = this.createNewProducer$default$12();
        return this.createNewProducer(x$16, x$18, x$20, x$21, x$17, x$22, x$23, x$24, x$25, x$26, (Serializer)x$27, (Serializer)x$28, (Option<Properties>)x$19);
    }

    public void seedTopicWithNumberedRecords(String topic, int numRecords, Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        String x$104 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$105 = Integer.MAX_VALUE;
        int x$106 = -1;
        Some x$107 = new Some((Object)props);
        long x$108 = this.createNewProducer$default$3();
        long x$109 = this.createNewProducer$default$4();
        long x$110 = this.createNewProducer$default$6();
        long x$111 = this.createNewProducer$default$7();
        SecurityProtocol x$112 = this.createNewProducer$default$8();
        Option<File> x$113 = this.createNewProducer$default$9();
        Option<Properties> x$114 = this.createNewProducer$default$10();
        ByteArraySerializer x$115 = this.createNewProducer$default$11();
        ByteArraySerializer x$116 = this.createNewProducer$default$12();
        try (KafkaProducer producer = this.createNewProducer(x$104, x$106, x$108, x$109, x$105, x$110, x$111, x$112, x$113, x$114, (Serializer)x$115, (Serializer)x$116, (Option<Properties>)x$107);){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, (Object)this.asBytes(((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString()), (Object)this.asBytes(((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString()))));
            producer.flush();
        }
    }

    private String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private byte[] asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String assertCommittedAndGetValue(ConsumerRecord<byte[], byte[]> record) {
        Option option = JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable(record.headers().headers(this.kafka$utils$TestUtils$$transactionStatusKey())).headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw this.fail("expected the record header to include an expected transaction status, but received nothing.");
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Header header = (Header)some.value();
        Assert.assertEquals((String)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " but expected the value to indicate "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.asString(header.value())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed status."})).s((Seq)Nil$.MODULE$)), (Object)this.asString(this.kafka$utils$TestUtils$$committedValue()), (Object)this.asString(header.value()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.recordValueAsString(record);
    }

    public String recordValueAsString(ConsumerRecord<byte[], byte[]> record) {
        return this.asString((byte[])record.value());
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, byte[] key, byte[] value, boolean willBeCommitted) {
        Header header = new Header(willBeCommitted){
            private final boolean willBeCommitted$1;

            public String key() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$transactionStatusKey();
            }

            public byte[] value() {
                return this.willBeCommitted$1 ? TestUtils$.MODULE$.kafka$utils$TestUtils$$committedValue() : TestUtils$.MODULE$.kafka$utils$TestUtils$$abortedValue();
            }
            {
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        };
        return new ProducerRecord(topic, null, (Object)key, (Object)value, (java.lang.Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{header}))));
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, String key, String value, boolean willBeCommitted) {
        return this.producerRecordWithExpectedTransactionStatus(topic, this.asBytes(key), this.asBytes(value), willBeCommitted);
    }

    public Map<TopicPartition, OffsetAndMetadata> consumerPositions(KafkaConsumer<byte[], byte[]> consumer) {
        HashMap offsetsToCommit = new HashMap();
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(consumer.assignment()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> offsetsToCommit.put(topicPartition, (Object)new OffsetAndMetadata(consumer.position(topicPartition))));
        return offsetsToCommit.toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<ConsumerRecord<byte[], byte[]>> pollUntilAtLeastNumRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords) {
        void var3_3;
        ArrayBuffer records = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((java.lang.Iterable)consumer.poll(50L)));
            return records.size() >= numRecords;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout, but expected ", " records."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.size()), BoxesRunTime.boxToInteger((int)numRecords)})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        return var3_3;
    }

    public void resetToCommittedPositions(KafkaConsumer<byte[], byte[]> consumer) {
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(consumer.assignment()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestUtils$.$anonfun$resetToCommittedPositions$1(consumer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public String grabConsoleOutput(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return out.toString();
    }

    public static final /* synthetic */ Properties $anonfun$createBrokerConfigs$1(TestUtils$ $this, String zkConnect$1, boolean enableControlledShutdown$1, boolean enableDeleteTopic$1, Option interBrokerSecurityProtocol$1, Option trustStoreFile$1, Option saslProperties$1, boolean enablePlaintext$1, boolean enableSsl$1, boolean enableSaslPlaintext$1, boolean enableSaslSsl$1, Map rackInfo$1, int node) {
        int x$29 = node;
        String x$30 = zkConnect$1;
        boolean x$31 = enableControlledShutdown$1;
        boolean x$32 = enableDeleteTopic$1;
        int x$33 = $this.RandomPort();
        Option x$34 = interBrokerSecurityProtocol$1;
        Option x$35 = trustStoreFile$1;
        Option x$36 = saslProperties$1;
        boolean x$37 = enablePlaintext$1;
        boolean x$38 = enableSsl$1;
        boolean x$39 = enableSaslPlaintext$1;
        boolean x$40 = enableSaslSsl$1;
        Option x$41 = rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
        int x$42 = $this.createBrokerConfig$default$11();
        int x$43 = $this.createBrokerConfig$default$13();
        int x$44 = $this.createBrokerConfig$default$15();
        return $this.createBrokerConfig(x$29, x$30, x$31, x$32, x$33, (Option<SecurityProtocol>)x$34, (Option<File>)x$35, (Option<Properties>)x$36, x$37, x$39, x$42, x$38, x$43, x$40, x$44, (Option<String>)x$41);
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerListStrFromServers$2(SecurityProtocol protocol$1, EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = protocol$1;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$bootstrapServers$2(ListenerName listenerName$1, EndPoint x$3) {
        ListenerName listenerName = x$3.listenerName();
        ListenerName listenerName2 = listenerName$1;
        return !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
    }

    public static final /* synthetic */ void $anonfun$shutdownServers$1(KafkaServer s) {
        s.shutdown();
        CoreUtils$.MODULE$.delete(s.config().logDirs());
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$2(SecurityProtocol protocol$2, SecurityProtocol x$4) {
        SecurityProtocol securityProtocol = x$4;
        SecurityProtocol securityProtocol2 = protocol$2;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    private static final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$2(protocol, x$4))));
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$5(TestUtils$ $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
        boolean bl = $this.usesSslTransportLayer(protocol);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$6(TestUtils$ $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
        boolean bl = $this.usesSaslAuthentication(protocol);
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$createTopic$1(ZkUtils zkUtils$3, String topic$2, Seq servers$3, int i) {
        MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)servers$3, topic$2, i, MODULE$.waitUntilMetadataIsPropagated$default$4());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)MODULE$.waitUntilLeaderIsElectedOrChanged(zkUtils$3, topic$2, i, MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
    }

    public static final /* synthetic */ Tuple2 $anonfun$createTopic$2(ZkUtils zkUtils$2, String topic$1, Seq servers$2, int x0$5) {
        int n = x0$5;
        MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)servers$2, topic$1, n, MODULE$.waitUntilMetadataIsPropagated$default$4());
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)BoxesRunTime.boxToInteger((int)MODULE$.waitUntilLeaderIsElectedOrChanged(zkUtils$2, topic$1, n, MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
        return tuple2;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$createBrokersInZk$1(int x$6) {
        return new BrokerMetadata(x$6, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ Tuple2 $anonfun$produceRequestWithAcks$2(ByteBufferMessageSet message$1, String topic$10, int partition) {
        return new Tuple2((Object)new TopicAndPartition(topic$10, partition), (Object)message$1);
    }

    public static final /* synthetic */ void $anonfun$makeLeaderForPartition$1(TestUtils$ $this, ZkUtils zkUtils$7, String topic$6, int controllerEpoch$1, Tuple2 x0$8) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            int partition = tuple2._1$mcI$sp();
            int leader = tuple2._2$mcI$sp();
            try {
                LeaderAndIsr newLeaderAndIsr = (LeaderAndIsr)zkUtils$7.getLeaderAndIsrForPartition(topic$6, partition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.newLeader(leader)).getOrElse((Function0 & Serializable & scala.Serializable)() -> LeaderAndIsr$.MODULE$.apply(leader, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))));
                zkUtils$7.updatePersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic$6, partition), zkUtils$7.leaderAndIsrZkData(newLeaderAndIsr, controllerEpoch$1), zkUtils$7.updatePersistentPath$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable oe) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while electing leader for partition [", ",", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$6, BoxesRunTime.boxToInteger((int)partition)})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> oe);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$1() {
        return "Can't define both the old and the new leader";
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$2(Option oldLeaderOpt$1, Option newLeaderOpt$1, TopicPartition topicPartition$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for leader to be elected or changed for partition ", ", old leader is ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition$1, oldLeaderOpt$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newLeaderOpt$1}));
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$3(TopicPartition topicPartition$1, int l$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected new leader ", " is elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)l$1), topicPartition$1}));
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$4(TopicPartition topicPartition$1, int l$1, int oldLeader$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader for partition ", " is changed from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition$1, BoxesRunTime.boxToInteger((int)oldLeader$1), BoxesRunTime.boxToInteger((int)l$1)}));
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$5(TopicPartition topicPartition$1, int l$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader ", " is elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)l$1), topicPartition$1}));
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$6(TopicPartition topicPartition$1, int l$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current leader for partition ", " is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition$1, BoxesRunTime.boxToInteger((int)l$1)}));
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$7(TopicPartition topicPartition$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader for partition ", " is not elected yet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition$1}));
    }

    public static final /* synthetic */ Nothing$ $anonfun$waitUntilLeaderIsElectedOrChanged$8(TestUtils$ $this, long timeoutMs$1, Option oldLeaderOpt$1, Option newLeaderOpt$1, TopicPartition topicPartition$1, ObjectRef leader$2) {
        Option option;
        String string;
        Option option2;
        Tuple2 tuple2 = new Tuple2((Object)newLeaderOpt$1, (Object)oldLeaderOpt$1);
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            int newLeader = BoxesRunTime.unboxToInt((Object)some.value());
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since expected new leader ", " was not elected for partition ", ", leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeoutMs$1), BoxesRunTime.boxToInteger((int)newLeader), topicPartition$1, (Option)leader$2.elem}));
        } else if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            int oldLeader = BoxesRunTime.unboxToInt((Object)some.value());
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since a new leader that is different from ", " was not elected for partition ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeoutMs$1), BoxesRunTime.boxToInteger((int)oldLeader), topicPartition$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Option)leader$2.elem}));
        } else {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since a leader was not elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeoutMs$1), topicPartition$1}));
        }
        String errorMessage = string;
        return $this.fail(errorMessage);
    }

    public static final /* synthetic */ boolean $anonfun$isLeaderLocalOnBroker$1(Partition x$9) {
        return x$9.leaderReplicaIfLocal().isDefined();
    }

    public static final /* synthetic */ int $anonfun$waitUntilBrokerMetadataIsPropagated$1(KafkaServer x$10) {
        return x$10.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilBrokerMetadataIsPropagated$4(Set expectedBrokerIds$1, KafkaServer server) {
        Set set = expectedBrokerIds$1;
        Set set2 = ((TraversableOnce)server.apis().metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Seq$.MODULE$.canBuildFrom())).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilMetadataIsPropagated$3(String topic$4, int partition$1, IntRef leader$3, boolean result, KafkaServer server) {
        boolean bl;
        Option partitionStateOpt = server.apis().metadataCache().getPartitionInfo(topic$4, partition$1);
        Option option = partitionStateOpt;
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.value();
            leader$3.elem = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
            bl = result && Request$.MODULE$.isValidBrokerId(leader$3.elem);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$4(Partition x$12) {
        return x$12.leaderReplicaIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$3(TopicPartition tp$1, KafkaServer server) {
        return server.replicaManager().getPartition(tp$1).exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$4(x$12)));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoUnderReplicatedPartitions$7(ObjectRef leader$4, KafkaServer s) {
        return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)((Option)leader$4.elem).get());
    }

    public static final /* synthetic */ boolean $anonfun$verifyNonDaemonThreadsStatus$1(String threadNamePrefix$1, Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(threadNamePrefix$1);
    }

    public static final /* synthetic */ String $anonfun$sendMessages$1(String header$1, int x) {
        return header$1 + "-" + x;
    }

    public static final /* synthetic */ byte[] $anonfun$produceMessages$1(int valueBytes$1, int x) {
        byte[] byArray;
        int n = valueBytes$1;
        switch (n) {
            case -1: {
                byArray = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})).getBytes();
                break;
            }
            default: {
                byArray = new byte[valueBytes$1];
                break;
            }
        }
        return byArray;
    }

    public static final /* synthetic */ void $anonfun$getMessages$2(TestUtils$ $this, int nMessagesPerThread$1, ObjectRef messages$1, boolean shouldGetAllMessages$1, KafkaStream messageStream) {
        ConsumerIterator iterator = messageStream.iterator();
        try {
            for (int i = 0; shouldGetAllMessages$1 && iterator.hasNext() || i < nMessagesPerThread$1; ++i) {
                Assert.assertTrue((boolean)iterator.hasNext());
                String message = (String)iterator.next().message();
                messages$1.elem = ((List)messages$1.elem).$colon$colon((Object)message);
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "received message: " + message);
            }
        }
        catch (ConsumerTimeoutException e) {
            if (shouldGetAllMessages$1) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "consumer timed out after receiving " + ((List)messages$1.elem).length() + " message(s).");
            }
            throw e;
        }
    }

    public static final /* synthetic */ TopicPartition $anonfun$verifyTopicDeletion$1(String topic$3, int x$14) {
        return new TopicPartition(topic$3, x$14);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$9(KafkaServer server$1, TopicPartition tp) {
        return server$1.replicaManager().getPartition(tp).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$11(KafkaServer server$2, TopicPartition tp) {
        return server$2.getLogManager().getLog(tp).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$17(TopicPartition tp$2, Map checkpointsPerLogDir) {
        return !checkpointsPerLogDir.contains((Object)tp$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$15(KafkaServer server$3, TopicPartition tp) {
        Map[] checkpoints = (Map[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])server$3.getLogManager().logDirs())).map((Function1 & Serializable & scala.Serializable)logDir -> new OffsetCheckpointFile(new File((File)logDir, "cleaner-offset-checkpoint")).read(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints)).forall((Function1 & Serializable & scala.Serializable)checkpointsPerLogDir -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$17(tp, checkpointsPerLogDir)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$22(String logDir$1, TopicPartition tp) {
        return !new File(logDir$1, tp.topic() + "-" + tp.partition()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$20(IndexedSeq topicPartitions$1, KafkaServer server) {
        return server.config().logDirs().forall((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$22(logDir, tp)))));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$28(TopicPartition tp$3, String[] partitionDirectoryName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName)).startsWith((GenSeq)Predef$.MODULE$.wrapString(tp$3.topic() + "-" + tp$3.partition())) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName)).endsWith((GenSeq)Predef$.MODULE$.wrapString(Log$.MODULE$.DeleteDirSuffix()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$27(String logDir$2, TopicPartition tp) {
        return !((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Arrays.asList((Object[])new String[][]{new File(logDir$2).list()})).asScala()).exists((Function1 & Serializable & scala.Serializable)partitionDirectoryName -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$28(tp, partitionDirectoryName)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$25(IndexedSeq topicPartitions$1, KafkaServer server) {
        return server.config().logDirs().forall((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$27(logDir, tp)))));
    }

    private static final Seq subPaths$1(String path2, ZkUtils zkUtils$11) {
        Seq seq;
        if (zkUtils$11.pathExists(path2)) {
            String string = path2;
            seq = (Seq)((SeqLike)((TraversableLike)zkUtils$11.getChildren(path2).map((Function1 & Serializable & scala.Serializable)c -> path2 + "/" + c, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)path -> TestUtils$.subPaths$1(path, zkUtils$11), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public static final /* synthetic */ void $anonfun$verifySecureZkAcls$1(TestUtils$ $this, ZkUtils zkUtils$6, int usersWithAccess$1, String path) {
        block0: {
            if (!zkUtils$6.pathExists(path)) break block0;
            boolean sensitive = ZkUtils$.MODULE$.sensitivePath(path);
            int aclCount = sensitive ? usersWithAccess$1 : usersWithAccess$1 + 1;
            java.util.List acls = (java.util.List)zkUtils$6.zkConnection().getAcl(path).getKey();
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ACLs for ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, acls})), (long)aclCount, (long)acls.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).foreach((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)$this.isAclSecure(acl, sensitive)));
        }
    }

    public static final /* synthetic */ void $anonfun$verifyUnsecureZkAcls$1(TestUtils$ $this, ZkUtils zkUtils$5, String path) {
        block0: {
            if (!zkUtils$5.pathExists(path)) break block0;
            java.util.List acls = (java.util.List)zkUtils$5.zkConnection().getAcl(path).getKey();
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ACLs for ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, acls})), (long)1L, (long)acls.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).foreach((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)$this.isAclUnsecure(acl)));
        }
    }

    private final void failWithTimeout$1(String message$2, int timeoutMs$2) {
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Timed out, the concurrent functions took more than ", " milliseconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message$2, BoxesRunTime.boxToInteger((int)timeoutMs$2)})));
    }

    public static final /* synthetic */ void $anonfun$resetToCommittedPositions$1(KafkaConsumer consumer$4, TopicPartition x0$1) {
        BoxedUnit boxedUnit;
        TopicPartition topicPartition = x0$1;
        OffsetAndMetadata offset = consumer$4.committed(topicPartition);
        if (offset != null) {
            consumer$4.seek(topicPartition, offset.offset());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            consumer$4.seekToBeginning(Collections.singletonList(topicPartition));
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.random = TestUtils.RANDOM;
        this.RandomPort = 0;
        this.MockZkPort = 1;
        this.MockZkConnect = "127.0.0.1:" + this.MockZkPort();
        this.kafka$utils$TestUtils$$transactionStatusKey = "transactionStatus";
        this.kafka$utils$TestUtils$$committedValue = "committed".getBytes(StandardCharsets.UTF_8);
        this.kafka$utils$TestUtils$$abortedValue = "aborted".getBytes(StandardCharsets.UTF_8);
    }
}

