/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.common.KafkaException;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u000f\tIQ\u000b^5mgR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u001e;jYNT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001C\u0002\u0013%\u0011$\u0001\u0004m_\u001e<WM]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006Y><GG\u001b\u0006\u0003?9\ta!\u00199bG\",\u0017BA\u0011\u001d\u0005\u0019aunZ4fe\"11\u0005\u0001Q\u0001\ni\tq\u0001\\8hO\u0016\u0014\b\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#A\u0014\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013!\u0002:fO\u0016D(B\u0001\u0017.\u0003\u0011)H/\u001b7\u000b\u00039\nAA[1wC&\u0011\u0001'\u000b\u0002\b!\u0006$H/\u001a:o\u0011\u0019\u0011\u0004\u0001)A\u0005O\u0005\t2\r\\;ti\u0016\u0014\u0018\n\u001a)biR,'O\u001c\u0011\t\u000bQ\u0002A\u0011A\u001b\u0002\u0017Q,7\u000f^*xC2dwn\u001e\u000b\u0002mA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t!QK\\5uQ\t\u0019T\b\u0005\u0002?\u00016\tqH\u0003\u0002\f\u001d%\u0011\u0011i\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003D\u0001\u0011\u0005Q'\u0001\u000buKN$8)\u001b:dk2\f'/\u0013;fe\u0006$xN\u001d\u0015\u0003\u0005vBQA\u0012\u0001\u0005\u0002U\nQ\u0002^3tiJ+\u0017\r\u001a\"zi\u0016\u001c\bFA#>\u0011\u0015I\u0005\u0001\"\u00016\u0003\u001d!Xm\u001d;BEND#\u0001S\u001f\t\u000b1\u0003A\u0011A\u001b\u0002#Q,7\u000f\u001e*fa2\f7-Z*vM\u001aL\u0007\u0010\u000b\u0002L{!)q\n\u0001C\u0001k\u0005YA/Z:u%\u0016\fG-\u00138uQ\tqU\bC\u0003S\u0001\u0011\u0005Q'A\u0006uKN$8i\u001d<MSN$\bFA)>\u0011\u0015)\u0006\u0001\"\u00016\u0003)!Xm\u001d;DgZl\u0015\r\u001d\u0015\u0003)vBQ\u0001\u0017\u0001\u0005\u0002U\n!\u0002^3ti&sGj\\2lQ\t9V\bC\u0003\\\u0001\u0011\u0005Q'A\u000euKN$XK\u001d7TC\u001a,')Y:fmQ*enY8eKV+\u0016\n\u0012\u0015\u00035vBQA\u0018\u0001\u0005\u0002U\n\u0001\u0004^3ti\u001e+g.\u001a:bi\u0016,V/\u001b3Bg\n\u000b7/\u001a\u001c5Q\tiV\b")
public class UtilsTest
extends JUnitSuite {
    private final Logger logger = Logger.getLogger(UtilsTest.class);
    private final Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");

    private Logger logger() {
        return this.logger;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        CoreUtils$.MODULE$.swallow((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            UtilsTest.$anonfun$testSwallow$2(this, x$1, x$2);
            return BoxedUnit.UNIT;
        }, (Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException("test");
        });
    }

    @Test
    public void testCircularIterator() {
        List l = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator itl = CoreUtils$.MODULE$.circularIterator((Iterable)l);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertFalse((boolean)itl.hasDefiniteSize());
        Set s = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator its = CoreUtils$.MODULE$.circularIterator((Iterable)s);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
    }

    @Test
    public void testReadBytes() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "a", "abcd"})).foreach((Function1 & Serializable & scala.Serializable)testCase -> {
            UtilsTest.$anonfun$testReadBytes$1(testCase);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((long)0L, (long)Utils.abs((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)-1));
        Assert.assertEquals((long)0L, (long)Utils.abs((int)0));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testReplaceSuffix() {
        Assert.assertEquals((Object)"blah.foo.text", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ".text"));
        Assert.assertEquals((Object)"blah.foo", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ""));
        Assert.assertEquals((Object)"txt.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("txt.txt.txt", ".txt", ""));
        Assert.assertEquals((Object)"foo.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("foo", "", ".txt"));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(values)).size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            buffer.putInt(i * 4, values[i]);
            Assert.assertEquals((String)"Written value should match read value.", (long)values[i], (long)CoreUtils$.MODULE$.readInt(buffer.array(), i * 4));
        });
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        String nullString = null;
        Seq emptyList = CoreUtils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = CoreUtils$.MODULE$.parseCsvList(nullString);
        Seq emptyStringList = (Seq)Seq$.MODULE$.empty();
        Assert.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assert.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testCsvMap() {
        String emptyString = "";
        Map emptyMap = CoreUtils$.MODULE$.parseCsvMap(emptyString);
        scala.collection.immutable.Map emptyStringMap = Predef$.MODULE$.Map().empty();
        Assert.assertTrue((emptyMap != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringMap.equals((Object)emptyStringMap));
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        Map ipv6Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV6);
        ipv6Map.foreach((Function1 & Serializable & scala.Serializable)m -> {
            UtilsTest.$anonfun$testCsvMap$1(m);
            return BoxedUnit.UNIT;
        });
        String singleEntry = "key:value";
        Map singleMap = CoreUtils$.MODULE$.parseCsvMap(singleEntry);
        Object value = singleMap.getOrElse((Object)"key", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Assert.assertTrue((boolean)value.equals("value"));
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        Map ipv4Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV4);
        ipv4Map.foreach((Function1 & Serializable & scala.Serializable)m -> {
            UtilsTest.$anonfun$testCsvMap$3(m);
            return BoxedUnit.UNIT;
        });
        String kvPairsSpaces = "key:value      , key:   value";
        Map spaceMap = CoreUtils$.MODULE$.parseCsvMap(kvPairsSpaces);
        spaceMap.foreach((Function1 & Serializable & scala.Serializable)m -> {
            UtilsTest.$anonfun$testCsvMap$4(m);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInLock() {
        ReentrantLock lock = new ReentrantLock();
        int result = BoxesRunTime.unboxToInt((Object)CoreUtils$.MODULE$.inLock((Lock)lock, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Assert.assertTrue((String)"Should be in lock", (boolean)lock.isHeldByCurrentThread());
            return 2;
        }));
        Assert.assertEquals((long)2L, (long)result);
        Assert.assertFalse((String)"Should be unlocked", (boolean)lock.isLocked());
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = CoreUtils$.MODULE$.urlSafeBase64EncodeNoPadding(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assert.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assert.assertEquals((long)clusterId1.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = CoreUtils$.MODULE$.urlSafeBase64EncodeNoPadding(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assert.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assert.assertEquals((long)clusterId2.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assert.assertEquals((long)clusterId.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    public static final /* synthetic */ void $anonfun$testSwallow$2(UtilsTest $this, Object x$1, Throwable x$2) {
        $this.logger().info(x$1, x$2);
    }

    public static final /* synthetic */ void $anonfun$testReadBytes$1(String testCase) {
        byte[] bytes = testCase.getBytes();
        Assert.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$1(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("a:b:c"));
        Assert.assertTrue((boolean)((String)m._2()).equals("v"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$3(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("192.168.2.1/30"));
        Assert.assertTrue((boolean)((String)m._2()).equals("allow"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$4(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("key"));
        Assert.assertTrue((boolean)((String)m._2()).equals("value"));
    }
}

