/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.List;
import kafka.common.TopicAndPartition;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Test;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u000f\tY!l[+uS2\u001cH+Z:u\u0015\t\u0019A!A\u0003vi&d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0003qCRDW#\u0001\f\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00027b]\u001eT\u0011aG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001e1\t11\u000b\u001e:j]\u001eDaa\b\u0001!\u0002\u00131\u0012!\u00029bi\"\u0004\u0003\"B\u0011\u0001\t\u0003\u0011\u0013a\t;fgR\u001cVoY2fgN4W\u000f\\\"p]\u0012LG/[8oC2$U\r\\3uKB\u000bG\u000f\u001b\u000b\u0002GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t!QK\\5uQ\t\u0001#\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u0005)!.\u001e8ji*\tq&A\u0002pe\u001eL!!\r\u0017\u0003\tQ+7\u000f\u001e\u0005\u0006g\u0001!\tAI\u0001\u001di\u0016\u001cH\u000fU3sg&\u001cH/\u001a8u'\u0016\fX/\u001a8uS\u0006d\u0007+\u0019;iQ\t\u0011$\u0006C\u00037\u0001\u0011\u0005!%\u0001\u0011uKN$\u0018IY8si\u0016$7i\u001c8eSRLwN\\1m\t\u0016dW\r^3QCRD\u0007FA\u001b+\u0011\u0015I\u0004\u0001\"\u0001#\u0003\u0001\"Xm\u001d;DYV\u001cH/\u001a:JI\u0016tG/\u001b4jKJT5o\u001c8QCJ\u001c\u0018N\\4)\u0005aR\u0003\"\u0002\u001f\u0001\t\u0003\u0011\u0013A\u000b;fgR<U\r^!mYB\u000b'\u000f^5uS>t7\u000fV8qS\u000e<\u0016\u000e\u001e5pkR\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003w)\u0002")
public class ZkUtilsTest
extends ZooKeeperTestHarness {
    private final String path;

    public String path() {
        return this.path;
    }

    @Test
    public void testSuccessfulConditionalDeletePath() {
        Option optionalData;
        Stat statAfterCreation;
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = this.path();
        String x$2 = qual$1.createPersistentPath$default$2();
        List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        Tuple2 tuple2 = this.zkUtils().readData(this.path());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Stat stat = statAfterCreation = (Stat)tuple2._2();
        Stat statAfterCreation2 = stat;
        Assert.assertTrue((String)"Deletion should be successful", (boolean)this.zkUtils().conditionalDeletePath(this.path(), statAfterCreation2.getVersion()));
        Tuple2 tuple22 = this.zkUtils().readDataMaybeNull(this.path());
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option option = optionalData = (Option)tuple22._1();
        Option optionalData2 = option;
        Assert.assertTrue((String)"Node should be deleted", (boolean)optionalData2.isEmpty());
        Assert.assertTrue((String)"Deletion should be successful", (boolean)this.zkUtils().conditionalDeletePath(this.path(), 0));
    }

    @Test
    public void testPersistentSequentialPath() {
        ZkUtils qual$2 = this.zkUtils();
        String x$4 = this.path();
        String x$5 = qual$2.createPersistentPath$default$2();
        List x$6 = qual$2.createPersistentPath$default$3();
        qual$2.createPersistentPath(x$4, x$5, x$6);
        ZkUtils qual$3 = this.zkUtils();
        String x$7 = this.path() + "/sequence_";
        String x$8 = qual$3.createSequentialPersistentPath$default$2();
        List x$9 = qual$3.createSequentialPersistentPath$default$3();
        String result = qual$3.createSequentialPersistentPath(x$7, x$8, x$9);
        Assert.assertEquals((Object)"/path/sequence_0000000000", (Object)result);
        ZkUtils qual$4 = this.zkUtils();
        String x$10 = this.path() + "/sequence_";
        String x$11 = qual$4.createSequentialPersistentPath$default$2();
        List x$12 = qual$4.createSequentialPersistentPath$default$3();
        result = qual$4.createSequentialPersistentPath(x$10, x$11, x$12);
        Assert.assertEquals((Object)"/path/sequence_0000000001", (Object)result);
    }

    @Test
    public void testAbortedConditionalDeletePath() {
        Option optionalData;
        Stat statAfterCreation;
        ZkUtils qual$5 = this.zkUtils();
        String x$13 = this.path();
        String x$14 = qual$5.createPersistentPath$default$2();
        List x$15 = qual$5.createPersistentPath$default$3();
        qual$5.createPersistentPath(x$13, x$14, x$15);
        Tuple2 tuple2 = this.zkUtils().readData(this.path());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Stat stat = statAfterCreation = (Stat)tuple2._2();
        Stat statAfterCreation2 = stat;
        ZkUtils qual$6 = this.zkUtils();
        String x$16 = this.path();
        String x$17 = "data";
        List x$18 = qual$6.updatePersistentPath$default$3();
        qual$6.updatePersistentPath(x$16, x$17, x$18);
        Assert.assertFalse((String)"Deletion should be aborted", (boolean)this.zkUtils().conditionalDeletePath(this.path(), statAfterCreation2.getVersion()));
        Tuple2 tuple22 = this.zkUtils().readDataMaybeNull(this.path());
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option option = optionalData = (Option)tuple22._1();
        Option optionalData2 = option;
        Assert.assertTrue((String)"Node should still be there", (boolean)optionalData2.isDefined());
    }

    @Test
    public void testClusterIdentifierJsonParsing() {
        String clusterId = "test";
        Assert.assertEquals((Object)this.zkUtils().ClusterId().fromJson(this.zkUtils().ClusterId().toJson(clusterId)), (Object)clusterId);
    }

    @Test
    public void testGetAllPartitionsTopicWithoutPartitions() {
        String topic = "testtopic";
        ZkUtils qual$7 = this.zkUtils();
        String x$19 = ZkUtils$.MODULE$.getTopicPartitionPath(topic, 0);
        String x$20 = qual$7.createPersistentPath$default$2();
        List x$21 = qual$7.createPersistentPath$default$3();
        qual$7.createPersistentPath(x$19, x$20, x$21);
        ZkUtils qual$8 = this.zkUtils();
        String x$22 = ZkUtils$.MODULE$.getTopicPath("nopartitions");
        String x$23 = qual$8.createPersistentPath$default$2();
        List x$24 = qual$8.createPersistentPath$default$3();
        qual$8.createPersistentPath(x$22, x$23, x$24);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), (Object)this.zkUtils().getAllPartitions());
    }

    public ZkUtilsTest() {
        this.path = "/path";
    }
}

