/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.security.auth.login.Configuration;
import kafka.consumer.ConsumerConfig;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.ZKCheckedEphemeral;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZKEphemeralTest$;
import kafka.zk.ZooKeeperTestHarness;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.java8.JFunction0;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005t!B\u0001\u0003\u0011\u00039\u0011a\u0004.L\u000bBDW-\\3sC2$Vm\u001d;\u000b\u0005\r!\u0011A\u0001>l\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u00105.+\u0005\u000f[3nKJ\fG\u000eV3tiN\u0019\u0011\u0002\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\ti1#\u0003\u0002\u0015\u001d\ta1+\u001a:jC2L'0\u00192mK\")a#\u0003C\u0001/\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\u00063%!\tAG\u0001\u0016K:\f'\r\\3TK\u000e,(/\u001b;z\u001fB$\u0018n\u001c8t+\u0005Y\u0002c\u0001\u000f\"G5\tQD\u0003\u0002\u001f?\u0005!A.\u00198h\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\u0011%#XM]1cY\u0016\u00042!\u0004\u0013'\u0013\t)cBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001dO%\u0011\u0001&\b\u0002\b\u0005>|G.Z1oQ\tA\"\u0006\u0005\u0002,{9\u0011AF\u000f\b\u0003[]r!A\f\u001b\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011A\u0002\u001fs_>$h(C\u00014\u0003\ry'oZ\u0005\u0003kY\nQA[;oSRT\u0011aM\u0005\u0003qe\nqA];o]\u0016\u00148O\u0003\u00026m%\u00111\bP\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\u0005aJ\u0014B\u0001 @\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0003wqBq!Q\u0005\u0002\u0002\u0013%!)A\u0006sK\u0006$'+Z:pYZ,G#A\"\u0011\u0005q!\u0015BA#\u001e\u0005\u0019y%M[3di\u001a!!B\u0001\u0001H'\t1\u0005\n\u0005\u0002\t\u0013&\u0011!J\u0001\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u001113%Q1A\u0005\u00025\u000baa]3dkJ,W#\u0001(\u0011\u00055y\u0015B\u0001\u0015\u000f\u0011!\tfI!A!\u0002\u0013q\u0015aB:fGV\u0014X\r\t\u0005\u0006-\u0019#\ta\u0015\u000b\u0003)V\u0003\"\u0001\u0003$\t\u000b1\u0013\u0006\u0019\u0001(\t\u000f]3%\u0019!C\u00011\u0006A!.Y1t\r&dW-F\u0001Z!\tQV,D\u0001\\\u0015\tav$\u0001\u0002j_&\u0011al\u0017\u0002\u0005\r&dW\r\u0003\u0004a\r\u0002\u0006I!W\u0001\nU\u0006\f7OR5mK\u0002BqA\u0019$C\u0002\u0013\u00051-\u0001\u0007bkRD\u0007K]8wS\u0012,'/F\u0001e!\taR-\u0003\u0002g;\t11\u000b\u001e:j]\u001eDa\u0001\u001b$!\u0002\u0013!\u0017!D1vi\"\u0004&o\u001c<jI\u0016\u0014\b\u0005C\u0004k\r\u0002\u0007I\u0011A6\u0002%i\\7+Z:tS>tG+[7f_V$Xj]\u000b\u0002YB\u0011Q\"\\\u0005\u0003]:\u00111!\u00138u\u0011\u001d\u0001h\t1A\u0005\u0002E\faC_6TKN\u001c\u0018n\u001c8US6,w.\u001e;Ng~#S-\u001d\u000b\u0003eV\u0004\"!D:\n\u0005Qt!\u0001B+oSRDqA^8\u0002\u0002\u0003\u0007A.A\u0002yIEBa\u0001\u001f$!B\u0013a\u0017a\u0005>l'\u0016\u001c8/[8o)&lWm\\;u\u001bN\u0004\u0003\"\u0002>G\t\u0003Z\u0018!B:fiV\u0003H#\u0001:)\u0005el\bC\u0001@\u0000\u001b\u0005I\u0014bAA\u0001s\t1!)\u001a4pe\u0016Da!!\u0002G\t\u0003Z\u0018\u0001\u0003;fCJ$un\u001e8)\t\u0005\r\u0011\u0011\u0002\t\u0004}\u0006-\u0011bAA\u0007s\t)\u0011I\u001a;fe\"9\u0011\u0011\u0003$\u0005\u0002\u0005M\u0011\u0001\u0007;fgR,\u0005\u000f[3nKJ\fGNT8eK\u000ecW-\u00198vaV\t!\u000f\u000b\u0003\u0002\u0010\u0005]\u0001c\u0001@\u0002\u001a%\u0019\u00111D\u001d\u0003\tQ+7\u000f\u001e\u0005\b\u0003?1E\u0011AA\n\u0003Y!Xm\u001d;[W^\u000bGo\u00195fI\u0016\u0003\b.Z7fe\u0006d\u0007\u0006BA\u000f\u0003/Aq!!\nG\t\u0013\t9#\u0001\u0007uKN$8I]3bi&|g\u000eF\u0002s\u0003SA\u0001\"a\u000b\u0002$\u0001\u0007\u0011QF\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u00020\u0005]b\u0002BA\u0019\u0003g\u0001\"a\f\b\n\u0007\u0005Ub\"\u0001\u0004Qe\u0016$WMZ\u0005\u0004M\u0006e\"bAA\u001b\u001d!9\u0011Q\b$\u0005\u0002\u0005M\u0011a\u0006;fgR|e/\u001a:mCB\u0004\u0018N\\4TKN\u001c\u0018n\u001c8tQ\u0011\tY$a\u0006\t\u000f\u0005\rc\t\"\u0001\u0002\u0014\u0005yA/Z:u'\u0006lWmU3tg&|g\u000e\u000b\u0003\u0002B\u0005]\u0001f\u0002$\u0002J\u0005U\u0013q\u000b\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011qJ\u001d\u0002\rI,hN\\3s\u0013\u0011\t\u0019&!\u0014\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011\u0011\f\t\u0005\u00037\ni&D\u0001=\u0013\r\ty\u0006\u0010\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3")
public class ZKEphemeralTest
extends ZooKeeperTestHarness {
    private final boolean secure;
    private final File jaasFile;
    private final String authProvider;
    private int zkSessionTimeoutMs;

    @Parameterized.Parameters
    public static Iterable<Boolean[]> enableSecurityOptions() {
        return ZKEphemeralTest$.MODULE$.enableSecurityOptions();
    }

    public boolean secure() {
        return this.secure;
    }

    public File jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void zkSessionTimeoutMs_$eq(int x$1) {
        this.zkSessionTimeoutMs = x$1;
    }

    @Override
    @Before
    public void setUp() {
        if (this.secure()) {
            System.setProperty("java.security.auth.login.config", this.jaasFile().getAbsolutePath());
            Configuration.setConfiguration(null);
            System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            if (!JaasUtils.isZkSecurityEnabled()) {
                throw this.fail("Secure access not enabled", new Position("ZKEphemeralTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            }
        }
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testEphemeralNodeCleanup() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        try {
            ZkUtils qual$1 = zkUtils;
            String x$2 = "/tmp/zktest";
            String x$3 = "node created";
            List x$4 = qual$1.createEphemeralPathExpectConflict$default$3();
            qual$1.createEphemeralPathExpectConflict(x$2, x$3, x$4);
        }
        catch (Exception exception) {}
        String testData = null;
        testData = (String)zkUtils.readData("/tmp/zktest")._1();
        Assert.assertNotNull((Object)testData);
        zkUtils.close();
        zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        boolean nodeExists = zkUtils.pathExists("/tmp/zktest");
        Assert.assertFalse((boolean)nodeExists);
        zkUtils.close();
    }

    @Test
    public void testZkWatchedEphemeral() {
        this.testCreation("/zwe-test");
        this.testCreation("/zwe-test-parent/zwe-test");
    }

    private void testCreation(String path) {
        ZooKeeper zk = this.zkUtils().zkConnection().getZookeeper();
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk, JaasUtils.isZkSecurityEnabled());
        BooleanRef created = BooleanRef.create((boolean)false);
        zk.exists(path, new Watcher(null, created){
            private final BooleanRef created$1;

            public void process(WatchedEvent event) {
                block0: {
                    Watcher.Event.EventType eventType = event.getType();
                    Watcher.Event.EventType eventType2 = Watcher.Event.EventType.NodeCreated;
                    if (eventType != null ? !eventType.equals(eventType2) : eventType2 != null) break block0;
                    this.created$1.elem = true;
                }
            }
            {
                this.created$1 = created$1;
            }
        });
        zwe.create();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().pathExists(path), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't created"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testOverlappingSessions() {
        boolean bl;
        String path = "/zwe-test";
        ZooKeeper zk1 = this.zkUtils().zkConnection().getZookeeper();
        Tuple2 tuple2 = ZkUtils$.MODULE$.createZkClientAndConnection(this.zkConnect(), this.zkSessionTimeoutMs(), this.zkConnectionTimeout());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ZkClient zkClient2 = (ZkClient)tuple2._1();
        ZkConnection zkConnection2 = (ZkConnection)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)zkClient2, (Object)zkConnection2);
        Tuple2 tuple23 = tuple22;
        ZkClient zkClient22 = (ZkClient)tuple23._1();
        ZkConnection zkConnection22 = (ZkConnection)tuple23._2();
        ZooKeeper zk2 = zkConnection22.getZookeeper();
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk2, JaasUtils.isZkSecurityEnabled());
        zk1.create(path, (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        try {
            zwe.create();
            bl = false;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            bl = true;
        }
        boolean gotException = bl;
        Assert.assertTrue((boolean)gotException);
        zkClient22.close();
    }

    @Test
    public void testSameSession() {
        boolean bl;
        String path = "/zwe-test";
        ZooKeeper zk = this.zkUtils().zkConnection().getZookeeper();
        zk.create(path, (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk, JaasUtils.isZkSecurityEnabled());
        try {
            zwe.create();
            bl = false;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            bl = true;
        }
        boolean gotException = bl;
        Assert.assertFalse((boolean)gotException);
    }

    public ZKEphemeralTest(boolean secure) {
        this.secure = secure;
        this.jaasFile = JaasTestUtils$.MODULE$.writeJaasContextsToFile(JaasTestUtils$.MODULE$.zkSections());
        this.authProvider = "zookeeper.authProvider.1";
        this.zkSessionTimeoutMs = 1000;
    }
}

