/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import unit.kafka.admin.ConsumerGroupExecutor;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0001\u0003\u0001%\u0011ADU3tKR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\u0011QAB\u0001\u0006W\u000647.\u0019\u0006\u0002\u000f\u0005!QO\\5u\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-yQ\"\u0001\u0007\u000b\u00055q\u0011aC5oi\u0016<'/\u0019;j_:T\u0011!B\u0005\u0003!1\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006%\u0001!\taE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0001\"!\u0006\u0001\u000e\u0003\tAqa\u0006\u0001C\u0002\u0013\u0005\u0001$A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005I\u0002C\u0001\u000e \u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0011)H/\u001b7\u000b\u0003y\tAA[1wC&\u0011\u0001e\u0007\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002\u0012\u0001A\u0003%\u0011$\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA!9A\u0005\u0001b\u0001\n\u0003)\u0013A\u0002;pa&\u001c\u0017'F\u0001'!\t9#&D\u0001)\u0015\tIS$\u0001\u0003mC:<\u0017BA\u0016)\u0005\u0019\u0019FO]5oO\"1Q\u0006\u0001Q\u0001\n\u0019\nq\u0001^8qS\u000e\f\u0004\u0005C\u00040\u0001\t\u0007I\u0011A\u0013\u0002\rQ|\u0007/[23\u0011\u0019\t\u0004\u0001)A\u0005M\u00059Ao\u001c9jGJ\u0002\u0003bB\u001a\u0001\u0005\u0004%\t!J\u0001\u0006OJ|W\u000f\u001d\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0014\u0002\r\u001d\u0014x.\u001e9!\u0011\u001d9\u0004A1A\u0005\u0002a\tQ\u0001\u001d:paNDa!\u000f\u0001!\u0002\u0013I\u0012A\u00029s_B\u001c\b\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002+\r|gn];nKJ<%o\\;q'\u0016\u0014h/[2fgV\tQ\bE\u0002?\u000b\u001ek\u0011a\u0010\u0006\u0003\u0001\u0006\u000bq!\\;uC\ndWM\u0003\u0002C\u0007\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR \u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003\u0011Ns!!\u0013)\u000f\u0005){eBA&O\u001b\u0005a%BA'\t\u0003\u0019a$o\\8u}%\tQ!\u0003\u0002\u0004\u001d%\u0011\u0011KU\u0001\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9D_6l\u0017M\u001c3\u000b\u0005\rq\u0011B\u0001+V\u0005eY\u0015MZ6b\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u000b\u0005E\u0013\u0006BB,\u0001A\u0003%Q(\u0001\fd_:\u001cX/\\3s\u000fJ|W\u000f]*feZL7-Z:!\u0011\u001dI\u0006A1A\u0005\u0002i\u000b\u0011\"\u001a=fGV$xN]:\u0016\u0003m\u00032AP#]!\t)R,\u0003\u0002_\u0005\t)2i\u001c8tk6,'o\u0012:pkB,\u00050Z2vi>\u0014\bB\u00021\u0001A\u0003%1,\u0001\u0006fq\u0016\u001cW\u000f^8sg\u0002BQA\u0019\u0001\u0005B\r\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002IB\u0019QM[7\u000f\u0005\u0019DgBA&h\u0013\u0005!\u0015BA5D\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\u0007M+\u0017O\u0003\u0002j\u0007B\u0011a.]\u0007\u0002_*\u0011\u0001OD\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005I|'aC&bM.\f7i\u001c8gS\u001eDQ\u0001\u001e\u0001\u0005BU\fQa]3u+B$\u0012A\u001e\t\u0003obl\u0011aQ\u0005\u0003s\u000e\u0013A!\u00168ji\"\u00121o\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018!\u00026v]&$(BAA\u0001\u0003\ry'oZ\u0005\u0004\u0003\u000bi(A\u0002\"fM>\u0014X\r\u0003\u0004\u0002\n\u0001!\t%^\u0001\ti\u0016\f'\u000fR8x]\"\"\u0011qAA\u0007!\ra\u0018qB\u0005\u0004\u0003#i(!B!gi\u0016\u0014\bBBA\u000b\u0001\u0011\u0005Q/\u0001\u0011uKN$(+Z:fi>3gm]3ug:{G/\u0012=jgRLgnZ$s_V\u0004\b\u0006BA\n\u00033\u00012\u0001`A\u000e\u0013\r\ti\" \u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002\"\u0001!\t!^\u0001)i\u0016\u001cHOU3tKR|eMZ:fiNtUm^\"p]N,X.\u001a:Fq&\u001cH/\u001b8h)>\u0004\u0018n\u0019\u0015\u0005\u0003?\tI\u0002\u0003\u0004\u0002(\u0001!\t!^\u0001 i\u0016\u001cHOU3tKR|eMZ:fiN$v\u000eT8dC2$\u0015\r^3US6,\u0007\u0006BA\u0013\u00033Aa!!\f\u0001\t\u0003)\u0018a\b;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>TvN\\3e\t\u0006$X\rV5nK\"\"\u00111FA\r\u0011\u0019\t\u0019\u0004\u0001C\u0001k\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]\"\"\u0011\u0011GA\r\u0011\u0019\tI\u0004\u0001C\u0001k\u0006!C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]R{W)\u0019:mS\u0016\u001cH\u000f\u000b\u0003\u00028\u0005e\u0001BBA \u0001\u0011\u0005Q/\u0001\u000euKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cH\u000f\u000b\u0003\u0002>\u0005e\u0001BBA#\u0001\u0011\u0005Q/\u0001\ruKN$(+Z:fi>3gm]3ugR{G*\u0019;fgRDC!a\u0011\u0002\u001a!1\u00111\n\u0001\u0005\u0002U\fq\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u000e+(O]3oi>3gm]3uQ\u0011\tI%!\u0007\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T\u0005I\u0002O]8ek\u000e,7i\u001c8tk6,\u0017I\u001c3TQV$Hm\\<o)%1\u0018QKA-\u0003G\n)\bC\u0004\u0002X\u0005=\u0003\u0019A$\u0002)\r|gn];nKJ<%o\\;q\u0007>lW.\u00198e\u0011)\tY&a\u0014\u0011\u0002\u0003\u0007\u0011QL\u0001\r]Vl7i\u001c8tk6,'o\u001d\t\u0004o\u0006}\u0013bAA1\u0007\n\u0019\u0011J\u001c;\t\u0011\u0005\u0015\u0014q\na\u0001\u0003O\nQ\u0001^8qS\u000e\u0004B!!\u001b\u0002r9!\u00111NA7!\tY5)C\u0002\u0002p\r\u000ba\u0001\u0015:fI\u00164\u0017bA\u0016\u0002t)\u0019\u0011qN\"\t\u0011\u0005]\u0014q\na\u0001\u0003;\nQ\u0002^8uC2lUm]:bO\u0016\u001c\bBBA>\u0001\u0011\u0005Q/\u0001\u0011uKN$(+Z:fi>3gm]3ugR{7\u000b]3dS\u001aL7m\u00144gg\u0016$\b\u0006BA=\u00033Aa!!!\u0001\t\u0003)\u0018!\u0007;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t'\"Lg\r\u001e)mkNDC!a \u0002\u001a!1\u0011q\u0011\u0001\u0005\u0002U\f!\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4G/T5okNDC!!\"\u0002\u001a!1\u0011Q\u0012\u0001\u0005\u0002U\f\u0001\u0006^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=M_^,'\u000f\u00165b]\u0016\u000b'\u000f\\5fgRDC!a#\u0002\u001a!1\u00111\u0013\u0001\u0005\u0002U\fq\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=IS\u001eDWM\u001d+iC:d\u0015\r^3ti\"\"\u0011\u0011SA\r\u0011\u0019\tI\n\u0001C\u0001k\u0006!C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti>swJ\\3U_BL7\r\u000b\u0003\u0002\u0018\u0006e\u0001BBAP\u0001\u0011\u0005Q/\u0001\u0019uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148P]\u0016$v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003;\u000bI\u0002\u0003\u0004\u0002&\u0002!\t!^\u0001#i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o)>\u0004\u0018nY:)\t\u0005\r\u0016\u0011\u0004\u0005\u0007\u0003W\u0003A\u0011A;\u0002_Q,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\\#be2LWm\u001d;P]R{\u0007/[2t\u0003:$\u0007+\u0019:uSRLwN\\:)\t\u0005%\u0016\u0011\u0004\u0005\u0007\u0003c\u0003A\u0011A;\u0002AQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cX\t\u001f9peRLU\u000e]8siBc\u0017M\u001c\u0015\u0005\u0003_\u000bI\u0002\u0003\u0004\u00028\u0002!I!^\u0001\u0013aJLg\u000e^\"p]N,X.\u001a:He>,\b\u000fC\u0004\u00028\u0002!I!a/\u0015\u0007Y\fi\fC\u00044\u0003s\u0003\r!a\u001a\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\u0006Y2M]3bi\u0016\u001cuN\\:v[\u0016\u0014xI]8va\u0016CXmY;u_J$\u0012\u0002XAc\u0003\u0013\fY-a4\t\u0011\u0005\u001d\u0017q\u0018a\u0001\u0003O\n!B\u0019:pW\u0016\u0014H*[:u\u0011!\tY&a0A\u0002\u0005u\u0003\u0002CAg\u0003\u007f\u0003\r!a\u001a\u0002\u000f\u001d\u0014x.\u001e9JI\"A\u0011QMA`\u0001\u0004\t9\u0007C\u0004\u0002T\u0002!I!!6\u00025\r\u0014X-\u0019;f\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u0015\u0007\u001d\u000b9\u000e\u0003\u0005\u0002Z\u0006E\u0007\u0019AAn\u0003\u0011y\u0007\u000f^:\u0011\u0007!\u000bi.C\u0002\u0002`V\u00131dQ8ogVlWM]$s_V\u00048i\\7nC:$w\n\u001d;j_:\u001c\b\"CAr\u0001E\u0005I\u0011BAs\u0003\r\u0002(o\u001c3vG\u0016\u001cuN\\:v[\u0016\fe\u000eZ*ikR$wn\u001e8%I\u00164\u0017-\u001e7uII*\"!a:+\t\u0005u\u0013\u0011^\u0016\u0003\u0003W\u0004B!!<\u0002x6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\u00190A\u0005v]\u000eDWmY6fI*\u0019\u0011Q_\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002z\u0006=(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ResetConsumerGroupOffsetTest
extends KafkaServerTestHarness {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;
    private final String group;
    private final Properties props = new Properties();
    private final ArrayBuffer<ConsumerGroupCommand.KafkaConsumerGroupService> consumerGroupServices = new ArrayBuffer();
    private final ArrayBuffer<ConsumerGroupExecutor> executors = new ArrayBuffer();

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public String group() {
        return this.group;
    }

    public Properties props() {
        return this.props;
    }

    public ArrayBuffer<ConsumerGroupCommand.KafkaConsumerGroupService> consumerGroupServices() {
        return this.consumerGroupServices;
    }

    public ArrayBuffer<ConsumerGroupExecutor> executors() {
        return this.executors;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.props().setProperty("group.id", this.group());
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executors().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            this.consumerGroupServices().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        this.createConsumerGroupExecutor(this.brokerList(), 1, this.group(), this.topic1());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "missing.group", "--all-topics", "--to-current"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset;
            Map map = assignmentsToReset = consumerGroupCommand.resetOffsets();
            Map map2 = Predef$.MODULE$.Map().empty();
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected to have an empty assignations map.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testResetOffsetsNewConsumerExistingTopic() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "new.group", "--topic", this.topic1(), "--to-offset", "50", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsNewConsumerExistingTopic$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 1 (specific offset).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup("new.group");
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
        consumerGroupCommand.close();
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        ConsumerGroupExecutor executor = this.createConsumerGroupExecutor(this.brokerList(), 1, this.group(), this.topic1());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Some some;
            Seq assignments;
            long sumOffset;
            Option assignmentsOption;
            Option assignmentsOption2;
            Tuple2 tuple2 = consumerGroupCommand.describeGroup();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignmentsOption2 = (Option)tuple2._2();
            Option option2 = assignmentsOption = option;
            boolean bl = option2 instanceof Some ? (sumOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)(assignments = (Seq)(some = (Some)option2).value()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$3(this, x$4)))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$5(x$6)))).map((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$6(assignment)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$7, x$8) -> x$7 + x$8))) == 100L : false;
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected that consumer group has consumed all messages from topic/partition.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        String[] cgcArgs1 = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts1 = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs1);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand1 = this.createConsumerGroupService(opts1);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand1.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$10(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to when offset was 50.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 50, 1, 100000);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        Date checkpoint = new Date();
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 50, 1, 100000);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        ConsumerGroupExecutor executor = this.createConsumerGroupExecutor(this.brokerList(), 1, this.group(), this.topic1());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Some some;
            Seq assignments;
            long sumOffset;
            Option assignmentsOption;
            Option assignmentsOption2;
            Tuple2 tuple2 = consumerGroupCommand.describeGroup();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignmentsOption2 = (Option)tuple2._2();
            Option option2 = assignmentsOption = option;
            boolean bl = option2 instanceof Some ? (sumOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)(assignments = (Seq)(some = (Some)option2).value()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$3(this, x$9)))).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$5(x$11)))).map((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$6(assignment)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$12, x$13) -> x$12 + x$13))) == 100L : false;
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected that consumer group has consumed all messages from topic/partition.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        String[] cgcArgs1 = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(checkpoint), "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts1 = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs1);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand1 = this.createConsumerGroupService(opts1);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand1.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$10(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to when offset was 50.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT1M", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsByDuration$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest by duration).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT0.1S", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsByDurationToEarliest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 100 (latest by duration).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-latest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLatest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 200 (latest).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-current", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToCurrentOffset$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 100 (current).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    private void produceConsumeAndShutdown(ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand, int numConsumers, String topic, int totalMessages) {
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, totalMessages, 1, 100000);
        ConsumerGroupExecutor executor = this.createConsumerGroupExecutor(this.brokerList(), numConsumers, this.group(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Some some;
            Seq assignments;
            long sumOffset;
            Option assignmentsOption;
            Option assignmentsOption2;
            Tuple2 tuple2 = consumerGroupCommand.describeGroup();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignmentsOption2 = (Option)tuple2._2();
            Option option2 = assignmentsOption = option;
            boolean bl = option2 instanceof Some ? (sumOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)(assignments = (Seq)(some = (Some)option2).value()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$produceConsumeAndShutdown$3(topic, x$14)))).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$produceConsumeAndShutdown$5(x$16)))).map((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$produceConsumeAndShutdown$6(assignment)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$17, x$18) -> x$17 + x$18))) == (long)totalMessages : false;
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to consume all messages from topic.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$2() {
        return 1;
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "1", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToSpecificOffset$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 1 (specific offset).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "50", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsShiftPlus$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 150 (current + 50).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-50", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsShiftMinus$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 50 (current - 50).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-150", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsShiftByLowerThanEarliest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest by shift).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "150", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsShiftByHigherThanLatest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 200 (latest by shift).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic1(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnOneTopic$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", String.format("%s:1", this.topic1()), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 2, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnOneTopicAndPartition$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest) in partition 1.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic1(), "--topic", this.topic2(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic2(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic2(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnTopics$3(this, assignment))) && assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnTopics$4(this, assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic2());
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", String.format("%s:1", this.topic1()), "--topic", String.format("%s:1", this.topic2()), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic2(), 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 2, this.topic1(), 100);
        this.produceConsumeAndShutdown(consumerGroupCommand, 2, this.topic2(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnTopicsAndPartitions$3(this, assignment)));
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnTopicsAndPartitions$4(this, assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest) in partition 1.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic2());
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--export"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = this.createConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 2, this.topic1(), 100);
        File file = File.createTempFile("reset", ".csv");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(consumerGroupCommand.exportOffsetsToReset(assignmentsToReset));
            bw.close();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExportImportPlan$3(assignment))) && file.exists();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consume all messages and save reset offsets plan to file", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String[] cgcArgsExec = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--from-file", file.getCanonicalPath()});
        ConsumerGroupCommand.ConsumerGroupCommandOptions optsExec = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgsExec);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommandExec = this.createConsumerGroupService(optsExec);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommandExec.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExportImportPlan$6(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest) by file.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        file.deleteOnExit();
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    private void printConsumerGroup() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--group", this.group(), "--describe"});
        ConsumerGroupCommand$.MODULE$.main(cgcArgs);
    }

    private void printConsumerGroup(String group) {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--group", group, "--describe"});
        ConsumerGroupCommand$.MODULE$.main(cgcArgs);
    }

    private ConsumerGroupExecutor createConsumerGroupExecutor(String brokerList, int numConsumers, String groupId, String topic) {
        ConsumerGroupExecutor executor = new ConsumerGroupExecutor(brokerList, numConsumers, groupId, topic);
        this.executors().$plus$eq((Object)executor);
        return executor;
    }

    /*
     * WARNING - void declaration
     */
    private ConsumerGroupCommand.KafkaConsumerGroupService createConsumerGroupService(ConsumerGroupCommand.ConsumerGroupCommandOptions opts) {
        void var2_2;
        ConsumerGroupCommand.KafkaConsumerGroupService service = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        this.consumerGroupServices().$plus$eq((Object)service);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsNewConsumerExistingTopic$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 50L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLocalDateTime$4(ResetConsumerGroupOffsetTest $this, String x$5) {
        String string = x$5;
        String string2 = $this.topic1();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLocalDateTime$3(ResetConsumerGroupOffsetTest $this, ConsumerGroupCommand.PartitionAssignmentState x$4) {
        return x$4.topic().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$4($this, x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLocalDateTime$5(ConsumerGroupCommand.PartitionAssignmentState x$6) {
        return x$6.offset().isDefined();
    }

    public static final /* synthetic */ long $anonfun$testResetOffsetsToLocalDateTime$6(ConsumerGroupCommand.PartitionAssignmentState assignment) {
        return BoxesRunTime.unboxToLong((Object)assignment.offset().get());
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLocalDateTime$10(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToZonedDateTime$4(ResetConsumerGroupOffsetTest $this, String x$10) {
        String string = x$10;
        String string2 = $this.topic1();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToZonedDateTime$3(ResetConsumerGroupOffsetTest $this, ConsumerGroupCommand.PartitionAssignmentState x$9) {
        return x$9.topic().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$4($this, x$10)));
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToZonedDateTime$5(ConsumerGroupCommand.PartitionAssignmentState x$11) {
        return x$11.offset().isDefined();
    }

    public static final /* synthetic */ long $anonfun$testResetOffsetsToZonedDateTime$6(ConsumerGroupCommand.PartitionAssignmentState assignment) {
        return BoxesRunTime.unboxToLong((Object)assignment.offset().get());
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToZonedDateTime$10(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 50L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsByDuration$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsByDurationToEarliest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 100L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLatest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 200L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToCurrentOffset$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 100L;
    }

    public static final /* synthetic */ boolean $anonfun$produceConsumeAndShutdown$4(String topic$1, String x$15) {
        String string = x$15;
        String string2 = topic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$produceConsumeAndShutdown$3(String topic$1, ConsumerGroupCommand.PartitionAssignmentState x$14) {
        return x$14.topic().exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$produceConsumeAndShutdown$4(topic$1, x$15)));
    }

    public static final /* synthetic */ boolean $anonfun$produceConsumeAndShutdown$5(ConsumerGroupCommand.PartitionAssignmentState x$16) {
        return x$16.offset().isDefined();
    }

    public static final /* synthetic */ long $anonfun$produceConsumeAndShutdown$6(ConsumerGroupCommand.PartitionAssignmentState assignment) {
        return BoxesRunTime.unboxToLong((Object)assignment.offset().get());
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToSpecificOffset$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 1L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsShiftPlus$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 150L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsShiftMinus$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 50L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsShiftByLowerThanEarliest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsShiftByHigherThanLatest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 200L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnOneTopic$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnOneTopicAndPartition$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L && ((TopicPartition)assignment._1()).partition() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnTopics$3(ResetConsumerGroupOffsetTest $this, Tuple2 assignment) {
        if (((OffsetAndMetadata)assignment._2()).offset() != 0L) return false;
        String string = ((TopicPartition)assignment._1()).topic();
        String string2 = $this.topic1();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnTopics$4(ResetConsumerGroupOffsetTest $this, Tuple2 assignment) {
        if (((OffsetAndMetadata)assignment._2()).offset() != 0L) return false;
        String string = ((TopicPartition)assignment._1()).topic();
        String string2 = $this.topic2();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnTopicsAndPartitions$3(ResetConsumerGroupOffsetTest $this, Tuple2 assignment) {
        if (((OffsetAndMetadata)assignment._2()).offset() != 0L) return false;
        if (((TopicPartition)assignment._1()).partition() != 1) return false;
        String string = ((TopicPartition)assignment._1()).topic();
        String string2 = $this.topic1();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnTopicsAndPartitions$4(ResetConsumerGroupOffsetTest $this, Tuple2 assignment) {
        if (((OffsetAndMetadata)assignment._2()).offset() != 0L) return false;
        if (((TopicPartition)assignment._1()).partition() != 1) return false;
        String string = ((TopicPartition)assignment._1()).topic();
        String string2 = $this.topic2();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsExportImportPlan$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsExportImportPlan$6(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
        this.group = "test.group";
    }
}

