/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.List;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.security.auth.Authorizer;
import kafka.server.AdminManager;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0001\u0003\u0001%\u0011QbS1gW\u0006\f\u0005/[:UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\u0011QAB\u0001\u0006W\u000647.\u0019\u0006\u0002\u000f\u0005!QO\\5u\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!\u0001C\u0004\u0017\u0001\t\u0007I\u0011B\f\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYV\t\u0001\u0004\u0005\u0002\u001a;5\t!D\u0003\u0002\u001c9\u00059a.\u001a;x_J\\'\"A\u0003\n\u0005yQ\"A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\u0007A\u0001\u0001\u000b\u0011\u0002\r\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002BqA\t\u0001C\u0002\u0013%1%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003\u0011\u0002\"!J\u0014\u000e\u0003\u0019R!a\u0001\u000f\n\u0005!2#A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0007U\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002Bq\u0001\f\u0001C\u0002\u0013%Q&\u0001\the>,\boQ8pe\u0012Lg.\u0019;peV\ta\u0006\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005)qM]8va*\u00111\u0007H\u0001\fG>|'\u000fZ5oCR|'/\u0003\u00026a\t\u0001rI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0005\u0007o\u0001\u0001\u000b\u0011\u0002\u0018\u0002#\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b\u0005C\u0004:\u0001\t\u0007I\u0011\u0002\u001e\u0002\u0019\u0005$W.\u001b8NC:\fw-\u001a:\u0016\u0003m\u0002\"!\n\u001f\n\u0005u2#\u0001D!e[&tW*\u00198bO\u0016\u0014\bBB \u0001A\u0003%1(A\u0007bI6Lg.T1oC\u001e,'\u000f\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u00039!\bP\\\"p_J$\u0017N\\1u_J,\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rJ\n1\u0002\u001e:b]N\f7\r^5p]&\u0011\u0001*\u0012\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\"1!\n\u0001Q\u0001\n\r\u000bq\u0002\u001e=o\u0007>|'\u000fZ5oCR|'\u000f\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0002\u001dB\u0011q*U\u0007\u0002!*\u0011A\nH\u0005\u0003%B\u0013qbS1gW\u0006\u001cuN\u001c;s_2dWM\u001d\u0005\u0007)\u0002\u0001\u000b\u0011\u0002(\u0002\u0017\r|g\u000e\u001e:pY2,'\u000f\t\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0003\u001dQ8.\u0016;jYN,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037r\tQ!\u001e;jYNL!!\u0018.\u0003\u000fi[W\u000b^5mg\"1q\f\u0001Q\u0001\na\u000b\u0001B_6Vi&d7\u000f\t\u0005\bC\u0002\u0011\r\u0011\"\u0003c\u00035iW\r^1eCR\f7)Y2iKV\t1\r\u0005\u0002&I&\u0011QM\n\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\t\r\u001d\u0004\u0001\u0015!\u0003d\u00039iW\r^1eCR\f7)Y2iK\u0002Bq!\u001b\u0001C\u0002\u0013%!.A\u0004nKR\u0014\u0018nY:\u0016\u0003-\u0004\"\u0001\\;\u000e\u00035T!!\u001b8\u000b\u0005=\u0004\u0018AB2p[6|gN\u0003\u0002\u0006c*\u0011!o]\u0001\u0007CB\f7\r[3\u000b\u0003Q\f1a\u001c:h\u0013\t1XNA\u0004NKR\u0014\u0018nY:\t\ra\u0004\u0001\u0015!\u0003l\u0003!iW\r\u001e:jGN\u0004\u0003b\u0002>\u0001\u0005\u0004%Ia_\u0001\tEJ|7.\u001a:JIV\tA\u0010\u0005\u0002\f{&\u0011a\u0010\u0004\u0002\u0004\u0013:$\bbBA\u0001\u0001\u0001\u0006I\u0001`\u0001\nEJ|7.\u001a:JI\u0002B\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\u0002\u0015\u0005,H\u000f[8sSj,'/\u0006\u0002\u0002\nA)1\"a\u0003\u0002\u0010%\u0019\u0011Q\u0002\u0007\u0003\r=\u0003H/[8o!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA!Y;uQ*\u0019\u0011\u0011\u0004\u000f\u0002\u0011M,7-\u001e:jifLA!!\b\u0002\u0014\tQ\u0011)\u001e;i_JL'0\u001a:\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003\u0013\t1\"Y;uQ>\u0014\u0018N_3sA!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011qE\u0001\u0013G2LWM\u001c;Rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002*A\u0019Q%a\u000b\n\u0007\u00055bE\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b\u0002CA\u0019\u0001\u0001\u0006I!!\u000b\u0002'\rd\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d\u0011\t\u0013\u0005U\u0002A1A\u0005\n\u0005]\u0012!G2mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ,\"!!\u000f\u0011\u0007\u0015\nY$C\u0002\u0002>\u0019\u0012\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe\"A\u0011\u0011\t\u0001!\u0002\u0013\tI$\u0001\u000edY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014\b\u0005C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002H\u0005\u0019\"/\u001a9mS\u000e\f\u0017+^8uC6\u000bg.Y4feV\u0011\u0011\u0011\n\t\u0004K\u0005-\u0013bAA'M\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002J\u0005!\"/\u001a9mS\u000e\f\u0017+^8uC6\u000bg.Y4fe\u0002B\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\u0002\rE,x\u000e^1t+\t\tI\u0006\u0005\u0003\u0002\\\u0005=d\u0002BA/\u0003WrA!a\u0018\u0002j9!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f!\ta\u0001\u0010:p_Rt\u0014\"A\u0003\n\u0005\ra\u0012bAA7M\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&!\u0011\u0011OA:\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0019\u0011Q\u000e\u0014\t\u0011\u0005]\u0004\u0001)A\u0005\u00033\nq!];pi\u0006\u001c\b\u0005C\u0005\u0002|\u0001\u0011\r\u0011\"\u0003\u0002~\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0003\u0003\u007f\u00022!JAA\u0013\r\t\u0019I\n\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biND\u0001\"a\"\u0001A\u0003%\u0011qP\u0001\u0012EJ|7.\u001a:U_BL7m\u0015;biN\u0004\u0003\"CAF\u0001\t\u0007I\u0011BAG\u0003%\u0019G.^:uKJLE-\u0006\u0002\u0002\u0010B!\u0011\u0011SAN\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u00027b]\u001eT!!!'\u0002\t)\fg/Y\u0005\u0005\u0003;\u000b\u0019J\u0001\u0004TiJLgn\u001a\u0005\t\u0003C\u0003\u0001\u0015!\u0003\u0002\u0010\u0006Q1\r\\;ti\u0016\u0014\u0018\n\u001a\u0011\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005\u001d\u0016\u0001\u0002;j[\u0016,\"!!+\u0011\u0007e\u000bY+C\u0002\u0002.j\u0013\u0001\"T8dWRKW.\u001a\u0005\t\u0003c\u0003\u0001\u0015!\u0003\u0002*\u0006)A/[7fA!9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016aD2sK\u0006$XmS1gW\u0006\f\u0005/[:\u0015\t\u0005e\u0016q\u0018\t\u0004K\u0005m\u0016bAA_M\tI1*\u00194lC\u0006\u0003\u0018n\u001d\u0005\t\u0003\u0003\f\u0019\f1\u0001\u0002D\u0006Q\u0012N\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]B!\u0011QYAf\u001b\t\t9MC\u0002\u0002Jr\t1!\u00199j\u0013\u0011\ti-a2\u0003\u0015\u0005\u0003\u0018NV3sg&|g\u000eC\u0004\u0002R\u0002!\t!a5\u0002MNDw.\u001e7e)\"\u0014xn^+ogV\u0004\bo\u001c:uK\u00124VM]:j_:,\u0005pY3qi&|gn\u00148IC:$G.Z!eI>3gm]3u)>$\u0006P\u001c*fcV,7\u000f^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u001d>$8+\u001e9q_J$X\r\u001a\u000b\u0003\u0003+\u00042aCAl\u0013\r\tI\u000e\u0004\u0002\u0005+:LG\u000f\u000b\u0005\u0002P\u0006u\u0017\u0011^Av!\u0011\ty.!:\u000e\u0005\u0005\u0005(bAArg\u0006)!.\u001e8ji&!\u0011q]Aq\u0005\u0011!Vm\u001d;\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!!<\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cT1!a=o\u0003\u0019)'O]8sg&!\u0011q_Ay\u0005m)fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\"9\u00111 \u0001\u0005\u0002\u0005M\u0017A[:i_VdG\r\u00165s_^,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]>s\u0007*\u00198eY\u0016\fE\r\u001a)beRLG/[8ogR{G\u000b\u001f8SKF,Xm\u001d;XQ\u0016t\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pY:{GoU;qa>\u0014H/\u001a3)\u0011\u0005e\u0018Q\\Au\u0003WDqA!\u0001\u0001\t\u0003\t\u0019.A4tQ>,H\u000e\u001a+ie><XK\\:vaB|'\u000f^3e-\u0016\u00148/[8o\u000bb\u001cW\r\u001d;j_:|e\u000eS1oI2,G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LGOU3rk\u0016\u001cHo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0005\u0002\u0000\u0006u\u0017\u0011^Av\u0011\u001d\u00119\u0001\u0001C\u0001\u0003'\fal\u001d5pk2$G\u000b\u001b:poVs7/\u001e9q_J$X\r\u001a,feNLwN\\#yG\u0016\u0004H/[8o\u001f:D\u0015M\u001c3mK\u0016sG\r\u0016=o%\u0016\fX/Z:u/\",g.\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2tu\u000e^*vaB|'\u000f^3eQ!\u0011)!!8\u0002j\u0006-\bb\u0002B\u0007\u0001\u0011\u0005\u00111[\u0001hg\"|W\u000f\u001c3UQJ|w/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016C8-\u001a9uS>twJ\u001c%b]\u0012dWm\u0016:ji\u0016$\u0006P\\'be.,'o\u001d*fcV,7\u000f^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u001d>$8+\u001e9q_J$X\r\u001a\u0015\t\u0005\u0017\ti.!;\u0002l\"9!1\u0003\u0001\u0005\u0002\u0005M\u0017!X:i_VdGMU3ta>tGmV5uQVs7/\u001e9q_J$X\r\u001a$pe6+7o]1hK\u001a{'/\\1u\u001f:D\u0015M\u001c3mK^\u0013\u0018\u000e^3Uq:l\u0015M]6feN<\u0006.\u001a8NC\u001eL7\rT8xKJ$\u0006.\u00198SKF,\u0018N]3eQ\u0011\u0011\t\"!8\t\u000f\te\u0001\u0001\"\u0001\u0002T\u0006\u00196\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$W*Z:tC\u001e,gi\u001c:nCR4uN\u001d\"bIB\u000b'\u000f^5uS>t\u0017I\u001c3O_\u0016\u0013(o\u001c:t\r>\u0014xi\\8e!\u0006\u0014H/\u001b;j_:DCAa\u0006\u0002^\"9!q\u0004\u0001\u0005\u0002\u0005M\u0017!O:i_VdG-\u00119qK:$Gk\u001c'pO>swK]5uKRCh.T1sW\u0016\u00148o\u00165f]\u000e{'O]3di6\u000bw-[2WKJ\u001c\u0018n\u001c8)\t\tu\u0011Q\u001c\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0003q\u0019'/Z1uK^\u0013\u0018\u000e^3Uq:l\u0015M]6feN\u0014V-];fgR$BA!\u000b\u0003JA91Ba\u000b\u00030\tm\u0012b\u0001B\u0017\u0019\t1A+\u001e9mKJ\u0002BA!\r\u000385\u0011!1\u0007\u0006\u0004\u0005kq\u0017\u0001\u0003:fcV,7\u000f^:\n\t\te\"1\u0007\u0002\u0017/JLG/\u001a+y]6\u000b'o[3sgJ+\u0017/^3tiB!!Q\bB\"\u001d\rI\"qH\u0005\u0004\u0005\u0003R\u0012A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0005\u000b\u00129EA\u0004SKF,Xm\u001d;\u000b\u0007\t\u0005#\u0004\u0003\u0005\u0003L\t\r\u0002\u0019\u0001B'\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0005\u001f\u0012)F!\u0017\u000e\u0005\tE#\u0002\u0002B*\u0003/\u000bA!\u001e;jY&!!q\u000bB)\u0005\u0011a\u0015n\u001d;\u0011\t\tm#QL\u0007\u0002]&\u0019!q\f8\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0002")
public class KafkaApisTest {
    private final RequestChannel requestChannel = (RequestChannel)EasyMock.createNiceMock(RequestChannel.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)EasyMock.createNiceMock(GroupCoordinator.class);
    private final AdminManager adminManager = (AdminManager)EasyMock.createNiceMock(AdminManager.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)EasyMock.createNiceMock(TransactionCoordinator.class);
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final Option<Authorizer> authorizer = None$.MODULE$;
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)EasyMock.createNiceMock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)EasyMock.createNiceMock(ClientRequestQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager());
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final String clusterId;
    private final MockTime time = new MockTime();

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private AdminManager adminManager() {
        return this.adminManager;
    }

    private TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private String clusterId() {
        return this.clusterId;
    }

    private MockTime time() {
        return this.time;
    }

    public KafkaApis createKafkaApis(ApiVersion interBrokerProtocolVersion) {
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        properties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerProtocolVersion.toString());
        properties.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), interBrokerProtocolVersion.toString());
        return new KafkaApis(this.requestChannel(), this.replicaManager(), this.adminManager(), this.groupCoordinator(), this.txnCoordinator(), this.controller(), this.zkUtils(), this.brokerId(), new KafkaConfig((java.util.Map)properties), this.metadataCache(), this.metrics(), this.authorizer(), this.quotas(), this.brokerTopicStats(), this.clusterId(), (Time)this.time());
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddOffsetToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddOffsetsToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddPartitionsToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleTxnOffsetCommitRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleEndTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleEndTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleWriteTxnMarkersRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleWriteTxnMarkersRequest(null);
    }

    @Test
    public void shouldRespondWithUnsupportedForMessageFormatOnHandleWriteTxnMarkersWhenMagicLowerThanRequired() {
        WriteTxnMarkersRequest writeTxnMarkersRequest;
        RequestChannel.Request request;
        TopicPartition topicPartition;
        block3: {
            Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2;
            block2: {
                topicPartition = new TopicPartition("t", 0);
                tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}));
                if (tuple2 == null) break block2;
                WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple2._1();
                request = (RequestChannel.Request)tuple2._2();
                if (writeTxnMarkersRequest2 == null) break block2;
                writeTxnMarkersRequest = writeTxnMarkersRequest2;
                if (request != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        RequestChannel.Request request2 = request;
        Tuple2 tuple2 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request2);
        Tuple2 tuple22 = tuple2;
        WriteTxnMarkersRequest writeTxnMarkersRequest3 = (WriteTxnMarkersRequest)tuple22._1();
        RequestChannel.Request request3 = (RequestChannel.Request)tuple22._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis((ApiVersion)KAFKA_0_11_0_IV0$.MODULE$).handleWriteTxnMarkersRequest(request3);
        Send send = (Send)((RequestChannel.Response)capturedResponse.getValue()).responseSend().get();
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        channel.buffer().getInt();
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)channel.buffer());
        Struct struct = ApiKeys.WRITE_TXN_MARKERS.responseSchema(writeTxnMarkersRequest3.version()).read(channel.buffer());
        WriteTxnMarkersResponse markersResponse = new WriteTxnMarkersResponse(struct);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnsupportedMessageFormatForBadPartitionAndNoErrorsForGoodPartition() {
        WriteTxnMarkersRequest writeTxnMarkersRequest;
        RequestChannel.Request request;
        TopicPartition tp2;
        TopicPartition tp1;
        block3: {
            Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2;
            block2: {
                tp1 = new TopicPartition("t", 0);
                tp2 = new TopicPartition("t1", 0);
                tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{tp1, tp2}));
                if (tuple2 == null) break block2;
                WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple2._1();
                request = (RequestChannel.Request)tuple2._2();
                if (writeTxnMarkersRequest2 == null) break block2;
                writeTxnMarkersRequest = writeTxnMarkersRequest2;
                if (request != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        RequestChannel.Request request2 = request;
        Tuple2 tuple2 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request2);
        Tuple2 tuple22 = tuple2;
        WriteTxnMarkersRequest writeTxnMarkersRequest3 = (WriteTxnMarkersRequest)tuple22._1();
        RequestChannel.Request request3 = (RequestChannel.Request)tuple22._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, tp2, responseCallback){
            private final TopicPartition tp2$1;
            private final Capture responseCallback$1;

            public void answer() {
                ((Function1)this.responseCallback$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$1), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.tp2$1 = tp2$1;
                this.responseCallback$1 = responseCallback$1;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis((ApiVersion)KAFKA_0_11_0_IV0$.MODULE$).handleWriteTxnMarkersRequest(request3);
        Send send = (Send)((RequestChannel.Response)capturedResponse.getValue()).responseSend().get();
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        channel.buffer().getInt();
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)channel.buffer());
        Struct struct = ApiKeys.WRITE_TXN_MARKERS.responseSchema(writeTxnMarkersRequest3.version()).read(channel.buffer());
        WriteTxnMarkersResponse markersResponse = new WriteTxnMarkersResponse(struct);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldAppendToLogOnWriteTxnMarkersWhenCorrectMagicVersion() {
        WriteTxnMarkersRequest writeTxnMarkersRequest;
        RequestChannel.Request request;
        TopicPartition topicPartition;
        block3: {
            Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2;
            block2: {
                topicPartition = new TopicPartition("t", 0);
                tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}));
                if (tuple2 == null) break block2;
                WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple2._1();
                request = (RequestChannel.Request)tuple2._2();
                if (writeTxnMarkersRequest2 == null) break block2;
                writeTxnMarkersRequest = writeTxnMarkersRequest2;
                if (request != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        RequestChannel.Request request2 = request;
        Tuple2 tuple2 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request2);
        Tuple2 tuple22 = tuple2;
        WriteTxnMarkersRequest writeTxnMarkersRequest3 = (WriteTxnMarkersRequest)tuple22._1();
        RequestChannel.Request request3 = (RequestChannel.Request)tuple22._2();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (Option)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.createKafkaApis((ApiVersion)KAFKA_0_11_0_IV0$.MODULE$).handleWriteTxnMarkersRequest(request3);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    private Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> createWriteTxnMarkersRequest(List<TopicPartition> partitions) {
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Utils.mkList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(1L, (short)1, 0, TransactionResult.COMMIT, partitions)})).build();
        RequestHeader header = new RequestHeader(ApiKeys.WRITE_TXN_MARKERS.id, writeTxnMarkersRequest.version(), "", 0);
        ByteBuffer byteBuffer = writeTxnMarkersRequest.serialize(header);
        RequestChannel.Request request = new RequestChannel.Request(1, "1", new RequestChannel.Session(KafkaPrincipal.ANONYMOUS, InetAddress.getLocalHost()), byteBuffer, 0L, new ListenerName(""), SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
    }

    public KafkaApisTest() {
        this.brokerId = 1;
        this.clusterId = "clusterId";
    }
}

