/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.ThroughputThrottler;

public class VerifiableProducer {
    String topic;
    private Producer<String, String> producer;
    private long maxMessages = -1L;
    private long numAcked = 0L;
    private long numSent = 0L;
    private long throughput;
    private boolean stopProducing = false;
    private Integer valuePrefix;

    public VerifiableProducer(Properties producerProps, String topic, int throughput, int maxMessages, Integer valuePrefix) {
        this.topic = topic;
        this.throughput = throughput;
        this.maxMessages = maxMessages;
        this.producer = new KafkaProducer(producerProps);
        this.valuePrefix = valuePrefix;
    }

    private static ArgumentParser argParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"verifiable-producer").defaultHelp(true).description("This tool produces increasing integers to the specified topic and prints JSON metadata to stdout on each \"send\" request, making externally visible which messages have been acked and which have not.");
        parser.addArgument(new String[]{"--topic"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).metavar(new String[]{"TOPIC"}).help("Produce messages to this topic.");
        parser.addArgument(new String[]{"--broker-list"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).metavar(new String[]{"HOST1:PORT1[,HOST2:PORT2[...]]"}).dest("brokerList").help("Comma-separated list of Kafka brokers in the form HOST1:PORT1,HOST2:PORT2,...");
        parser.addArgument(new String[]{"--max-messages"}).action((ArgumentAction)Arguments.store()).required(false).setDefault((Object)-1).type(Integer.class).metavar(new String[]{"MAX-MESSAGES"}).dest("maxMessages").help("Produce this many messages. If -1, produce messages until the process is killed externally.");
        parser.addArgument(new String[]{"--throughput"}).action((ArgumentAction)Arguments.store()).required(false).setDefault((Object)-1).type(Integer.class).metavar(new String[]{"THROUGHPUT"}).help("If set >= 0, throttle maximum message throughput to *approximately* THROUGHPUT messages/sec.");
        parser.addArgument(new String[]{"--acks"}).action((ArgumentAction)Arguments.store()).required(false).setDefault((Object)-1).type(Integer.class).choices((Object[])new Integer[]{0, 1, -1}).metavar(new String[]{"ACKS"}).help("Acks required on each produced message. See Kafka docs on request.required.acks for details.");
        parser.addArgument(new String[]{"--producer.config"}).action((ArgumentAction)Arguments.store()).required(false).type(String.class).metavar(new String[]{"CONFIG_FILE"}).help("Producer config properties file.");
        parser.addArgument(new String[]{"--value-prefix"}).action((ArgumentAction)Arguments.store()).required(false).type(Integer.class).metavar(new String[]{"VALUE-PREFIX"}).dest("valuePrefix").help("If specified, each produced value will have this prefix with a dot separator");
        return parser;
    }

    public static Properties loadProps(String filename) throws IOException, FileNotFoundException {
        Properties props = new Properties();
        try (FileInputStream propStream = new FileInputStream(filename);){
            props.load(propStream);
        }
        return props;
    }

    public static VerifiableProducer createFromArgs(String[] args) {
        ArgumentParser parser = VerifiableProducer.argParser();
        VerifiableProducer producer = null;
        try {
            Namespace res = parser.parseArgs(args);
            int maxMessages = res.getInt("maxMessages");
            String topic = res.getString("topic");
            int throughput = res.getInt("throughput");
            String configFile = res.getString("producer.config");
            Integer valuePrefix = res.getInt("valuePrefix");
            Properties producerProps = new Properties();
            producerProps.put("bootstrap.servers", res.getString("brokerList"));
            producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            producerProps.put("acks", Integer.toString(res.getInt("acks")));
            producerProps.put("retries", "0");
            if (configFile != null) {
                try {
                    producerProps.putAll((Map<?, ?>)VerifiableProducer.loadProps(configFile));
                }
                catch (IOException e) {
                    throw new ArgumentParserException(e.getMessage(), parser);
                }
            }
            producer = new VerifiableProducer(producerProps, topic, throughput, maxMessages, valuePrefix);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String key, String value) {
        ProducerRecord record = new ProducerRecord(this.topic, (Object)key, (Object)value);
        ++this.numSent;
        try {
            this.producer.send(record, (Callback)new PrintInfoCallback(key, value));
        }
        catch (Exception e) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println(this.errorString(e, key, value, System.currentTimeMillis()));
            }
        }
    }

    public String getValue(long val) {
        if (this.valuePrefix != null) {
            return String.format("%d.%d", this.valuePrefix, val);
        }
        return String.format("%d", val);
    }

    public void close() {
        this.producer.close();
        System.out.println(this.shutdownString());
    }

    String shutdownString() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", "shutdown_complete");
        return this.toJsonString(data);
    }

    String startupString() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", "startup_complete");
        return this.toJsonString(data);
    }

    String errorString(Exception e, String key, String value, Long nowMs) {
        assert (e != null) : "Expected non-null exception.";
        HashMap<String, Object> errorData = new HashMap<String, Object>();
        errorData.put("name", "producer_send_error");
        errorData.put("time_ms", nowMs);
        errorData.put("exception", e.getClass().toString());
        errorData.put("message", e.getMessage());
        errorData.put("topic", this.topic);
        errorData.put("key", key);
        errorData.put("value", value);
        return this.toJsonString(errorData);
    }

    String successString(RecordMetadata recordMetadata, String key, String value, Long nowMs) {
        assert (recordMetadata != null) : "Expected non-null recordMetadata object.";
        HashMap<String, Object> successData = new HashMap<String, Object>();
        successData.put("name", "producer_send_success");
        successData.put("time_ms", nowMs);
        successData.put("topic", this.topic);
        successData.put("partition", recordMetadata.partition());
        successData.put("offset", recordMetadata.offset());
        successData.put("key", key);
        successData.put("value", value);
        return this.toJsonString(successData);
    }

    private String toJsonString(Map<String, Object> data) {
        String json;
        try {
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            json = "Bad data can't be written as json: " + e.getMessage();
        }
        return json;
    }

    public static void main(String[] args) throws IOException {
        final VerifiableProducer producer = VerifiableProducer.createFromArgs(args);
        final long startMs = System.currentTimeMillis();
        boolean infinite = producer.maxMessages < 0L;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                producer.stopProducing = true;
                producer.close();
                long stopMs = System.currentTimeMillis();
                double avgThroughput = 1000.0 * ((double)producer.numAcked / (double)(stopMs - startMs));
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("name", "tool_data");
                data.put("sent", producer.numSent);
                data.put("acked", producer.numAcked);
                data.put("target_throughput", producer.throughput);
                data.put("avg_throughput", avgThroughput);
                System.out.println(producer.toJsonString(data));
            }
        });
        ThroughputThrottler throttler = new ThroughputThrottler(producer.throughput, startMs);
        System.out.println(producer.startupString());
        long maxMessages = infinite ? Long.MAX_VALUE : producer.maxMessages;
        for (long i = 0L; i < maxMessages && !producer.stopProducing; ++i) {
            long sendStartMs = System.currentTimeMillis();
            producer.send(null, producer.getValue(i));
            if (!throttler.shouldThrottle(i, sendStartMs)) continue;
            throttler.throttle();
        }
    }

    private class PrintInfoCallback
    implements Callback {
        private String key;
        private String value;

        PrintInfoCallback(String key, String value) {
            this.key = key;
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                if (e == null) {
                    VerifiableProducer.this.numAcked++;
                    System.out.println(VerifiableProducer.this.successString(recordMetadata, this.key, this.value, System.currentTimeMillis()));
                } else {
                    System.out.println(VerifiableProducer.this.errorString(e, this.key, this.value, System.currentTimeMillis()));
                }
            }
        }
    }
}

