/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.processor.TopologyBuilder;

public class WordCountDemo {
    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.put("application.id", "streams-wordcount");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("cache.max.bytes.buffering", (Object)0);
        props.put("default.key.serde", Serdes.String().getClass().getName());
        props.put("default.value.serde", Serdes.String().getClass().getName());
        props.put("auto.offset.reset", "earliest");
        KStreamBuilder builder = new KStreamBuilder();
        KStream source = builder.stream(new String[]{"streams-file-input"});
        KTable counts = source.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<String>>(){

            public Iterable<String> apply(String value) {
                return Arrays.asList(value.toLowerCase(Locale.getDefault()).split(" "));
            }
        }).map((KeyValueMapper)new KeyValueMapper<String, String, KeyValue<String, String>>(){

            public KeyValue<String, String> apply(String key, String value) {
                return new KeyValue((Object)value, (Object)value);
            }
        }).groupByKey().count("Counts");
        counts.to(Serdes.String(), Serdes.Long(), "streams-wordcount-output");
        KafkaStreams streams = new KafkaStreams((TopologyBuilder)builder, props);
        streams.start();
        Thread.sleep(5000L);
        streams.close();
    }
}

