/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;

class KStreamFilter<K, V>
implements ProcessorSupplier<K, V> {
    private final Predicate<K, V> predicate;
    private final boolean filterNot;

    public KStreamFilter(Predicate<K, V> predicate, boolean filterNot) {
        this.predicate = predicate;
        this.filterNot = filterNot;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamFilterProcessor();
    }

    private class KStreamFilterProcessor
    extends AbstractProcessor<K, V> {
        private KStreamFilterProcessor() {
        }

        @Override
        public void process(K key, V value) {
            if (KStreamFilter.this.filterNot ^ KStreamFilter.this.predicate.test(key, value)) {
                this.context().forward(key, value);
            }
        }
    }
}

