/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.PrintForeachAction;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KGroupedTableImpl;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KStreamMapValues;
import org.apache.kafka.streams.kstream.internals.KStreamPeek;
import org.apache.kafka.streams.kstream.internals.KStreamPrint;
import org.apache.kafka.streams.kstream.internals.KTableFilter;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableJoinMerger;
import org.apache.kafka.streams.kstream.internals.KTableKTableLeftJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableOuterJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableRightJoin;
import org.apache.kafka.streams.kstream.internals.KTableMapValues;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableRepartitionMap;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.KTableSourceValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.state.KeyValueStore;

public class KTableImpl<K, S, V>
extends AbstractStream<K>
implements KTable<K, V> {
    private static final String FILTER_NAME = "KTABLE-FILTER-";
    private static final String FOREACH_NAME = "KTABLE-FOREACH-";
    public static final String JOINTHIS_NAME = "KTABLE-JOINTHIS-";
    public static final String JOINOTHER_NAME = "KTABLE-JOINOTHER-";
    private static final String MAPVALUES_NAME = "KTABLE-MAPVALUES-";
    public static final String MERGE_NAME = "KTABLE-MERGE-";
    private static final String PRINTING_NAME = "KSTREAM-PRINTER-";
    private static final String SELECT_NAME = "KTABLE-SELECT-";
    public static final String SOURCE_NAME = "KTABLE-SOURCE-";
    private static final String TOSTREAM_NAME = "KTABLE-TOSTREAM-";
    public static final String STATE_STORE_NAME = "STATE-STORE-";
    private final ProcessorSupplier<?, ?> processorSupplier;
    private final String queryableStoreName;
    private final boolean isQueryable;
    private boolean sendOldValues = false;
    private final Serde<K> keySerde;
    private final Serde<V> valSerde;

    public KTableImpl(KStreamBuilder topology, String name, ProcessorSupplier<?, ?> processorSupplier, Set<String> sourceNodes, String queryableStoreName, boolean isQueryable) {
        super(topology, name, sourceNodes);
        this.processorSupplier = processorSupplier;
        this.queryableStoreName = queryableStoreName;
        this.keySerde = null;
        this.valSerde = null;
        this.isQueryable = isQueryable;
    }

    public KTableImpl(KStreamBuilder topology, String name, ProcessorSupplier<?, ?> processorSupplier, Serde<K> keySerde, Serde<V> valSerde, Set<String> sourceNodes, String queryableStoreName, boolean isQueryable) {
        super(topology, name, sourceNodes);
        this.processorSupplier = processorSupplier;
        this.queryableStoreName = queryableStoreName;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.isQueryable = isQueryable;
    }

    @Override
    public String queryableStoreName() {
        if (!this.isQueryable) {
            return null;
        }
        return this.queryableStoreName;
    }

    String internalStoreName() {
        return this.queryableStoreName;
    }

    private KTable<K, V> doFilter(Predicate<? super K, ? super V> predicate, StateStoreSupplier<KeyValueStore> storeSupplier, boolean isFilterNot) {
        Objects.requireNonNull(predicate, "predicate can't be null");
        String name = this.topology.newName(FILTER_NAME);
        String internalStoreName = null;
        if (storeSupplier != null) {
            internalStoreName = storeSupplier.name();
        }
        KTableFilter<? super K, ? super V> processorSupplier = new KTableFilter<K, V>(this, predicate, isFilterNot, internalStoreName);
        this.topology.addProcessor(name, processorSupplier, this.name);
        if (storeSupplier != null) {
            this.topology.addStateStore(storeSupplier, name);
        }
        return new KTableImpl<K, S, V>(this.topology, name, processorSupplier, this.keySerde, this.valSerde, this.sourceNodes, internalStoreName, internalStoreName != null);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate) {
        return this.filter(predicate, (String)null);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate, String queryableStoreName) {
        StateStoreSupplier<KeyValueStore> storeSupplier = null;
        if (queryableStoreName != null) {
            storeSupplier = KTableImpl.keyValueStore(this.keySerde, this.valSerde, queryableStoreName);
        }
        return this.doFilter(predicate, storeSupplier, false);
    }

    @Override
    public KTable<K, V> filter(Predicate<? super K, ? super V> predicate, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doFilter(predicate, storeSupplier, false);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate) {
        return this.filterNot(predicate, (String)null);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate, String queryableStoreName) {
        StateStoreSupplier<KeyValueStore> storeSupplier = null;
        if (queryableStoreName != null) {
            storeSupplier = KTableImpl.keyValueStore(this.keySerde, this.valSerde, queryableStoreName);
        }
        return this.doFilter(predicate, storeSupplier, true);
    }

    @Override
    public KTable<K, V> filterNot(Predicate<? super K, ? super V> predicate, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doFilter(predicate, storeSupplier, true);
    }

    private <V1> KTable<K, V1> doMapValues(ValueMapper<? super V, ? extends V1> mapper, Serde<V1> valueSerde, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(mapper);
        String name = this.topology.newName(MAPVALUES_NAME);
        String internalStoreName = null;
        if (storeSupplier != null) {
            internalStoreName = storeSupplier.name();
        }
        KTableMapValues processorSupplier = new KTableMapValues(this, mapper, internalStoreName);
        this.topology.addProcessor(name, processorSupplier, this.name);
        if (storeSupplier != null) {
            this.topology.addStateStore(storeSupplier, name);
            return new KTableImpl<K, S, V1>(this.topology, name, processorSupplier, this.keySerde, valueSerde, this.sourceNodes, internalStoreName, true);
        }
        return new KTableImpl<K, S, V>(this.topology, name, processorSupplier, this.sourceNodes, this.queryableStoreName, false);
    }

    @Override
    public <V1> KTable<K, V1> mapValues(ValueMapper<? super V, ? extends V1> mapper) {
        return this.mapValues(mapper, (Serde<V1>)null, (String)null);
    }

    @Override
    public <V1> KTable<K, V1> mapValues(ValueMapper<? super V, ? extends V1> mapper, Serde<V1> valueSerde, String queryableStoreName) {
        StateStoreSupplier<KeyValueStore> storeSupplier = null;
        if (queryableStoreName != null) {
            storeSupplier = KTableImpl.keyValueStore(this.keySerde, valueSerde, queryableStoreName);
        }
        return this.doMapValues(mapper, valueSerde, storeSupplier);
    }

    @Override
    public <V1> KTable<K, V1> mapValues(ValueMapper<? super V, ? extends V1> mapper, Serde<V1> valueSerde, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doMapValues(mapper, valueSerde, storeSupplier);
    }

    @Override
    public void print() {
        this.print(null, null, null);
    }

    @Override
    public void print(String streamName) {
        this.print(null, null, streamName);
    }

    @Override
    public void print(Serde<K> keySerde, Serde<V> valSerde) {
        this.print(keySerde, valSerde, null);
    }

    @Override
    public void print(Serde<K> keySerde, Serde<V> valSerde, String streamName) {
        String name = this.topology.newName(PRINTING_NAME);
        streamName = streamName == null ? this.name : streamName;
        this.topology.addProcessor(name, new KStreamPrint(new PrintForeachAction(null, streamName), keySerde, valSerde), this.name);
    }

    @Override
    public void writeAsText(String filePath) {
        this.writeAsText(filePath, null, null, null);
    }

    @Override
    public void writeAsText(String filePath, String streamName) {
        this.writeAsText(filePath, streamName, null, null);
    }

    @Override
    public void writeAsText(String filePath, Serde<K> keySerde, Serde<V> valSerde) {
        this.writeAsText(filePath, null, keySerde, valSerde);
    }

    @Override
    public void writeAsText(String filePath, String streamName, Serde<K> keySerde, Serde<V> valSerde) {
        Objects.requireNonNull(filePath, "filePath can't be null");
        if (filePath.trim().isEmpty()) {
            throw new TopologyBuilderException("filePath can't be an empty string");
        }
        String name = this.topology.newName(PRINTING_NAME);
        streamName = streamName == null ? this.name : streamName;
        try {
            PrintWriter printWriter = new PrintWriter(filePath, StandardCharsets.UTF_8.name());
            this.topology.addProcessor(name, new KStreamPrint(new PrintForeachAction(printWriter, streamName), keySerde, valSerde), this.name);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            String message = "Unable to write stream to file at [" + filePath + "] " + e.getMessage();
            throw new TopologyBuilderException(message);
        }
    }

    @Override
    public void foreach(final ForeachAction<? super K, ? super V> action) {
        Objects.requireNonNull(action, "action can't be null");
        String name = this.topology.newName(FOREACH_NAME);
        KStreamPeek processorSupplier = new KStreamPeek(new ForeachAction<K, Change<V>>(){

            @Override
            public void apply(K key, Change<V> value) {
                action.apply(key, value.newValue);
            }
        }, false);
        this.topology.addProcessor(name, processorSupplier, this.name);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<? super K, ? super V> partitioner, String topic, String queryableStoreName) {
        String internalStoreName = queryableStoreName != null ? queryableStoreName : this.topology.newStoreName(TOSTREAM_NAME);
        this.to(keySerde, valSerde, partitioner, topic);
        return this.topology.table(keySerde, valSerde, topic, internalStoreName);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<? super K, ? super V> partitioner, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        this.to(keySerde, valSerde, partitioner, topic);
        return this.topology.table(keySerde, valSerde, topic, storeSupplier);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<? super K, ? super V> partitioner, String topic) {
        return this.through(keySerde, valSerde, partitioner, topic, (String)null);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, String topic, String queryableStoreName) {
        return this.through(keySerde, valSerde, null, topic, queryableStoreName);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.through(keySerde, valSerde, null, topic, storeSupplier);
    }

    @Override
    public KTable<K, V> through(Serde<K> keySerde, Serde<V> valSerde, String topic) {
        return this.through(keySerde, valSerde, null, topic, (String)null);
    }

    @Override
    public KTable<K, V> through(StreamPartitioner<? super K, ? super V> partitioner, String topic, String queryableStoreName) {
        return this.through(null, null, partitioner, topic, queryableStoreName);
    }

    @Override
    public KTable<K, V> through(StreamPartitioner<? super K, ? super V> partitioner, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.through(null, null, partitioner, topic, storeSupplier);
    }

    @Override
    public KTable<K, V> through(StreamPartitioner<? super K, ? super V> partitioner, String topic) {
        return this.through(null, null, partitioner, topic, (String)null);
    }

    @Override
    public KTable<K, V> through(String topic, String queryableStoreName) {
        return this.through(null, null, null, topic, queryableStoreName);
    }

    @Override
    public KTable<K, V> through(String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.through(null, null, null, topic, storeSupplier);
    }

    @Override
    public KTable<K, V> through(String topic) {
        return this.through(null, null, null, topic, (String)null);
    }

    @Override
    public void to(String topic) {
        this.to(null, null, null, topic);
    }

    @Override
    public void to(StreamPartitioner<? super K, ? super V> partitioner, String topic) {
        this.to(null, null, partitioner, topic);
    }

    @Override
    public void to(Serde<K> keySerde, Serde<V> valSerde, String topic) {
        this.toStream().to(keySerde, valSerde, null, topic);
    }

    @Override
    public void to(Serde<K> keySerde, Serde<V> valSerde, StreamPartitioner<? super K, ? super V> partitioner, String topic) {
        this.toStream().to(keySerde, valSerde, partitioner, topic);
    }

    @Override
    public KStream<K, V> toStream() {
        String name = this.topology.newName(TOSTREAM_NAME);
        this.topology.addProcessor(name, new KStreamMapValues(new ValueMapper<Change<V>, V>(){

            @Override
            public V apply(Change<V> change) {
                return change.newValue;
            }
        }), this.name);
        return new KStreamImpl(this.topology, name, this.sourceNodes, false);
    }

    @Override
    public <K1> KStream<K1, V> toStream(KeyValueMapper<? super K, ? super V, ? extends K1> mapper) {
        return this.toStream().selectKey(mapper);
    }

    @Override
    public <V1, R> KTable<K, R> join(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, false, false, null, null);
    }

    @Override
    public <V1, R> KTable<K, R> join(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, Serde<R> joinSerde, String queryableStoreName) {
        return this.doJoin(other, joiner, false, false, joinSerde, queryableStoreName);
    }

    @Override
    public <V1, R> KTable<K, R> join(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doJoin(other, joiner, false, false, storeSupplier);
    }

    @Override
    public <V1, R> KTable<K, R> outerJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, true, true, null, null);
    }

    @Override
    public <V1, R> KTable<K, R> outerJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, Serde<R> joinSerde, String queryableStoreName) {
        return this.doJoin(other, joiner, true, true, joinSerde, queryableStoreName);
    }

    @Override
    public <V1, R> KTable<K, R> outerJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doJoin(other, joiner, true, true, storeSupplier);
    }

    @Override
    public <V1, R> KTable<K, R> leftJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner) {
        return this.doJoin(other, joiner, true, false, null, null);
    }

    @Override
    public <V1, R> KTable<K, R> leftJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, Serde<R> joinSerde, String queryableStoreName) {
        return this.doJoin(other, joiner, true, false, joinSerde, queryableStoreName);
    }

    @Override
    public <V1, R> KTable<K, R> leftJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doJoin(other, joiner, true, false, storeSupplier);
    }

    private <V1, R> KTable<K, R> doJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, boolean leftOuter, boolean rightOuter, Serde<R> joinSerde, String queryableStoreName) {
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        StateStoreSupplier<KeyValueStore> storeSupplier = queryableStoreName == null ? null : KTableImpl.keyValueStore(this.keySerde, joinSerde, queryableStoreName);
        return this.doJoin(other, joiner, leftOuter, rightOuter, storeSupplier);
    }

    private <V1, R> KTable<K, R> doJoin(KTable<K, V1> other, ValueJoiner<? super V, ? super V1, ? extends R> joiner, boolean leftOuter, boolean rightOuter, StateStoreSupplier<KeyValueStore> storeSupplier) {
        KTableKTableAbstractJoin joinOther;
        KTableKTableAbstractJoin joinThis;
        Objects.requireNonNull(other, "other can't be null");
        Objects.requireNonNull(joiner, "joiner can't be null");
        String internalQueryableName = storeSupplier == null ? null : storeSupplier.name();
        Set<String> allSourceNodes = this.ensureJoinableWith((AbstractStream)((Object)other));
        if (leftOuter) {
            this.enableSendingOldValues();
        }
        if (rightOuter) {
            ((KTableImpl)other).enableSendingOldValues();
        }
        String joinThisName = this.topology.newName(JOINTHIS_NAME);
        String joinOtherName = this.topology.newName(JOINOTHER_NAME);
        String joinMergeName = this.topology.newName(MERGE_NAME);
        if (!leftOuter) {
            joinThis = new KTableKTableJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        } else if (!rightOuter) {
            joinThis = new KTableKTableLeftJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableRightJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        } else {
            joinThis = new KTableKTableOuterJoin(this, (KTableImpl)other, joiner);
            joinOther = new KTableKTableOuterJoin((KTableImpl)other, this, KTableImpl.reverseJoiner(joiner));
        }
        KTableKTableJoinMerger<K, V> joinMerge = new KTableKTableJoinMerger<K, V>(new KTableImpl<K, S, V>(this.topology, joinThisName, joinThis, this.sourceNodes, this.internalStoreName(), false), new KTableImpl<K, S, V>(this.topology, joinOtherName, joinOther, ((KTableImpl)other).sourceNodes, ((KTableImpl)other).internalStoreName(), false), internalQueryableName);
        this.topology.addProcessor(joinThisName, joinThis, this.name);
        this.topology.addProcessor(joinOtherName, joinOther, ((KTableImpl)other).name);
        this.topology.addProcessor(joinMergeName, joinMerge, joinThisName, joinOtherName);
        this.topology.connectProcessorAndStateStores(joinThisName, ((KTableImpl)other).valueGetterSupplier().storeNames());
        this.topology.connectProcessorAndStateStores(joinOtherName, this.valueGetterSupplier().storeNames());
        if (internalQueryableName != null) {
            this.topology.addStateStore(storeSupplier, joinMergeName);
        }
        return new KTableImpl<K, S, V>(this.topology, joinMergeName, joinMerge, allSourceNodes, internalQueryableName, internalQueryableName != null);
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> selector, Serde<K1> keySerde, Serde<V1> valueSerde) {
        Objects.requireNonNull(selector, "selector can't be null");
        String selectName = this.topology.newName(SELECT_NAME);
        KTableRepartitionMap<? super K, ? super V, K1, V1> selectSupplier = new KTableRepartitionMap<K, V, K1, V1>(this, selector);
        this.topology.addProcessor(selectName, selectSupplier, this.name);
        this.enableSendingOldValues();
        return new KGroupedTableImpl<K1, V1>(this.topology, selectName, this.name, keySerde, valueSerde);
    }

    @Override
    public <K1, V1> KGroupedTable<K1, V1> groupBy(KeyValueMapper<? super K, ? super V, KeyValue<K1, V1>> selector) {
        return this.groupBy(selector, (Serde<K1>)null, (Serde<V1>)null);
    }

    KTableValueGetterSupplier<K, V> valueGetterSupplier() {
        if (this.processorSupplier instanceof KTableSource) {
            KTableSource source = (KTableSource)this.processorSupplier;
            return new KTableSourceValueGetterSupplier(source.storeName);
        }
        if (this.processorSupplier instanceof KStreamAggProcessorSupplier) {
            return ((KStreamAggProcessorSupplier)this.processorSupplier).view();
        }
        return ((KTableProcessorSupplier)this.processorSupplier).view();
    }

    void enableSendingOldValues() {
        if (!this.sendOldValues) {
            if (this.processorSupplier instanceof KTableSource) {
                KTableSource source = (KTableSource)this.processorSupplier;
                source.enableSendingOldValues();
            } else if (this.processorSupplier instanceof KStreamAggProcessorSupplier) {
                ((KStreamAggProcessorSupplier)this.processorSupplier).enableSendingOldValues();
            } else {
                ((KTableProcessorSupplier)this.processorSupplier).enableSendingOldValues();
            }
            this.sendOldValues = true;
        }
    }

    boolean sendingOldValueEnabled() {
        return this.sendOldValues;
    }
}

