/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.state.KeyValueStore;

public class KTableSource<K, V>
implements ProcessorSupplier<K, V> {
    public final String storeName;
    private boolean sendOldValues = false;

    public KTableSource(String storeName) {
        this.storeName = storeName;
    }

    @Override
    public Processor<K, V> get() {
        return new KTableSourceProcessor();
    }

    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    private class KTableSourceProcessor
    extends AbstractProcessor<K, V> {
        private KeyValueStore<K, V> store;
        private TupleForwarder<K, V> tupleForwarder;

        private KTableSourceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(KTableSource.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context, KTableSource.this.sendOldValues), KTableSource.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                return;
            }
            Object oldValue = this.store.get(key);
            this.store.put(key, value);
            this.tupleForwarder.maybeForward(key, value, oldValue);
        }
    }
}

