/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.state.internals.ThreadCache;

public abstract class AbstractProcessorContext
implements InternalProcessorContext {
    static final String NONEXIST_TOPIC = "__null_topic__";
    private final TaskId taskId;
    private final String applicationId;
    private final StreamsConfig config;
    private final StreamsMetrics metrics;
    private final Serde keySerde;
    private final ThreadCache cache;
    private final Serde valueSerde;
    private boolean initialized;
    private RecordContext recordContext;
    private ProcessorNode currentNode;
    final StateManager stateManager;

    public AbstractProcessorContext(TaskId taskId, String applicationId, StreamsConfig config, StreamsMetrics metrics, StateManager stateManager, ThreadCache cache) {
        this.taskId = taskId;
        this.applicationId = applicationId;
        this.config = config;
        this.metrics = metrics;
        this.stateManager = stateManager;
        this.valueSerde = config.valueSerde();
        this.keySerde = config.keySerde();
        this.cache = cache;
    }

    @Override
    public String applicationId() {
        return this.applicationId;
    }

    @Override
    public TaskId taskId() {
        return this.taskId;
    }

    @Override
    public Serde<?> keySerde() {
        return this.keySerde;
    }

    @Override
    public Serde<?> valueSerde() {
        return this.valueSerde;
    }

    @Override
    public File stateDir() {
        return this.stateManager.baseDir();
    }

    @Override
    public StreamsMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void register(StateStore store, boolean loggingEnabled, StateRestoreCallback stateRestoreCallback) {
        if (this.initialized) {
            throw new IllegalStateException("Can only create state stores during initialization.");
        }
        Objects.requireNonNull(store, "store must not be null");
        this.stateManager.register(store, loggingEnabled, stateRestoreCallback);
    }

    @Override
    public String topic() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as topic() should only be called while a record is processed");
        }
        String topic = this.recordContext.topic();
        if (topic.equals(NONEXIST_TOPIC)) {
            return null;
        }
        return topic;
    }

    @Override
    public int partition() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as partition() should only be called while a record is processed");
        }
        return this.recordContext.partition();
    }

    @Override
    public long offset() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as offset() should only be called while a record is processed");
        }
        return this.recordContext.offset();
    }

    @Override
    public long timestamp() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as timestamp() should only be called while a record is processed");
        }
        return this.recordContext.timestamp();
    }

    @Override
    public Map<String, Object> appConfigs() {
        return this.config.originals();
    }

    @Override
    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return this.config.originalsWithPrefix(prefix);
    }

    @Override
    public void setRecordContext(RecordContext recordContext) {
        this.recordContext = recordContext;
    }

    @Override
    public RecordContext recordContext() {
        return this.recordContext;
    }

    @Override
    public void setCurrentNode(ProcessorNode currentNode) {
        this.currentNode = currentNode;
    }

    @Override
    public ProcessorNode currentNode() {
        return this.currentNode;
    }

    @Override
    public ThreadCache getCache() {
        return this.cache;
    }

    @Override
    public void initialized() {
        this.initialized = true;
    }
}

