/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractTask.class);
    final TaskId id;
    final String applicationId;
    final ProcessorTopology topology;
    final Consumer consumer;
    final ProcessorStateManager stateMgr;
    final Set<TopicPartition> partitions;
    InternalProcessorContext processorContext;
    private final ThreadCache cache;
    final String logPrefix;
    final boolean eosEnabled;

    AbstractTask(TaskId id, String applicationId, Collection<TopicPartition> partitions, ProcessorTopology topology, Consumer<byte[], byte[]> consumer, ChangelogReader changelogReader, boolean isStandby, StateDirectory stateDirectory, ThreadCache cache, StreamsConfig config) {
        this.id = id;
        this.applicationId = applicationId;
        this.partitions = new HashSet<TopicPartition>(partitions);
        this.topology = topology;
        this.consumer = consumer;
        this.cache = cache;
        this.eosEnabled = "exactly_once".equals(config.getString("processing.guarantee"));
        this.logPrefix = String.format("%s [%s]", isStandby ? "standby-task" : "task", this.id());
        try {
            this.stateMgr = new ProcessorStateManager(id, partitions, isStandby, stateDirectory, topology.storeToChangelogTopic(), changelogReader, this.eosEnabled);
        }
        catch (IOException e) {
            throw new ProcessorStateException(String.format("%s Error while creating the state manager", this.logPrefix), e);
        }
    }

    public abstract void resume();

    public abstract void commit();

    public abstract void suspend();

    public abstract void close(boolean var1);

    public final TaskId id() {
        return this.id;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Set<TopicPartition> partitions() {
        return this.partitions;
    }

    public final ProcessorTopology topology() {
        return this.topology;
    }

    public final ProcessorContext context() {
        return this.processorContext;
    }

    public final ThreadCache cache() {
        return this.cache;
    }

    public StateStore getStore(String name) {
        return this.stateMgr.getStore(name);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("StreamsTask taskId: ");
        sb.append(this.id);
        sb.append("\n");
        if (this.topology != null) {
            sb.append(indent).append(this.topology.toString(indent + "\t"));
        }
        if (this.partitions != null && !this.partitions.isEmpty()) {
            sb.append(indent).append("Partitions [");
            for (TopicPartition topicPartition : this.partitions) {
                sb.append(topicPartition.toString()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]\n");
        }
        return sb.toString();
    }

    protected Map<TopicPartition, Long> recordCollectorOffsets() {
        return Collections.emptyMap();
    }

    protected void updateOffsetLimits() {
        log.debug("{} Updating store offset limits {}", (Object)this.logPrefix);
        for (TopicPartition partition : this.partitions) {
            try {
                OffsetAndMetadata metadata = this.consumer.committed(partition);
                this.stateMgr.putOffsetLimit(partition, metadata != null ? metadata.offset() : 0L);
            }
            catch (AuthorizationException e) {
                throw new ProcessorStateException(String.format("task [%s] AuthorizationException when initializing offsets for %s", this.id, partition), e);
            }
            catch (WakeupException e) {
                throw e;
            }
            catch (KafkaException e) {
                throw new ProcessorStateException(String.format("task [%s] Failed to initialize offsets for %s", this.id, partition), e);
            }
        }
    }

    void flushState() {
        this.stateMgr.flush();
    }

    void initializeStateStores() {
        log.debug("{} Initializing state stores", (Object)this.logPrefix);
        this.updateOffsetLimits();
        for (StateStore store : this.topology.stateStores()) {
            log.trace("task [{}] Initializing store {}", (Object)this.id(), (Object)store.name());
            store.init(this.processorContext, store);
        }
    }

    void closeStateManager(boolean writeCheckpoint) throws ProcessorStateException {
        log.trace("{} Closing state manager", (Object)this.logPrefix);
        this.stateMgr.close(writeCheckpoint ? this.recordCollectorOffsets() : null);
    }
}

