/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.GlobalProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateMaintainer;
import org.apache.kafka.streams.processor.internals.GlobalStateManagerImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateUpdateTask;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalStreamThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(GlobalStreamThread.class);
    private final StreamsConfig config;
    private final Consumer<byte[], byte[]> consumer;
    private final StateDirectory stateDirectory;
    private final Time time;
    private final ThreadCache cache;
    private final StreamsMetrics streamsMetrics;
    private final ProcessorTopology topology;
    private volatile boolean running = false;
    private volatile StreamsException startupException;

    public GlobalStreamThread(ProcessorTopology topology, StreamsConfig config, Consumer<byte[], byte[]> globalConsumer, StateDirectory stateDirectory, Metrics metrics, Time time, String threadClientId) {
        super(threadClientId);
        this.time = time;
        this.config = config;
        this.topology = topology;
        this.consumer = globalConsumer;
        this.stateDirectory = stateDirectory;
        long cacheSizeBytes = Math.max(0L, config.getLong("cache.max.bytes.buffering") / (long)(config.getInt("num.stream.threads") + 1));
        this.streamsMetrics = new StreamsMetricsImpl(metrics, threadClientId, Collections.singletonMap("client-id", threadClientId));
        this.cache = new ThreadCache(threadClientId, cacheSizeBytes, this.streamsMetrics);
    }

    @Override
    public void run() {
        StateConsumer stateConsumer = this.initialize();
        if (stateConsumer == null) {
            return;
        }
        try {
            while (this.running) {
                stateConsumer.pollAndUpdate();
            }
            log.debug("Shutting down GlobalStreamThread at user request");
        }
        finally {
            try {
                stateConsumer.close();
            }
            catch (IOException e) {
                log.error("Failed to cleanly shutdown GlobalStreamThread", (Throwable)e);
            }
        }
    }

    private StateConsumer initialize() {
        try {
            GlobalStateManagerImpl stateMgr = new GlobalStateManagerImpl(this.topology, this.consumer, this.stateDirectory);
            StateConsumer stateConsumer = new StateConsumer(this.consumer, new GlobalStateUpdateTask(this.topology, new GlobalProcessorContextImpl(this.config, stateMgr, this.streamsMetrics, this.cache), stateMgr), this.time, this.config.getLong("poll.ms"), this.config.getLong("commit.interval.ms"));
            stateConsumer.initialize();
            this.running = true;
            return stateConsumer;
        }
        catch (StreamsException e) {
            this.startupException = e;
        }
        catch (Exception e) {
            this.startupException = new StreamsException("Exception caught during initialization of GlobalStreamThread", e);
        }
        return null;
    }

    @Override
    public synchronized void start() {
        super.start();
        while (!this.running) {
            Utils.sleep((long)1L);
            if (this.startupException == null) continue;
            throw this.startupException;
        }
    }

    public void close() {
        this.running = false;
    }

    public boolean stillRunning() {
        return this.running;
    }

    static class StateConsumer {
        private final Consumer<byte[], byte[]> consumer;
        private final GlobalStateMaintainer stateMaintainer;
        private final Time time;
        private final long pollMs;
        private final long flushInterval;
        private long lastFlush;

        StateConsumer(Consumer<byte[], byte[]> consumer, GlobalStateMaintainer stateMaintainer, Time time, long pollMs, long flushInterval) {
            this.consumer = consumer;
            this.stateMaintainer = stateMaintainer;
            this.time = time;
            this.pollMs = pollMs;
            this.flushInterval = flushInterval;
        }

        void initialize() {
            Map<TopicPartition, Long> partitionOffsets = this.stateMaintainer.initialize();
            this.consumer.assign(partitionOffsets.keySet());
            for (Map.Entry<TopicPartition, Long> entry : partitionOffsets.entrySet()) {
                this.consumer.seek(entry.getKey(), entry.getValue().longValue());
            }
            this.lastFlush = this.time.milliseconds();
        }

        void pollAndUpdate() {
            ConsumerRecords received = this.consumer.poll(this.pollMs);
            for (ConsumerRecord record : received) {
                this.stateMaintainer.update((ConsumerRecord<byte[], byte[]>)record);
            }
            long now = this.time.milliseconds();
            if (this.flushInterval >= 0L && now >= this.lastFlush + this.flushInterval) {
                this.stateMaintainer.flushState();
                this.lastFlush = now;
            }
        }

        public void close() throws IOException {
            try {
                this.consumer.close();
            }
            catch (Exception e) {
                log.error("Failed to cleanly close GlobalStreamThread consumer", (Throwable)e);
            }
            this.stateMaintainer.close();
        }
    }
}

