/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.PartitionGroup;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.PunctuationQueue;
import org.apache.kafka.streams.processor.internals.PunctuationSchedule;
import org.apache.kafka.streams.processor.internals.Punctuator;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTask
extends AbstractTask
implements Punctuator {
    private static final Logger log = LoggerFactory.getLogger(StreamTask.class);
    private static final ConsumerRecord<Object, Object> DUMMY_RECORD = new ConsumerRecord("__null_topic__", -1, -1L, null, null);
    private final PartitionGroup partitionGroup;
    private final PartitionGroup.RecordInfo recordInfo = new PartitionGroup.RecordInfo();
    private final PunctuationQueue punctuationQueue = new PunctuationQueue();
    private final Map<TopicPartition, Long> consumedOffsets;
    private final RecordCollector recordCollector;
    private final Producer<byte[], byte[]> producer;
    private final int maxBufferedSize;
    private boolean commitRequested = false;
    private boolean commitOffsetNeeded = false;
    private boolean transactionInFlight = false;
    private final Time time;
    private final TaskMetrics metrics;

    public StreamTask(TaskId id, String applicationId, Collection<TopicPartition> partitions, ProcessorTopology topology, Consumer<byte[], byte[]> consumer, ChangelogReader changelogReader, StreamsConfig config, StreamsMetrics metrics, StateDirectory stateDirectory, ThreadCache cache, Time time, Producer<byte[], byte[]> producer) {
        super(id, applicationId, partitions, topology, consumer, changelogReader, false, stateDirectory, cache, config);
        this.maxBufferedSize = config.getInt("buffered.records.per.partition");
        this.metrics = new TaskMetrics(metrics);
        HashMap<TopicPartition, RecordQueue> partitionQueues = new HashMap<TopicPartition, RecordQueue>();
        TimestampExtractor defaultTimestampExtractor = config.defaultTimestampExtractor();
        for (TopicPartition partition : partitions) {
            SourceNode source = topology.source(partition.topic());
            TimestampExtractor sourceTimestampExtractor = source.getTimestampExtractor() != null ? source.getTimestampExtractor() : defaultTimestampExtractor;
            RecordQueue queue = new RecordQueue(partition, source, sourceTimestampExtractor);
            partitionQueues.put(partition, queue);
        }
        this.partitionGroup = new PartitionGroup(partitionQueues);
        this.consumedOffsets = new HashMap<TopicPartition, Long>();
        this.producer = producer;
        this.recordCollector = this.createRecordCollector();
        this.processorContext = new ProcessorContextImpl(id, this, config, this.recordCollector, this.stateMgr, metrics, cache);
        this.time = time;
        log.debug("{} Initializing", (Object)this.logPrefix);
        this.initializeStateStores();
        this.stateMgr.registerGlobalStateStores(topology.globalStateStores());
        if (this.eosEnabled) {
            this.producer.initTransactions();
            this.producer.beginTransaction();
            this.transactionInFlight = true;
        }
        this.initTopology();
        this.processorContext.initialized();
    }

    @Override
    public void resume() {
        log.debug("{} Resuming", (Object)this.logPrefix);
        if (this.eosEnabled) {
            this.producer.beginTransaction();
            this.transactionInFlight = true;
        }
        this.initTopology();
    }

    public boolean process() {
        StampedRecord record = this.partitionGroup.nextRecord(this.recordInfo);
        if (record == null) {
            return false;
        }
        try {
            ProcessorNode currNode = this.recordInfo.node();
            TopicPartition partition = this.recordInfo.partition();
            log.trace("{} Start processing one record [{}]", (Object)this.logPrefix, (Object)record);
            this.updateProcessorContext(record, currNode);
            currNode.process(record.key(), record.value());
            log.trace("{} Completed processing one record [{}]", (Object)this.logPrefix, (Object)record);
            this.consumedOffsets.put(partition, record.offset());
            this.commitOffsetNeeded = true;
            if (this.recordInfo.queue().size() == this.maxBufferedSize) {
                this.consumer.resume(Collections.singleton(partition));
            }
        }
        catch (KafkaException e) {
            throw new StreamsException(String.format("Exception caught in process. taskId=%s, processor=%s, topic=%s, partition=%d, offset=%d", this.id(), this.processorContext.currentNode().name(), record.topic(), record.partition(), record.offset()), e);
        }
        finally {
            this.processorContext.setCurrentNode(null);
        }
        return true;
    }

    @Override
    public void punctuate(ProcessorNode node, long timestamp) {
        if (this.processorContext.currentNode() != null) {
            throw new IllegalStateException(String.format("%s Current node is not null", this.logPrefix));
        }
        this.updateProcessorContext(new StampedRecord(DUMMY_RECORD, timestamp), node);
        log.trace("{} Punctuating processor {} with timestamp {}", new Object[]{this.logPrefix, node.name(), timestamp});
        try {
            node.punctuate(timestamp);
        }
        catch (KafkaException e) {
            throw new StreamsException(String.format("%s Exception caught while punctuating processor '%s'", this.logPrefix, node.name()), e);
        }
        finally {
            this.processorContext.setCurrentNode(null);
        }
    }

    private void updateProcessorContext(StampedRecord record, ProcessorNode currNode) {
        this.processorContext.setRecordContext(new ProcessorRecordContext(record.timestamp, record.offset(), record.partition(), record.topic()));
        this.processorContext.setCurrentNode(currNode);
    }

    @Override
    public void commit() {
        this.commitImpl(true);
    }

    void commitImpl(final boolean startNewTransaction) {
        log.trace("{} Committing", (Object)this.logPrefix);
        this.metrics.metrics.measureLatencyNs(this.time, new Runnable(){

            @Override
            public void run() {
                StreamTask.this.flushState();
                if (!StreamTask.this.eosEnabled) {
                    StreamTask.this.stateMgr.checkpoint(StreamTask.this.recordCollectorOffsets());
                }
                StreamTask.this.commitOffsets(startNewTransaction);
            }
        }, this.metrics.taskCommitTimeSensor);
    }

    @Override
    protected Map<TopicPartition, Long> recordCollectorOffsets() {
        return this.recordCollector.offsets();
    }

    @Override
    protected void flushState() {
        log.trace("{} Flushing state and producer", (Object)this.logPrefix);
        super.flushState();
        this.recordCollector.flush();
    }

    private void commitOffsets(boolean startNewTransaction) {
        if (this.commitOffsetNeeded) {
            log.debug("{} Committing offsets", (Object)this.logPrefix);
            HashMap<TopicPartition, OffsetAndMetadata> consumedOffsetsAndMetadata = new HashMap<TopicPartition, OffsetAndMetadata>(this.consumedOffsets.size());
            for (Map.Entry<TopicPartition, Long> entry : this.consumedOffsets.entrySet()) {
                TopicPartition partition = entry.getKey();
                long offset = entry.getValue() + 1L;
                consumedOffsetsAndMetadata.put(partition, new OffsetAndMetadata(offset));
                this.stateMgr.putOffsetLimit(partition, offset);
            }
            if (this.eosEnabled) {
                this.producer.sendOffsetsToTransaction(consumedOffsetsAndMetadata, this.applicationId);
                this.producer.commitTransaction();
                this.transactionInFlight = false;
                if (startNewTransaction) {
                    this.transactionInFlight = true;
                    this.producer.beginTransaction();
                }
            } else {
                try {
                    this.consumer.commitSync(consumedOffsetsAndMetadata);
                }
                catch (CommitFailedException e) {
                    log.warn("{} Failed offset commits {}: ", new Object[]{this.logPrefix, consumedOffsetsAndMetadata, e});
                    throw e;
                }
            }
            this.commitOffsetNeeded = false;
        } else if (this.eosEnabled && !startNewTransaction && this.transactionInFlight) {
            this.producer.commitTransaction();
            this.transactionInFlight = false;
        }
        this.commitRequested = false;
    }

    private void initTopology() {
        log.debug("{} Initializing processor nodes of the topology", (Object)this.logPrefix);
        for (ProcessorNode node : this.topology.processors()) {
            this.processorContext.setCurrentNode(node);
            try {
                node.init(this.processorContext);
            }
            finally {
                this.processorContext.setCurrentNode(null);
            }
        }
    }

    @Override
    public void suspend() {
        this.suspend(true);
    }

    private void suspend(boolean clean) {
        log.debug("{} Suspending", (Object)this.logPrefix);
        this.closeTopology();
        if (clean) {
            this.commitImpl(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTopology() {
        log.debug("{} Closing processor topology", (Object)this.logPrefix);
        this.partitionGroup.clear();
        RuntimeException exception = null;
        for (ProcessorNode node : this.topology.processors()) {
            this.processorContext.setCurrentNode(node);
            try {
                node.close();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            finally {
                this.processorContext.setCurrentNode(null);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean clean) {
        log.debug("{} Closing", (Object)this.logPrefix);
        RuntimeException firstException = null;
        try {
            this.suspend(clean);
        }
        catch (RuntimeException e) {
            clean = false;
            firstException = e;
            log.error("{} Could not close task: ", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.closeStateManager(clean);
        }
        catch (RuntimeException e) {
            clean = false;
            if (firstException == null) {
                firstException = e;
            }
            log.error("{} Could not close state manager: ", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.partitionGroup.close();
            this.metrics.removeAllSensors();
        }
        finally {
            if (this.eosEnabled) {
                if (!clean) {
                    try {
                        this.producer.abortTransaction();
                        this.transactionInFlight = false;
                    }
                    catch (ProducerFencedException e) {}
                }
                try {
                    this.recordCollector.close();
                }
                catch (Throwable e) {
                    log.error("{} Failed to close producer: ", (Object)this.logPrefix, (Object)e);
                }
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public int addRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> records) {
        int oldQueueSize = this.partitionGroup.numBuffered(partition);
        int newQueueSize = this.partitionGroup.addRawRecords(partition, records);
        log.trace("{} Added records into the buffered queue of partition {}, new queue size is {}", new Object[]{this.logPrefix, partition, newQueueSize});
        if (newQueueSize > this.maxBufferedSize) {
            this.consumer.pause(Collections.singleton(partition));
        }
        return newQueueSize - oldQueueSize;
    }

    public void schedule(long interval) {
        if (this.processorContext.currentNode() == null) {
            throw new IllegalStateException(String.format("%s Current node is null", this.logPrefix));
        }
        this.punctuationQueue.schedule(new PunctuationSchedule(this.processorContext.currentNode(), interval));
    }

    int numBuffered() {
        return this.partitionGroup.numBuffered();
    }

    boolean maybePunctuate() {
        long timestamp = this.partitionGroup.timestamp();
        if (timestamp == -1L) {
            return false;
        }
        return this.punctuationQueue.mayPunctuate(timestamp, this);
    }

    void needCommit() {
        this.commitRequested = true;
    }

    boolean commitNeeded() {
        return this.commitRequested;
    }

    ProcessorContext processorContext() {
        return this.processorContext;
    }

    RecordCollector recordCollector() {
        return this.recordCollector;
    }

    RecordCollector createRecordCollector() {
        return new RecordCollectorImpl(this.producer, this.id.toString());
    }

    protected class TaskMetrics {
        final StreamsMetricsImpl metrics;
        final Sensor taskCommitTimeSensor;

        TaskMetrics(StreamsMetrics metrics) {
            String name = StreamTask.this.id().toString();
            this.metrics = (StreamsMetricsImpl)metrics;
            this.taskCommitTimeSensor = metrics.addLatencyAndThroughputSensor("task", name, "commit", Sensor.RecordingLevel.DEBUG, "streams-task-id", name);
        }

        void removeAllSensors() {
            this.metrics.removeSensor(this.taskCommitTimeSensor);
        }
    }
}

