/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.AbstractStoreSupplier;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.MeteredSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowStoreSupplier;

public class RocksDBWindowStoreSupplier<K, V>
extends AbstractStoreSupplier<K, V, WindowStore>
implements WindowStoreSupplier<WindowStore> {
    private final long retentionPeriod;
    private final boolean retainDuplicates;
    private final int numSegments;
    private final long segmentInterval;
    private final long windowSize;
    private final boolean enableCaching;

    public RocksDBWindowStoreSupplier(String name, long retentionPeriod, int numSegments, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde, long windowSize, boolean logged, Map<String, String> logConfig, boolean enableCaching) {
        this(name, retentionPeriod, numSegments, retainDuplicates, keySerde, valueSerde, null, windowSize, logged, logConfig, enableCaching);
    }

    public RocksDBWindowStoreSupplier(String name, long retentionPeriod, int numSegments, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde, Time time, long windowSize, boolean logged, Map<String, String> logConfig, boolean enableCaching) {
        super(name, keySerde, valueSerde, time, logged, logConfig);
        this.retentionPeriod = retentionPeriod;
        this.retainDuplicates = retainDuplicates;
        this.numSegments = numSegments;
        this.windowSize = windowSize;
        this.enableCaching = enableCaching;
        this.segmentInterval = Segments.segmentInterval(retentionPeriod, numSegments);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public WindowStore get() {
        return this.maybeWrapCaching(this.maybeWrapLogged(new RocksDBSegmentedBytesStore(this.name, this.retentionPeriod, this.numSegments, new WindowKeySchema())));
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }

    private SegmentedBytesStore maybeWrapLogged(SegmentedBytesStore inner) {
        if (!this.logged) {
            return inner;
        }
        return new ChangeLoggingSegmentedBytesStore(inner);
    }

    private WindowStore<K, V> maybeWrapCaching(SegmentedBytesStore inner) {
        MeteredSegmentedBytesStore metered = new MeteredSegmentedBytesStore(inner, "rocksdb-window", this.time);
        if (!this.enableCaching) {
            return new RocksDBWindowStore(metered, this.keySerde, this.valueSerde, this.retainDuplicates, this.windowSize);
        }
        RocksDBWindowStore<Bytes, byte[]> windowed = RocksDBWindowStore.bytesStore(metered, this.retainDuplicates, this.windowSize);
        return new CachingWindowStore(windowed, this.keySerde, this.valueSerde, this.windowSize, this.segmentInterval);
    }
}

