/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;

class WrappedSessionStoreIterator<K, V>
implements KeyValueIterator<Windowed<K>, V> {
    final KeyValueIterator<Bytes, byte[]> bytesIterator;
    private final StateSerdes<K, V> serdes;

    static WrappedSessionStoreIterator<Bytes, byte[]> bytesIterator(KeyValueIterator<Bytes, byte[]> underlying, StateSerdes<Bytes, byte[]> serdes) {
        return new WrappedSessionStoreBytesIterator(underlying, serdes);
    }

    WrappedSessionStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<K, V> serdes) {
        this.bytesIterator = bytesIterator;
        this.serdes = serdes;
    }

    @Override
    public void close() {
        this.bytesIterator.close();
    }

    @Override
    public Windowed<K> peekNextKey() {
        Bytes bytes = this.bytesIterator.peekNextKey();
        return SessionKeySerde.from(bytes.get(), this.serdes.keyDeserializer(), this.serdes.topic());
    }

    @Override
    public boolean hasNext() {
        return this.bytesIterator.hasNext();
    }

    @Override
    public KeyValue<Windowed<K>, V> next() {
        KeyValue next = (KeyValue)this.bytesIterator.next();
        return KeyValue.pair(SessionKeySerde.from(((Bytes)next.key).get(), this.serdes.keyDeserializer(), this.serdes.topic()), this.serdes.valueFrom((byte[])next.value));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
    }

    private static class WrappedSessionStoreBytesIterator
    extends WrappedSessionStoreIterator<Bytes, byte[]> {
        WrappedSessionStoreBytesIterator(KeyValueIterator<Bytes, byte[]> underlying, StateSerdes<Bytes, byte[]> serdes) {
            super(underlying, serdes);
        }

        @Override
        public Windowed<Bytes> peekNextKey() {
            Bytes key = (Bytes)this.bytesIterator.peekNextKey();
            return SessionKeySerde.fromBytes(key);
        }

        @Override
        public KeyValue<Windowed<Bytes>, byte[]> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            return KeyValue.pair(SessionKeySerde.fromBytes((Bytes)next.key), next.value);
        }
    }
}

