/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.Utils;

public class NodeApiVersions {
    private final Map<ApiKeys, UsableVersion> usableVersions = new EnumMap<ApiKeys, UsableVersion>(ApiKeys.class);
    private final List<ApiVersionsResponse.ApiVersion> unknownApis = new ArrayList<ApiVersionsResponse.ApiVersion>();

    public static NodeApiVersions create() {
        return NodeApiVersions.create(Collections.emptyList());
    }

    public static NodeApiVersions create(Collection<ApiVersionsResponse.ApiVersion> overrides) {
        LinkedList<ApiVersionsResponse.ApiVersion> apiVersions = new LinkedList<ApiVersionsResponse.ApiVersion>(overrides);
        for (ApiKeys apiKey : ApiKeys.values()) {
            boolean exists = false;
            for (ApiVersionsResponse.ApiVersion apiVersion : apiVersions) {
                if (apiVersion.apiKey != apiKey.id) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            apiVersions.add(new ApiVersionsResponse.ApiVersion(apiKey));
        }
        return new NodeApiVersions(apiVersions);
    }

    public NodeApiVersions(Collection<ApiVersionsResponse.ApiVersion> nodeApiVersions) {
        for (ApiVersionsResponse.ApiVersion nodeApiVersion : nodeApiVersions) {
            if (ApiKeys.hasId(nodeApiVersion.apiKey)) {
                ApiKeys nodeApiKey = ApiKeys.forId(nodeApiVersion.apiKey);
                this.usableVersions.put(nodeApiKey, new UsableVersion(nodeApiKey, nodeApiVersion));
                continue;
            }
            this.unknownApis.add(nodeApiVersion);
        }
    }

    public short usableVersion(ApiKeys apiKey) {
        return this.usableVersion(apiKey, null);
    }

    public short usableVersion(ApiKeys apiKey, Short desiredVersion) {
        UsableVersion usableVersion = this.usableVersions.get((Object)apiKey);
        if (usableVersion == null) {
            throw new UnsupportedVersionException("The broker does not support " + (Object)((Object)apiKey));
        }
        if (desiredVersion == null) {
            usableVersion.ensureUsable();
            return usableVersion.value;
        }
        usableVersion.ensureUsable(desiredVersion);
        return desiredVersion;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean lineBreaks) {
        TreeMap<Short, String> apiKeysText = new TreeMap<Short, String>();
        for (UsableVersion usableVersion : this.usableVersions.values()) {
            apiKeysText.put(((UsableVersion)usableVersion).apiVersion.apiKey, this.apiVersionToText(usableVersion.apiVersion));
        }
        for (ApiVersionsResponse.ApiVersion apiVersion : this.unknownApis) {
            apiKeysText.put(apiVersion.apiKey, this.apiVersionToText(apiVersion));
        }
        for (Iterator<Object> iterator : ApiKeys.values()) {
            if (apiKeysText.containsKey(((ApiKeys)((Object)iterator)).id)) continue;
            StringBuilder bld = new StringBuilder();
            bld.append(((ApiKeys)((Object)iterator)).name).append("(").append(((ApiKeys)((Object)iterator)).id).append("): ").append("UNSUPPORTED");
            apiKeysText.put(((ApiKeys)((Object)iterator)).id, bld.toString());
        }
        String separator = lineBreaks ? ",\n\t" : ", ";
        StringBuilder bld = new StringBuilder();
        bld.append("(");
        if (lineBreaks) {
            bld.append("\n\t");
        }
        bld.append(Utils.join(apiKeysText.values(), separator));
        if (lineBreaks) {
            bld.append("\n");
        }
        bld.append(")");
        return bld.toString();
    }

    private String apiVersionToText(ApiVersionsResponse.ApiVersion apiVersion) {
        StringBuilder bld = new StringBuilder();
        ApiKeys apiKey = null;
        if (ApiKeys.hasId(apiVersion.apiKey)) {
            apiKey = ApiKeys.forId(apiVersion.apiKey);
            bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
        } else {
            bld.append("UNKNOWN(").append(apiVersion.apiKey).append("): ");
        }
        if (apiVersion.minVersion == apiVersion.maxVersion) {
            bld.append(apiVersion.minVersion);
        } else {
            bld.append(apiVersion.minVersion).append(" to ").append(apiVersion.maxVersion);
        }
        if (apiKey != null) {
            UsableVersion usableVersion = this.usableVersions.get((Object)apiKey);
            if (usableVersion.isTooOld()) {
                bld.append(" [unusable: node too old]");
            } else if (usableVersion.isTooNew()) {
                bld.append(" [unusable: node too new]");
            } else {
                bld.append(" [usable: ").append(usableVersion.value).append("]");
            }
        }
        return bld.toString();
    }

    public ApiVersionsResponse.ApiVersion apiVersion(ApiKeys apiKey) {
        UsableVersion usableVersion = this.usableVersions.get((Object)apiKey);
        if (usableVersion == null) {
            return null;
        }
        return usableVersion.apiVersion;
    }

    private static class UsableVersion {
        private static final short NODE_TOO_OLD = -1;
        private static final short NODE_TOO_NEW = -2;
        private final ApiKeys apiKey;
        private final ApiVersionsResponse.ApiVersion apiVersion;
        private final Short value;

        private UsableVersion(ApiKeys apiKey, ApiVersionsResponse.ApiVersion nodeApiVersion) {
            this.apiKey = apiKey;
            this.apiVersion = nodeApiVersion;
            short v = Utils.min(apiKey.latestVersion(), nodeApiVersion.maxVersion);
            this.value = v < nodeApiVersion.minVersion ? Short.valueOf((short)-2) : (v < apiKey.oldestVersion() ? Short.valueOf((short)-1) : Short.valueOf(v));
        }

        private boolean isTooOld() {
            return this.value == -1;
        }

        private boolean isTooNew() {
            return this.value == -2;
        }

        private void ensureUsable() {
            if (this.value == -1) {
                throw new UnsupportedVersionException("The broker is too old to support " + (Object)((Object)this.apiKey) + " version " + this.apiKey.oldestVersion());
            }
            if (this.value == -2) {
                throw new UnsupportedVersionException("The broker is too new to support " + (Object)((Object)this.apiKey) + " version " + this.apiKey.latestVersion());
            }
        }

        private void ensureUsable(short desiredVersion) {
            if (this.apiVersion.minVersion > desiredVersion || this.apiVersion.maxVersion < desiredVersion) {
                throw new UnsupportedVersionException("The broker does not support the requested version " + desiredVersion + " for api " + (Object)((Object)this.apiKey) + ". Supported versions are " + this.apiVersion.minVersion + " to " + this.apiVersion.maxVersion + ".");
            }
        }
    }
}

