/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.KafkaFuture;

public class KafkaFutureImpl<T>
extends KafkaFuture<T> {
    private boolean done = false;
    private T value = null;
    private Throwable exception = null;
    private List<KafkaFuture.BiConsumer<? super T, ? super Throwable>> waiters = new ArrayList<KafkaFuture.BiConsumer<? super T, ? super Throwable>>();

    private static void wrapAndThrow(Throwable t) throws InterruptedException, ExecutionException {
        if (t instanceof CancellationException) {
            throw (CancellationException)t;
        }
        if (t instanceof InterruptedException) {
            throw (InterruptedException)t;
        }
        throw new ExecutionException(t);
    }

    @Override
    public <R> KafkaFuture<R> thenApply(KafkaFuture.Function<T, R> function) {
        KafkaFutureImpl<T> future = new KafkaFutureImpl<T>();
        this.addWaiter(new Applicant<T, R>(function, future));
        return future;
    }

    @Override
    protected synchronized void addWaiter(KafkaFuture.BiConsumer<? super T, ? super Throwable> action) {
        if (this.exception != null) {
            action.accept(null, this.exception);
        } else if (this.done) {
            action.accept(this.value, null);
        } else {
            this.waiters.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean complete(T newValue) {
        List<KafkaFuture.BiConsumer<T, Throwable>> oldWaiters = null;
        KafkaFutureImpl kafkaFutureImpl = this;
        synchronized (kafkaFutureImpl) {
            if (this.done) {
                return false;
            }
            this.value = newValue;
            this.done = true;
            oldWaiters = this.waiters;
            this.waiters = null;
        }
        for (KafkaFuture.BiConsumer biConsumer : oldWaiters) {
            biConsumer.accept(newValue, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean completeExceptionally(Throwable newException) {
        List<KafkaFuture.BiConsumer<T, Throwable>> oldWaiters = null;
        KafkaFutureImpl kafkaFutureImpl = this;
        synchronized (kafkaFutureImpl) {
            if (this.done) {
                return false;
            }
            this.exception = newException;
            this.done = true;
            oldWaiters = this.waiters;
            this.waiters = null;
        }
        for (KafkaFuture.BiConsumer biConsumer : oldWaiters) {
            biConsumer.accept(null, newException);
        }
        return true;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.completeExceptionally(new CancellationException())) {
            return true;
        }
        return this.exception instanceof CancellationException;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        SingleWaiter waiter = new SingleWaiter();
        this.addWaiter(waiter);
        return (T)waiter.await();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        SingleWaiter waiter = new SingleWaiter();
        this.addWaiter(waiter);
        return (T)waiter.await(timeout, unit);
    }

    @Override
    public synchronized T getNow(T valueIfAbsent) throws InterruptedException, ExecutionException {
        if (this.exception != null) {
            KafkaFutureImpl.wrapAndThrow(this.exception);
        }
        if (this.done) {
            return this.value;
        }
        return valueIfAbsent;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.exception != null && this.exception instanceof CancellationException;
    }

    @Override
    public synchronized boolean isCompletedExceptionally() {
        return this.exception != null;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    private static class SingleWaiter<R>
    extends KafkaFuture.BiConsumer<R, Throwable> {
        private R value = null;
        private Throwable exception = null;
        private boolean done = false;

        private SingleWaiter() {
        }

        @Override
        public synchronized void accept(R newValue, Throwable newException) {
            this.value = newValue;
            this.exception = newException;
            this.done = true;
            this.notifyAll();
        }

        synchronized R await() throws InterruptedException, ExecutionException {
            while (true) {
                if (this.exception != null) {
                    KafkaFutureImpl.wrapAndThrow(this.exception);
                }
                if (this.done) {
                    return this.value;
                }
                this.wait();
            }
        }

        R await(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long startMs = System.currentTimeMillis();
            long waitTimeMs = unit.toMillis(timeout) > 0L ? unit.toMillis(timeout) : 1L;
            long delta = 0L;
            SingleWaiter singleWaiter = this;
            synchronized (singleWaiter) {
                while (true) {
                    if (this.exception != null) {
                        KafkaFutureImpl.wrapAndThrow(this.exception);
                    }
                    if (this.done) {
                        return this.value;
                    }
                    if (delta > waitTimeMs) {
                        throw new TimeoutException();
                    }
                    this.wait(waitTimeMs - delta);
                    delta = System.currentTimeMillis() - startMs;
                }
            }
        }
    }

    private static class Applicant<A, B>
    extends KafkaFuture.BiConsumer<A, Throwable> {
        private final KafkaFuture.Function<A, B> function;
        private final KafkaFutureImpl<B> future;

        Applicant(KafkaFuture.Function<A, B> function, KafkaFutureImpl<B> future) {
            this.function = function;
            this.future = future;
        }

        @Override
        public void accept(A a, Throwable exception) {
            if (exception != null) {
                this.future.completeExceptionally(exception);
            } else {
                try {
                    B b = this.function.apply(a);
                    this.future.complete(b);
                }
                catch (Throwable t) {
                    this.future.completeExceptionally(t);
                }
            }
        }
    }
}

