/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.scram;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.AuthCallbackHandler;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialCallback;

public class ScramServerCallbackHandler
implements AuthCallbackHandler {
    private final CredentialCache.Cache<ScramCredential> credentialCache;

    public ScramServerCallbackHandler(CredentialCache.Cache<ScramCredential> credentialCache) {
        this.credentialCache = credentialCache;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String username = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                username = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof ScramCredentialCallback) {
                ((ScramCredentialCallback)callback).scramCredential(this.credentialCache.get(username));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void configure(Map<String, ?> configs, Mode mode, Subject subject, String saslMechanism) {
    }

    @Override
    public void close() {
    }
}

