#line 982 "../../src/builtin/snarf.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 982
#ifdef HAVE_CONFIG_H
#line 982
# include <config.h>
#line 982
#endif
#line 982
#include <sys/types.h>
#line 982

#line 982
#include "mailfromd.h"
#line 982
#include "prog.h"
#line 982
#include "builtin.h"
#line 982

#line 982

#line 1022 "../../src/builtin/snarf.m4"

/* End of snarf.m4 */
#line 1 "system.bi"
/* This file is part of Mailfromd.             -*- c -*-
   Copyright (C) 2006-2020 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */



#include <sys/utsname.h>
#include <mflib/status.h>

void
#line 22
bi_system(eval_environ_t env)
#line 22

#line 22

#line 22 "system.bi"
{
#line 22
	
#line 22

#line 22

#line 22
char *  str;
#line 22
        
#line 22
get_string_arg(env, 0, &str);
#line 22
        
#line 22

#line 22
        adjust_stack(env, 1);
#line 22

#line 22

#line 22
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 22
		prog_trace(env, "system %s",str);;
#line 22

{
	
#line 24
do {
#line 24
  push(env, (STKVAL)(mft_number)(system(str)));
#line 24
  goto endlab;
#line 24
} while (0);
}
endlab:
#line 26
        env_function_cleanup_flush(env, NULL);
#line 26
	return;
#line 26
}

void
#line 28
bi_time(eval_environ_t env)
#line 28

#line 28

#line 28 "system.bi"
{
#line 28
	
#line 28

#line 28

#line 28

#line 28

#line 28

#line 28
        adjust_stack(env, 0);
#line 28

#line 28

#line 28
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 28
		prog_trace(env, "time");;
#line 28

{
	time_t t = time(NULL);
	
#line 31
do {
#line 31
  push(env, (STKVAL)(mft_number)(t));
#line 31
  goto endlab;
#line 31
} while (0);
}
endlab:
#line 33
        env_function_cleanup_flush(env, NULL);
#line 33
	return;
#line 33
}

void
#line 35
bi_sleep(eval_environ_t env)
#line 35

#line 35

#line 35 "system.bi"
{
#line 35
	
#line 35

#line 35
long __bi_argcnt;
#line 35
long  seconds;
#line 35
        long  useconds;
#line 35
        
#line 35
get_numeric_arg(env, 1, &seconds);
#line 35
        get_numeric_arg(env, 2, &useconds);
#line 35
        
#line 35
get_numeric_arg(env, 0, &__bi_argcnt);
#line 35
        adjust_stack(env, __bi_argcnt + 1);
#line 35

#line 35

#line 35
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 35
		prog_trace(env, "sleep %lu %lu",seconds, ((__bi_argcnt > 1) ? useconds : 0));;
#line 35

{
	struct timeval tv;
	
	tv.tv_sec = seconds;
	tv.tv_usec = ((__bi_argcnt > 1) ? useconds : 0);
	/* FIXME: signals? */
	select(0, NULL, NULL, NULL, &tv);
}

#line 44
        env_function_cleanup_flush(env, NULL);
#line 44
	return;
#line 44
}

void
#line 46
bi_strftime(eval_environ_t env)
#line 46

#line 46

#line 46 "system.bi"
{
#line 46
	
#line 46

#line 46
long __bi_argcnt;
#line 46
char * MFL_DATASEG fmt;
#line 46
        long  timestamp;
#line 46
        long  gmt;
#line 46
        
#line 46
get_string_arg(env, 1, &fmt);
#line 46
        get_numeric_arg(env, 2, &timestamp);
#line 46
        get_numeric_arg(env, 3, &gmt);
#line 46
        
#line 46
get_numeric_arg(env, 0, &__bi_argcnt);
#line 46
        adjust_stack(env, __bi_argcnt + 1);
#line 46

#line 46

#line 46
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 46
		prog_trace(env, "strftime %s %lu %lu",fmt, timestamp, ((__bi_argcnt > 2) ? gmt : 0));;
#line 46

{
	char buf[1024];
	time_t t = timestamp;
	struct tm *tm = ((__bi_argcnt > 2) ? gmt : 0) ? gmtime(&t) : localtime(&t);
	size_t size = strftime(buf, sizeof(buf), fmt, tm);
	size_t off;
	char *s = (char*) env_data_ref(env, (off = heap_reserve(env, size + 1)));
	strcpy(s, buf);
	
#line 55
do {
#line 55
  push(env, (STKVAL) (mft_size) (off));
#line 55
  goto endlab;
#line 55
} while (0);
}
endlab:
#line 57
        env_function_cleanup_flush(env, NULL);
#line 57
	return;
#line 57
}

void
#line 59
bi_umask(eval_environ_t env)
#line 59

#line 59

#line 59 "system.bi"
{
#line 59
	
#line 59

#line 59

#line 59
long  mask;
#line 59
        
#line 59
get_numeric_arg(env, 0, &mask);
#line 59
        
#line 59

#line 59
        adjust_stack(env, 1);
#line 59

#line 59

#line 59
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 59
		prog_trace(env, "umask %lu",mask);;
#line 59

{
	mode_t mode = umask(mask);
	
#line 62
do {
#line 62
  push(env, (STKVAL)(mft_number)(mode));
#line 62
  goto endlab;
#line 62
} while (0);
}
endlab:
#line 64
        env_function_cleanup_flush(env, NULL);
#line 64
	return;
#line 64
}

/* Interface to the system uname call.
   
   Format sequences are:
   %s   sysname
   %n   nodename
   %r   release
   %v   version
   %m   machine
*/
void
#line 75
bi_uname(eval_environ_t env)
#line 75

#line 75

#line 75 "system.bi"
{
#line 75
	
#line 75

#line 75

#line 75
char * MFL_DATASEG fmt;
#line 75
        
#line 75
get_string_arg(env, 0, &fmt);
#line 75
        
#line 75

#line 75
        adjust_stack(env, 1);
#line 75

#line 75

#line 75
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 75
		prog_trace(env, "uname %s",fmt);;
#line 75

{
	struct utsname ubuf;

	uname(&ubuf);
	heap_obstack_begin(env);
	while (*fmt) {
		if (*fmt == '%') {
			switch (*++fmt) {
			case 's':
				heap_obstack_grow(env, ubuf.sysname, strlen(ubuf.sysname));
#line 87
				break;
			case 'n':
				heap_obstack_grow(env, ubuf.nodename, strlen(ubuf.nodename));
#line 91
				break;
			case 'r':
				heap_obstack_grow(env, ubuf.release, strlen(ubuf.release));
#line 95
				break;
			case 'v':
				heap_obstack_grow(env, ubuf.version, strlen(ubuf.version));
#line 99
				break;
			case 'm':
				heap_obstack_grow(env, ubuf.machine, strlen(ubuf.machine));
#line 103
				break;
			case '%':
				do { char __c = '%'; heap_obstack_grow(env, &__c, 1); } while(0);
				break;
			default:
				do { char __c = '%'; heap_obstack_grow(env, &__c, 1); } while(0);
				do { char __c = *fmt; heap_obstack_grow(env, &__c, 1); } while(0);
			}
			fmt++;
		} else {
			do { char __c = *fmt; heap_obstack_grow(env, &__c, 1); } while(0);
			fmt++;
		}
	}
	do { char __c = 0; heap_obstack_grow(env, &__c, 1); } while(0);
	
#line 118
do {
#line 118
  push(env, (STKVAL) (heap_obstack_finish(env)));
#line 118
  goto endlab;
#line 118
} while (0);
}
endlab:
#line 120
        env_function_cleanup_flush(env, NULL);
#line 120
	return;
#line 120
}

static struct builtin_const_trans access_modes[] = {
	{ _MFL_R_OK, R_OK },
	{ _MFL_W_OK, W_OK },
	{ _MFL_X_OK, X_OK },
	{ _MFL_F_OK, F_OK }
};

void
#line 129
bi_access(eval_environ_t env)
#line 129

#line 129

#line 129 "system.bi"
{
#line 129
	
#line 129

#line 129

#line 129
char *  pathname;
#line 129
        long  mode;
#line 129
        
#line 129
get_string_arg(env, 0, &pathname);
#line 129
        get_numeric_arg(env, 1, &mode);
#line 129
        
#line 129

#line 129
        adjust_stack(env, 2);
#line 129

#line 129

#line 129
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 129
		prog_trace(env, "access %s %lu",pathname, mode);;
#line 129

{
	int c_mode;
	
		if (!(_builtin_const_to_c(access_modes,
#line 133
				      MU_ARRAY_SIZE(access_modes),
#line 133
				      mode,
#line 133
				      &c_mode) == 0))
#line 133
		(
#line 133
	env_throw_bi(env, mfe_failure, "access", "bad access mode")
#line 133
)
#line 138
;
	
#line 139
do {
#line 139
  push(env, (STKVAL)(mft_number)(access(pathname, c_mode) == 0));
#line 139
  goto endlab;
#line 139
} while (0);
}
endlab:
#line 141
        env_function_cleanup_flush(env, NULL);
#line 141
	return;
#line 141
}

void
#line 143
bi_getenv(eval_environ_t env)
#line 143

#line 143

#line 143 "system.bi"
{
#line 143
	
#line 143

#line 143

#line 143
char * MFL_DATASEG name;
#line 143
        
#line 143
get_string_arg(env, 0, &name);
#line 143
        
#line 143

#line 143
        adjust_stack(env, 1);
#line 143

#line 143

#line 143
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 143
		prog_trace(env, "getenv %s",name);;
#line 143

{
	char *p = getenv(name);
		if (!(p != NULL))
#line 146
		(
#line 146
	env_throw_bi(env, mfe_not_found, "getenv", "%s: environment variable not defined",name)
#line 146
)
#line 149
;
	
#line 150
do {
#line 150
  pushs(env, p);
#line 150
  goto endlab;
#line 150
} while (0);
}
endlab:
#line 152
        env_function_cleanup_flush(env, NULL);
#line 152
	return;
#line 152
}

void
#line 154
bi_unlink(eval_environ_t env)
#line 154

#line 154

#line 154 "system.bi"
{
#line 154
	
#line 154

#line 154

#line 154
char *  name;
#line 154
        
#line 154
get_string_arg(env, 0, &name);
#line 154
        
#line 154

#line 154
        adjust_stack(env, 1);
#line 154

#line 154

#line 154
	if (builtin_module_trace(BUILTIN_IDX_system))
#line 154
		prog_trace(env, "unlink %s",name);;
#line 154

{
	int rc = unlink(name);
		if (!(rc == 0))
#line 157
		(
#line 157
	env_throw_bi(env, mfe_failure, "unlink", "cannot unlink %s: %s",name,mu_strerror(errno))
#line 157
)
#line 159
;
}

#line 161
        env_function_cleanup_flush(env, NULL);
#line 161
	return;
#line 161
}
		  
#line 982 "../../src/builtin/snarf.m4"

#line 982

#line 982

#line 982
void
#line 982
system_init_builtin(void)
#line 982
{
#line 982
	
#line 982
	#line 22 "system.bi"
va_builtin_install_ex("system", bi_system, 0, dtype_number, 1, 0, 0|0, dtype_string);
#line 28 "system.bi"
va_builtin_install_ex("time", bi_time, 0, dtype_number, 0, 0, 0|0, dtype_unspecified);
#line 35 "system.bi"
va_builtin_install_ex("sleep", bi_sleep, 0, dtype_unspecified, 2, 1, 0|0, dtype_number, dtype_number);
#line 46 "system.bi"
va_builtin_install_ex("strftime", bi_strftime, 0, dtype_string, 3, 1, 0|0, dtype_string, dtype_number, dtype_number);
#line 59 "system.bi"
va_builtin_install_ex("umask", bi_umask, 0, dtype_number, 1, 0, 0|0, dtype_number);
#line 75 "system.bi"
va_builtin_install_ex("uname", bi_uname, 0, dtype_string, 1, 0, 0|0, dtype_string);
#line 129 "system.bi"
va_builtin_install_ex("access", bi_access, 0, dtype_number, 2, 0, 0|0, dtype_string, dtype_number);
#line 143 "system.bi"
va_builtin_install_ex("getenv", bi_getenv, 0, dtype_string, 1, 0, 0|0, dtype_string);
#line 154 "system.bi"
va_builtin_install_ex("unlink", bi_unlink, 0, dtype_unspecified, 1, 0, 0|0, dtype_string);

#line 982 "../../src/builtin/snarf.m4"
	
#line 982
}
#line 982 "../../src/builtin/snarf.m4"

