/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jmx;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JMXConfigurator
extends ContextAwareBase
implements LoggerContextListener {
    private static String EMPTY = "";
    LoggerContext loggerContext;
    MBeanServer mbs;
    ObjectName objectName;
    String objectNameAsString;
    boolean debug = true;
    boolean started = true;

    public JMXConfigurator(LoggerContext loggerContext, MBeanServer mbs, ObjectName objectName) {
        this.context = loggerContext;
        this.loggerContext = loggerContext;
        this.mbs = mbs;
        this.objectName = objectName;
        this.objectNameAsString = objectName.toString();
        if (this.previouslyRegisteredListenerWithSameObjectName()) {
            this.addError("Previously registered JMXConfigurator named [" + this.objectNameAsString + "] in the logger context named [" + loggerContext.getName() + "]");
        } else {
            loggerContext.addListener(this);
        }
    }

    private boolean previouslyRegisteredListenerWithSameObjectName() {
        List<LoggerContextListener> lcll = this.loggerContext.getCopyOfListenerList();
        for (LoggerContextListener lcl : lcll) {
            if (!(lcl instanceof JMXConfigurator)) continue;
            JMXConfigurator jmxConfigurator = (JMXConfigurator)lcl;
            if (!this.objectName.equals(jmxConfigurator.objectName)) continue;
            return true;
        }
        return false;
    }

    public void onStop(LoggerContext context) {
        if (!this.started) {
            this.addInfo("onStop() method called on a stopped JMXActivator [" + this.objectNameAsString + "]");
            return;
        }
        if (this.mbs.isRegistered(this.objectName)) {
            try {
                this.addInfo("Unregistering mbean [" + this.objectNameAsString + "]");
                this.mbs.unregisterMBean(this.objectName);
            }
            catch (InstanceNotFoundException e) {
                this.addError("Unable to find a verifiably registered mbean [" + this.objectNameAsString + "]", e);
            }
            catch (MBeanRegistrationException e) {
                this.addError("Failed to unregister [" + this.objectNameAsString + "]", e);
            }
        } else {
            this.addInfo("mbean [" + this.objectNameAsString + "] was not in the mbean registry. This is OK.");
        }
        this.stop();
    }

    public void onReset(LoggerContext context) {
        this.addInfo("onReset() method called JMXActivator [" + this.objectNameAsString + "]");
    }

    public boolean isResetResistant() {
        return true;
    }

    private void clearFields() {
        this.mbs = null;
        this.objectName = null;
        this.loggerContext = null;
    }

    private void stop() {
        this.started = false;
        this.clearFields();
    }

    public void onStart(LoggerContext context) {
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.context.getName() + ")";
    }
}

