/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import org.xml.sax.Attributes;

public class ConfigurationAction
extends Action {
    boolean debugMode = false;

    public void begin(InterpretationContext ec, String name, Attributes attributes) {
        String debugAttrib = attributes.getValue("debug");
        if (OptionHelper.isEmpty(debugAttrib) || debugAttrib.equalsIgnoreCase("false") || debugAttrib.equalsIgnoreCase("null")) {
            this.addInfo("debug attribute not set");
        } else {
            this.debugMode = true;
        }
        this.processScanAttrib(attributes);
        new ContextUtil(this.context).addHostNameAsProperty();
        ec.pushObject(this.getContext());
    }

    void processScanAttrib(Attributes attributes) {
        String scanAttrib = attributes.getValue("scan");
        if (!OptionHelper.isEmpty(scanAttrib) && !"false".equalsIgnoreCase(scanAttrib)) {
            ReconfigureOnChangeFilter rocf = new ReconfigureOnChangeFilter();
            rocf.setContext(this.context);
            String scanPeriodAttrib = attributes.getValue("scanPeriod");
            if (!OptionHelper.isEmpty(scanPeriodAttrib)) {
                try {
                    Duration duration = Duration.valueOf(scanPeriodAttrib);
                    rocf.setRefreshPeriod(duration.getMilliseconds());
                    this.addInfo("Setting ReconfigureOnChangeFilter scanning period to " + duration);
                }
                catch (NumberFormatException nfe) {
                    this.addError("Error while converting [" + scanAttrib + "] to long", nfe);
                }
            }
            rocf.start();
            LoggerContext lc = (LoggerContext)this.context;
            this.addInfo("Adding ReconfigureOnChangeFilter as a turbo filter");
            lc.addTurboFilter(rocf);
        }
    }

    public void end(InterpretationContext ec, String name) {
        if (this.debugMode) {
            this.addInfo("End of configuration.");
            LoggerContext loggerContext = (LoggerContext)this.context;
            StatusPrinter.print(loggerContext);
        }
        ec.popObject();
    }
}

