/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MDCConverter
extends ClassicConverter {
    String key;

    public void start() {
        this.key = this.getFirstOption();
        super.start();
    }

    public void stop() {
        this.key = null;
        super.stop();
    }

    public String convert(ILoggingEvent event) {
        Map<String, String> mdcPropertyMap = event.getMDCPropertyMap();
        if (mdcPropertyMap == null) {
            return "";
        }
        if (this.key == null) {
            StringBuilder buf = new StringBuilder();
            Set<String> keys = mdcPropertyMap.keySet();
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                String tmpKey = it.next();
                String tmpValue = mdcPropertyMap.get(tmpKey);
                buf.append(tmpKey).append('=').append(tmpValue);
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            return buf.toString();
        }
        String value = event.getMDCPropertyMap().get(this.key);
        if (value != null) {
            return value;
        }
        return "";
    }
}

