/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.InfoStatus;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import org.slf4j.Marker;

public class ReconfigureOnChangeFilter
extends TurboFilter {
    static final long INIT = System.currentTimeMillis();
    long refreshPeriod = 60000L;
    File fileToScan;
    protected long nextCheck;
    volatile long lastModified;
    Object lock = new Object();
    private int invocationCounter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        URL url = (URL)this.context.getObject(CoreConstants.URL_OF_LAST_CONFIGURATION_VIA_JORAN);
        if (url != null) {
            this.fileToScan = this.convertToFile(url);
            if (this.fileToScan != null) {
                Object object = this.lock;
                synchronized (object) {
                    long inSeconds = this.refreshPeriod / 1000L;
                    this.addInfo("Will scan for changes in file [" + this.fileToScan + "] every " + inSeconds + " seconds. ");
                    this.lastModified = this.fileToScan.lastModified();
                    this.updateNextCheck(System.currentTimeMillis());
                }
                super.start();
            }
        } else {
            this.addError("Could not find URL of file to scan.");
        }
    }

    File convertToFile(URL url) {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            File file = new File(URLDecoder.decode(url.getFile()));
            return file;
        }
        this.addError("URL [" + url + "] is not of type file");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if ((this.invocationCounter++ & 0xF) != 15) {
            return FilterReply.NEUTRAL;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean changed = this.changeDetected();
            if (changed) {
                this.detachReconfigurationToNewThread();
            }
        }
        return FilterReply.NEUTRAL;
    }

    private void detachReconfigurationToNewThread() {
        this.disableSubsequentRecofiguration();
        this.addInfo("Detected change in [" + this.fileToScan + "]");
        this.addInfo("Resetting and reconfiguring context [" + this.context.getName() + "]");
        new ReconfiguringThread().start();
    }

    void updateNextCheck(long now) {
        this.nextCheck = now + this.refreshPeriod;
    }

    protected boolean changeDetected() {
        long now = System.currentTimeMillis();
        if (now >= this.nextCheck) {
            this.updateNextCheck(now);
            return this.lastModified != this.fileToScan.lastModified() && this.lastModified != Long.MAX_VALUE;
        }
        return false;
    }

    void disableSubsequentRecofiguration() {
        this.lastModified = Long.MAX_VALUE;
    }

    public void setRefreshPeriod(long refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }

    class ReconfiguringThread
    extends Thread {
        ReconfiguringThread() {
        }

        public void run() {
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext(ReconfigureOnChangeFilter.this.context);
            LoggerContext lc = (LoggerContext)ReconfigureOnChangeFilter.this.context;
            lc.reset();
            try {
                jc.doConfigure(ReconfigureOnChangeFilter.this.fileToScan);
            }
            catch (JoranException e) {
                ReconfigureOnChangeFilter.this.addError("Failure during reconfiguration", e);
            }
            lc.getStatusManager().add(new InfoStatus("done resetting the logging context", this));
        }
    }
}

