/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicStatusManager
implements StatusManager {
    int count = 0;
    protected final List<Status> statusList = new ArrayList<Status>();
    protected final CyclicBuffer<Status> tailBuffer = new CyclicBuffer(150);
    protected final Object statusListLock = new Object();
    int level = 0;
    protected final List<StatusListener> statusListenerList = new ArrayList<StatusListener>();
    protected final Object statusListenerListLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Status newStatus) {
        this.fireStatusAddEvent(newStatus);
        ++this.count;
        if (newStatus.getLevel() > this.level) {
            this.level = newStatus.getLevel();
        }
        Object object = this.statusListLock;
        synchronized (object) {
            if (this.statusList.size() < 150) {
                this.statusList.add(newStatus);
            } else {
                this.tailBuffer.add(newStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Status> getCopyOfStatusList() {
        Object object = this.statusListLock;
        synchronized (object) {
            ArrayList<Status> tList = new ArrayList<Status>(this.statusList);
            tList.addAll(this.tailBuffer.asList());
            return tList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStatusAddEvent(Status status) {
        Object object = this.statusListenerListLock;
        synchronized (object) {
            for (StatusListener sl : this.statusListenerList) {
                sl.addStatusEvent(status);
            }
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(StatusListener listener) {
        Object object = this.statusListenerListLock;
        synchronized (object) {
            this.statusListenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StatusListener listener) {
        Object object = this.statusListenerListLock;
        synchronized (object) {
            this.statusListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StatusListener> getCopyOfStatusListenerList() {
        Object object = this.statusListenerListLock;
        synchronized (object) {
            return new ArrayList<StatusListener>(this.statusListenerList);
        }
    }
}

