/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.boolex;

import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Matcher
extends ContextAwareBase
implements LifeCycle {
    private String regex;
    private String name;
    private boolean caseSensitive = true;
    private boolean canonEq = false;
    private boolean unicodeCase = false;
    private boolean start = false;
    private Pattern pattern;

    public void start() {
        if (this.name == null) {
            this.addError("All Matcher objects must be named");
            return;
        }
        try {
            int code = 0;
            if (!this.caseSensitive) {
                code |= 2;
            }
            if (this.canonEq) {
                code |= 0x80;
            }
            if (this.unicodeCase) {
                code |= 0x40;
            }
            this.pattern = Pattern.compile(this.regex, code);
            this.start = true;
        }
        catch (PatternSyntaxException pse) {
            this.addError("Failed to compile regex [" + this.regex + "]", pse);
        }
    }

    public void stop() {
        this.start = false;
    }

    public boolean isStarted() {
        return this.start;
    }

    public String getName() {
        return this.name;
    }
}

