/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.CAI_WithLocatorSupport;
import ch.qos.logback.core.joran.spi.EventPlayer;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.RuleStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private static List EMPTY_LIST = new Vector(0);
    private final RuleStore ruleStore;
    private final InterpretationContext interpretationContext;
    private final ArrayList<ImplicitAction> implicitActions;
    private final CAI_WithLocatorSupport cai = new CAI_WithLocatorSupport(this);
    private Pattern pattern;
    Locator locator;
    EventPlayer player;
    Stack<List> actionListStack;
    Pattern skip = null;

    public Interpreter(Context context, RuleStore rs, Pattern initialPattern) {
        this.cai.setContext(context);
        this.ruleStore = rs;
        this.interpretationContext = new InterpretationContext(context, this);
        this.implicitActions = new ArrayList(3);
        this.pattern = initialPattern;
        this.actionListStack = new Stack();
        this.player = new EventPlayer(this);
    }

    public void setInterpretationContextPropertiesMap(Map<String, String> propertiesMap) {
        this.interpretationContext.setPropertiesMap(propertiesMap);
    }

    public InterpretationContext getInterpretationContext() {
        return this.interpretationContext;
    }

    public void startElement(StartEvent se) {
        this.setDocumentLocator(se.getLocator());
        this.startElement(se.namespaceURI, se.localName, se.qName, se.attributes);
    }

    private void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String tagName = this.getTagName(localName, qName);
        this.pattern.push(tagName);
        if (this.skip != null) {
            this.pushEmptyActionList();
            return;
        }
        List applicableActionList = this.getApplicableActionList(this.pattern, atts);
        if (applicableActionList != null) {
            this.actionListStack.add(applicableActionList);
            this.callBeginAction(applicableActionList, tagName, atts);
        } else {
            this.pushEmptyActionList();
            String errMsg = "no applicable action for [" + tagName + "], current pattern is [" + this.pattern + "]";
            this.cai.addError(errMsg);
        }
    }

    private void pushEmptyActionList() {
        this.actionListStack.add(EMPTY_LIST);
    }

    public void characters(BodyEvent be) {
        this.setDocumentLocator(be.locator);
        String body = be.getText();
        List applicableActionList = this.actionListStack.peek();
        if (body != null) {
            body = body.trim();
        }
        if (body.length() > 0) {
            this.callBodyAction(applicableActionList, body);
        }
    }

    public void endElement(EndEvent endEvent) {
        this.setDocumentLocator(endEvent.locator);
        this.endElement(endEvent.namespaceURI, endEvent.localName, endEvent.qName);
    }

    private void endElement(String namespaceURI, String localName, String qName) {
        List applicableActionList = this.actionListStack.pop();
        if (this.skip != null) {
            if (this.skip.equals(this.pattern)) {
                this.skip = null;
            }
        } else if (applicableActionList != EMPTY_LIST) {
            this.callEndAction(applicableActionList, this.getTagName(localName, qName));
        }
        this.pattern.pop();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    String getTagName(String localName, String qName) {
        String tagName = localName;
        if (tagName == null || tagName.length() < 1) {
            tagName = qName;
        }
        return tagName;
    }

    public void addImplicitAction(ImplicitAction ia) {
        this.implicitActions.add(ia);
    }

    List lookupImplicitAction(Pattern pattern, Attributes attributes, InterpretationContext ec) {
        int len = this.implicitActions.size();
        for (int i = 0; i < len; ++i) {
            ImplicitAction ia = this.implicitActions.get(i);
            if (!ia.isApplicable(pattern, attributes, ec)) continue;
            ArrayList<ImplicitAction> actionList = new ArrayList<ImplicitAction>(1);
            actionList.add(ia);
            return actionList;
        }
        return null;
    }

    List getApplicableActionList(Pattern pattern, Attributes attributes) {
        List applicableActionList = this.ruleStore.matchActions(pattern);
        if (applicableActionList == null) {
            applicableActionList = this.lookupImplicitAction(pattern, attributes, this.interpretationContext);
        }
        return applicableActionList;
    }

    void callBeginAction(List applicableActionList, String tagName, Attributes atts) {
        if (applicableActionList == null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.begin(this.interpretationContext, tagName, atts);
            }
            catch (ActionException e) {
                this.skip = (Pattern)this.pattern.clone();
                this.cai.addError("ActionException in Action for tag [" + tagName + "]", e);
            }
            catch (RuntimeException e) {
                this.skip = (Pattern)this.pattern.clone();
                this.cai.addError("RuntimeException in Action for tag [" + tagName + "]", e);
            }
        }
    }

    private void callBodyAction(List applicableActionList, String body) {
        if (applicableActionList == null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.body(this.interpretationContext, body);
            }
            catch (ActionException ae) {
                this.cai.addError("Exception in end() methd for action [" + action + "]", ae);
            }
        }
    }

    private void callEndAction(List applicableActionList, String tagName) {
        if (applicableActionList == null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.end(this.interpretationContext, tagName);
            }
            catch (ActionException ae) {
                this.cai.addError("ActionException in Action for tag [" + tagName + "]", ae);
            }
            catch (RuntimeException e) {
                this.cai.addError("RuntimeException in Action for tag [" + tagName + "]", e);
            }
        }
    }

    public RuleStore getRuleStore() {
        return this.ruleStore;
    }

    public void play(List<SaxEvent> eventList) {
        this.player.play(eventList);
    }

    public void addEventsDynamically(List<SaxEvent> eventList, int offset) {
        if (this.player != null) {
            this.player.addEventsDynamically(eventList, offset);
        }
    }
}

