/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.spi.ContextAware;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToObjectConverter {
    private static final Class[] STING_CLASS_PARAMETER = new Class[]{String.class};

    public static boolean canBeBuiltFromSimpleString(Class<?> parameterClass) {
        Package p = parameterClass.getPackage();
        if (parameterClass.isPrimitive()) {
            return true;
        }
        if (p != null && "java.lang".equals(p.getName())) {
            return true;
        }
        if (StringToObjectConverter.followsTheValueOfConvention(parameterClass)) {
            return true;
        }
        if (parameterClass.isEnum()) {
            return true;
        }
        return StringToObjectConverter.isOfTypeCharset(parameterClass);
    }

    public static Object convertArg(ContextAware contextAware, String string, Class<?> clazz) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (String.class.isAssignableFrom(clazz)) {
            return string2;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return new Integer(string2);
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return new Long(string2);
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            return new Float(string2);
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            return new Double(string2);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            if ("true".equalsIgnoreCase(string2)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string2)) {
                return Boolean.FALSE;
            }
        } else {
            if (clazz.isEnum()) {
                return StringToObjectConverter.convertToEnum(contextAware, string2, clazz);
            }
            if (StringToObjectConverter.followsTheValueOfConvention(clazz)) {
                return StringToObjectConverter.convertByValueOfMethod(contextAware, clazz, string2);
            }
            if (StringToObjectConverter.isOfTypeCharset(clazz)) {
                return StringToObjectConverter.convertToCharset(contextAware, string);
            }
        }
        return null;
    }

    private static boolean isOfTypeCharset(Class<?> clazz) {
        return Charset.class.isAssignableFrom(clazz);
    }

    private static Charset convertToCharset(ContextAware ca, String val) {
        try {
            return Charset.forName(val);
        }
        catch (UnsupportedCharsetException e) {
            ca.addError("Failed to get charset [" + val + "]", e);
            return null;
        }
    }

    private static boolean followsTheValueOfConvention(Class<?> parameterClass) {
        try {
            Method valueOfMethod = parameterClass.getMethod("valueOf", STING_CLASS_PARAMETER);
            int mod = valueOfMethod.getModifiers();
            if (Modifier.isStatic(mod)) {
                return true;
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private static Object convertByValueOfMethod(ContextAware ca, Class<?> type, String val) {
        try {
            Method valueOfMethod = type.getMethod("valueOf", STING_CLASS_PARAMETER);
            return valueOfMethod.invoke(null, val);
        }
        catch (Exception e) {
            ca.addError("Failed to invoke valueOf{} method in class [" + type.getName() + "] with value [" + val + "]");
            return null;
        }
    }

    private static Object convertToEnum(ContextAware ca, String val, Class<? extends Enum> enumType) {
        return Enum.valueOf(enumType, val);
    }
}

