/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

class Token {
    static Token EOF_TOKEN = new Token(Integer.MAX_VALUE, "EOF");
    static Token RIGHT_PARENTHESIS_TOKEN = new Token(41);
    static Token LEFT_PARENTHESIS_TOKEN = new Token(40);
    static Token PERCENT_TOKEN = new Token(37);
    private final int type;
    private final Object value;

    public Token(int type) {
        this(type, null);
    }

    public Token(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        String typeStr = null;
        switch (this.type) {
            case 37: {
                typeStr = "%";
                break;
            }
            case 1002: {
                typeStr = "FormatModifier";
                break;
            }
            case 1000: {
                typeStr = "LITERAL";
                break;
            }
            case 1006: {
                typeStr = "OPTION";
                break;
            }
            case 1004: {
                typeStr = "KEYWORD";
                break;
            }
            case 41: {
                typeStr = "RIGHT_PARENTHESIS";
                break;
            }
            case 40: {
                typeStr = "LEFT_PARENTHESIS";
                break;
            }
            default: {
                typeStr = "UNKNOWN";
            }
        }
        if (this.value == null) {
            return "Token(" + typeStr + ")";
        }
        return "Token(" + typeStr + ", \"" + this.value + "\")";
    }

    public int hashCode() {
        int result = this.type;
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        if (this.type != token.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(token.value) : token.value != null);
    }
}

