/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander;

import com.mucommander.MuLogging;
import com.mucommander.PlatformManager;
import com.mucommander.RuntimeConstants;
import com.mucommander.ShutdownHook;
import com.mucommander.auth.CredentialsManager;
import com.mucommander.bonjour.BonjourDirectory;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.bookmark.file.BookmarkProtocolProvider;
import com.mucommander.command.Command;
import com.mucommander.command.CommandException;
import com.mucommander.command.CommandManager;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.icon.impl.SwingFileIconProvider;
import com.mucommander.commons.file.impl.ftp.FTPProtocolProvider;
import com.mucommander.commons.file.impl.smb.SMBProtocolProvider;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.conf.MuPreferences;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.extension.ExtensionManager;
import com.mucommander.shell.ShellHistoryManager;
import com.mucommander.text.CustomDateFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionKeymapIO;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.startup.CheckVersionDialog;
import com.mucommander.ui.dialog.startup.InitialSetupDialog;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.main.SplashScreen;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.main.commandbar.CommandBarIO;
import com.mucommander.ui.main.toolbar.ToolBarIO;
import com.mucommander.ui.notifier.AbstractNotifier;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(Launcher.class);
    private static SplashScreen splashScreen;
    private static boolean useSplash;
    private static boolean verbose;
    public static boolean isLaunching;
    public static final Object LAUNCH_LOCK;

    private Launcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitUntilLaunched() {
        LOGGER.debug("called, thread=" + Thread.currentThread());
        Object object = LAUNCH_LOCK;
        synchronized (object) {
            while (isLaunching) {
                try {
                    LOGGER.debug("waiting");
                    LAUNCH_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static void printUsage() {
        System.out.println("Usage: mucommander [options] [folders]");
        System.out.println("Options:");
        System.out.println(" -a FILE, --assoc FILE             Load associations from FILE.");
        System.out.println(" -b FILE, --bookmarks FILE         Load bookmarks from FILE.");
        System.out.println(" -c FILE, --configuration FILE     Load configuration from FILE");
        System.out.println(" -C FILE, --commandbar FILE        Load command bar from FILE.");
        System.out.println(" -e FOLDER, --extensions FOLDER    Load extensions from FOLDER.");
        System.out.println(" -f FILE, --commands FILE          Load custom commands from FILE.");
        System.out.println(" -i, --ignore-warnings             Do not fail on warnings (default).");
        System.out.println(" -k FILE, --keymap FILE            Load keymap from FILE");
        System.out.println(" -p FOLDER, --preferences FOLDER   Store configuration files in FOLDER");
        System.out.println(" -S, --silent                      Do not print verbose error messages");
        System.out.println(" -s FILE, --shell-history FILE     Load shell history from FILE");
        System.out.println(" -t FILE, --toolbar FILE           Load toolbar from FILE");
        System.out.println(" -u FILE, --credentials FILE       Load credentials from FILE");
        System.out.println(" -h, --help                        Print the help text and exit");
        System.out.println(" -v, --version                     Print the version and exit");
        System.out.println(" -V, --verbose                     Print verbose error messages (default)");
        System.out.println(" -w, --fail-on-warnings            Quits when a warning is encountered during");
        System.out.println("                                   the boot process.");
        System.exit(0);
    }

    private static void printVersion() {
        System.out.println(RuntimeConstants.APP_STRING);
        System.out.print("Copyright (C) ");
        System.out.print(RuntimeConstants.COPYRIGHT);
        System.out.println(" Maxence Bernard");
        System.out.println("This is free software, distributed under the terms of the GNU General Public License.");
        System.exit(0);
    }

    private static void printError(String msg, Exception exception, boolean quit) {
        Launcher.printError(Launcher.createErrorMessage(msg, exception, quit).toString(), quit);
    }

    private static StringBuilder createErrorMessage(String msg, Exception exception, boolean quit) {
        StringBuilder error = new StringBuilder();
        if (quit) {
            error.append("Warning: ");
        }
        error.append(msg);
        if (verbose && exception != null) {
            error.append(": ");
            error.append(exception.getMessage());
        }
        return error;
    }

    private static void printError(String msg, boolean quit) {
        System.err.println(msg);
        if (quit) {
            System.err.println("See mucommander --help for more information.");
            System.exit(1);
        }
    }

    private static void printFileError(String msg, Exception exception, boolean quit) {
        StringBuilder error = Launcher.createErrorMessage(msg, exception, quit);
        if (!quit) {
            error.append(". Using default values.");
        }
        Launcher.printError(error.toString(), quit);
    }

    private static void printStartupMessage(String message) {
        if (useSplash) {
            splashScreen.setLoadingMessage(message);
        }
        LOGGER.trace(message);
    }

    private static void migrateCommand(String useName, String commandName, String alias) {
        String command;
        if (MuConfigurations.getPreferences().getBooleanVariable(useName) && (command = MuConfigurations.getPreferences().getVariable(commandName)) != null) {
            try {
                CommandManager.registerCommand(new Command(alias, command, 1));
            }
            catch (CommandException e) {
                // empty catch block
            }
            MuConfigurations.getPreferences().removeVariable(useName);
            MuConfigurations.getPreferences().removeVariable(commandName);
        }
    }

    private static void checkHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Error: no graphical environment detected.");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try {
            boolean isFirstBoot;
            int i;
            boolean fatalWarnings = false;
            verbose = true;
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("-v") || args[i].equals("--version")) {
                    Launcher.printVersion();
                    continue;
                }
                if (args[i].equals("-h") || args[i].equals("--help")) {
                    Launcher.printUsage();
                    continue;
                }
                if (args[i].equals("-a") || args[i].equals("--assoc")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        CommandManager.setAssociationFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set association files", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-f") || args[i].equals("--commands")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        CommandManager.setCommandFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set commands file", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-b") || args[i].equals("--bookmarks")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        BookmarkManager.setBookmarksFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set bookmarks file", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-c") || args[i].equals("--configuration")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        MuConfigurations.setPreferencesFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set configuration file", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--shell-history")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        ShellHistoryManager.setHistoryFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set shell history file", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-k") || args[i].equals("--keymap")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        ActionKeymapIO.setActionsFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set keymap file", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--toolbar")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        ToolBarIO.setDescriptionFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set keymap file", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-C") || args[i].equals("--commandbar")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        CommandBarIO.setDescriptionFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set commandbar description file", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-U") || args[i].equals("--credentials")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FILE parameter to " + args[i], null, true);
                    }
                    try {
                        CredentialsManager.setCredentialsFile(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set credentials file", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("--preferences")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FOLDER parameter to " + args[i], null, true);
                    }
                    try {
                        PlatformManager.setPreferencesFolder(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set preferences folder", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-e") || args[i].equals("--extensions")) {
                    if (i >= args.length - 1) {
                        Launcher.printError("Missing FOLDER parameter to " + args[i], null, true);
                    }
                    try {
                        ExtensionManager.setExtensionsFolder(args[++i]);
                    }
                    catch (Exception e) {
                        Launcher.printError("Could not set extensions folder", e, fatalWarnings);
                    }
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--ignore-warnings")) {
                    fatalWarnings = false;
                    continue;
                }
                if (args[i].equals("-w") || args[i].equals("--fail-on-warnings")) {
                    fatalWarnings = true;
                    continue;
                }
                if (args[i].equals("-S") || args[i].equals("--silent")) {
                    verbose = false;
                    continue;
                }
                if (!args[i].equals("-V") && !args[i].equals("--verbose")) break;
                verbose = true;
            }
            Launcher.checkHeadless();
            try {
                isFirstBoot = !MuConfigurations.isPreferencesFileExists();
            }
            catch (IOException e) {
                isFirstBoot = true;
            }
            try {
                MuConfigurations.loadSnapshot();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load snapshot", e, fatalWarnings);
            }
            try {
                MuConfigurations.loadPreferences();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load configuration", e, fatalWarnings);
            }
            MuLogging.configureLogging();
            if (OsFamilies.MAC_OS_X.isCurrent()) {
                try {
                    Class<?> osxIntegrationClass = Class.forName("com.mucommander.ui.macosx.OSXIntegration");
                    Constructor<?> constructor = osxIntegrationClass.getConstructor(new Class[0]);
                    constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.debug("Exception thrown while initializing Mac OS X integration", e);
                }
            }
            try {
                ExtensionManager.addExtensionsToClasspath();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to add extensions to the classpath", e);
            }
            System.setProperty("java.net.useSystemProxies", "true");
            useSplash = MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_SPLASH_SCREEN, true);
            if (useSplash) {
                splashScreen = new SplashScreen(RuntimeConstants.VERSION, "Loading preferences...");
            }
            boolean showSetup = MuConfigurations.getPreferences().getVariable(MuPreference.THEME_TYPE) == null;
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            Launcher.configureFilesystems();
            try {
                DesktopManager.init(isFirstBoot);
            }
            catch (Exception e) {
                Launcher.printError("Could not initialize desktop", e, true);
            }
            Launcher.printStartupMessage("Loading dictionary...");
            try {
                Translator.loadDictionaryFile();
            }
            catch (Exception e) {
                Launcher.printError("Could not load dictionary", e, true);
            }
            Launcher.printStartupMessage("Loading file associations...");
            try {
                CommandManager.loadCommands();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load custom commands", e, fatalWarnings);
            }
            Launcher.migrateCommand("viewer.use_custom", "viewer.custom_command", "view");
            Launcher.migrateCommand("editor.use_custom", "editor.custom_command", "edit");
            try {
                CommandManager.writeCommands();
            }
            catch (Exception e) {
                System.out.println("###############################");
                LOGGER.debug("Caught exception", e);
            }
            try {
                CommandManager.loadAssociations();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load custom associations", e, fatalWarnings);
            }
            Launcher.printStartupMessage("Loading bookmarks...");
            try {
                BookmarkManager.loadBookmarks();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load bookmarks", e, fatalWarnings);
            }
            Launcher.printStartupMessage("Loading credentials...");
            try {
                CredentialsManager.loadCredentials();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load credentials", e, fatalWarnings);
            }
            Launcher.printStartupMessage("Loading shell history...");
            try {
                ShellHistoryManager.loadHistory();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load shell history", e, fatalWarnings);
            }
            CustomDateFormat.init();
            Launcher.printStartupMessage("Loading icons...");
            SwingFileIconProvider.forceInit();
            FileIcons.setScaleFactor(Math.max(1.0f, MuConfigurations.getPreferences().getVariable(MuPreference.TABLE_ICON_SCALE, 1.0f)));
            FileIcons.setSystemIconsPolicy(MuConfigurations.getPreferences().getVariable(MuPreference.USE_SYSTEM_FILE_ICONS, "applications"));
            Launcher.printStartupMessage("Registering actions...");
            ActionManager.registerActions();
            Launcher.printStartupMessage("Loading actions shortcuts...");
            try {
                ActionKeymapIO.loadActionKeymap();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load actions shortcuts", e, fatalWarnings);
            }
            Launcher.printStartupMessage("Loading toolbar description...");
            try {
                ToolBarIO.loadDescriptionFile();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load toolbar description", e, fatalWarnings);
            }
            Launcher.printStartupMessage("Loading command bar description...");
            try {
                CommandBarIO.loadCommandBar();
            }
            catch (Exception e) {
                Launcher.printFileError("Could not load commandbar description", e, fatalWarnings);
            }
            Launcher.printStartupMessage("Loading theme...");
            ThemeManager.loadCurrentTheme();
            Launcher.printStartupMessage("Starting Bonjour services discovery...");
            BonjourDirectory.setActive(MuConfigurations.getPreferences().getVariable(MuPreference.ENABLE_BONJOUR_DISCOVERY, true));
            Launcher.printStartupMessage("Initializing window...");
            while (i < args.length) {
                if (i < args.length - 1) {
                    WindowManager.createNewMainFrame(args[i], args[i + 1]);
                } else {
                    WindowManager.createNewMainFrame(args[i], null);
                }
                i += 2;
            }
            if (WindowManager.getCurrentMainFrame() == null) {
                WindowManager.createNewMainFrame();
            }
            Object object = LAUNCH_LOCK;
            synchronized (object) {
                isLaunching = false;
                LAUNCH_LOCK.notifyAll();
            }
            if (MuConfigurations.getPreferences().getVariable(MuPreference.ENABLE_SYSTEM_NOTIFICATIONS, MuPreferences.DEFAULT_ENABLE_SYSTEM_NOTIFICATIONS)) {
                Launcher.printStartupMessage("Enabling system notifications...");
                if (AbstractNotifier.isAvailable()) {
                    AbstractNotifier.getNotifier().setEnabled(true);
                }
            }
            if (splashScreen != null) {
                splashScreen.dispose();
            }
            if (MuConfigurations.getPreferences().getVariable(MuPreference.CHECK_FOR_UPDATE, true)) {
                new CheckVersionDialog(WindowManager.getCurrentMainFrame(), false);
            }
            if (showSetup) {
                new InitialSetupDialog(WindowManager.getCurrentMainFrame()).showDialog();
            }
        }
        catch (Throwable t) {
            if (splashScreen != null) {
                splashScreen.dispose();
            }
            LOGGER.error("Startup failed", t);
            InformationDialog.showErrorDialog(null, null, Translator.get("startup_error", new String[0]), null, t);
            WindowManager.quit();
        }
    }

    private static void configureFilesystems() {
        SMBProtocolProvider.setLmCompatibility(MuConfigurations.getPreferences().getVariable(MuPreference.SMB_LM_COMPATIBILITY, 0));
        SMBProtocolProvider.setExtendedSecurity(MuConfigurations.getPreferences().getVariable(MuPreference.SMB_USE_EXTENDED_SECURITY, false));
        FTPProtocolProvider.setForceHiddenFilesListing(MuConfigurations.getPreferences().getVariable(MuPreference.LIST_HIDDEN_FILES, false));
        FileFactory.setDefaultAuthenticator(CredentialsManager.getAuthenticator());
        FileFactory.registerProtocol("bookmark", new BookmarkProtocolProvider());
    }

    static {
        isLaunching = true;
        LAUNCH_LOCK = new Object();
    }
}

