/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformManager
implements JavaVersions,
OsFamilies,
OsVersions {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformManager.class);
    private static AbstractFile prefFolder;

    public static AbstractFile getDefaultPreferencesFolder() {
        File folder = MAC_OS_X.isCurrent() ? new File(System.getProperty("user.home") + "/Library/Preferences/muCommander") : new File(System.getProperty("user.home"), "/.mucommander");
        if (!folder.exists() && !folder.mkdir()) {
            LOGGER.warn("Could not create preference folder: " + folder.getAbsolutePath());
        }
        return FileFactory.getFile(folder.getAbsolutePath());
    }

    public static AbstractFile getPreferencesFolder() {
        if (prefFolder != null) {
            return prefFolder;
        }
        return PlatformManager.getDefaultPreferencesFolder();
    }

    public static void setPreferencesFolder(File folder) throws IOException {
        PlatformManager.setPreferencesFolder(FileFactory.getFile(folder.getAbsolutePath()));
    }

    public static void setPreferencesFolder(String path) throws IOException {
        AbstractFile folder = FileFactory.getFile(path);
        if (folder == null) {
            PlatformManager.setPreferencesFolder(new File(path));
        } else {
            PlatformManager.setPreferencesFolder(folder);
        }
    }

    public static void setPreferencesFolder(AbstractFile folder) throws IOException {
        if (!folder.exists()) {
            folder.mkdir();
        } else if (!folder.isBrowsable()) {
            folder = folder.getParent();
        }
        prefFolder = folder;
    }
}

