/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander;

import com.mucommander.auth.CredentialsManager;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.command.CommandManager;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.shell.ShellHistoryManager;
import com.mucommander.ui.action.ActionKeymapIO;
import com.mucommander.ui.main.commandbar.CommandBarIO;
import com.mucommander.ui.main.toolbar.ToolBarIO;
import com.mucommander.ui.main.tree.TreeIOThreadManager;
import com.mucommander.ui.theme.ThemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHook
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHook.class);
    private static boolean shutdownTasksPerformed;

    public ShutdownHook() {
        super(ShutdownHook.class.getName());
    }

    public static void initiateShutdown() {
        LOGGER.info("shutting down");
        System.exit(0);
    }

    public void run() {
        ShutdownHook.performShutdownTasks();
    }

    private static synchronized void performShutdownTasks() {
        if (shutdownTasksPerformed) {
            return;
        }
        TreeIOThreadManager.getInstance().interrupt();
        try {
            MuConfigurations.saveSnapshot();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save snapshot", e);
        }
        try {
            MuConfigurations.savePreferences();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save configuration", e);
        }
        try {
            ShellHistoryManager.writeHistory();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save shell history", e);
        }
        try {
            CredentialsManager.writeCredentials(false);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save credentials", e);
        }
        try {
            BookmarkManager.writeBookmarks(false);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save bookmarks", e);
        }
        try {
            ThemeManager.saveCurrentTheme();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save user theme", e);
        }
        try {
            CommandManager.writeCommands();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save commands", e);
        }
        try {
            CommandManager.writeAssociations();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save associations", e);
        }
        try {
            ActionKeymapIO.saveActionKeymap();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save action keymap", e);
        }
        try {
            CommandBarIO.saveCommandBar();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save command bar", e);
        }
        try {
            ToolBarIO.saveToolBar();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save toolbar", e);
        }
        shutdownTasksPerformed = true;
    }
}

