/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.auth;

import com.mucommander.PlatformManager;
import com.mucommander.auth.CredentialsMapping;
import com.mucommander.auth.CredentialsParser;
import com.mucommander.auth.CredentialsWriter;
import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.commons.collections.VectorChangeListener;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.Authenticator;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.util.Chmod;
import com.mucommander.commons.runtime.OsFamily;
import com.mucommander.io.backup.BackupOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CredentialsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsManager.class);
    private static List<CredentialsMapping> volatileCredentialMappings = new Vector<CredentialsMapping>();
    private static AlteredVector<CredentialsMapping> persistentCredentialMappings = new AlteredVector();
    private static final Authenticator AUTHENTICATOR = new CredentialsManagerAuthenticator();
    private static AbstractFile credentialsFile;
    private static final VectorChangeListener PERSISTENT_CREDENTIALS_VECTOR_CHANGE_LISTENER;
    private static boolean saveNeeded;
    private static CredentialsManager singleton;

    private static AbstractFile getCredentialsFile() throws IOException {
        if (credentialsFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("credentials.xml");
        }
        return credentialsFile;
    }

    public static void setCredentialsFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            CredentialsManager.setCredentialsFile(new File(path));
        } else {
            CredentialsManager.setCredentialsFile(file);
        }
    }

    public static void setCredentialsFile(File file) throws FileNotFoundException {
        CredentialsManager.setCredentialsFile(FileFactory.getFile(file.getAbsolutePath()));
    }

    public static void setCredentialsFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file);
        }
        credentialsFile = file;
    }

    public static void loadCredentials() throws Exception {
        AbstractFile credentialsFile = CredentialsManager.getCredentialsFile();
        if (credentialsFile.exists()) {
            LOGGER.debug("Found credentials file: " + credentialsFile.getAbsolutePath());
            new CredentialsParser().parse(credentialsFile);
            LOGGER.debug("Credentials file loaded.");
        } else {
            LOGGER.debug("No credentials file found at " + credentialsFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCredentials(boolean forceWrite) throws IOException {
        boolean fileSecured;
        if (!forceWrite && !saveNeeded) {
            return;
        }
        BackupOutputStream out = null;
        try {
            credentialsFile = CredentialsManager.getCredentialsFile();
            out = new BackupOutputStream(credentialsFile);
            CredentialsWriter.write(out);
            saveNeeded = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        boolean bl = fileSecured = !OsFamily.getCurrent().isUnixBased() || Chmod.chmod(credentialsFile, 384);
        if (fileSecured) {
            LOGGER.debug("Credentials file saved successfully.");
        } else {
            LOGGER.warn("Credentials file could not be chmod!");
        }
    }

    public static CredentialsMapping[] getMatchingCredentials(FileURL location) {
        List<CredentialsMapping> matchesV = CredentialsManager.getMatchingCredentialsV(location);
        CredentialsMapping[] matches = new CredentialsMapping[matchesV.size()];
        matchesV.toArray(matches);
        return matches;
    }

    public static Authenticator getAuthenticator() {
        return AUTHENTICATOR;
    }

    private static List<CredentialsMapping> getMatchingCredentialsV(FileURL location) {
        Vector<CredentialsMapping> matchesV = new Vector<CredentialsMapping>();
        CredentialsManager.findMatches(location, volatileCredentialMappings, matchesV);
        CredentialsManager.findMatches(location, persistentCredentialMappings, matchesV);
        int bestMatchIndex = CredentialsManager.getBestMatchIndex(location, matchesV);
        if (bestMatchIndex != -1) {
            matchesV.add(0, (CredentialsMapping)matchesV.remove(bestMatchIndex));
        }
        return matchesV;
    }

    public static void addCredentials(CredentialsMapping credentialsMapping) {
        if (credentialsMapping.getCredentials().isEmpty()) {
            return;
        }
        boolean persist = credentialsMapping.isPersistent();
        LOGGER.trace("called, realm=" + credentialsMapping.getRealm() + " isPersistent=" + credentialsMapping.isPersistent());
        LOGGER.trace("before, persistentCredentials=" + persistentCredentialMappings);
        LOGGER.trace("before, volatileCredentials=" + volatileCredentialMappings);
        if (persist) {
            CredentialsManager.replaceVectorElement(persistentCredentialMappings, credentialsMapping);
            volatileCredentialMappings.remove(credentialsMapping);
        } else {
            CredentialsManager.replaceVectorElement(volatileCredentialMappings, credentialsMapping);
            persistentCredentialMappings.removeElement(credentialsMapping);
        }
        LOGGER.trace("after, persistentCredentials=" + persistentCredentialMappings);
        LOGGER.trace("after, volatileCredentials=" + volatileCredentialMappings);
    }

    public static void authenticate(FileURL location, CredentialsMapping credentialsMapping) {
        location.setCredentials(credentialsMapping.getCredentials());
        FileURL realm = credentialsMapping.getRealm();
        Enumeration<String> propertyKeys = realm.getPropertyNames();
        while (propertyKeys.hasMoreElements()) {
            String key = propertyKeys.nextElement();
            if (location.getProperty(key) != null) continue;
            location.setProperty(key, realm.getProperty(key));
        }
    }

    private static void authenticateImplicit(FileURL location) {
        LOGGER.trace("called, fileURL=" + location + " containsCredentials=" + location.containsCredentials());
        CredentialsMapping[] creds = CredentialsManager.getMatchingCredentials(location);
        if (creds.length > 0) {
            CredentialsManager.authenticate(location, creds[0]);
        } else {
            Credentials guestCredentials = location.getGuestCredentials();
            if (guestCredentials != null) {
                CredentialsManager.authenticate(location, new CredentialsMapping(guestCredentials, location.getRealm(), false));
            }
        }
    }

    private static void findMatches(FileURL location, List<CredentialsMapping> credentials, List<CredentialsMapping> matches) {
        int nbEntries = credentials.size();
        for (CredentialsMapping tempCredentialsMapping : credentials) {
            FileURL tempRealm = tempCredentialsMapping.getRealm();
            if (!location.schemeEquals(tempRealm) || !location.portEquals(tempRealm) || !location.hostEquals(tempRealm)) continue;
            matches.add(tempCredentialsMapping);
        }
        LOGGER.trace("returning matches=" + matches);
    }

    private static int getBestMatchIndex(FileURL location, List<CredentialsMapping> matches) {
        if (matches.size() == 0) {
            return -1;
        }
        String path = location.getPath();
        Vector<String> pathTokensV = new Vector<String>();
        StringTokenizer st = new StringTokenizer(path, "/\\");
        while (st.hasMoreTokens()) {
            pathTokensV.add(st.nextToken());
        }
        int nbTokens = pathTokensV.size();
        String[] pathTokens = new String[nbTokens];
        pathTokensV.toArray(pathTokens);
        int maxTokens = 0;
        int bestMatchIndex = 0;
        int nbMatches = matches.size();
        for (int i = 0; i < nbMatches; ++i) {
            CredentialsMapping tempCredentialsMapping = matches.get(i);
            FileURL tempURL = tempCredentialsMapping.getRealm();
            String tempPath = tempURL.getPath();
            if (tempPath.equalsIgnoreCase(path)) {
                return i;
            }
            st = new StringTokenizer(tempPath, "/\\");
            int nbMatchingToken = 0;
            for (int j = 0; j < nbTokens && st.hasMoreTokens() && st.nextToken().equalsIgnoreCase(pathTokens[nbMatchingToken]); ++j) {
                ++nbMatchingToken;
            }
            if (nbMatchingToken <= maxTokens) continue;
            maxTokens = nbMatchingToken;
            bestMatchIndex = i;
        }
        LOGGER.trace("returning bestMatchIndex=" + bestMatchIndex);
        return bestMatchIndex;
    }

    private static void replaceVectorElement(List<CredentialsMapping> vector, CredentialsMapping o) {
        int index = vector.indexOf(o);
        if (index == -1) {
            vector.add(o);
        } else {
            vector.set(index, o);
        }
    }

    public static AlteredVector<CredentialsMapping> getPersistentCredentialMappings() {
        return persistentCredentialMappings;
    }

    static {
        singleton = new CredentialsManager();
        PERSISTENT_CREDENTIALS_VECTOR_CHANGE_LISTENER = new VectorChangeListener(){

            public void elementsAdded(int startIndex, int nbAdded) {
                saveNeeded = true;
            }

            public void elementsRemoved(int startIndex, int nbRemoved) {
                saveNeeded = true;
            }

            public void elementChanged(int index) {
                saveNeeded = true;
            }
        };
        persistentCredentialMappings.addVectorChangeListener(PERSISTENT_CREDENTIALS_VECTOR_CHANGE_LISTENER);
    }

    private static class CredentialsManagerAuthenticator
    implements Authenticator {
        private CredentialsManagerAuthenticator() {
        }

        public void authenticate(FileURL fileURL) {
            CredentialsManager.authenticateImplicit(fileURL);
        }
    }
}

