/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.auth;

import com.mucommander.auth.CredentialsManager;
import com.mucommander.auth.CredentialsMapping;
import com.mucommander.bookmark.XORCipher;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.io.backup.BackupInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CredentialsParser
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsParser.class);
    private FileURL url;
    private Map<String, String> urlProperties;
    private String login;
    private String password;
    private StringBuilder characters;
    private String version;
    private String encryptionMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(AbstractFile file) throws Exception {
        InputStream in = null;
        this.characters = new StringBuilder();
        try {
            in = new BackupInputStream(file);
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)this);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters.setLength(0);
        if (qName.equals("credentials")) {
            this.url = null;
            this.urlProperties = null;
            this.login = null;
            this.password = null;
        } else if (qName.equals("property")) {
            if (this.urlProperties == null) {
                this.urlProperties = new Hashtable<String, String>();
            }
            this.urlProperties.put(attributes.getValue("name"), attributes.getValue("value"));
        } else if (qName.equals("credentials_list")) {
            this.encryptionMethod = attributes.getValue("encryption");
            this.version = attributes.getValue("version");
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("credentials")) {
            if (this.url == null || this.login == null || this.password == null) {
                LOGGER.info("Missing value, credentials ignored: url=" + this.url + " login=" + this.login);
                return;
            }
            if (this.urlProperties != null) {
                for (String key : this.urlProperties.keySet()) {
                    this.url.setProperty(key, this.urlProperties.get(key));
                }
            }
            try {
                this.password = XORCipher.decryptXORBase64(this.password);
            }
            catch (IOException e) {
                LOGGER.info("Password could not be decrypted: " + this.password + ", credentials will be ignored");
                return;
            }
            CredentialsManager.getPersistentCredentialMappings().add(new CredentialsMapping(new Credentials(this.login, this.password), this.url, true));
        } else if (qName.equals("url")) {
            try {
                this.url = FileURL.getFileURL(this.characters.toString().trim());
            }
            catch (MalformedURLException e) {
                LOGGER.info("Malformed URL: " + this.characters + ", location will be ignored");
            }
        } else if (qName.equals("login")) {
            this.login = this.characters.toString().trim();
        } else if (qName.equals("password")) {
            this.password = this.characters.toString().trim();
        }
    }

    public void characters(char[] ch, int offset, int length) {
        this.characters.append(ch, offset, length);
    }
}

