/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.bonjour;

import com.mucommander.bonjour.BonjourService;
import com.mucommander.commons.file.FileURL;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Vector;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BonjourDirectory
implements ServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BonjourDirectory.class);
    private static final BonjourDirectory instance = new BonjourDirectory();
    private static JmDNS jmDNS;
    private static List<BonjourService> services;
    private static final String[][] KNOWN_SERVICE_TYPES;

    private BonjourDirectory() {
    }

    public static void setActive(boolean enabled) {
        if (enabled && jmDNS == null) {
            try {
                jmDNS = JmDNS.create();
                int nbServices = KNOWN_SERVICE_TYPES.length;
                for (int i = 0; i < nbServices; ++i) {
                    jmDNS.addServiceListener(KNOWN_SERVICE_TYPES[i][0], instance);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Could not instantiate jmDNS, Bonjour not enabled", e);
            }
        } else if (!enabled && jmDNS != null) {
            jmDNS.close();
            services.clear();
            jmDNS = null;
        }
    }

    public static boolean isActive() {
        return jmDNS != null;
    }

    public static BonjourService[] getServices() {
        BonjourService[] servicesArray = new BonjourService[services.size()];
        services.toArray(servicesArray);
        return servicesArray;
    }

    private static BonjourService createBonjourService(ServiceInfo serviceInfo) {
        try {
            String type = serviceInfo.getType();
            int nbServices = KNOWN_SERVICE_TYPES.length;
            for (int i = 0; i < nbServices; ++i) {
                if (!KNOWN_SERVICE_TYPES[i][0].equals(type)) continue;
                return new BonjourService(serviceInfo.getName(), FileURL.getFileURL(serviceInfo.getURL(KNOWN_SERVICE_TYPES[i][1])), serviceInfo.getQualifiedName());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public void serviceAdded(final ServiceEvent serviceEvent) {
        LOGGER.trace("name=" + serviceEvent.getName() + " type=" + serviceEvent.getType());
        if (!BonjourDirectory.isActive()) {
            return;
        }
        new Thread(){

            public void run() {
                jmDNS.requestServiceInfo(serviceEvent.getType(), serviceEvent.getName(), 10000);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(ServiceEvent serviceEvent) {
        LOGGER.trace("name=" + serviceEvent.getName() + " type=" + serviceEvent.getType() + " info=" + serviceEvent.getInfo());
        if (!BonjourDirectory.isActive()) {
            return;
        }
        ServiceInfo serviceInfo = serviceEvent.getInfo();
        if (serviceInfo != null) {
            if (serviceInfo.getInetAddress() instanceof Inet6Address) {
                LOGGER.debug("ignoring IPv6 service");
                return;
            }
            BonjourService bs = BonjourDirectory.createBonjourService(serviceInfo);
            BonjourDirectory bonjourDirectory = instance;
            synchronized (bonjourDirectory) {
                if (bs != null && !services.contains(bs)) {
                    LOGGER.debug("BonjourService " + bs + " added");
                    services.add(bs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(ServiceEvent serviceEvent) {
        LOGGER.trace("name=" + serviceEvent.getName() + " type=" + serviceEvent.getType());
        if (!BonjourDirectory.isActive()) {
            return;
        }
        ServiceInfo serviceInfo = jmDNS.getServiceInfo(serviceEvent.getType(), serviceEvent.getName());
        if (serviceInfo != null) {
            if (serviceInfo.getInetAddress() instanceof Inet6Address) {
                LOGGER.debug("ignoring IPv6 service");
                return;
            }
            BonjourService bs = BonjourDirectory.createBonjourService(serviceInfo);
            BonjourDirectory bonjourDirectory = instance;
            synchronized (bonjourDirectory) {
                if (bs != null && services.contains(bs)) {
                    LOGGER.debug("BonjourService " + bs + " removed");
                    services.remove(bs);
                }
            }
        }
    }

    static {
        services = new Vector<BonjourService>();
        KNOWN_SERVICE_TYPES = new String[][]{{"_http._tcp.local.", "http"}, {"_ftp._tcp.local.", "ftp"}, {"_ssh._tcp.local.", "sftp"}, {"_smb._tcp.local.", "smb"}};
    }
}

