/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.bookmark;

import com.mucommander.auth.CredentialsManager;
import com.mucommander.auth.CredentialsMapping;
import com.mucommander.bookmark.BookmarkBuilder;
import com.mucommander.bookmark.BookmarkException;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class BookmarkParser
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BookmarkParser.class);
    private String bookmarkName;
    private String bookmarkLocation;
    private StringBuilder characters;
    private BookmarkBuilder builder;
    private String version;

    void parse(InputStream in, BookmarkBuilder builder) throws Exception {
        this.builder = builder;
        this.characters = new StringBuilder();
        SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)this);
    }

    public void startDocument() throws SAXException {
        try {
            this.builder.startBookmarks();
        }
        catch (BookmarkException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.builder.endBookmarks();
        }
        catch (BookmarkException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.characters.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters.setLength(0);
        if (qName.equals("bookmarks")) {
            this.version = attributes.getValue("version");
        } else if (qName.equals("bookmark")) {
            this.bookmarkName = null;
            this.bookmarkLocation = null;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("bookmark")) {
            if (this.bookmarkName == null || this.bookmarkLocation == null) {
                LOGGER.info("Missing value, bookmark ignored: name=" + this.bookmarkName + " location=" + this.bookmarkLocation);
                return;
            }
            try {
                this.builder.addBookmark(this.bookmarkName, this.bookmarkLocation);
            }
            catch (BookmarkException e) {
                throw new SAXException(e);
            }
        }
        if (qName.equals("name")) {
            this.bookmarkName = this.characters.toString().trim();
        } else if (qName.equals("location")) {
            this.bookmarkLocation = this.characters.toString().trim();
        } else if (qName.equals("url")) {
            try {
                FileURL url = FileURL.getFileURL(this.characters.toString().trim());
                Credentials credentials = url.getCredentials();
                if (credentials != null) {
                    CredentialsManager.addCredentials(new CredentialsMapping(credentials, url, true));
                    this.bookmarkLocation = url.toString(false);
                } else {
                    this.bookmarkLocation = this.characters.toString().trim();
                }
            }
            catch (MalformedURLException e) {
                this.bookmarkLocation = this.characters.toString().trim();
            }
        }
    }
}

