/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.bookmark.file;

import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkBuilder;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.bookmark.file.BookmarkOutputStream;
import com.mucommander.bookmark.file.BookmarkRoot;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;

public class BookmarkFile
extends ProtocolFile {
    private Bookmark bookmark;
    private AbstractFile file;
    static final FilePermissions PERMISSIONS = new SimpleFilePermissions(384, 448);

    protected BookmarkFile(Bookmark bookmark) throws IOException {
        super(FileURL.getFileURL("bookmark://" + URLEncoder.encode(bookmark.getName(), "UTF-8")));
        this.bookmark = bookmark;
    }

    private synchronized AbstractFile getUnderlyingFile() {
        if (this.file == null) {
            this.file = FileFactory.getFile(this.bookmark.getLocation());
        }
        return this.file;
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public String getName() {
        return this.bookmark.getName();
    }

    public AbstractFile[] ls() throws IOException, UnsupportedFileOperationException {
        return this.getUnderlyingFile().ls();
    }

    public AbstractFile getParent() {
        try {
            return new BookmarkRoot();
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getFreeSpace() throws IOException, UnsupportedFileOperationException {
        return this.getUnderlyingFile().getFreeSpace();
    }

    public long getTotalSpace() throws IOException, UnsupportedFileOperationException {
        return this.getUnderlyingFile().getTotalSpace();
    }

    public boolean isDirectory() {
        return true;
    }

    public void setParent(AbstractFile parent) {
        this.getUnderlyingFile().setParent(parent);
    }

    public boolean exists() {
        return BookmarkManager.getBookmark(this.bookmark.getName()) != null;
    }

    public void mkfile() {
        BookmarkManager.addBookmark(this.bookmark);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractFile)) {
            return false;
        }
        AbstractFile file = ((AbstractFile)o).getAncestor();
        if (file instanceof BookmarkFile) {
            return this.bookmark.equals(((BookmarkFile)file).getBookmark());
        }
        return false;
    }

    public String getCanonicalPath() {
        return this.bookmark.getLocation();
    }

    public void renameTo(AbstractFile destination) throws IOException {
        this.checkRenamePrerequisites(destination, true, true);
        destination = destination.getTopAncestor();
        if (!(destination instanceof BookmarkFile)) {
            throw new IOException();
        }
        Bookmark newBookmark = new Bookmark(destination.getName(), this.bookmark.getLocation());
        Bookmark oldBookmark = BookmarkManager.getBookmark(newBookmark.getName());
        if (oldBookmark != null) {
            BookmarkManager.removeBookmark(oldBookmark);
        }
        BookmarkManager.addBookmark(newBookmark);
        BookmarkManager.removeBookmark(this.bookmark);
    }

    @UnsupportedFileOperation
    public void delete() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.DELETE);
    }

    public void copyRemotelyTo(AbstractFile destination) throws IOException {
        if (!((destination = destination.getTopAncestor()) instanceof BookmarkFile)) {
            throw new IOException();
        }
        BookmarkManager.addBookmark(new Bookmark(destination.getName(), this.bookmark.getLocation()));
    }

    public FilePermissions getPermissions() {
        return PERMISSIONS;
    }

    @UnsupportedFileOperation
    public void changePermission(int access, int permission, boolean enabled) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CHANGE_PERMISSION);
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        BookmarkBuilder builder = BookmarkManager.getBookmarkWriter(stream);
        try {
            builder.startBookmarks();
            builder.addBookmark(this.bookmark.getName(), this.bookmark.getLocation());
            builder.endBookmarks();
        }
        catch (Throwable e) {
            Throwable e2;
            while ((e2 = e.getCause()) != null) {
                e = e2;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
        return new ByteArrayInputStream(stream.toByteArray());
    }

    public OutputStream getOutputStream() throws IOException {
        return new BookmarkOutputStream();
    }

    @UnsupportedFileOperation
    public void mkdir() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CREATE_DIRECTORY);
    }

    public long getDate() {
        return 0L;
    }

    public PermissionBits getChangeablePermissions() {
        return PermissionBits.EMPTY_PERMISSION_BITS;
    }

    @UnsupportedFileOperation
    public void changeDate(long lastModified) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CHANGE_DATE);
    }

    public long getSize() {
        return -1L;
    }

    @UnsupportedFileOperation
    public RandomAccessInputStream getRandomAccessInputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_READ_FILE);
    }

    @UnsupportedFileOperation
    public OutputStream getAppendOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.APPEND_FILE);
    }

    @UnsupportedFileOperation
    public RandomAccessOutputStream getRandomAccessOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_WRITE_FILE);
    }

    public Object getUnderlyingFileObject() {
        return null;
    }

    public boolean isSymlink() {
        return false;
    }

    public String getOwner() {
        return null;
    }

    public boolean canGetOwner() {
        return false;
    }

    public String getGroup() {
        return null;
    }

    public boolean canGetGroup() {
        return false;
    }
}

