/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.bookmark.file;

import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.bookmark.file.BookmarkFile;
import com.mucommander.bookmark.file.BookmarkRoot;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.ProtocolProvider;
import java.io.IOException;

public class BookmarkProtocolProvider
implements ProtocolProvider {
    public AbstractFile getFile(FileURL url, Object ... instantiationParams) throws IOException {
        if (url.getHost() == null) {
            if (url.getPath().equals("/")) {
                return new BookmarkRoot(url);
            }
            throw new IOException();
        }
        Bookmark bookmark = BookmarkManager.getBookmark(url.getHost());
        if (bookmark == null) {
            if (!url.getPath().equals("/")) {
                throw new IOException();
            }
            return new BookmarkFile(new Bookmark(url.getHost(), url.getPath()));
        }
        if (!url.getPath().equals("/")) {
            return FileFactory.getFile(bookmark.getLocation() + url.getPath());
        }
        return new BookmarkFile(bookmark);
    }
}

