/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.command;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import java.io.File;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command
implements Comparable<Command> {
    private final String alias;
    private final String command;
    private final String displayName;
    private final int type;

    public Command(String alias, String command, int type, String displayName) {
        this.alias = alias;
        this.type = type;
        this.displayName = displayName;
        this.command = command;
    }

    public Command(String alias, String command, int type) {
        this(alias, command, type, null);
    }

    public synchronized String[] getTokens(AbstractFile file) {
        return Command.getTokens(this.command, file);
    }

    public synchronized String[] getTokens(FileSet files) {
        return Command.getTokens(this.command, files);
    }

    public static String[] getTokens(String command) {
        return Command.getTokens(command, (AbstractFile[])null);
    }

    public static String[] getTokens(String command, AbstractFile file) {
        return Command.getTokens(command, new AbstractFile[]{file});
    }

    public static String[] getTokens(String command, FileSet files) {
        return Command.getTokens(command, files.toArray(new AbstractFile[files.size()]));
    }

    public static String[] getTokens(String command, AbstractFile[] files) {
        Vector<String> tokens = new Vector<String>();
        command = command.trim();
        StringBuilder currentToken = new StringBuilder(command.length());
        char[] buffer = command.toCharArray();
        boolean isInQuotes = false;
        for (int i = 0; i < command.length(); ++i) {
            if (buffer[i] == '\"') {
                currentToken.append(buffer[i]);
                isInQuotes = !isInQuotes;
                continue;
            }
            if (buffer[i] == '\\') {
                if (i + 1 == command.length()) continue;
                currentToken.append(buffer[++i]);
                continue;
            }
            if (buffer[i] == ' ' && !isInQuotes) {
                while (i + 1 < command.length() && buffer[i + 1] == ' ') {
                    ++i;
                }
                tokens.add(currentToken.toString());
                currentToken.setLength(0);
                continue;
            }
            if (buffer[i] == '$') {
                if (files == null) {
                    currentToken.append('$');
                    continue;
                }
                if (++i == buffer.length) {
                    currentToken.append('$');
                    continue;
                }
                if (Command.isLegalKeyword(buffer[i])) {
                    currentToken.append(Command.getKeywordReplacement(buffer[i], files[0]));
                    if (buffer[i] == 'j') continue;
                    if (!isInQuotes && files.length != 1) {
                        tokens.add(currentToken.toString());
                        currentToken.setLength(0);
                    }
                    for (int j = 1; j < files.length; ++j) {
                        if (isInQuotes) {
                            currentToken.append(' ');
                            currentToken.append(Command.getKeywordReplacement(buffer[i], files[j]));
                            continue;
                        }
                        if (j != files.length - 1) {
                            tokens.add(Command.getKeywordReplacement(buffer[i], files[j]));
                            continue;
                        }
                        currentToken.append(Command.getKeywordReplacement(buffer[i], files[j]));
                    }
                    continue;
                }
                currentToken.append('$');
                currentToken.append(buffer[i]);
                continue;
            }
            currentToken.append(buffer[i]);
        }
        if (currentToken.length() != 0) {
            tokens.add(currentToken.toString());
        }
        if (tokens.size() == 0) {
            return new String[]{""};
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static boolean isLegalKeyword(char keyword) {
        return keyword == 'f' || keyword == 'n' || keyword == 'p' || keyword == 'j' || keyword == 'e' || keyword == 'b';
    }

    private static String getKeywordReplacement(char keyword, AbstractFile file) {
        switch (keyword) {
            case 'f': {
                return file.getAbsolutePath();
            }
            case 'n': {
                return file.getName();
            }
            case 'p': {
                AbstractFile parentFile = file.getParent();
                return parentFile == null ? "" : parentFile.getAbsolutePath();
            }
            case 'j': {
                return new File(System.getProperty("user.dir")).getAbsolutePath();
            }
            case 'e': {
                String extension = file.getExtension();
                if (extension == null) {
                    return "";
                }
                return extension;
            }
            case 'b': {
                return file.getNameWithoutExtension();
            }
        }
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        int hashCode = this.alias.hashCode();
        hashCode = hashCode * 31 + this.command.hashCode();
        hashCode = hashCode * 31 + this.getDisplayName().hashCode();
        hashCode = hashCode * 31 + this.type;
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Command)) {
            return false;
        }
        Command cmd = (Command)object;
        return this.command.equals(cmd.command) && this.alias.equals(cmd.alias) && this.type == cmd.type && this.getDisplayName().equals(cmd.getDisplayName());
    }

    @Override
    public int compareTo(Command command) {
        int buffer = this.getDisplayName().compareTo(command.getDisplayName());
        if (buffer != 0) {
            return buffer;
        }
        buffer = this.getAlias().compareTo(command.getAlias());
        if (buffer != 0) {
            return buffer;
        }
        return this.command.compareTo(command.command);
    }

    public synchronized String getCommand() {
        return this.command;
    }

    public synchronized String getAlias() {
        return this.alias;
    }

    public synchronized int getType() {
        return this.type;
    }

    public synchronized String getDisplayName() {
        if (this.displayName == null) {
            return this.alias;
        }
        return this.displayName;
    }

    synchronized boolean isDisplayNameSet() {
        return this.displayName != null;
    }

    public String toString() {
        return this.alias + (this.displayName == null ? "" : ":" + this.displayName) + ":" + this.command;
    }
}

